//******************************************************************************
//  Copyright (c) 2005-2010 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#include "qmaemo5datepickselector_c.h"

#if defined MAEMO5
QMaemo5DatePickSelectorH QMaemo5DatePickSelector_create(QObjectH parent)
{
	return (QMaemo5DatePickSelectorH) new QMaemo5DatePickSelector((QObject*)parent);
}

void QMaemo5DatePickSelector_destroy(QMaemo5DatePickSelectorH handle)
{
	delete (QMaemo5DatePickSelector *)handle;
}

QWidgetH QMaemo5DatePickSelector_widget(QMaemo5DatePickSelectorH handle, QWidgetH parent)
{
	return (QWidgetH) ((QMaemo5DatePickSelector *)handle)->widget((QWidget*)parent);
}

void QMaemo5DatePickSelector_currentDate(QMaemo5DatePickSelectorH handle, QDateH retval)
{
	*(QDate *)retval = ((QMaemo5DatePickSelector *)handle)->currentDate();
}

void QMaemo5DatePickSelector_setCurrentDate(QMaemo5DatePickSelectorH handle, const QDateH date)
{
	((QMaemo5DatePickSelector *)handle)->setCurrentDate(*(const QDate*)date);
}

int QMaemo5DatePickSelector_minimumYear(QMaemo5DatePickSelectorH handle)
{
	return (int) ((QMaemo5DatePickSelector *)handle)->minimumYear();
}

int QMaemo5DatePickSelector_maximumYear(QMaemo5DatePickSelectorH handle)
{
	return (int) ((QMaemo5DatePickSelector *)handle)->maximumYear();
}

void QMaemo5DatePickSelector_setMinimumYear(QMaemo5DatePickSelectorH handle, int minYear)
{
	((QMaemo5DatePickSelector *)handle)->setMinimumYear(minYear);
}

void QMaemo5DatePickSelector_setMaximumYear(QMaemo5DatePickSelectorH handle, int maxYear)
{
	((QMaemo5DatePickSelector *)handle)->setMaximumYear(maxYear);
}

void QMaemo5DatePickSelector_currentValueText(QMaemo5DatePickSelectorH handle, PWideString retval)
{
	QString t_retval;
	t_retval = ((QMaemo5DatePickSelector *)handle)->currentValueText();
	copyQStringToPWideString(t_retval, retval);
}

#endif
