#ifndef MAEMOAPPLICATIONDETAILS_H
#define MAEMOAPPLICATIONDETAILS_H

#include "MaemoApplication.h"
#include "MaemoComment.h"
#include <QObject>

class MaemoApplicationDetails : public MaemoApplication {
    Q_OBJECT

    public:
        MaemoApplicationDetails();
        ~MaemoApplicationDetails();

        enum order {DESC,NORM};
        //set parameters
        void setDesc (QString);
        void setLicence (QString);
        void setStatus (QString);
        void setInstallFile (QString);
        void setInstallFileContent (QString);
        void setRevisor (QString);
        void addScreenshot (QString);
        void addUserComment (MaemoComment*,int order=NORM);
        void setUnparsedComments (QByteArray);
        void setBugUrl (QString);


        //get parameters
        QString getDescription ();
        QString getBugUrl();
        QString getLicence ();
        QString getStatus ();
        QString getInstallFile ();
        QList <QString>* getScreenShots ();
        QString getInstallFileContent ();
        QString getFirstScreenShot ();
        QList <MaemoComment*>* getUserComments();
        QByteArray getUnparsedComments ();

        //output as a QString
        QString toString ();

    public slots:
        void setCommentsList (QList <MaemoComment*> *);

    private:
        QString desc;
        QString licence;
        QString status;
        QString installFile;
        QString installFileContent;
        QString revisor;
        QString bugUrl;
        QList <QString> *screenshots;
        QList <MaemoComment*> *userComments;
        QByteArray unparsedComments;

    };
#endif // MAEMOAPPLICATIONDETAILS_H
