/* vim: set sw=4 ts=4 et: */
/*
 * This file is part of Live Wallpaper (livewp)
 * 
 * Copyright (C) 2010 Vlad Vasiliev
 * Copyright (C) 2010 Tanya Makova
 *       for the code
 * 
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
*/
/*******************************************************************************/
#ifndef _livewp_common_h
#define _livewp_common_h 1
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gtk/gtk.h>
#include <hildon/hildon.h>
#include <locale.h>
#include <libhildondesktop/libhildondesktop.h>
#include <libosso.h>
#include <gconf/gconf-client.h>
#include <time.h> 
#include <X11/extensions/Xrender.h>
#include <gdk/gdkx.h>

#include <X11/Xatom.h>
/* Gstreamer */
#include <gst/gst.h>
#include <gst/interfaces/xoverlay.h>

#define GETTEXT_PACKAGE "livewp"
#include <glib/gi18n-lib.h>

/* Position of plugin on desktop */
#define Xstartposition 800
#define Ystartposition 480 

#define THEME_PATH "/usr/share/livewp/theme"
#define SHORT_TIMER 75 /* 100 milisecond */
//#define LONG_TIMER 5*60*1000 /* 10 minutes */
#define LONG_TIMER  20*1000 /* 20 seconds */
enum { SHORT_TIMER_TYPE, LONG_TIMER_TYPE };
#define SKY_LEVEL 0 
#define SUN_LEVEL 0 
#define TOWN_LEVEL 0 
#define TRAM_LEVEL 20 

typedef struct _Scene Scene;
struct _Scene 
{
    GSList * actors;
    gint daytime;
    gint timer_type;
    gint wind_orientation; // +/- 1
    double wind_angle; // [-1 .. 1]
    guint seed; /* init value for random  */
    guint notification;
};

typedef struct _AWallpaperPlugin AWallpaperPlugin;
typedef struct _AWallpaperPluginClass AWallpaperPluginClass;
typedef struct _Animation_WallpaperPrivate Animation_WallpaperPrivate;



struct _Animation_WallpaperPrivate
{
    gint long_timer;
    gint short_timer;
    gchar *theme;
    gboolean visible;
    gboolean rich_animation;
    GtkWidget *main_widget;
    GtkWidget *window;
    GtkWidget *right_corner;
    AWallpaperPlugin *desktop_plugin;
    DBusConnection      *dbus_conn;
    DBusConnection      *dbus_conn_session;
    osso_context_t      *osso;
    gint xapplet;
    gint yapplet;
    Scene *scene;
    GHashTable * hash_scene_func;
    GKeyFile *config_file;
    gint view;
    pid_t  pid;
    pid_t  podpid;
    guint view_notify;
    guint alive_timer;
    time_t last_alive_event;
    gchar *theme_string_parametr1;
    guint theme_int_parametr1;
    GstElement *pipeline;
    gboolean running;
};

struct _AWallpaperPlugin
{
    HDHomePluginItem parent;
    Animation_WallpaperPrivate *priv;
};

struct _AWallpaperPluginClass
{
  HDHomePluginItemClass parent_class;
};


#define LIVEWP_SIGNAL_INTERFACE "org.maemo.livewp"
#define LIVEWP_SIGNAL_PATH "/org/maemo/livewp"
#define LIVEWP_SIGNAL_RELOAD_CONFIG_INTERFACE "org.maemo.livewp.reload_config"
#define LIVEWP_SIGNAL_RELOAD_CONFIG_PATH "/org/maemo/livewp/reload_config"
#define LIVEWP_RELOAD_CONFIG "reload_config"
#define LIVEWP_RELOAD_PLUGIN "reload_plugin"
#define LIVEWP_STOP_LIVEBG_ON_VIEW1 "stop_livebg_on_view1"
#define LIVEWP_STOP_LIVEBG_ON_VIEW2 "stop_livebg_on_view2"
#define LIVEWP_STOP_LIVEBG_ON_VIEW3 "stop_livebg_on_view3"
#define LIVEWP_STOP_LIVEBG_ON_VIEW4 "stop_livebg_on_view4"
#define LIVEWP_PAUSE_LIVEBG_ON_VIEW1 "pause_livebg_on_view1"
#define LIVEWP_PAUSE_LIVEBG_ON_VIEW2 "pause_livebg_on_view2"
#define LIVEWP_PAUSE_LIVEBG_ON_VIEW3 "pause_livebg_on_view3"
#define LIVEWP_PAUSE_LIVEBG_ON_VIEW4 "pause_livebg_on_view4"
#define LIVEWP_PLAY_LIVEBG_ON_VIEW1 "play_livebg_on_view1"
#define LIVEWP_PLAY_LIVEBG_ON_VIEW2 "play_livebg_on_view2"
#define LIVEWP_PLAY_LIVEBG_ON_VIEW3 "play_livebg_on_view3"
#define LIVEWP_PLAY_LIVEBG_ON_VIEW4 "play_livebg_on_view4"
#define LIVEWP_ALIVE_LIVEBG_ON_VIEW1 "alive_livebg_on_view1"
#define LIVEWP_ALIVE_LIVEBG_ON_VIEW2 "alive_livebg_on_view2"
#define LIVEWP_ALIVE_LIVEBG_ON_VIEW3 "alive_livebg_on_view3"
#define LIVEWP_ALIVE_LIVEBG_ON_VIEW4 "alive_livebg_on_view4"




/* For DBUS notification */
#define NOTIFY_SIGNAL_INTERFACE "org.freedesktop.Notifications"
#define NOTIFY_SIGNAL_PATH "/org/freedesktop/Notifications"
#define NOTIFY_MEMBER "Notify"
#define CLOSENOTIFY_MEMBER "NotificationClosed"

#endif
