/* This file is part of the KMPlayer project
 *
 * Copyright (C) 2010 Koos Vriezen <koos.vriezen@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 * until boost gets common, a more or less compatable one ..
 */

#include <stdio.h>

#include "log.h"

using namespace KMPlayer;


KMPLAYER_NO_EXPORT Log & Log::operator << (const char * s) {
    fprintf (stderr, "%s", s);
    return *this;
}

KMPLAYER_NO_EXPORT Log & Log::operator << (int i) {
    fprintf (stderr, "%d", i);
    return *this;
}

KMPLAYER_NO_EXPORT Log & Log::operator << (unsigned int i) {
    fprintf (stderr, "%u", i);
    return *this;
}

KMPLAYER_NO_EXPORT Log & Log::operator << (double d) {
    fprintf (stderr, "%f", d);
    return *this;
}

KMPLAYER_NO_EXPORT Log & Log::operator << (void * d) {
    fprintf (stderr, "0x%x", d);
    return *this;
}
