import urllib
import csv
import org.maemo.hermes.engine.service
from org.maemo.hermes.engine.friend import Friend

class Service(org.maemo.hermes.engine.service.Service):
    """maemo.org backend for Hermes.
       
       Copyright (c) Andrew Flegg <andrew@bleb.org> 2010.
       Released under the Artistic Licence."""
       
    #_account_url = "http://hermes.garage.maemo.org/mo-list.csv"
    _account_url = "file:///home/andrew/src/scratchbox/hermes/www/mo-list.csv"
       
    # -----------------------------------------------------------------------
    def __init__(self):
        """Initialise the maemo.org service."""
        
        org.maemo.hermes.engine.service.Service.__init__(self, "maemo.org")
        
        self._friends_by_contact = {}
        self._contacts_by_friend = {}
    
    
    # -----------------------------------------------------------------------
    def pre_process_contact(self, contact):
        """Extracts addresses from the contact."""
        
        for address in contact.get_emails():
            self._address_to_contact[address] = contact
    
    
    # -----------------------------------------------------------------------
    def process_friends(self):
        self._lookup_addresses()

    
    # -----------------------------------------------------------------------
    def process_contact(self, contact):
        """On first call (with a contact missing a photo), go get data from 
           Gravatar's servers."""
        
        if not self._has_photo(contact):
            for address in contact.get_emails():
                hash = self._get_hash_for_address(address)
                if (self._hash_has_gravatar.has_key(hash) and self._hash_has_gravatar[hash]):
                    friend = Friend(contact.get_name())
                    friend.set_photo_url(self._get_url_for_email_hash(hash))
                    self._register_match(contact, friend)
                    return friend
        
        return None


    # -----------------------------------------------------------------------
    def get_unmatched_friends(self):
        """Will always return empty list - Gravatar only reacts on e-mail 
           addresses from existing contacts."""

        return []
    

    # -----------------------------------------------------------------------
    def _get_friends(self):
        return self._contacts_by_friend.keys()


    # -----------------------------------------------------------------------    
    def _get_contacts_with_match(self):
        """Returns a dict with Contact objects as keys and Friend objects as 
           values"""
        
        return self._friends_by_contact


    # -----------------------------------------------------------------------
    def _register_match(self, contact, friend):
        friend.set_contact(contact)
        self._friends_by_contact[contact] = friend
        self._contacts_by_friend[friend] = contact
        
    # -----------------------------------------------------------------------
    # FIXME
    def _has_photo(self, contact):
        return False
    
        
    # -----------------------------------------------------------------------
    def _lookup_addresses(self):
        """Constructs hashes for address_to_contact, makes call to the Gravatar.com service and updates
        self._hash_has_gravatar"""
        
        addresses = self._address_to_contact.keys()
        if len(addresses) == 0:
            self._set_hash_information({})
        else:
            args = { "apikey" : self._api_key}
            hashes = self._construct_hashes(addresses)
            args["hashes"] = list(hashes)
            url = self._api_url
            self._set_hash_information(self._get_hash_info_from_server(args, url))
            

    # -----------------------------------------------------------------------
    def _get_hash_info_from_server(self, args, url):
        """Makes the actual XML-RPC call - override this for testing"""
        
        service = xmlrpclib.ServerProxy(url)
        return service.grav.exists(args)


    # -----------------------------------------------------------------------
    def _set_hash_information(self, hash_info):
        self._hash_has_gravatar = hash_info
        

    # -----------------------------------------------------------------------
    def _get_url_for_email_hash(self, hash, default="404", size="128"):
        """Assembles the URL to a gravatar, based on a hash of an e-mail address"""
    
        return self._image_url_base + urllib.urlencode({'gravatar_id':hash, 'd':default, 'size':size})
    
    
    # -----------------------------------------------------------------------
    def _construct_hashes(self, addresses):
        """Creates hashes for all addresses specified, returning a set of hashes"""
    
        result = set()
        for address in addresses:
            hash = self._get_hash_for_address(address)
            self._hash_to_address[hash] = address
            result.add(hash)
    
        return result

    # -----------------------------------------------------------------------
    def _get_hash_for_address(self, address):
        return hashlib.md5(address.lower()).hexdigest()
