class Friend():
    """Encapsulate the data from a remote service.
    
       Copyright (c) Fredrik Wendt <fredrik@wendt.se> 2010.
       Released under the Artistic Licence."""

    
    def __init__(self, name=None, source=None, props=None):
        """ source is source service, such as LinkedIn """
        self._attributes = {};
        if name: self._set('fn', name)
        self._multi_attributes = {}
        self._source = source
        if props:
            for key in props:
                self._set(key, props[key])
        
    def __getitem__(self, key):
        return self._safe_get(key)
                              
    def __unicode__(self):
        return self.__repr__()
    
    def __repr__(self):
        return "Friend %s" % self.get_name()
    
    # public accessors -----------------
    
    def add_url(self, url):
	if url:
	    if not isinstance(url, basestring):
	        print url
	        raise Exception('Not valid to add non-string URLs')
            self._add('url', url)
    
    def add_phone(self, phone):
 	if phone:
            self._add('phone', phone)
        
    def get_birthday_date(self):
        return self._safe_get('bday')
    
    def get_contact(self):
        return self._safe_get('contact')
    
    def get_name(self):
        return self._safe_get('fn')
    
    def get_source(self):
        return self._source
    
    def set_source(self, source):
        self._source = source
    
    def get_nickname(self):
        return self._safe_get("nickname")
    
    def get_urls(self):
        try: return self._multi_attributes['url'] 
        except: return []
    
    def get_phones(self):
        try: return self._multi_attributes['phone'] 
        except: return []
        
    def get_photo_url(self):
        return self._safe_get('photo-url')
    
    def has_birthday_date(self):
        return self._has('bday')
    
    def is_empty(self):
        for a in self._attributes:
            return False
        for a in self._multi_attributes:
            return False
        return True
    
    def set_name(self, name):
        self._set('fn', name)
    
    def set_nickname(self, nickname):
        self._set('nickname', nickname)
        
    def set_birthday_date(self, date):
        self._set('bday', date)
        
    def set_contact(self, contact):
        self._set('contact', contact)
        
    def set_photo_url(self, url):
        self._set('photo-url', url)
    
    def update_from_friend(self, other_friend, overwrite=False):
        """
        Overwrites any attributes in this friend, with attributes from other_friend
        """
        
        self._attributes.update(other_friend._attributes)
        
        for key in other_friend._multi_attributes.keys():
            for value in other_friend._multi_attributes[key]:
                self._add(key, value)
     
    def update_contact(self, contact, overwrite=False):
        """Updates the contact with information from this object,
           without overwriting unless overwrite is set to True.
           Returns flag indicating if anything *was* changed."""
        
        def set_birthday(arg):
            # Hackily assumes Facebook format (mm/d[/y])
            date_str = arg.split('/')
            date_str.append('0')
            return contact.set_birthday(int(date_str[1]),
                                        int(date_str[0]),
                                        int(date_str[2]))

        updated = False
        if overwrite or contact.get_photo() is None:    updated += self._if_defined('photo-url', contact.set_photo)
        if overwrite or contact.get_nickname() is None: updated += self._if_defined('nickname', contact.set_nickname)
        if overwrite or contact.get_birthday() is None: updated += self._if_defined('bday', set_birthday)
        if self._multi_attributes.has_key('url'):
            for url in self._multi_attributes['url']:
                updated += contact.add_url(url)

        if self._multi_attributes.has_key('phone'):
            for phone in self._multi_attributes['phone']:
                updated += contact.add_phone(phone)
                
        return updated


    # private helpers -----------------------
    #
    def _add(self, key, value):
        if value is not None:
            if not self._multi_attributes.has_key(key):
                self._multi_attributes[key] = []
#            print "%s ADD %s to %s" % (self, key, value)
            self._multi_attributes[key].append(value)
    
    def _contains(self, key, value):
        if self._attributes.has_key(key):
            return value == self._attributes[key]
        if self._multi_attributes.has_key(key):
            return value in self._multi_attributes[key]
        return False
    
    def _if_defined(self, key, callback):
        return self._attributes.has_key(key) and callback(self._attributes[key]) or False
    
    def _has(self, key):
        return self._attributes.has_key(key) or self._multi_attributes.has_key(key)
    
    def _safe_get(self, key):
        try: return self._attributes[key]
        except: return None
        
    def _set(self, key, value):
        if value is not None:
#            print "%s SET %s to %s" % (self, key, value)
            self._attributes[key] = value
    
