import gtk
import hildon
from ctypes import *
from pygobject import *
from org.maemo.hermes.gui.searchablelist import SearchableList

class MapContact(SearchableList):
    """Widget which shows a list of friends from various feeds and allows
       the mapping to a particular contact.
       
       Copyright (c) Andrew Flegg <andrew@bleb.org> 2009.
       Released under the Artistic Licence."""


    # -----------------------------------------------------------------------
    def __init__(self, friends, contact):
        """Constructor. Passed a list of `friends' and the contact we're mapping."""
        
        SearchableList.__init__(self, 1)
        self.friends = friends
        self.contact = contact
        self.treestore = gtk.ListStore(gtk.gdk.Pixbuf, str, gtk.gdk.Pixbuf, gobject.TYPE_PYOBJECT)
        
        accounts = {}
        _tick    = gtk.icon_theme_get_default().load_icon('widgets_tickmark_list', 48, 0)
        
        self.contact_mapped = False
        mapped_iter = None
        best_iter   = None
        last_name   = '' # Keep track for when we switch name positions and focus there
        for key in sorted(self.friends.keys(), cmp = lambda a, b: cmp(a.lower(), b.lower())):
            friend = self.friends[key]
            if friend.get_source() not in accounts:
                try:
                    accounts[friend.get_source()] = gtk.gdk.pixbuf_new_from_file("/opt/hermes/share/account-%s.png" % (friend.get_source()))
                except glib.GError, e:
                    accounts[friend.get_source()] = None
                    print "Couldn't find icon:", e.message
              
            pixbuf = None
            if friend.get_contact() is not None:
                if friend.get_contact() == contact:
                    pixbuf = _tick
                    self.contact_mapped = True
                    mapped_iter = self.treestore.append([accounts[friend.get_source()], friend.get_name(), pixbuf, friend])
                else:
                    continue
            else:
                position = self.treestore.append([accounts[friend.get_source()], friend.get_name(), pixbuf, friend])
                if cmp(last_name, contact.get_name()) != cmp(friend.get_name(), contact.get_name()):
                    best_iter = position

                last_name = friend.get_name()
        
        self.treeview = gtk.TreeView(self.treestore)
        hildon.hildon_gtk_tree_view_set_ui_mode(self.treeview, gtk.HILDON_UI_MODE_EDIT)
        
        self.treeview.append_column(gtk.TreeViewColumn('Account', gtk.CellRendererPixbuf(), pixbuf = 0))
        self.treeview.append_column(gtk.TreeViewColumn('Name', gtk.CellRendererText(), text = 1))
        
        cell = gtk.CellRendererPixbuf()
        cell.set_property('xalign', 1.0)
        self.treeview.append_column(gtk.TreeViewColumn('Picture', cell, pixbuf = 2))
        
        if mapped_iter:
            path = self.treestore.get_path(mapped_iter)
            self.treeview.get_selection().select_path(path)
            self.treeview.scroll_to_cell(path)
        elif best_iter:
            path = self.treestore.get_path(best_iter)
            self.treeview.get_selection().unselect_all()
            self.treeview.scroll_to_cell(path)
        else:
            self.treeview.get_selection().unselect_all()
          
        self.add(self.treeview)

      
    # -----------------------------------------------------------------------
    def get_selected_friend(self):
        """Return the selected friend, or `None' if none."""
    
        (model, iter) = self.treeview.get_selection().get_selected()
        if not iter:
            return None
             
        return model.get_value(iter, 3)


_account_selected = gobject.signal_new('account-selected', MapContact, gobject.SIGNAL_ACTION, gobject.TYPE_NONE, [gobject.TYPE_PYOBJECT, gobject.TYPE_PYOBJECT])

