//    Group SMS
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#ifndef GROUPACTIONSWINDOW_H
#define GROUPACTIONSWINDOW_H

#include <QMainWindow>
#include <QMenu>
#include <QEventLoop>
#include "group.h"
#include "contactsdatamodel.h"

namespace Ui {
    class GroupActionsWindow;
}

class GroupActionsWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit GroupActionsWindow(QWidget *parent = 0, Group* group=0);
    ~GroupActionsWindow();

private:
    Ui::GroupActionsWindow *ui;

    QEventLoop* m_Loop;
    Group* m_Group;
    QMenu* m_ContactMenu;

    QList<Contact*> m_Contacts;
    ContactsDataModel* m_DataModel;
    void PopulateContactsTable();
    QList<QString> GetSelectedNumbers();
    void SelectAllContacts(bool select=true);

public slots:
    void show();
    void closeEvent(QCloseEvent*);

private slots:
    void AddContactSlot();
    void RemoveSlot();
    void SendSlot();
    void EditSlot();
    void ContactDoubleClick(QModelIndex index);
    void ContactMenuSlot(QPoint point);

    void SelectAllSlot();
    void DeselectAllSlot();
    void RemoveOneSlot();

protected:
    void resizeEvent (QResizeEvent*);
};

#endif // GROUPACTIONSWINDOW_H
