/**
 * Copyright (C) 2008-09 Tan Miaoqing
 * Contact: Tan Miaoqing <rabbitrun84@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef TP_STATUS_FEED_H_
#define TP_STATUS_FEED_H_

#include <libosso-abook/osso-abook.h>
#include <libosso-abook/osso-abook-contact.h>

G_BEGIN_DECLS

#define TP_TYPE_STATUS_FEED             (tp_status_feed_get_type ())
#define TP_STATUS_FEED(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                                         TP_TYPE_STATUS_FEED, TpStatusFeed))
#define TP_STATUS_FEED_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), \
                                         TP_TYPE_STATUS_FEED, TpStatusFeedClass))
#define TP_IS_STATUS_FEED(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                                         TP_TYPE_STATUS_FEED))
#define TP_IS_STATUS_FEED_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                                         TP_TYPE_STATUS_FEED))
#define TP_STATUS_FEED_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                                         TP_TYPE_STATUS_FEED, TpStatusFeedClass))

#define PROGRAM_NAME "FriendStatus"
#define LOGO_ICON_NAME "friendstatus"
#define AUTHOR "Tan Miaoqing <rabbitrun84@gmail.com>"
#define COMMENTS "FriendStatus collects and stores IM presence status messages"
#define WEBSITE "http://friendstatus.garage.maemo.org"

typedef struct _TpStatusFeed      TpStatusFeed;
typedef struct _TpStatusFeedClass TpStatusFeedClass;

struct _TpStatusFeed
{
  GObject      parent;
  gpointer     priv;
};

struct _TpStatusFeedClass
{
  GObjectClass parent_class;
};

GType         tp_status_feed_get_type          (void);
TpStatusFeed *tp_status_feed_get_instance      (void);

void          tp_status_set_osso (TpStatusFeed *statusfeed,
                                  osso_context_t *osso);

/* Backend functions */

void tp_status_feed_backend_log_self_status_update (TpStatusFeed *statusfeed);

void tp_status_feed_backend_contacts_added_cb (OssoABookRoster *aggregator,
    OssoABookContact **contacts, gpointer userdata);

/*
void tp_status_feed_backend_contacts_removed_cb (OssoABookRoster *aggregator,
    OssoABookContact **contacts, gpointer userdata);
*/

G_END_DECLS

#endif /* TP_STATUS_FEED_H_ */
