from com import Component, msgs
from utils import logging
import platforms

import dbus


class SoundVolumeMonitor(Component):

    def __init__(self):

        Component.__init__(self)

        bus = platforms.get_session_bus()
        bus.add_signal_receiver(self.__on_change_property,
                                signal_name="property_changed",
                                dbus_interface="com.nokia.mafw.extension",
                                path="/com/nokia/mafw/renderer/gstrenderer")
       
        
    def __on_change_property(self, key, value):
    
        if (key == "volume"):
            self.emit_message(msgs.SYSTEM_EV_SOUND_VOLUME_CHANGED, value)

