#include <string>
using namespace std;

#include "includes.h"
#include "screen_main.h"
#include "screen_edit.h"
#include "txt.h"
#include "file_category.h"
#include "file_expenses.h"
#include "screen_category.h"
#include "popup.h"

#include <sys/stat.h>
#include <sys/types.h>

//nossos arquivos de dados
#define nome_arquivo_diretorio "/home/user/MyDocs/expenselog"
#define nome_arquivo_expenses_txt "/home/user/MyDocs/expenselog/expenses.txt"
#define nome_arquivo_category_txt "/home/user/MyDocs/expenselog/categories.txt"

//afazer: subir projeto

void screen_main::run(HildonWindow *window0)
{
	base_window = window0;

    //tela toda
    GtkWidget *tela_toda = gtk_vbox_new(FALSE, 1);
    //GtkWidget *separador = gtk_hseparator_new();
    //gtk_box_pack_start (GTK_BOX(tela_toda), separador, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX(tela_toda), build_grid(), TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX(tela_toda), build_button_bar(), FALSE, FALSE, 0);

    gtk_container_add(GTK_CONTAINER(base_window), tela_toda);


    /* Begin the main application */
    gtk_widget_show_all ( GTK_WIDGET ( base_window ) );

    //verifica se o diretorio de dados existe, e cria se o cara deixar
    struct stat buf_verifica_diretorio;
    if(stat(nome_arquivo_diretorio, &buf_verifica_diretorio) == -1)
    {
    	if(!popup::confirm(txt::tx(txt::screen_main_criar_diretorio)))
    		exit(1);

    	//cria o diretorio
		mkdir(nome_arquivo_diretorio, 0777);
		//salva os dois arquivos de dados
		file_expenses::get_instance().inicializar(nome_arquivo_expenses_txt);
		file_expenses::get_instance().salvar();
		file_category::get_instance().inicializar(nome_arquivo_category_txt);
		file_category::get_instance().salvar();
    }


    //inicializa os arquivos
    int linha_erro_expenmses = file_expenses::get_instance().inicializar(nome_arquivo_expenses_txt);
    if(linha_erro_expenmses != -1)
    {
#define bufferimpressao 200
    	char buffer[bufferimpressao  + 10];
    	snprintf(buffer, bufferimpressao, "%d", linha_erro_expenmses);
    	string esteerro;
    	esteerro = txt::tx(txt::erro_arquivo_expenses);
    	esteerro = esteerro + buffer;
    	if(!popup::confirm(esteerro.c_str()))
    		exit(1);
    }
    if(!file_category::get_instance().inicializar(nome_arquivo_category_txt))
    {
    	if(!popup::confirm(txt::tx(txt::erro_arquivo_categoria)))
    		exit(1);
    }

    atualizar_grade();

    gtk_main();
}

void botao_adicionar_clicked (GtkButton* button, gpointer data)
{
	screen_edit::get_instance().acao_adicionar(screen_main::get_instance().base_window );
}

//indice da linha selecionada ou -1
int screen_main::indice_selecionado()
{
	//vamos pegar o item atualmente selecionado
	GtkTreeIter iter;
	GtkTreeSelection *selection = gtk_tree_view_get_selection ( GTK_TREE_VIEW(nosso_tree));
	GtkTreeModel *model;
	if (!gtk_tree_selection_get_selected(GTK_TREE_SELECTION(selection), &model, &iter))
		return -1;

	//coluna do indice
	char *value;
	gtk_tree_model_get(model, &iter, 3, &value,  -1);
	int selectedindex = atoi(value);
	g_free(value);

	return selectedindex;
}

void botao_excluir_clicked (GtkButton* button, gpointer data)
{
	int selectedindex = screen_main::get_instance().indice_selecionado();
	if (selectedindex == -1)
	{
		popup::warn(txt::tx(txt::screen_main_sem_selecao));
		return;
	}

	file_expenses::dado_item *item = &file_expenses::get_instance().dados()[selectedindex];
	string msg = txt::tx(txt::screen_main_confirma_excluir);
	msg += "\n";
	msg += item->data_tela();
	msg += "\n";
	msg += item->valor_tela();
	if(!popup::confirm(msg.c_str()))
		return;

	file_expenses::get_instance().dados().erase(
			file_expenses::get_instance().dados().begin() + selectedindex);
	file_expenses::get_instance().salvar();
	screen_main::get_instance().atualizar_grade();
}


void botao_editar_clicked (GtkButton* button, gpointer data)
{
	int selectedindex = screen_main::get_instance().indice_selecionado();
	if (selectedindex == -1)
	{
		popup::warn(txt::tx(txt::screen_main_sem_selecao));
		return;
	}
	screen_edit::get_instance().acao_editar(screen_main::get_instance().base_window, selectedindex);
}

//a barra de botoes
GtkWidget *screen_main::build_button_bar()
{
	GtkWidget *botao_adicionar;
	GtkWidget *botao_editar;
	GtkWidget *botao_excluir;

	HildonSizeType sizetype = (HildonSizeType)(HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);

	//barra de botoes
    GtkWidget *barra_botoes = gtk_hbox_new(TRUE, 1);

    botao_adicionar = hildon_button_new_with_text (sizetype, HILDON_BUTTON_ARRANGEMENT_VERTICAL, txt::tx(txt::screen_main_botao_adicionar), NULL);
    gtk_container_add (GTK_CONTAINER(barra_botoes), botao_adicionar);
	g_signal_connect (G_OBJECT (botao_adicionar), "clicked", G_CALLBACK (botao_adicionar_clicked), NULL);

	botao_editar = hildon_button_new_with_text (sizetype, HILDON_BUTTON_ARRANGEMENT_VERTICAL, txt::tx(txt::screen_main_botao_editar), NULL);
    gtk_container_add (GTK_CONTAINER(barra_botoes), botao_editar);
	g_signal_connect (G_OBJECT (botao_editar), "clicked", G_CALLBACK (botao_editar_clicked), NULL);

	botao_excluir = hildon_button_new_with_text (sizetype, HILDON_BUTTON_ARRANGEMENT_VERTICAL, txt::tx(txt::screen_main_botao_excluir), NULL);
    gtk_container_add (GTK_CONTAINER(barra_botoes), botao_excluir);
	g_signal_connect (G_OBJECT (botao_excluir), "clicked", G_CALLBACK (botao_excluir_clicked), NULL);

	return barra_botoes;
}

/*
 * constroi o grid, onde ficam os dados em si
 */
GtkWidget *screen_main::build_grid()
{
	//lista
    nosso_store = gtk_list_store_new (4, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

#ifndef WITH_HILDON_2_2
    nosso_tree=gtk_tree_view_new();
#else
    nosso_tree=hildon_gtk_tree_view_new(HILDON_UI_MODE_EDIT);
#endif

    gtk_tree_view_set_model(GTK_TREE_VIEW(nosso_tree), GTK_TREE_MODEL(nosso_store));
    GtkCellRenderer *renderer;
    GtkTreeViewColumn *column;
    renderer = gtk_cell_renderer_text_new ();
    g_object_set(renderer, "xalign", 1.0, NULL);
    g_object_set(renderer, "alignment", PANGO_ALIGN_RIGHT, NULL);
    column = gtk_tree_view_column_new_with_attributes (txt::tx(txt::screen_main_grid_data), renderer,  "text", 0, NULL);
    gtk_tree_view_column_set_min_width (column, 150);
    gtk_tree_view_column_set_max_width (column, 150);
    gtk_tree_view_column_set_alignment (column, 1.0);
    gtk_tree_view_append_column (GTK_TREE_VIEW (nosso_tree), column);

    renderer = gtk_cell_renderer_text_new ();
    g_object_set(renderer, "xalign", 1.0, NULL);
    g_object_set(renderer, "alignment", PANGO_ALIGN_RIGHT, NULL);
    column = gtk_tree_view_column_new_with_attributes (txt::tx(txt::screen_main_grid_valor), renderer,  "text", 1, NULL);
    gtk_tree_view_column_set_min_width (column, 150);
    gtk_tree_view_column_set_max_width (column, 150);
    gtk_tree_view_column_set_alignment (column, 1.0);
    gtk_tree_view_append_column (GTK_TREE_VIEW (nosso_tree), column);

    renderer = gtk_cell_renderer_text_new ();
    g_object_set(renderer, "xalign", 0.0, NULL);
    //o jeito é colocar a largura hard-coded, nao escobri como deixar ele usar a largura natural... saco!
    g_object_set(renderer, "wrap-width", 470, NULL);
    g_object_set(renderer, "wrap-mode", PANGO_WRAP_WORD_CHAR, NULL);
    //ou entao ligamos o ellipsize
    //so funciona com o ellipsize no meio....
    //g_object_set(renderer, "ellipsize", PANGO_ELLIPSIZE_MIDDLE, NULL);
    g_object_set(renderer, "alignment", PANGO_ALIGN_LEFT, NULL);
    column = gtk_tree_view_column_new_with_attributes (txt::tx(txt::screen_main_grid_comentario), renderer,  "text", 2, NULL);
    gtk_tree_view_append_column (GTK_TREE_VIEW (nosso_tree), column);

    gtk_tree_view_set_headers_visible (GTK_TREE_VIEW (nosso_tree), TRUE);
    gtk_tree_view_set_grid_lines (GTK_TREE_VIEW (nosso_tree), GTK_TREE_VIEW_GRID_LINES_BOTH);

    //scroll
#ifndef WITH_HILDON_2_2
    GtkWidget *treescroll =gtk_scrolled_window_new(NULL, NULL);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(treescroll), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
#else
    GtkWidget *treescroll =hildon_pannable_area_new();
#endif
    gtk_container_add(GTK_CONTAINER(treescroll), nosso_tree);

    return treescroll;
}


/*
 * transfere do arquivo para a tela
 */
void screen_main::atualizar_grade()
{
	//colocamos em nosso_store
	gtk_list_store_clear (nosso_store);

    GtkTreeIter iter1;  /* Parent iter */
    GValue value  = {0};
    g_value_init (&value, G_TYPE_STRING);

    vector<file_expenses::dado_item> &dados = file_expenses::get_instance().dados();
    vector<file_expenses::dado_item>::iterator it;
    int contador_linha = 0;
	for ( it=dados.begin() ; it < dados.end(); it++, contador_linha++ )
	{
		gtk_list_store_append( nosso_store, &iter1);
		g_value_set_static_string (&value, (*it).data_tela().c_str());
		gtk_list_store_set_value  (nosso_store, &iter1, 0, &value);
		g_value_set_static_string (&value, (*it).valor_tela().c_str());
	    gtk_list_store_set_value  (nosso_store, &iter1, 1, &value);
		g_value_set_static_string (&value, (*it).descricao_get());
	    gtk_list_store_set_value  (nosso_store, &iter1, 2, &value);

	    //coluna de contagem
		g_value_set_static_string (&value, string_conversion::conversao_int2string(contador_linha).c_str());
	    gtk_list_store_set_value  (nosso_store, &iter1, 3, &value);
	}
}


