/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.Compiler;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicClassLoader
extends URLClassLoader {
    HashMap<Integer, Object[]> constantVals = new HashMap();
    HashMap<String, byte[]> map = new HashMap();
    static final URL[] EMPTY_URLS = new URL[0];

    public DynamicClassLoader() {
        super(EMPTY_URLS, Thread.currentThread().getContextClassLoader() == null || Thread.currentThread().getContextClassLoader() == ClassLoader.getSystemClassLoader() ? Compiler.class.getClassLoader() : Thread.currentThread().getContextClassLoader());
    }

    public DynamicClassLoader(ClassLoader parent) {
        super(EMPTY_URLS, parent);
    }

    public Class defineClass(String name, byte[] bytes) {
        return this.defineClass(name, bytes, 0, bytes.length);
    }

    public void addBytecode(String className, byte[] bytes) {
        if (this.map.containsKey(className)) {
            throw new IllegalStateException(String.format("Class %s already present", className));
        }
        this.map.put(className, bytes);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] bytes = this.map.get(name);
        if (bytes != null) {
            return this.defineClass(name, bytes, 0, bytes.length);
        }
        return super.findClass(name);
    }

    public void registerConstants(int id, Object[] val) {
        this.constantVals.put(id, val);
    }

    public Object[] getConstants(int id) {
        return this.constantVals.get(id);
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }
}

