#!/bin/sh

# defaults
FILEPATH="/home/user/.cleven"

# Read MAC address
MACADDR="`cat $FILEPATH/myMAC`"
echo $MACADDR

# Unload wifi modules
rmmod wl1251_spi 2>/dev/null
rmmod wl1251 2>/dev/null
rmmod wl12xx 2>/dev/null
rmmod mac80211 2>/dev/null
rmmod cfg80211 2>/dev/null
rmmod rfkill_backport 2>/dev/null
rmmod compat_firmware_class 2>/dev/null
rmmod compat 2>/dev/null
# Load wl12xx
modprobe wl12xx
# Restore mac address
ifconfig wlan0 down hw ether "$MACADDR"

echo "INFO: Stock wifi drivers loaded and restored MAC address.."