#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>

//#include <stdio.h>

#include "omapfb.h"

//#include <asm/ioctl.h>
//#include <asm/types.h>
//#include <asm/arch-omap/omapfb.h>

char fbname[] = "/dev/fb0";

void print(char *s){
    write(1,s,strlen(s));
}
/*
*/

int main(int argc,char *argv[]){
int fbdev=open(fbname,O_RDWR);
int update_mode=0;
int ret=-1;
if (argc<2){
//    printf("usage %s auto|manual\n",argv[0]);
    print("usage ");print(argv[0]);print(" auto|manual\n");
    exit(0);
}
if (strcmp(argv[1],"auto")==0)
    update_mode=OMAPFB_AUTO_UPDATE;
if (strcmp(argv[1],"manual")==0)
    update_mode=OMAPFB_MANUAL_UPDATE;
    
if (fbdev>0 && update_mode>0){
    ret=ioctl(fbdev,OMAPFB_SET_UPDATE_MODE,&update_mode);
    if (ret>=0){
	ret=ioctl(fbdev,OMAPFB_GET_UPDATE_MODE,&update_mode);
	if (ret>=0){
	    if (update_mode==OMAPFB_AUTO_UPDATE)
		print("mode set to auto\n");
	    if (update_mode==OMAPFB_MANUAL_UPDATE)
		print("mode set to manual\n");
	} else
	    print("OMAPFB_GET_UPDATE_MODE ioctl failed\n");
    } else
	print("OMAPFB_SET_UPDATE_MODE ioctl failed\n");
    //close(fbdev);
}
exit(ret);
}