#ifndef RESIZEABLEGRAPHICSVIEW_H
#define RESIZEABLEGRAPHICSVIEW_H

#include <QGraphicsView>


/*!
  ResizeableGraphicsView extends the QGraphicsView by emitting a signal on size
  change.
*/
class ResizeableGraphicsView : public QGraphicsView
{
    Q_OBJECT

public:
    explicit ResizeableGraphicsView(QWidget *parent = 0);

protected:
    void resizeEvent(QResizeEvent * event);

signals:
    void sizeChanged(QGraphicsView *graphicsView);
};

#endif // RESIZEABLEGRAPHICSVIEW_H
