import unittest
from unit.pie import *

from wifi_assistant.gui.add_network_dialog import AddNetworkDialog 

class AddNetworkDialogTest(unittest.TestCase):
    
    def setUp(self):
        self.parent_window = None
        self.save_callback = Mock()
        
        #given(self.save_callback).save().willReturn(None)
        self.save_callback.replay()
 
        self.testee = AddNetworkDialog(self.parent_window, self.save_callback.save)
        

    def test_cancelButtonDoesntCallSaveCallback(self):
        self._makeRunDialogReturn(AddNetworkDialog.CANCEL_BUTTON)
        self.testee.show()
        verify(self.save_callback, never()).save()


    def test_saveButtonCallsSaveCallback(self):
        self._makeRunDialogReturn(AddNetworkDialog.SAVE_BUTTON)
        self.testee.show('A Network Name', True)
        verify(self.save_callback).save('A Network Name', True)


    def _makeRunDialogReturn(self, value):
        class method():
            def __init__(self, value_to_return):
                self._value_to_return = value_to_return
            def __call__(self, x):
                return self._value_to_return
        self.testee._runDialog = method(value)
    
if __name__ == '__main__':
    unittest.main()

