#!/usr/bin/python2.5
import gtk, hildon

def _(str):
    return str

class AddNetworkDialog():
    
    CANCEL_BUTTON = 1
    SAVE_BUTTON = 2
    
    def __init__(self, parent_window, saveCallback):
        """saveCallback(ssid, launch_browser)"""
        
        self._parent_window = parent_window
        self._saveCallback = saveCallback


    def show(self, ssid=_('MyNetwork'), launch_browser=True):
        checkbox = hildon.CheckButton(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT)
        checkbox.set_label(_('Launch browser when connected'))
        checkbox.set_active(launch_browser)
        
        url_label = gtk.Label(_('Name of the network:')) # IMPROVEMENT: caption?
        url_label.set_alignment(0, 0.5)
        url_label.set_padding(5, 5)
        url_field = hildon.Entry(gtk.HILDON_SIZE_AUTO)
        url_field.set_text(ssid)
        
        dialog = gtk.Dialog(_('Add network'), self._parent_window)
        dialog.vbox.set_homogeneous(False)
        
        dialog.vbox.add(url_label)
        dialog.vbox.add(url_field)
        dialog.vbox.add(checkbox)
        
        dialog.add_button(_('Cancel'), AddNetworkDialog.CANCEL_BUTTON)
        dialog.add_button(_('Save'), AddNetworkDialog.SAVE_BUTTON)
        
        dialog.show_all()
        result = self._runDialog(dialog)
        dialog.hide()
        

        if result == AddNetworkDialog.SAVE_BUTTON:
            launch_browser = checkbox.get_active()
            ssid = url_field.get_text()
            self._saveCallback(ssid, launch_browser)
    

    def _runDialog(self, dialog):
        result = dialog.run()
        return result
