#!/usr/bin/python2.5
from gnome import gconf
import gtk, gobject

class Settings():
    
    def __init__(self, gconf_root_dir='/apps/maemo/wifi-assistant'):
        self._gc = gconf.client_get_default()
        self._gconfRootDir = gconf_root_dir
        self._gconfLaunchDirectory = gconf_root_dir + '/launch'
        self._gconfPopupKey = gconf_root_dir + '/daemon'
        self._gconfUrlToOpen = gconf_root_dir + '/url-to-open'
        self._listeners = {}
    
    # ---- public API __________________________________________________________

    def getLaunchSetting(self, ssid):
        """Returns True or False to indicate that the user wants a browser
           launched or not, otherwise None (the ssid is not recognized)"""
           
        value = self._gc.get_without_default(self._get_launch_key(ssid))
        if value is None:
            return None
        return value.get_bool()

    
    def getLaunchSettings(self):
        """Returns a ListStore with one Row per SSID"""
        
        store = gtk.ListStore(str, gobject.TYPE_BOOLEAN)
        entries = self._gc.all_entries(self._gconfLaunchDirectory)
        directoryPathLength = len(self._gconfLaunchDirectory) + 1
        for entry in entries:
            ssidName = entry.get_key()[directoryPathLength:]
            launchBrowser = entry.get_value().get_bool()
            store.append([ssidName, launchBrowser])
        
        return store
    

    def setLaunchSetting(self, ssid, mode):
        """Saves the setting for the specified ssid. mode is True or False"""
        
        self._gc.set_bool(self._get_launch_key(ssid), mode)
    
    
    def deleteLaunchSetting(self, ssid):
        """Removes a setting for the specified ssid."""
        
        self._gc.unset(self._get_launch_key(ssid))
        
        
    def addUsePopupListener(self, callback):
        """Registers a listener/callback to changes on Use Daemon setting"""
        
        if len(self._listeners) == 0:
            self._gc.add_dir(self._gconfRootDir, gconf.CLIENT_PRELOAD_NONE)
        ref_id = self._gc.notify_add(self._gconfPopupKey, callback)
        self._listeners[callback] = ref_id
        
    
    def removeUsePopupListener(self, callback):
        """Unregisters the listener/callback"""
        
        if (self._listeners.has_key(callback)):
            ref_id = self._listeners.pop(callback)
            self._gc.notify_remove(ref_id)
            
            if len(self._listeners) == 0:
                self._gc.remove_dir(self._gconfRootDir)
    
            
    def getUsePopup(self):
        """Tells whether to use the daemon or not."""
        
        return self._gc.get_bool(self._gconfPopupKey) is True


    def setUsePopup(self, mode):
        """mode is either True or False."""
        
        self._gc.set_bool(self._gconfPopupKey, mode)
        
    
    def getUrlToOpen(self):
        """Returns the URL to open when launching a browser"""
        
        return self._gc.get_string(self._gconfUrlToOpen) or 'http://wifi-assistant.garage.maemo.org/ping/'


    def setUrlToOpen(self, url):
        """Sets the URL to open when launching a browser"""
        
        self._gc.set_string(self._gconfUrlToOpen, url)
    
    
    # ---- private _____________________________________________________________
        
    def _get_launch_key(self, ssid):
        return self._gconfLaunchDirectory + '/' + ssid


if __name__ == "__main__":
    print Settings().getLaunchSetting('limbergwendt2')
