/**
 *  Viito -- an image dictionary for sign language
 *
 *  Copyright (C) 2010  Aki Niemi <aki.niemi@iki.fi>
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef VIMAGEWIDGET_H
#define VIMAGEWIDGET_H

#include <QWidget>

class QString;
class QLabel;
class QPixmap;
class QEvent;
class QKeyEvent;
class QMouseEvent;
class QGestureEvent;
class QSwipeGesture;

class VImageWidget : public QWidget
{
    Q_OBJECT

public:
    VImageWidget(QWidget *parent=0);

    void setImage(const QString &path, const QString &author);

protected:
    bool event(QEvent *);

signals:
    void next();
    void previous();

private slots:
    void orientationChanged();

private:
    bool isLandscape();
    bool keyboardEvent(QKeyEvent *event);
    bool screentapEvent(QMouseEvent *event);
    bool gestureEvent(QGestureEvent *event);
    bool handleSwipe(QSwipeGesture *swipe);

    QLabel *mAuthor;
    QLabel *mImage;
    QPixmap mPixmap;
};

#endif // VIMAGEWIDGET_H
