//  © Copyright 2010 Reuben D'Netto (rdnetto+uremote@gmail.com)
//  This file is part of uRemote v1.0
//
//  uRemote is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  uRemote is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with uRemote.  If not, see <http://www.gnu.org/licenses/>.


#ifndef JSON_H
#define JSON_H

#include <QString>
#include <QStringList>
#include <QMap>
#include "torrentdata.h"

class JSON{
private:
	JSON(){}
	static void AddEntry(QMap<QString, QString>& dict, QString data);
	static QStringList SplitArray(QString data);
	static QString Trim(QString data);

public:
	static QMap<QString, QString> ParseDictionary(QString data);
	static QStringList ParseLabels(QString data);
	static QStringList ParseHashes(QString data);
	static QList<TorrentData> ParseTorrents(QString data);
	static void ParseFiles(QList<TorrentData>& torrents, QMap<QString, QList<TorrentFile> >& filelists, QString data);
};

#endif // JSON_H
