//  © Copyright 2010 Reuben D'Netto (rdnetto+uremote@gmail.com)
//  This file is part of uRemote v1.0
//
//  uRemote is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  uRemote is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with uRemote.  If not, see <http://www.gnu.org/licenses/>.


#include "addtorrentdialog.h"
#include "ui_addtorrentdialog.h"
#include <QFileDialog>

AddTorrentDialog::AddTorrentDialog(QWidget *parent, BtConnection* con) :
        QMainWindow(parent), m_ui(new Ui::AddTorrentDialog){

        m_ui->setupUi(this);

	Connection = con;
	m_ui->UrlGrp->hide();

	connect(m_ui->FileRdo, SIGNAL(toggled(bool)), this, SLOT(UpdateView()));
	connect(m_ui->UrlRdo, SIGNAL(toggled(bool)), this, SLOT(UpdateView()));
	connect(m_ui->BrowseBtn, SIGNAL(clicked()), this, SLOT(Browse()));
	connect(m_ui->AddBtn, SIGNAL(clicked()), this, SLOT(AddTorrent()));
	connect(m_ui->CancelBtn, SIGNAL(clicked()), this, SLOT(close()));
}

AddTorrentDialog::~AddTorrentDialog(){
	delete m_ui;
}

void AddTorrentDialog::changeEvent(QEvent *e){
        QWidget::changeEvent(e);
	switch (e->type()) {
	case QEvent::LanguageChange:
		m_ui->retranslateUi(this);
		break;
	default:
		break;
	}
}

void AddTorrentDialog::UpdateView(){
	if(m_ui->FileRdo->isChecked()){
		m_ui->FileGrp->show();
		m_ui->UrlGrp->hide();
	}else{
		m_ui->FileGrp->hide();
		m_ui->UrlGrp->show();
	} //end if
}

void AddTorrentDialog::Browse(){
        QString filename = QFileDialog::getOpenFileName(this,
		"Add Torrent", "/home/user/MyDocs", "Torrents (*.torrent)");
	if(! filename.isEmpty())
		m_ui->PathTxt->setText(filename);
}

void AddTorrentDialog::AddTorrent(){
	if(m_ui->FileRdo->isChecked()){
		Connection->AddFile(m_ui->PathTxt->text());
	}else{
		Connection->AddUrl(m_ui->UrlTxt->text());
	} //end if

	close();
}
