//  © Copyright 2010 Reuben D'Netto (rdnetto+uremote@gmail.com)
//  This file is part of uRemote v1.0
//
//  uRemote is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  uRemote is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with uRemote.  If not, see <http://www.gnu.org/licenses/>.


#include "filterdialog.h"
#include "ui_filterdialog.h"

FilterDialog::FilterDialog(QList<QString> labels, QWidget *parent) :
	QMainWindow(parent), m_ui(new Ui::FilterDialog){
	m_ui->setupUi(this);
	m_ui->scrollArea->setProperty("FingerScrollable", true);
	m_ui->SortCmb->addItems(QString("Name|Status|ETA|Label").split('|')); //order matches values of enum

	for(int i = 0; i < labels.count(); i += 1){
		QRadioButton *button = new QRadioButton(m_ui->scrollAreaWidgetContents);
		button->setText(labels[i]);
		button->setObjectName(labels[i] + "Lbl");

		m_ui->ButtonGrid->addWidget(button, 5 + (i / 2), i % 2);
	} //end for
}

FilterDialog::~FilterDialog(){
	delete m_ui;
}

void FilterDialog::changeEvent(QEvent *e){
	QMainWindow::changeEvent(e);
	switch (e->type()) {
	case QEvent::LanguageChange:
		m_ui->retranslateUi(this);
		break;
	default:
		break;
	}
}

void FilterDialog::closeEvent(QCloseEvent* event){
	foreach(QObject* obj, m_ui->scrollAreaWidgetContents->children()){
		if(obj->objectName().endsWith("Stat") || obj->objectName().endsWith("Lbl")){
			QRadioButton* btn = static_cast<QRadioButton*>(obj);

			if(btn->isChecked()){
				closed(btn->text().replace(" ", ""), btn->objectName().endsWith("Stat"), (TSortMode) m_ui->SortCmb->currentIndex());
				break;
			} //end if
		} //end if
	} //end foreach


	QMainWindow::closeEvent(event);
}

void FilterDialog::select(QString filter, bool isState, TSortMode mode){
	m_ui->SortCmb->setCurrentIndex((int) mode);

	foreach(QObject* obj, m_ui->scrollAreaWidgetContents->children()){
		if(obj->objectName() == filter + (isState ? "Stat" : "Lbl")){
			static_cast<QRadioButton*>(obj)->setChecked(true);
			return;
		} //end if
	} //end foreach

	qDebug(tr("ERROR: Invalid filter '%1'").arg(filter + (isState ? "Stat" : "Lbl")).toLocal8Bit());
}
