**
** DeliTracker Player for (see below)
**
	incdir	"Amiga:includes/"
	include	"silva/easy.i"
	include	"misc/DeliPlayer.i"

	PLAYERHEADER PlayerTagArray
	dc.b	'$VER: Medley player V0.1 for UADE (26.12.2001)',0
	even

PlayerTagArray
	dc.l	DTP_PlayerVersion,1
	dc.l	DTP_PlayerName,Name
	dc.l	DTP_Creator,Comment

	dc.l	DTP_Check2,Checky
	dc.l	DTP_InitPlayer,InitPly
	dc.l	DTP_InitSound,Init
	dc.l	DTP_Interrupt,Play
	dc.l	DTP_EndPlayer,EndPly

	*dc.l	DTP_NextSong,NextSong
	*dc.l	DTP_PrevSong,PrevSong

	dc.l	DTP_SubSongRange,SubsongRange
	dc.l	DTP_Flags,PLYF_SONGEND
	dc.l	TAG_DONE

* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
Name	dc.b	"Medley",0
Comment	dc.b	"Medley replay (c) by Paul van der Valk,",10
	dc.b	"adapted for uade by mld",10
	dc.b	"thanks also to Andi Silva for info and sample replay code",0
	even

* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

Checky:
	moveq	#-1,d0
	move.l	dtg_ChkData(a5),a0
	cmp.l	#"MSOB",(a0)
	bne.b	c_rts
	move.l	a0,data
	addq.l	#4,a0
	add.l	(a0),a0
	move.w	-2(a0),d0
	;subq.w	#1,d0
	move.w	d0,songs
	move.l	a5,dtg
	moveq	#0,d0
c_rts	rts

****

InitPly
	pushm	d2-a6
	clr.w	songnr
	bsr	MyInit
	moveq	#0,d0
	move.l	dtg_AudioAlloc(a5),a0
	jsr	(a0)
	move.w	songs(pc),songnr
	popm	d2-a6
	rts

EndPly
*	bra	Rem
	move.l	dtg_AudioFree(a5),a0
	jmp	(a0)
****

dtg	dc.l	0

module
data	dc.l	0

songnr	dc.w	0
songs	dc.w	0

Play:
	pushm	d0-a6
	bsr	MyInterrupt
	popm	d0-a6
	rts

Init:
	pushm	d1-a6
	bsr.b	MyInit

	move.l	dtg(pc),a5
	move.w	dtg_SndNum(a5),d0

	bsr	StartSong
	popm	d1-a6
	rts

_stop:
	bsr	stop
	move.w	#$f,$dff096
	rts

SubSongrange:
	moveq	#1,d0
	move.w	songs(pc),d1
	rts

SongEnd:
	movem.l	d0-d6/a0-a6,-(sp)
	move.l	dtg(pc),a5
	move.l	dtg_SongEnd(a5),a0
	jsr	(a0)
	movem.l	(sp)+,d0-d6/a0-a6
	rts	


* PV Synth 1.0 - Replayroutine by Paul van der Valk
*
* found in 'Imploder 4.0' ripped and adapted by Andreas da Silva
*	incdir	"include:"
*	include	"silva/replay.i"

*song	dc.w	0
StartSong:
	bsr	L_1050
	;MOVEQ	#1,D0
	BSR.W	L_1058
	BSR.W	L_1048
	rts


Stop:
*	BSR.W	L_11d6
L_29E4	BRA.W	L_12F0


MyInit
	BSR.W	L_1050
	BSR.W	L_F16
	MOVEQ	#$003F,D0
	BSR.W	L_101E

	move.l	module(pc),A0
	addq.l	#4,a0

	BSR.W	L_D3A
	BSR.W	L_11d6
	RTS

L_d26	MOVE.L	A1,D0		; lonely
	BEQ.B	L_D3A
	MOVE.L	A0,-(A7)
	MOVEA.L	A1,A0
	BSR.B	L_D3A
	MOVEA.L	(A7)+,A0
	MOVEQ	#1,D0
	MOVE.L	A0,D1
	BNE.B	L_D3C
	RTS	
L_D3A	MOVEQ	#3,D0
L_D3C	LEA	L_1B7C(PC),A1
L_D40	MOVE.L	A0,D1
	ADD.L	(A0)+,D1
	MOVE.L	D1,(A1)+
	DBRA	D0,L_D40
	RTS

L_F16	LEA	L_1B8C(PC),A0
	MOVEQ	#0,D0
	BSR.B	L_F34
	LEA	L_1C9A(PC),A0
	MOVEQ	#1,D0
	BSR.B	L_F34
	LEA	L_1DA8(PC),A0
	MOVEQ	#2,D0
	BSR.B	L_F34
	LEA	L_1EB6(PC),A0
	MOVEQ	#3,D0
L_F34	ANDI.W	#3,D0
	CLR.B	0(A0)
	MOVEQ	#1,D1
	ASL.W	D0,D1
	MOVE.W	D1,8(A0)
	ORI.W	#-$8000,D1
	MOVE.W	D1,$000A(A0)
	MOVEQ	#0,D1
	MOVE.B	D0,D1
	ASL.W	#4,D1
	ADDI.L	#$00DFF0A0,D1
	MOVE.L	d1,4(a0)
	MOVEQ	#0,D1
	MOVE.B	D0,D1
	ASL.W	#5,D1
	MOVEA.L	L_295C.L,A1
	TST.L	(A1)+
	ADDA.W	D1,A1
	MOVE.L	A1,$004A(A0)
	CLR.B	$0058(A0)
	MOVE.B	D0,D1
	CMP.B	#2,D1
	BCS.B	L_F84
	ST 	$0058(A0)
	EORI.B	#1,D1
L_F84	BTST	#0,D1
	SNE	$0057(A0)
	RTS	
L_F8E	CMP.W	#$1000,D0
	BHI.B	L_F98
	MOVE.W	#$1000,D0
L_F98	MOVE.W	D0,L_1FC4.L

*	MOVEA.L	L_2954(PC),A0
*	MOVE.B	D0,$0401(A0)
*	LSR.W	#8,D0
*	MOVE.B	D0,$0501(A0)

	RTS	
L_fae	MOVE.W	L_1FC4(PC),D0
	RTS	
L_fb4	MOVE.B	D0,L_1FD2.L
	RTS	
L_fbc	MOVE.B	D0,L_1FD3.L
	RTS	
L_fc4	MOVE.B	D0,L_1FD6.L
	RTS	
L_fcc	MOVE.B	D0,L_1FD4.L
	MOVE.B	#1,L_1FD5.L
	RTS	
L_fdc	LEA	L_1FD7(PC),A0
	MOVE.B	D0,(A0)
	LEA	L_1B26(PC),A0
	CMP.B	-1(A0),D0
	BLS.B	L_FEE
	MOVEQ	#0,D0
L_FEE	ANDI.W	#$00FF,D0
	ASL.W	#1,D0
	ADDA.W	D0,A0
	ADDA.W	(A0),A0
	MOVE.L	A0,L_1FC6.L
	MOVE.L	A0,L_1FCA.L
L_1004	MOVE.L	A2,-(A7)
	LEA	L_2960(PC),A2
	MOVEQ	#3,D1
L_100C	MOVEA.L	(A2)+,A1
	MOVE.B	(A0)+,D0
	EXT.W	D0
	MOVE.W	D0,$005A(A1)
	DBRA	D1,L_100C
	MOVEA.L	(A7)+,A2
	RTS	
L_101E	LEA	L_1FD8(PC),A0
L_1022	MOVEM.L	D2-D4,-(A7)
	ANDI.B	#$003F,D0
	MOVEQ	#$003F,D1
	MOVEQ	#$003F,D2
	MOVEQ	#$003F,D3
	MOVEQ	#0,D4
L_1032	MOVE.B	D4,(A0)+
	ADD.B	D0,D1
	CMP.B	D3,D1
	BCS.B	L_103E
	SUB.B	D3,D1
	ADDQ.B	#1,D4
L_103E	DBRA	D2,L_1032
	MOVEM.L	(A7)+,D2-D4
	RTS	
L_1048	ST 	L_2974.L
	RTS	
L_1050	CLR.B	L_2974.L
	RTS	

L_1058	MOVEA.L	L_1B7C(PC),A0
	CMP.B	-1(A0),D0
	BHI.W	L_1146
	ANDI.W	#$00FF,D0
	ASL.W	#2,D0
	ADDA.W	D0,A0
	MOVE.L	(A0),D0
	BEQ.W	L_1146
	ADDA.L	D0,A0
	BSR.B	L_1050
	CLR.B	L_2976.L
	CLR.B	L_2977.L
	MOVEM.L	D2-D7/A2-A6,-(A7)
	MOVEA.L	A0,A2
	LEA	L_2960(PC),A3
	MOVEQ	#0,D2
L_108E	MOVEA.L	(A3)+,A4
	MOVEA.L	A4,A0
	BSR.W	L_1166
	MOVEQ	#0,D0
	MOVE.B	$0010(A2,D2.W),D0
	BEQ.W	L_1134
	ASL.W	#2,D0
	MOVEA.L	L_1B80(PC),A0
	ADDA.W	D0,A0
	ADDA.L	(A0),A0
	ADDA.W	#$0010,A0
	MOVE.L	A0,$002C(A4)
	MOVE.L	A0,$005C(A4)
	MOVEQ	#0,D0
	MOVE.B	$001A(A2,D2.W),D0
	BNE.B	L_10C6
	MOVE.B	$001E(A2),D0
	BNE.B	L_10C6
	MOVEQ	#1,D0
L_10C6	MOVE.B	D0,$00A4(A4)
	ASL.W	#2,D0
	MOVEA.L	L_1B84(PC),A0
	ADDA.W	D0,A0
	ADDA.L	(A0),A0
	MOVE.L	A0,$000C(A4)
	MOVE.B	$0026(A2,D2.W),$00A6(A4)
	BNE.B	L_10E4
	ST 	0(A4)
L_10E4	MOVE.B	$002A(A2,D2.W),$00A7(A4)
	MOVE.B	$0024(A2),D0
	BSR.W	L_101E
	MOVE.B	$0020(A2),D0
	BSR.W	L_fc4
	MOVE.B	$0021(A2),D0
	BSR.W	L_fbc
	MOVE.B	$001F(A2),D0
	BSR.W	L_fb4
	MOVE.B	$0022(A2),D0
	BSR.W	L_fdc
	MOVE.B	$0023(A2),D0
	BSR.W	L_fcc
	MOVE.W	$0018(A2),D0
	BSR.W	L_F8E
	MOVE.B	$002E(A2,D2.W),D0
	LEA	$0064(A4),A0
	BSR.W	L_1022
	MOVE.B	#1,$0030(A4)
L_1134	ADDQ.B	#1,D2
	CMP.B	#4,D2
	BCS.W	L_108E
	MOVEM.L	(A7)+,D2-D7/A2-A6
	MOVEQ	#-1,D0
	BRA.B	L_1148
L_1146	MOVEQ	#0,D0
L_1148	LEA	L_2978(PC),A0
	MOVE.B	D0,(A0)
	RTS	

L_1150	LEA	L_1B8C(PC),A0
	BSR.B	L_1166
	LEA	L_1C9A(PC),A0
	BSR.B	L_1166
	LEA	L_1DA8(PC),A0
	BSR.B	L_1166
	LEA	L_1EB6(PC),A0
L_1166	CLR.B	0(A0)
	CLR.B	$0030(A0)
	CLR.B	2(A0)
	CLR.B	3(A0)
	CLR.B	$0062(A0)
	CLR.B	$00A8(A0)
	CLR.B	$00A9(A0)
	MOVE.B	#1,$002B(A0)
	CLR.W	$00AA(A0)
	CLR.W	$00AC(A0)
	CLR.W	$005A(A0)
	CLR.W	$0010(A0)
	LEA	$001A(A0),A1
	CLR.L	(A1)+
	CLR.L	(A1)+
	CLR.L	(A1)+
	CLR.L	(A1)+
	TST.B	$0051(A0)
	BNE.B	L_11B2
	MOVE.W	8(A0),$00DFF096.L
L_11B2	MOVEQ	#$003F,D0
	MOVE.B	D0,$0063(A0)
	LEA	$0064(A0),A0
	BRA.W	L_1022
L_11c0	TST.B	L_2976.L
	BNE.B	L_11FE
	BSR.W	L_12F0
	LEA	L_1B7C(PC),A0
	LEA	L_24B4(PC),A1
	BRA.B	L_11F4

L_11d6	BSR.W	L_12F0
	ST 	L_2979.L
	LEA	L_1B7C(PC),A0
	LEA	L_2018(PC),A1
	TST.B	L_2976.L
	BEQ.B	L_11F4
	LEA	L_24B4(PC),A0
L_11F4	MOVE.W	#$024D,D0
L_11F8	MOVE.W	(A0)+,(A1)+
	DBRA	D0,L_11F8
L_11FE	RTS	

L_1200	BSR.W	L_12F0
	TST.B	L_2979.L
	BEQ.B	L_11FE
	LEA	L_2018(PC),A0
	LEA	L_1B7C(PC),A1
	TST.B	L_2976.L
	BEQ.B	L_1220
	LEA	L_24B4(PC),A1
L_1220	BSR.B	L_11F4
	MOVE.W	L_1FC4(PC),D0
	BRA.W	L_F8E
L_122a	BSR.W	L_12F0

	bsr	SongEnd			; dtg_songend func

	LEA	L_24B4(PC),A0
	LEA	L_1B7C(PC),A1
	BSR.B	L_11F4
	MOVE.W	L_1FC4(PC),D0
	BRA.W	L_F8E
L_1240	MOVE.W	D0,-(A7)
	BSR.W	L_11c0
	MOVE.W	(A7)+,D0
	BSR.W	L_1058
	SNE	L_2976.L
	RTS	

L_1254	MOVE.W	D0,-(A7)	; lonely
	MOVEM.L	A0-A1,-(A7)
	BSR.W	L_12F0
	BSR.W	L_11c0
	MOVEM.L	(A7)+,A0-A1
	BSR.W	L_d26
	MOVE.W	(A7)+,D0
	BSR.W	L_1058
	SNE	L_2976.L
	RTS

L_1278	MOVEA.L	L_1B7C(PC),A0
	BRA.B	L_128E
L_127e	MOVEA.L	L_1B80(PC),A0
	BRA.B	L_128E
L_1284	MOVEA.L	L_1B84(PC),A0
	BRA.B	L_128E
L_128a	MOVEA.L	L_1B88(PC),A0
L_128E	CMP.B	-1(A0),D0
	BLS.B	L_1298
	MOVEQ	#0,D0
	BRA.B	L_12A6
L_1298	ANDI.W	#$00FF,D0
	ASL.W	#2,D0
	ADDA.W	D0,A0
	MOVE.L	(A0),D0
	BEQ.B	L_12A6
	ADD.L	A0,D0
L_12A6	MOVEA.L	D0,A0
	RTS	
L_12aa	BSR.W	L_1284
	BEQ.B	L_12B6
	LEA	L_12BA(PC),A0
	BSR.B	L_12D0
L_12B6	TST.L	D0
	RTS	
L_12BA	MOVE.L	D0,$000C(A0)
	CLR.W	$0010(A0)
	LEA	$001A(A0),A1
	CLR.L	(A1)+
	CLR.L	(A1)+
	CLR.L	(A1)+
	CLR.L	(A1)+
	RTS	
L_12D0	MOVE.L	A6,-(A7)
	MOVEA.L	A0,A6
	LEA	L_1B8C(PC),A0
	JSR	(A6)
	LEA	L_1C9A(PC),A0
	JSR	(A6)
	LEA	L_1DA8(PC),A0
	JSR	(A6)
	LEA	L_1EB6(PC),A0
	JSR	(A6)
	MOVEA.L	(A7)+,A6
	RTS	

L_12F0	BSR.W	L_1050
	LEA	L_12FA(PC),A0
	BRA.B	L_12D0

L_12FA	TST.B	$0051(A0)
	BNE.B	L_1308
	MOVE.W	8(A0),$00DFF096.L
L_1308	RTS

L_130a	BSR.B	L_131E
	ST 	$0051(A0)
	MOVEA.L	4(A0),A0
	RTS
L_1316	BSR.B	L_131E
	CLR.B	$0051(A0)
	RTS
L_131E	ANDI.W	#3,D0
	ASL.W	#2,D0
	LEA	L_2960(PC),A0
	MOVEA.L	(A0,D0.W),A0
	RTS

	
MyInterrupt:
	ADDQ.W	#1,L_2970.L
	TST.B	L_2974.L
	BEQ.B	l_rts
L_1374	MOVEM.L	D0-A6,-(A7)
	TST.B	L_2977.L
	BEQ.B	L_1394
	CLR.B	L_2977.L
	CLR.B	L_2976.L
	BSR.W	L_122a
	BSR.W	L_1048
L_1394	MOVE.B	L_1FD4(PC),D0
	BEQ.B	L_13BC
	LEA	L_1FD5(PC),A0
	SUBQ.B	#1,(A0)
	BNE.B	L_13BC
	MOVE.B	D0,(A0)
	MOVEA.L	L_1FC6(PC),A0
	CMPI.B	#-$0080,(A0)
	BNE.B	L_13B2
	MOVEA.L	L_1FCA(PC),A0
L_13B2	BSR.W	L_1004
	MOVE.L	A0,L_1FC6.L
L_13BC	LEA	L_1B8C(PC),A2
	BSR.B	L_13DA
	LEA	L_1C9A(PC),A2
	BSR.B	L_13DA
	LEA	L_1DA8(PC),A2
	BSR.B	L_13DA
	LEA	L_1EB6(PC),A2
	BSR.B	L_13DA
	MOVEM.L	(A7)+,D0-A6
l_rts	RTS	

L_13DA	TST.B	0(A2)
	BEQ.W	L_18AE
	MOVEA.L	$000C(A2),A3
	TST.B	$0030(A2)
	BEQ.B	L_1466
	SUBQ.B	#1,$002B(A2)
	BNE.B	L_1466
	ST 	$003F(A2)
	CLR.B	$0062(A2)
	MOVEA.L	$002C(A2),A0
L_13FE	MOVEQ	#0,D0
	MOVE.B	(A0)+,D0
	BMI.B	L_1434
	BEQ.B	L_1414
	MOVE.B	D0,1(A2)
	ST 	2(A2)
	ST 	3(A2)
	BRA.B	L_141C
L_1414	CLR.B	2(A2)
	CLR.B	3(A2)
L_141C	MOVE.B	(A0)+,$002B(A2)
	BEQ.B	L_13FE
	BPL.B	L_142E
	CLR.B	3(A2)
	BCLR	#7,$002B(A2)
L_142E	MOVE.L	A0,$002C(A2)
	BRA.B	L_1466
L_1434	MOVE.B	(A0)+,D1
	ANDI.W	#$000F,D0
	ASL.W	#1,D0
	LEA	L_1446(PC,D0.W),A1
	ADDA.W	(A1),A1
	JSR	(A1)
	BRA.B	L_13FE
L_1446	DC.W	L_1926-L_1446
L_1448	DC.W	l_rts-L_1448
L_144a	DC.W	L_1976-L_144a
L_144c	DC.W	L_198c-L_144c
L_144e	DC.W	L_19aa-L_144e
L_1450	DC.W	L_19d2-L_1450
L_1452	DC.W	L_1a02-L_1452
L_1454	DC.W	L_1a22-L_1454
L_1456	DC.W	L_1a42-L_1456
L_1458	DC.W	l_rts-L_1458
L_145a	DC.W	l_rts-L_145a
L_145c	DC.W	l_rts-L_145c
L_145e	DC.W	l_rts-L_145e
L_1460	DC.W	l_rts-L_1460
L_1462	DC.W	l_rts-L_1462
L_1464	DC.W	l_rts-L_1464
L_1466	SUBQ.B	#1,$0062(A2)
	BPL.W	l_rts
	MOVE.B	L_1FD6(PC),$0062(A2)
	TST.B	$003F(A2)
	BEQ.W	L_15E6
	CLR.B	$003F(A2)
	MOVE.B	1(A2),D2
	ADD.B	L_1FD2(PC),D2
	ADD.B	$00A9(A2),D2
	ADD.B	$0013(A3),D2
	CMPI.B	#2,$0010(A3)
	BNE.B	L_14E0
	MOVEQ	#-1,D0
	MOVEQ	#$000C,D1
L_149C	ADDQ.B	#1,D0
	SUB.B	D1,D2
	BCC.B	L_149C
	MOVE.B	D0,$003E(A2)
	ADD.B	D1,D2
	EXT.W	D2
	ASL.W	#1,D2
	LEA	L_1A60(PC),A0
	MOVE.W	(A0,D2.W),$004E(A2)
	MOVEQ	#0,D0
	MOVE.B	$0014(A3),D0
	ASL.W	#2,D0
	MOVEA.L	L_1B88(PC),A0
	ADDA.W	D0,A0
	ADDA.L	(A0),A0
	MOVE.L	A0,$0040(A2)
	MOVE.W	$0010(A0),$0044(A2)
	ADDA.W	#$0018,A0
	MOVE.L	A0,$0046(A2)
	CLR.B	$0050(A2)
	BRA.W	L_15E6
L_14E0	MOVE.B	D2,D0
	CMP.B	#$003E,D0
	BCS.B	L_152A
	CMP.B	#$0056,D0
	BCS.B	L_150C
	CMP.B	#$0062,D0
	BCS.B	L_1500
	LEA	$001C(A3),A0
	MOVE.B	#7,$003E(A2)
	BRA.B	L_1572
L_1500	LEA	$001B(A3),A0
	MOVE.B	#6,$003E(A2)
	BRA.B	L_1576
L_150C	CMP.B	#$004A,D0
	BCS.B	L_151E
	LEA	$001A(A3),A0
	MOVE.B	#5,$003E(A2)
	BRA.B	L_157A
L_151E	LEA	$0019(A3),A0
	MOVE.B	#4,$003E(A2)
	BRA.B	L_157E
L_152A	CMP.B	#$0026,D0
	BCS.B	L_154E
	CMP.B	#$0032,D0
	BCS.B	L_1542
	LEA	$0018(A3),A0
	MOVE.B	#3,$003E(A2)
	BRA.B	L_1582
L_1542	LEA	$0017(A3),A0
	MOVE.B	#2,$003E(A2)
	BRA.B	L_1586
L_154E	CMP.B	#$001A,D0
	BCS.B	L_1560
	LEA	$0016(A3),A0
	MOVE.B	#1,$003E(A2)
	BRA.B	L_158A
L_1560	LEA	$0015(A3),A0
	CLR.B	$003E(A2)
	BRA.B	L_158E
L_156A	DC.B	$00,$0C,$18,$24,$30,$3C,$48,$54
L_1572	MOVE.B	-(A0),D0
	BNE.B	L_1590
L_1576	MOVE.B	-(A0),D0
	BNE.B	L_1590
L_157A	MOVE.B	-(A0),D0
	BNE.B	L_1590
L_157E	MOVE.B	-(A0),D0
	BNE.B	L_1590
L_1582	MOVE.B	-(A0),D0
	BNE.B	L_1590
L_1586	MOVE.B	-(A0),D0
	BNE.B	L_1590
L_158A	MOVE.B	-(A0),D0
	BNE.B	L_1590
L_158E	MOVE.B	-(A0),D0
L_1590	MOVE.B	D0,$003D(A2)
	MOVEQ	#0,D1
	MOVE.B	D0,D1
	ASL.W	#2,D1
	MOVEA.L	L_1B88(PC),A1
	ADDA.W	D1,A1
	ADDA.L	(A1),A1
	MOVE.L	A1,$0040(A2)
	MOVEA.L	A1,A0
	ADDA.W	#$0018,A0
	MOVE.L	A0,$0046(A2)
	MOVEQ	#0,D1
	MOVE.B	$0014(A1),D1
	SUB.B	L_156A(PC,D1.W),D2
	MOVE.W	$0010(A1),D6
	CMPI.B	#1,$0010(A3)
	BNE.B	L_15CA
	SUBQ.B	#6,D2
	SUBQ.B	#6,D2
L_15CA	ADDI.B	#$0030,D2
	MOVEQ	#0,D1
	MOVE.B	D2,D1
	MOVE.B	D1,$003C(A2)
	ASL.W	#1,D1
	LEA	L_1A48(PC),A0
	MOVE.W	(A0,D1.W),$004E(A2)
	MOVE.W	D6,$0044(A2)
L_15E6	MOVE.W	$004E(A2),$0012(A2)
	MOVE.W	$0010(A2),D0
	TST.B	3(A2)
	BEQ.B	L_15FC
	MOVEQ	#0,D0
	CLR.B	$002A(A2)
L_15FC	TST.B	2(A2)
	BEQ.B	L_1630
	TST.B	$002A(A2)
	BEQ.B	L_161A
	SUB.W	$002E(A3),D0
	BCS.B	L_1614
	CMP.W	$002A(A3),D0
	BHI.B	L_1638
L_1614	MOVE.W	$002A(A3),D0
	BRA.B	L_1638
L_161A	ADD.W	$002C(A3),D0
	BCS.B	L_1626
	CMP.W	$0028(A3),D0
	BCS.B	L_1638
L_1626	MOVE.W	$0028(A3),D0
	ST 	$002A(A2)
	BRA.B	L_1638
L_1630	SUB.W	$0030(A3),D0
	BCC.B	L_1638
	MOVEQ	#0,D0
L_1638	MOVE.W	D0,$0010(A2)
	MOVE.W	D0,$0014(A2)
	CLR.W	$0016(A2)
	CLR.W	$0018(A2)
	CLR.B	$0061(A2)
	LEA	$0032(A3),A4
	LEA	$001A(A2),A6
	MOVEQ	#3,D7
L_1656	TST.B	(A4)
	BEQ.W	L_1760
	MOVE.W	(A6),D0
	TST.B	3(A2)
	BEQ.B	L_16AA
	MOVE.B	6(A4),2(A6)
	TST.B	2(A4)
	BNE.B	L_16AA
	CLR.B	3(A6)
	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVE.B	7(A4),D1
	BEQ.B	L_168C
	TST.B	$0056(A2,D1.W)
	BEQ.B	L_168C
	ST 	3(A6)
	MOVE.W	$000C(A4),D0
L_168C	CMPI.B	#1,(A4)
	BNE.B	L_1698
	TST.B	6(A4)
	BNE.B	L_16A4
L_1698	MOVE.B	8(A4),D1
	BEQ.B	L_16AA
	TST.B	$0056(A2,D1.W)
	BEQ.B	L_16AA
L_16A4	MOVE.W	$000C(A4),D0
	LSR.W	#1,D0
L_16AA	TST.B	2(A6)
	BNE.B	L_16E2
	TST.B	3(A6)
	BNE.B	L_16CC
	ADD.W	$000E(A4),D0
	BCS.B	L_16C2
	CMP.W	$000C(A4),D0
	BCS.B	L_16E6
L_16C2	MOVE.W	$000C(A4),D0
	ST 	3(A6)
	BRA.B	L_16E6
L_16CC	SUB.W	$0010(A4),D0
	BEQ.B	L_16D6
	BCC.B	L_16E6
	MOVEQ	#0,D0
L_16D6	TST.B	3(A4)
	BNE.B	L_16E6
	CLR.B	3(A6)
	BRA.B	L_16E6
L_16E2	SUBQ.B	#1,2(A6)
L_16E6	MOVE.W	D0,(A6)
	TST.B	1(A4)
	BEQ.B	L_16FA
	MOVEQ	#0,D0
	TST.B	3(A6)
	BEQ.B	L_16FA
	MOVE.W	$000C(A4),D0
L_16FA	TST.B	5(A4)
	BEQ.B	L_1706
	NEG.W	D0
	ADD.W	$000C(A4),D0
L_1706	CMPI.B	#2,(A4)
	BCS.B	L_1752
	BEQ.B	L_1726
	CMPI.B	#4,(A4)
	BCS.B	L_1732
	BEQ.B	L_173A
	CMPI.B	#6,(A4)
	BCS.B	L_1742
	BEQ.B	L_174A
	LSR.W	#8,D0
	ADD.B	D0,$0061(A2)
	BRA.B	L_1760
L_1726	SUB.W	D0,$0014(A2)
	BCC.B	L_1760
	CLR.W	$0014(A2)
	BRA.B	L_1760
L_1732	LSR.W	#8,D0
	ADD.W	D0,$0016(A2)
	BRA.B	L_1760
L_173A	LSR.W	#8,D0
	ADD.W	D0,$0018(A2)
	BRA.B	L_1760
L_1742	LSR.W	#5,D0
	ADD.W	D0,$0012(A2)
	BRA.B	L_1760
L_174A	LSR.W	#5,D0
	SUB.W	D0,$0012(A2)
	BRA.B	L_1760
L_1752	MOVE.W	$000C(A4),D1
	LSR.W	#1,D1
	SUB.W	D0,D1
	ASR.W	#8,D1
	ADD.W	D1,$0012(A2)
L_1760	ADDA.W	#$0012,A4
	ADDQ.W	#4,A6
	DBRA	D7,L_1656
	MOVEA.L	$0040(A2),A1
	MOVE.W	$0044(A2),D6
	MOVEA.L	$0046(A2),A0
	MOVE.B	$0010(A3),D0
	BEQ.W	L_1836
	SUBQ.B	#1,D0
	BEQ.W	L_183C
	SUBQ.B	#1,D0
	BNE.W	L_1828
	MOVEQ	#0,D2
	MOVE.B	$0012(A3),D2
	ADD.W	$0018(A2),D2
	CMP.W	$0054(A2),D2
	BNE.B	L_17A0
	TST.B	$0050(A2)
	BNE.B	L_1810
L_17A0	MOVE.W	D2,$0054(A2)
	MOVEQ	#$0020,D6
	MOVEQ	#0,D4
	MOVE.B	$001C(A3),D4
	ADD.B	$0061(A2),D4
	MOVE.W	D4,D5
	LSR.W	#4,D4
	BNE.B	L_17B8
	MOVEQ	#$0010,D4
L_17B8	ANDI.W	#$000F,D5
	BNE.B	L_17C0
	MOVEQ	#$0010,D5
L_17C0	MOVE.B	$003E(A2),D0
	MOVE.B	D0,D1
	SUBQ.B	#4,D1
	BCS.B	L_17DA
	CMP.B	#4,D1
	BLS.B	L_17D2
	MOVEQ	#4,D1
L_17D2	LSR.W	D1,D6
	ASL.W	D1,D4
	ASL.W	D1,D5
	MOVEQ	#4,D0
L_17DA	MOVE.B	D0,$0060(A2)
	MOVEA.L	$0046(A2),A0
	MOVEA.L	$004A(A2),A1
	MOVEQ	#0,D3
	MOVE.W	D6,D7
	LSR.W	#1,D6
	MOVE.W	D6,$0052(A2)
	MOVE.W	$0044(A2),D6
	SUBQ.W	#1,D6
L_17F6	AND.W	D6,D2
	AND.W	D6,D3
	MOVE.B	(A0,D2.W),D0
	ADD.B	(A0,D3.W),D0
	ADD.W	D4,D2
	ADD.W	D5,D3
	MOVE.B	D0,(A1)+
	SUBQ.B	#1,D7
	BNE.B	L_17F6
	ST 	$0050(A2)
L_1810	MOVE.W	$0012(A2),D0
	MOVE.B	$0060(A2),D1
	LSR.W	D1,D0
	MOVE.W	D0,$0012(A2)
	MOVE.W	$0052(A2),D2
	MOVEA.L	$004A(A2),A0
	BRA.B	L_1866
L_1828	TST.B	3(A2)
	BNE.B	L_1836
	MOVEA.L	L_295C(PC),A0
	MOVEQ	#2,D2
	BRA.B	L_1866
L_1836	MOVE.W	D6,D2
	LSR.W	#1,D2
	BRA.B	L_1866
L_183C	MOVE.W	D6,D2
	LSR.W	#2,D2
	MOVEQ	#0,D0
	MOVE.B	$0011(A3),D0
	ADD.W	$0016(A2),D0
	MOVE.B	$0014(A1),D1
	LSR.B	D1,D0
	BCLR	#0,D0
	BEQ.B	L_185E
	TST.B	$0016(A1)
	BEQ.B	L_185E
	ADDA.W	D6,A0
L_185E	LSR.W	#1,D6
	SUBQ.W	#1,D6
	AND.W	D6,D0
	ADDA.W	D0,A0
L_1866	MOVE.L	A0,$0036(A2)
	MOVE.W	D2,$003A(A2)
	TST.B	$0051(A2)
	BNE.B	L_18A8
	MOVEA.L	4(A2),A1
	MOVE.L	A0,(A1)
	MOVE.W	D2,4(A1)
	MOVE.W	$0012(A2),D0
	ADD.W	$005A(A2),D0
	MOVE.W	D0,6(A1)
	MOVEQ	#0,D0
	MOVE.B	$0014(A2),D0
	LSR.B	#2,D0
	MOVE.B	$0064(A2,D0.W),D0
	LEA	L_1FD8(PC),A0
	MOVE.B	(A0,D0.W),8(A1)
	MOVE.W	$000A(A2),$00DFF096.L
L_18A8	CLR.B	3(A2)
	RTS	
L_18AE	TST.B	$00A6(A2)
	BEQ.B	L_1912
	MOVE.W	L_2970(PC),D0
	ANDI.W	#3,D0
	BNE.B	L_1912
	TST.B	$00A8(A2)
	BNE.B	L_18D6
	BSR.B	L_1914
	MOVE.B	$00A7(A2),D1
	SUBQ.B	#1,D1
	AND.B	D1,D0
	ADD.B	$00A6(A2),D0
	MOVE.B	D0,$00A8(A2)
L_18D6	SUBQ.B	#1,$00A8(A2)
	BNE.B	L_1912
	BSR.B	L_1914
	MOVEA.L	$005C(A2),A0
	MOVEQ	#0,D1
	MOVE.B	1(A0),D1
	SUBQ.B	#1,D1
	AND.W	D1,D0
	ASL.W	#1,D0
	MOVE.B	3(A0,D0.W),D1
	ASL.W	#2,D1
	MOVEA.L	L_1B80(PC),A0
	ADDA.W	D1,A0
	MOVE.L	(A0),D0
	BEQ.B	L_1912
	ADDA.L	D0,A0
	ADDA.W	#$0010,A0
	MOVE.L	A0,$002C(A2)
	MOVE.B	#1,$002B(A2)
	ST 	0(A2)
L_1912	RTS	
L_1914	MOVE.W	L_2972(PC),D0
	ADD.W	L_2970(PC),D0
	MOVE.W	D0,L_2972.L
	LSR.W	#4,D0
	RTS	
L_1926	MOVE.W	$00AA(A2),D0
	BEQ.B	L_193A
	SUBQ.W	#4,$00AA(A2)
	LEA	$00AE(A2),A1
	MOVEA.L	-4(A1,D0.W),A0
	RTS	
L_193A	TST.B	L_2976.L
	BEQ.B	L_1948
	ST 	L_2977.L
L_1948	TST.B	$00A6(A2)
	BNE.B	L_195C
	;TST.B	L_1FD3.L
	;BEQ.B	L_195C
	MOVEA.L	$005C(A2),A0

	bsr	SongEnd

	RTS	
L_195C	CLR.B	0(A2)
	TST.B	$0051(A2)
	BNE.B	L_1972
	MOVEA.L	4(A2),A1
	MOVE.W	8(A2),$00DFF096.L
L_1972	TST.L	(A7)+
	RTS	

L_1976	MOVE.B	D1,D0
	LSR.B	#1,D0
	MOVE.B	D0,$0063(A2)
	MOVE.L	A0,-(A7)
	LEA	$0064(A2),A0
	BSR.W	L_1022
	MOVEA.L	(A7)+,A0
	RTS	
L_198c	MOVEQ	#0,D0
	MOVE.B	D1,D0
	ASL.W	#2,D0
	MOVEA.L	L_1B84(PC),A1
	ADDA.W	D0,A1
	MOVE.L	(A1),D0
	BEQ.B	L_19A8
	ADDA.L	D0,A1
	MOVEA.L	A1,A3
	MOVE.L	A1,$000C(A2)
	MOVE.B	D1,$00A4(A2)
L_19A8	RTS	
L_19aa	ANDI.W	#$00FF,D1
	BEQ.B	L_19D0
	SUBQ.W	#1,D1
	BSR.W	L_1914
	AND.W	D1,D0
	ASL.W	#1,D0
	MOVEQ	#0,D1
	MOVE.B	1(A0,D0.W),D1
	ASL.W	#2,D1
	MOVEA.L	L_1B80(PC),A1
	MOVE.L	(A1,D1.W),D0
	BEQ.B	L_19D0
	ADDA.L	D0,A1
	MOVEA.L	A1,A0
L_19D0	RTS	
L_19d2	MOVEQ	#0,D0
	MOVE.B	D1,D0
	ASL.W	#2,D0
	MOVEA.L	L_1B80(PC),A1
	ADDA.W	D0,A1
	MOVE.L	(A1),D1
	BEQ.B	L_1A00
	ADDA.W	#$0010,A1
	ADD.L	A1,D1
	MOVE.W	$00AA(A2),D0
	CMP.W	#$0020,D0
	BCC.B	L_1A00
	ADDQ.W	#4,$00AA(A2)
	LEA	$00AE(A2),A1
	MOVE.L	A0,(A1,D0.W)
	MOVEA.L	D1,A0
L_1A00	RTS	
L_1a02	MOVE.W	$00AC(A2),D0
	CMP.W	#$0020,D0
	BCC.B	L_1A20
	ADDQ.W	#4,$00AC(A2)
	LEA	$00CE(A2),A1
	MOVE.L	A0,(A1,D0.W)
	LEA	$00EE(A2),A1
	MOVE.B	D1,(A1,D0.W)
L_1A20	RTS	
L_1a22	MOVE.W	$00AC(A2),D0
	BEQ.B	L_1A3A
	LEA	$00EE(A2),A1
	SUBQ.B	#1,-4(A1,D0.W)
	BEQ.B	L_1A3C
	LEA	$00CE(A2),A1
	MOVEA.L	-4(A1,D0.W),A0
L_1A3A	RTS	
L_1A3C	SUBQ.W	#4,$00AC(A2)
	RTS	
L_1a42	MOVE.B	D1,$00A9(A2)
	RTS

L_1A48	DC.W	$3C00
	DC.W	$3880
	DC.W	$3580
	DC.W	$3280
	DC.W	$2FA0
	DC.W	$2D00
	DC.W	$2A60
	DC.W	$2800
	DC.W	$25C0
	DC.W	$23A0
	DC.W	$21A0
	DC.W	$1F9C
L_1A60	DC.W	$1E00
	DC.W	$1C40
	DC.W	$1AC0
	DC.W	$1940
	DC.W	$17D0
	DC.W	$1680
	DC.W	$1530
	DC.W	$1400
	DC.W	$12E0
	DC.W	$11D0
	DC.W	$10D0
	DC.W	$FE0
	DC.W	$F00
	DC.W	$E20
	DC.W	$D60
	DC.W	$CA0
	DC.W	$BE8
	DC.W	$B40
	DC.W	$A98
	DC.W	$A00
	DC.W	$970
	DC.W	$8E8
	DC.W	$868
	DC.W	$7F0
	DC.W	$780
	DC.W	$710
	DC.W	$6B0
	DC.W	$650
	DC.W	$5F4
	DC.W	$5A0
	DC.W	$54C
	DC.W	$500
	DC.W	$4B8
	DC.W	$474
	DC.W	$434
	DC.W	$3F8
	DC.W	$3C0
	DC.W	$388
	DC.W	$358
	DC.W	$328
	DC.W	$2FA
	DC.W	$2D0
	DC.W	$2A6
	DC.W	$280
	DC.W	$25C
	DC.W	$23A
	DC.W	$21A
	DC.W	$1FC
	DC.W	$1E0
	DC.W	$1C4
	DC.W	$1AC
	DC.W	$194
	DC.W	$17D
	DC.W	$168
	DC.W	$153
	DC.W	$140
	DC.W	$12E
	DC.W	$11D
	DC.W	$10D
	DC.W	$FE
	DC.W	$F0
	DC.W	$E2
	DC.W	$D6
	DC.W	$CA
	DC.W	$BE
	DC.W	$B4
	DC.W	$AA
	DC.W	$A0
	DC.W	$97
	DC.W	$8F
	DC.W	$87
	DC.W	$7F
	DC.W	$78
	DC.W	$71
	DC.W	$6B
	DC.W	$65
	DC.W	$5F
	DC.W	$5A
	DC.W	$55
	DC.W	$50
	DC.W	$4C
	DC.W	$48
	DC.W	$44
	DC.W	$40
	DC.W	$3C
	DC.W	$39
	DC.W	$35
	DC.W	$32
	DC.W	$2F
	DC.W	$2D
	DC.W	$2A
	DC.W	$28
	DC.W	$26
	DC.W	$24
	DC.W	$22
	DC.W	$20
	DC.W	$1E
	DC.W	$1C
	DC.W	5
L_1B26	DC.W	$C
	DC.W	$F
	DC.W	$16
	DC.W	$1D
	DC.W	$2C
	DC.W	$3B
	DC.W	0
	DC.W	0
	DC.W	-$7FFF
	DC.W	$100
	DC.W	0
	DC.W	1
	DC.W	$180
	DC.W	1
	DC.W	$2FF
	DC.W	$100
	DC.W	-$FE
	DC.W	-$8000
	DC.W	$102
	DC.W	-$FF
	DC.W	$2FF
	DC.W	2
	DC.W	-$100
	DC.W	$1FF
	DC.W	1
	DC.W	$280
	DC.W	0
	DC.W	-$1FE
	DC.W	$1FF
	DC.W	-$FF
	DC.W	$2FE
	DC.W	0
	DC.W	$1FF
	DC.W	-$FF
	DC.W	-$7F02
	DC.W	-$100
	DC.W	$1FF
	DC.W	1
	DC.W	$200
	DC.W	$102
	DC.W	-$FF
	DC.W	$2FF
	DC.W	-$180
L_1B7C	DC.L	0
L_1B80	DC.L	0
L_1B84	DC.L	0
L_1B88	DC.L	0
L_1B8C	BLK.B	270,0
L_1C9A	BLK.B	270,0
L_1DA8  BLK.B	270,0
L_1EB6	BLK.B	270,0
L_1FC4	DC.W	0
L_1FC6	DC.L	0
L_1FCA	DC.L	0,0
L_1FD2	DC.B	0
L_1fd3	DC.B	0
L_1FD4	DC.B	0
L_1FD5	DC.B	0
L_1FD6	DC.B	0
L_1FD7	DC.B	0
L_1FD8	BLK.B	64,0
L_2018	BLK.L	295,0
L_24B4	BLK.L	296,0
L_295C	DC.L	buffer8
L_2960	DC.L	L_1B8C,L_1C9A,L_1DA8,L_1EB6
L_2970	DC.W	0
L_2972	DC.W	0
L_2974	DC.B	0
	DC.B	0
L_2976	DC.B	0
L_2977	DC.B	0
L_2978	DC.B	0
L_2979	DC.B	0
buffer8	blk.b	$84,0

	END
