unit ftpsavedlg; 

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  ComCtrls, ExtCtrls, ShellCtrls, SynEdit, IdFTP, IdComponent, IdFTPList,
  IdFTPListParseUnix, txkinscroller, qt4, qtwidgets, ftpServerList, conic, txdbus;

type

  { TFTPSaveDlgF }

TFTPSaveDlgF = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Edit1: TEdit;
    Label1: TLabel;
    lv: TListView;
    Panel1: TPanel;
    Panel2: TPanel;
    Timer1: TTimer;
    tv: TTreeView;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure tvClick(Sender: TObject);
    procedure tvExpanding(Sender: TObject; Node: TTreeNode;
      var AllowExpansion: Boolean);
    procedure tvMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure tvMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure tvMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure tvSelectionChanged(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
    RemoteFileName : string;
    LocalFileName  : string;
    ftp : TIdFTP;
    root_node : TTreeNode;
    kinscroll : TTxKinScroller;
    currentStatus : TIdStatus;
    currentServer : TxFtpServer;
    procedure ftpWorkBeginEvent(ASender: TObject; AWorkMode: TWorkMode; AWorkCountMax: Int64);
    procedure ftpWorkEndEvent(ASender: TObject; AWorkMode: TWorkMode);
    procedure ftpWorkEvent(ASender: TObject; AWorkMode: TWorkMode; AWorkCount: Int64);
    procedure ftpOnConnected(Sender: TObject);
    procedure ftpDirParseEnd(Sender: TObject);
    procedure ftpDirParseStart(Sender: TObject);
    procedure ftpStatusEvent(ASender: TObject; const AStatus: TIdStatus; const AStatusText: string);
    procedure SetWorking(working : boolean; status : string = '');
    procedure OnExpandingTV(Node : TTreeNode);
  end; 

var
  FTPSaveDlgF: TFTPSaveDlgF;
  ClearingTV : boolean;

implementation

uses MainUnit, TxInputDlg;

{$R *.lfm}

{ TFTPSaveDlgF }

procedure TFTPSaveDlgF.OnExpandingTV(Node : TTreeNode);
var
  temp_path : string;
  temp_node : TTreeNode;
  i, r : integer;
begin
  if Node.Level > 0 then
    begin
      SetWorking(True,'Listing folders');
      // Find the path
      temp_path := '/'+Node.Text;
      temp_node := Node.Parent;
      if Node.Level > 1 then
        for i := Node.Level downto 2 do
          begin
            temp_path := '/'+temp_node.Text+temp_path;
            temp_node := temp_node.Parent;
          end;
      // Get the list
      for r := 0 to Node.Count-1 do
        begin
          try
            ftp.List(temp_path+'/'+Node.Items[r].Text);
          finally
            Node.Items[r].DeleteChildren;
            for i := 0 to ftp.DirectoryListing.Count-1 do
              begin
                if ftp.DirectoryListing[i].ItemType = ditDirectory then
                  begin
                    tv.Items.AddChild(Node.Items[r],ftp.DirectoryListing[i].FileName);
                  end;
              end;
          end;
        end;
      SetWorking(False);
    end;
end;

procedure TFTPSaveDlgF.SetWorking(working : boolean; status : string = '');
begin
  Application.ProcessMessages;
  if working then
    begin
      QWidget_setAttribute(TQtWidget(Self.Handle).Widget,QtWA_Maemo5ShowProgressIndicator , true);
      Panel2.Enabled := False;
      Panel1.Enabled := False;
      if status <> '' then
        begin
          Label1.Visible := True;
          Label1.Caption := 'Action : '+status;
        end;
    end
  else
    begin
      QWidget_setAttribute(TQtWidget(Self.Handle).Widget,QtWA_Maemo5ShowProgressIndicator , False);
      Label1.Visible := False;
      Panel2.Enabled := True;
      Panel1.Enabled := True;
    end;
  Application.ProcessMessages;
end;

procedure TFTPSaveDlgF.ftpOnConnected(Sender: TObject);
begin
end;

procedure TFTPSaveDlgF.ftpStatusEvent(ASender: TObject; const AStatus: TIdStatus; const AStatusText: string);
begin
  currentStatus := AStatus;
end;

procedure TFTPSaveDlgF.ftpWorkBeginEvent(ASender: TObject; AWorkMode: TWorkMode; AWorkCountMax: Int64);
begin

end;

procedure TFTPSaveDlgF.ftpWorkEndEvent(ASender: TObject; AWorkMode: TWorkMode);
begin

end;

procedure TFTPSaveDlgF.ftpWorkEvent(ASender: TObject; AWorkMode: TWorkMode; AWorkCount: Int64);
begin
  {}
end;

procedure TFTPSaveDlgF.ftpDirParseStart(Sender: TObject);
begin
end;

procedure TFTPSaveDlgF.ftpDirParseEnd(Sender: TObject);
begin
end;

procedure TFTPSaveDlgF.Button1Click(Sender: TObject);
begin
  if ftpServerListF.ShowModal <> mrOk then
    Exit;
  if not CreateWorkingIC then
    begin
      ShowDBusMiniMessage('No internet connection available, connection failed!');
      Exit;
    end;
  SetWorking(True,'Connecting!');
  ftp := TIdFTP.Create(Self);
  ftp.OnWorkBegin := @ftpWorkBeginEvent;
  ftp.OnWorkEnd := @ftpWorkEndEvent;
  ftp.OnWork := @ftpWorkEvent;
  ftp.OnConnected := @ftpOnConnected;
  ftp.OnDirParseEnd := @ftpDirParseEnd;
  ftp.OnDirParseStart := @ftpDirParseStart;
  ftp.OnStatus := @ftpStatusEvent;
  ftp.Host := ftpServerListF.Edit2.Text;
  ftp.Username := ftpServerListF.Edit3.Text;
  ftp.Password := ftpServerListF.Edit4.Text;
  ftp.Port:= StrToInt(ftpServerListF.Edit5.Text);
  ftp.Passive := ftpServerListF.CheckBox2.Checked;
  currentServer := ftpServerListF.currentServer;
  ClearingTV := True;
  tv.Items.Clear;
  ClearingTV := False;
  lv.Clear;
  try
    ftp.Connect;
  except
    on E:Exception do
      begin
        ShowMessage(E.Message);
        SetWorking(False);
        Exit;
      end;
  end;
  Timer1.Enabled := True;
end;

procedure TFTPSaveDlgF.Button2Click(Sender: TObject);
var
  temp_path, fname : string;
  temp_node : TTreeNode;
  temp_item : TListItem;
  i : integer;
begin
  if tv.Selected.Level > 0 then
    begin
      // Find the path
      temp_path := '/'+tv.Selected.Text;
      temp_node := tv.Selected.Parent;
      for i := tv.Selected.Level downto 2 do
        begin
          temp_path := '/'+temp_node.Text+temp_path;
          temp_node := temp_node.Parent;
        end;
    end;
  fname := ExtractFileName(Edit1.Text);
  if fname = '' then
    begin
      ShowMessage('Enter a file name first!');
      Exit;
    end;
  RemoteFileName := temp_path+'/'+fname;
  ModalResult := MrOk;
end;

procedure TFTPSaveDlgF.Button3Click(Sender: TObject);
var
  i, r : integer;
begin
  SetWorking(True,'Listing Folders');
  try
    ftp.List('');
  except
    on E:Exception do
      begin
        ShowMessage(E.Message);
        SetWorking(False);
        Exit;
      end;
  end;

  root_node := tv.Items.Add(tv.Items.GetFirstNode,'root');
  for i := 0 to ftp.DirectoryListing.Count - 1 do
    begin
      if ftp.DirectoryListing[i].ItemType = ditDirectory then
        begin
          tv.Items.AddChild(root_node,ftp.DirectoryListing[i].FileName);
        end;
    end;

  if root_node.Count < 1 then
    Exit;

  for i := 0 to root_node.Count - 1 do
    begin
      try
        ftp.List(root_node.Items[i].Text);
      except
        on E:Exception do
          begin
            ShowMessage(E.Message);
            SetWorking(False);
            Exit;
          end;
      end;

      for r := 0 to ftp.DirectoryListing.Count - 1 do
        begin
          if ftp.DirectoryListing[r].ItemType = ditDirectory then
            begin
              tv.Items.AddChild(root_node.Items[i],ftp.DirectoryListing[r].FileName);
            end;
        end;
    end;
  SetWorking(False);
end;

procedure TFTPSaveDlgF.Button4Click(Sender: TObject);
var
  temp_path, fname : string;
  temp_node : TTreeNode;
  temp_item : TListItem;
  i : integer;
begin
  if tv.Selected.Level > 0 then
    begin
      // Find the path
      temp_path := '/'+tv.Selected.Text;
      temp_node := tv.Selected.Parent;
      for i := tv.Selected.Level downto 2 do
        begin
          temp_path := '/'+temp_node.Text+temp_path;
          temp_node := temp_node.Parent;
        end;
    end;

  if ftp.Connected then
    begin
      if TxInputDlgF.ShowModal = mrOk then
        begin
          ftp.MakeDir(temp_path+'/'+TxInputDlgF.Edit1.Text);
          tv.Items.AddChild(tv.Selected,TxInputDlgF.Edit1.Text);
          ShowDBusMiniMessage('Directory created!');
        end;
    end
  else
    ShowDBusMiniMessage('Not connected!');
end;

procedure TFTPSaveDlgF.FormClose(Sender: TObject; var CloseAction: TCloseAction
  );
begin
  ftp.Free;
  CloseAction := caHide;
end;

procedure TFTPSaveDlgF.FormCreate(Sender: TObject);
var
  edt : TQtLineEdit;
begin

  edt := TQtLineEdit(Edit1.Handle);
  QWidget_setInputMethodHints(edt.Widget,QtImhNoAutoUppercase);
  edt.StyleSheet:= ' QLineEdit { border: 1px solid gray; ' +
                               ' border-radius: 0px; ' +
                               ' padding: 0 0px; ' +
                               ' background-color : white }';
  kinscroll := TTxKinScroller.Create(FTPSaveDlgF);
  kinscroll.TargetControl := tv;
  kinscroll.Enabled := True;
end;

procedure TFTPSaveDlgF.FormShow(Sender: TObject);
begin
  tv.Items.Clear;
  lv.Clear;
end;

procedure TFTPSaveDlgF.Timer1Timer(Sender: TObject);
begin
  if ftp.Connected and (currentStatus = ftpReady) then
    begin
      Timer1.Enabled := False;
      Button3.OnClick(Self);
    end;
end;

procedure TFTPSaveDlgF.tvClick(Sender: TObject);
begin
  if not kinscroll.InertiaActive and Assigned(tv.Selected) and (currentStatus = ftpReady) then
    begin
      if tv.Selected.Expanded then
        tv.Selected.Collapse(False)
      else
        begin
          OnExpandingTV(tv.Selected);
          tv.Selected.Expand(False);
        end;
    end;
end;

procedure TFTPSaveDlgF.tvExpanding(Sender: TObject; Node: TTreeNode;
  var AllowExpansion: Boolean);
begin
end;

procedure TFTPSaveDlgF.tvMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if Assigned(kinscroll) then
    kinscroll.MouseDown(X,Y);
end;

procedure TFTPSaveDlgF.tvMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  if Assigned(kinscroll) then
    kinscroll.MouseMove(X,Y);
end;

procedure TFTPSaveDlgF.tvMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if Assigned(kinscroll) then
    kinscroll.MouseUp(X,Y);
end;

procedure TFTPSaveDlgF.tvSelectionChanged(Sender: TObject);
var
  temp_path : string;
  temp_node : TTreeNode;
  temp_item : TListItem;
  i, r : integer;
begin
  if ClearingTV then
    Exit;

  if kinscroll.InertiaActive and (currentStatus <> ftpReady) then
    Exit;
  lv.Clear;
  SetWorking(True,'Listing Files');
  if tv.Selected.Level > 0 then
    begin
      // Find the path
      temp_path := '/'+tv.Selected.Text;
      temp_node := tv.Selected.Parent;
      for i := tv.Selected.Level downto 2 do
        begin
          temp_path := '/'+temp_node.Text+temp_path;
          temp_node := temp_node.Parent;
        end;
    end;
  Edit1.Text := temp_path+'/';
  try
    ftp.List(temp_path);
  except
    on E:Exception do
      begin
        ShowMessage(E.Message);
        SetWorking(False);
        Exit;
      end;
  end;

  for i := 0 to ftp.DirectoryListing.Count-1 do
    begin
      if ftp.DirectoryListing[i].ItemType <> ditDirectory then
        begin
          temp_item := lv.Items.Add;
          temp_item.Caption := ftp.DirectoryListing[i].FileName;
        end;
    end;
  SetWorking(False);
end;

end.

