#ifndef ACCOUNTMANAGER_H
#define ACCOUNTMANAGER_H

#include "QtCore/QSettings"

#include "account/account.h"

class AccountManager : public QObject
{
    Q_OBJECT

public:
    static AccountManager *instance(void);
    void setUser(UserInfo* user);
    void setSelected(QString user);
    Account* getSelected();
    void setSelectedAutoLogin(bool option);
    bool isSelectedAutoLogin(void);
    QList<Account>* getUsers(void);
    void saveImage(QImage avatar);
    void saveImage(QImage avatar, QString username);
    QImage getSelectedAvatar(void);
    QString getSelectedImageUrl(void);
    bool userExists(QString user);
    void removeSelected(void);
    bool hasAutoLogin(void);
    int autoLoginPosition(void);
    void saveNewAccount(QString username, QString token, QString tokenSecret);

private:
    AccountManager();
    void _loadSettings(void);
    void _reloadSettings(void);
    void _convertNewSettings(void);
    void _loadVersion(void);
    void _checkVersion(void);
    void _removeAllAccounts(void);

private:
    QSettings *_settings;
    static AccountManager *_instance;
    QMap<QString, Account> _accounts;
    QList<Account> _orderedAccounts;
    QString _autoLogin;
    Account *_selected;
    float _version;
};

#endif // ACCOUNTMANAGER_H
