# -*- coding: utf-8 -*-
import gtk, hildon

helptext = u"""MENU OPTIONS
• Save    Saves your modified configuration to $HOME/.config/tracker/tracker.cfg
• Restore original    Restores configuration to factory default. The existing tracker.cfg file is also copied to tracker.cfg.ORIG when this application runs the first time.
• Help    This screen.
• Restart tracker    Restarts trackerd but leaves current databases as is.
• Rebuild databases    Removes existing databases and restarts trackerd.
• Tail log    Displays output of trackerd log.

CONFIGURATION OPTIONS
[General]
• Verbosity    Log Verbosity (0=errors, 1=minimal, 2=detailed, 3=debug)
• InitialSleep    Initial sleep time in seconds (0->1000)
• LowMemoryMode    Minimizes memory use at the expense of indexing speed
• NFSLocking    Set to TRUE when the home directory is in a NFS filesystem

[Watches]
• WatchDirectoryRoots    List of directory roots to index and watch. Considering the internal disk also see IndexRemovableMedia below. The default listed directories are here because they are hidden.
• CrawlDirectory    List of directory roots to index but NOT watch
• NoWatchDirectory    List of directory roots NOT to index and NOT to watch
• EnableWatching    Set to false to completely disable any watching

[Indexing]
• Throttle    Sets the indexing speed (0->20, where 20=slowest speed)
• EnableIndexing    Set to false to completely disable any indexing
• EnableFileContentIndexing    Set to false to completely disable file content indexing
• EnableThumbnails    Set to false to completely disable thumbnail generation
• DisabledModules    List of disabled modules. The modules that are indexed are kept in $prefix/lib/tracker/indexer-modules
• FastMerges    Set to false to NOT hog the disk for extended periods
• NoIndexFileTypes    List of partial file pattern globs. This is for files to NOT index (basic stat info is only extended for files that match the patterns)
• MinWordLength    Set the minimum length of words to index (0->30, default=3)
• MaxWordLength    Set the maximum length of words to index (0->200, default=30)
• Language    Set the language specific stemmer and stopword list to use. Values include:
- en (English)
- da (Danish)
- nl (Dutch)
- fi (Finnish)
- fr (French)
- de (German)
- it (Italian)
- nb (Norwegian)
- pt (Portugese)
- ru (Russian)
- es (Spanish)
- sv (Swedish)
• EnableStemmer    Set to false to disable language specific stemmer
• BatteryIndex    Set to true to disable indexing when running on battery
• BatteryIndexInitial    Set to true to disable initial indexing when running on battery
• LowDiskSpaceLimit    Pause indexer when disk space is <= this valuem(0->100, value is in % of $HOME file system, -1=disable pausing)
• IndexMountedDirectories    Set to true to enable traversing mounted directories on other file systems (this excludes removable devices)
• IndexRemovableMedia    Set to true to enable traversing mounted directories for removable devices. Do note that both the internal 'N900 disk' (MyDocs) and the microSD card are removable media. That's why the internal disk as default is always indexed completely.

[Performance]
• MaxTextToIndexm    Maximum text size in bytes to index from a file's content
• MaxWordsToIndex    Maximum unique words to index from a file's content
• MinBucketCount
• MaxBucketCount
"""

class HelpWindow(hildon.StackableWindow):
  def __init__(self):
    hildon.StackableWindow.__init__(self)
    self.set_title('Tracker Configuration Help')
    textview = hildon.TextView()
    textbuffer = gtk.TextBuffer()
    textbuffer.set_text(helptext)
    textview.set_buffer(textbuffer)
    textview.set_editable(False)
    textview.set_wrap_mode(gtk.WRAP_WORD)
    pa = hildon.PannableArea()
    pa.add_with_viewport(textview)
    self.add(pa)
    self.show_all()

if __name__=="__main__":
  hw = HelpWindow()
  gtk.main()
