/*
 * Decompiled with CFR 0.152.
 */
package to_do_o.core.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;
import org.kxml2.kdom.Document;
import org.kxml2.kdom.Element;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;
import to_do_o.core.io.FileNotFoundException;

public class ToDoDocument
extends Document {
    protected Element root;

    public ToDoDocument() {
        this.setEncoding("utf8");
    }

    public final int getEntryCount() {
        if (this.root == null) {
            this.getRootElement();
        }
        return this.root.getChildCount();
    }

    public Element getRootElement() {
        if (this.getChildCount() > 0) {
            return this.root;
        }
        this.root = this.createElement("", "root");
        this.root.setAttribute("", "max_id", "0");
        this.addChild(2, this.root);
        return this.root;
    }

    public final int getMaxId() {
        String string = this.root.getAttributeValue("", "max_id");
        if (string != null) {
            return Integer.parseInt(string);
        }
        return -1;
    }

    public final String getMaxIdString() {
        return String.valueOf(this.getMaxId());
    }

    public final void incrementMaxId() {
        int maxId = 1;
        String maxIdStr = this.root.getAttributeValue("", "max_id");
        if (maxIdStr != null) {
            maxId = Integer.parseInt(maxIdStr);
            ++maxId;
        }
        this.root.setAttribute("", "max_id", String.valueOf(maxId));
    }

    public void loadFromFile(String string) throws FileNotFoundException {
        try {
            FileConnection fileConnection = (FileConnection)Connector.open(string, 1);
            if (!fileConnection.exists()) {
                throw new FileNotFoundException("File " + string + " not found!");
            }
            InputStream inputStream = fileConnection.openInputStream();
            this.loadFromInputStream(inputStream);
            inputStream.close();
            fileConnection.close();
            if (this.getMaxId() < 0) {
                this.recursivelyCreateIds(this.root);
                this.saveToFile(string);
            }
            return;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            if (iOException instanceof FileNotFoundException) {
                throw new FileNotFoundException(iOException2.getMessage());
            }
            iOException2.printStackTrace();
            return;
        }
    }

    protected final void loadFromInputStream(InputStream in) throws IOException {
        KXmlParser pars = new KXmlParser();
        try {
            pars.setInput(in, "utf8");
            this.parse((XmlPullParser)pars);
        }
        catch (XmlPullParserException xmlPullParserException) {
            XmlPullParserException e = xmlPullParserException;
            xmlPullParserException.printStackTrace();
        }
        this.root = super.getRootElement();
    }

    public void loadFromRecordStore() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"To-Do_XML", (boolean)true);
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
            if (recordEnumeration.hasNextElement()) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(recordEnumeration.nextRecord());
                Object object = new KXmlParser();
                try {
                    object.setInput((InputStream)byteArrayInputStream, "utf8");
                    this.parse((XmlPullParser)object);
                }
                catch (XmlPullParserException xmlPullParserException) {
                    object = xmlPullParserException;
                    xmlPullParserException.printStackTrace();
                }
                byteArrayInputStream.close();
            }
            recordEnumeration.destroy();
            recordStore.closeRecordStore();
            if (this.getMaxId() < 0) {
                this.recursivelyCreateIds(this.root);
                this.saveToRecordStore();
            }
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    protected final void recursivelyCreateIds(Element element) {
        for (int i = 0; i < element.getChildCount(); ++i) {
            Object object = element.getChild(i);
            if (!(object instanceof Element)) continue;
            object = (Element)object;
            this.incrementMaxId();
            ToDoDocument toDoDocument = this;
            object.setAttribute("", "id", String.valueOf(toDoDocument.getMaxId()));
            this.recursivelyCreateIds((Element)object);
        }
    }

    public void saveToFile(String fileName) throws IOException {
        FileConnection fileConnection = (FileConnection)Connector.open(fileName, 3);
        if (!fileConnection.exists()) {
            fileConnection.create();
        } else {
            fileConnection.truncate(0L);
        }
        OutputStream out = fileConnection.openOutputStream();
        this.saveToOutputStream(out);
        out.close();
        fileConnection.close();
    }

    protected final void saveToOutputStream(OutputStream out) throws IOException {
        KXmlSerializer ser = new KXmlSerializer();
        ser.setOutput(out, "utf8");
        this.write((XmlSerializer)ser);
        ser.flush();
        out.flush();
    }

    public void saveToRecordStore() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        KXmlSerializer kXmlSerializer = new KXmlSerializer();
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"To-Do_XML", (boolean)true);
            kXmlSerializer.setOutput((OutputStream)byteArrayOutputStream, "utf8");
            this.write((XmlSerializer)kXmlSerializer);
            kXmlSerializer.flush();
            kXmlSerializer = recordStore.enumerateRecords(null, null, false);
            if (kXmlSerializer.hasNextElement()) {
                recordStore.deleteRecord(kXmlSerializer.nextRecordId());
            }
            kXmlSerializer.destroy();
            recordStore.addRecord(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.toByteArray().length);
            recordStore.closeRecordStore();
            byteArrayOutputStream.close();
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }
}

