/*
    A Qt game based on Tic Tac Toe for Maemo
    Copyright (C) 2010  Victor Blazquez Francisco <victor.blazquez@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef MACHINEIA_H
#define MACHINEIA_H

class MachineIA
{
	public:
		MachineIA();
		~MachineIA() {};
		void updateMatrix(int p[3][3]);
		int bestPosition();
		int easyLevel();
		int hardLevel();
		void setLevel(int _nivel);
		int level();
	
	private:
		enum Shapes {
			Empty, 
			Machine, // Machine
			Human, // Human
			Img
		};
		enum Levels {
			EasyLevel,
			HardLevel,
			MaxLevel
		};
		int matrix[3][3];
		int nivel;
};

#endif // MACHINEIA_H
