/*
    A Qt game based on Tic Tac Toe for Maemo
    Copyright (C) 2010  Victor Blazquez Francisco <victor.blazquez@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef GRAPHICSVIEW_H
#define GRAPHICSVIEW_H

#include "graphicsscene.h"

#include <QtGui/QGraphicsView>


class GraphicsView : public QGraphicsView
{
	public:
		GraphicsView(QWidget* parent = 0);
		~GraphicsView();
		
		virtual void showEvent (QShowEvent* event);
		void twoPlayers();
		void changeLevel();
		void restartGame();
// 		void askUserName();
		void statistics();
		void changeShape();
		int numberPlayers();
	private:
		GraphicsScene* scene;
};

#endif // GRAPHICSVIEW_H
