/* The MIT License:

Copyright (c) 2009 Ivan Gagis

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE. */

/*
* aumiks 0.1
*/

/*
 * STK library (http://ccrma.stanford.edu/software/stk/index.html) was used as
 * a reference while creating this class.
 */

#pragma once

#include <ting/debug.hpp>
#include <ting/math.hpp>

#include "config.hpp"


namespace aumiks{

class FilterOneZero{
	aumiks::real a0, a1;
	aumiks::real x1;
	aumiks::real y0;
public:

	FilterOneZero(aumiks::real coefA0 = 0.5, aumiks::real coefA1 = 0.5) :
			a0(coefA0),
			a1(coefA1)
	{
		this->Clear();
	}

	void Clear(){
		this->x1 = 0;
		this->y0 = 0;
	}

	void SetCoefs(real coefA0, real coefA1){
		this->a0 = coefA0;
		this->a1 = coefA1;
	}

	inline aumiks::real Tick(aumiks::real sample){
		this->y0 = this->a1 * this->x1 + this->a0 * sample;
		this->x1 = sample;
		return this->y0;
	}
};

}//~namespace
