/* The MIT License:

Copyright (c) 2009 Ivan Gagis

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE. */

/* 
 * File:   ListenView.hpp
 * Author: ivan
 *
 * Created on February 23, 2009, 1:17 AM
 */

#pragma once

#include <deque>

#include <gtkmm/menu.h>
#include <gtkmm/box.h>
#include <gtkmm/label.h>
#include <gtkmm/button.h>

#include <ting/types.hpp>
#include <ting/Thread.hpp>
#include <aumiks/synth/synth.hpp>

#include "BasicWindow.hpp"
#include "dialogs/AboutDialog.hpp"
#include "Preferences.hpp"
#include "MainThread.hpp"



class ListenWindow :
		public BasicWindow,
		public MainThread::NetworkStateListener,
		public MainThread::CurrentPlayerListener
{
	Gtk::Label statusLabel;

	Gtk::Label playerNameLabel;

	Gtk::Button nextButton;


	
	ting::Mutex dispatcherArgMutex;
	std::deque<MainThread::ENetworkState> dispatcherArg;
	unsigned networkStatusDispatcher;

	void NetworkStatusDispatcherHandler();

	//NOTE: this method is called form different thread than UI trhead
	//override
	virtual void OnStateChange(MainThread::ENetworkState newState);



	ting::Mutex curPlayerDispatcherArgMutex;
	std::deque<std::string> curPlayerDispatcherArg;
	unsigned curPlayerDispatcher;

	void CurPlayerDispatcherHandler();

	//NOTE: this method is called form different thread than UI trhead
	//override
	void CurrentPlayer(const std::string& playerUsername);

public:
	ListenWindow();
	~ListenWindow();

private:
	//on_delete_event is sent when the window is closing
	bool OnDeleteEvent(GdkEventAny* event);

public:
	void OnNextButtonClicked();

	void SendNextCommandToServer(){
		this->OnNextButtonClicked();
	}
};



//class ListenWindow : public BasicWindow{
//	ListenView listenView;
//public:
//
//	ListenWindow();
//
//
//};

