// (c) Ivan Gagis
// e-mail: igagis@gmail.com
// Version: 1

// Description:
//	Cast class

#pragma once

#include <list>
#include <deque>

#include <ting/Ref.hpp>
#include <ting/Array.hpp>



//forward declarations
class Client;

typedef std::list<ting::Ref<Client> > T_ClientsList;
typedef T_ClientsList::iterator T_ClientsIter;

class Cast{
	ting::Ref<Client> player;

	T_ClientsList listeners;

	ting::Array<ting::u8> bufferedChunk;

	ting::u32 lastChunkArrivalTimeStamp;
public:
	Cast(ting::Ref<Client> castPlayer) :
			player(castPlayer),
			lastChunkArrivalTimeStamp(0)
	{}

	inline ting::Ref<Client> GetPlayer(){
		return this->player;
	}

	inline ting::u32 GetLastChunkArrivalTimestamp()const{
		return this->lastChunkArrivalTimeStamp;
	}

	void PushNewMusicDataPacket(ting::Array<ting::u8> d);

	void RemoveListener(ting::Ref<Client>& c);
	void AddListenerAndSendDataToClient(ting::Ref<Client>& c);

	inline ting::Ref<Client> PopListener(){
		if(this->listeners.size() == 0)
			return 0;

		ting::Ref<Client> ret = this->listeners.back();
		this->listeners.pop_back();
		return ret;
	}
};

typedef std::list<Cast> T_CastsList;
typedef T_CastsList::iterator T_CastsIter;
