#!/usr/bin/python2.5

##############################################################
##   snuggle - CellID to Geolocation using google's APIs    ##
##############################################################
# get cellid codes via dbus command
#     MCC   :   Mobile Country Code;	
#     MNC   :   Mobile Network Code;
#     LAC   :   Local Area Code; 	
#     CellID:   Cellid;
##############################################################


# Copyright (c) 2011 Christos Zamantzas
# Licenced under GPLv2

#Author: Christos Zamantzas <christos.zamantzas@gmail.com>
Version = '1.9-1'

# TODO:
# * find a better solution for gobject segmentation fault.
# * add two buttons for Edit Mode.
# * add better timestamp (unix time?).
# * create a db and store there the information collected.
# * create a ui to read the db, populate geolocation data if missing and transform it to kml(?) data.
# * create a daemon to log cell info.
# * make a ui to setup daemon options.
# * add in the ui LEDs to indicate status of daemon and updates.


# standard modules
import os
import sys
import time

# access modules
from struct import pack, unpack
from httplib import HTTP
import urllib2
import urllib

# DBus modules
import dbus
from dbus.mainloop.glib import DBusGMainLoop
# import gobject ## gives segmentation fault. Looks like issue: https://bugs.maemo.org/show_bug.cgi?id=10752

# GUI modules
from PyQt4.QtGui import *
from PyQt4.QtCore import *
from PyQt4.QtMaemo5 import *

# GUI model
from snuggleUI import *

# Constants 
country         = "en"
device          = "Nokia-N900-M5"
user_agent      = 'Mozilla/4.0 (compatible; MSIE 5.5; Windows NT)'
url_mmap        = 'http://www.google.com/glm/mmap'
url_geo         = 'http://maps.google.com/maps/geo'
url_map         = 'http://maps.google.com/maps'

# dbus variables
dbus_browser    = 'dbus-send --system --type=method_call\
                            --dest="com.nokia.osso_browser"\
                            --print-reply /com/nokia/osso_browser/request\
                            com.nokia.osso_browser.load_url string:'
dbus_cellid     = 'dbus-send --system --print-reply=literal\
                            --type=method_call\
                            --dest=com.nokia.phone.net\
                            /com/nokia/phone/net Phone.Net.get_registration_status'

# application paths and names                             
LogPath         = '/home/user/.snuggle'
MapName         = 'map.png'
LogCellInfo     = 'cellInfo.txt'
LogGeoInfo      = 'geoLocation.txt'

###########################################################################################
 
def GetTime():
    '''Convert time to readable format.'''

    t = time.localtime( time.time() )

    if t[2] <= 9:
        t2 = '0' + str(t[2])
    else:
        t2 = t[2]

    if t[1] <= 9:
        t1 = '0' + str(t[1])
    else:
        t1 = t[1]

    if t[0] <= 9:
        t0 = '0' + str(t[0])
    else:
        t0 = t[0]

    if t[3] <= 9:
        t3 = '0' + str(t[3])
    else:
        t3 = t[3]

    if t[4] <= 9:
        t4 = '0' + str(t[4])
    else:
        t4 = t[4]

    if t[5] <= 9:
        t5 = '0' + str(t[5])
    else:
        t5 = t[5]
    
    return "%s%s%s_%s_%s_%s" % (t0, t1, t2, t3, t4, t5)

def checkFile(Path, File):       
    ''' Check if a file exists. '''

    try:
        f = open(Path + '/' + File, 'r')
        f.close()
    except:
        return False
    else:
        return True

def showMessage(message):        
    ''' Method to display a message to the user that waits for an action. '''

    os.system('dbus-send --type=method_call --dest=org.freedesktop.Notifications \
               /org/freedesktop/Notifications \
               org.freedesktop.Notifications.SystemNoteDialog \
               string:"%s" uint32:0 string:"OK"' % message)          

def showQuickMessage(message):   
    ''' Method to display shortly a message to the user. '''

    os.system('dbus-send --type=method_call --dest=org.freedesktop.Notifications \
               /org/freedesktop/Notifications \
               org.freedesktop.Notifications.SystemNoteInfoprint \
               string:"%s"' % message)          
               
class snuggleAbout(QtGui.QMainWindow): #FIXME: update info, icon, URLs
    '''About Window'''
    def __init__(self, parent=None):
        QMainWindow.__init__(self,parent)
        self.parent = parent
        self.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
        self.setAttribute(Qt.WA_Maemo5StackedWindow, True)
        self.setWindowTitle("About Snuggle")

        aboutScrollArea = QScrollArea(self)
        aboutScrollArea.setWidgetResizable(True)
        awidget = QWidget(aboutScrollArea)
        awidget.setMinimumSize(470,1000)
        awidget.setSizePolicy( QSizePolicy.Expanding, QSizePolicy.Expanding )
        aboutScrollArea.setSizePolicy( QSizePolicy.Expanding, QSizePolicy.Expanding )
        #Kinetic scroller is available on Maemo and should be on meego
        try:
            scroller = aboutScrollArea.property("kineticScroller").toPyObject()
            scroller.setEnabled(True)
        except:
            pass

        aboutLayout = QVBoxLayout(awidget)

        aboutIcon = QLabel()
        aboutIcon.setPixmap( QIcon.fromTheme('snuggle').pixmap(48,48) )
        aboutIcon.setAlignment( Qt.AlignCenter or Qt.AlignHCenter )
        aboutIcon.resize(128,128)
        aboutLayout.addWidget(aboutIcon)

        aboutLabel = QLabel('''<center><b>Snuggle</b> %s
                                   <br>
                                   <br>
                                   <b>The Snuggle application
                                   <br>uses the cell tower information  
                                   <br>to locate your location   
                                   <br>coordinates.</b>
                                   <br>
                                   <br>Licenced under GPLv2
                                   <br>by <b>Christos Zamantzas</b> (Saturn)
                                   <br>
                                   <br>The application makes use of the  
                                   <br>CellID parameters and Google APIs   
                                   <br>to locate your position in a map.  
                                   <br>
                                   <br>
                                   <b>Additional information on the usage, 
                                   <br>settings and implications can be found 
                                   <br>in the wiki page</b>
                                   <br>
                                   <br>
                                   <br><b>Thanks to :</b>
                                   <br><b>Benoit HERVIER</b> at http://khertan.net/
                                   <br>for the code used in this about window
                                   <br>and the pyPackager utility.
                                   <br>
                                   </center>''' % Version)
        aboutLayout.addWidget(aboutLabel)
        self.bugtracker_button = QPushButton('BugTracker')
        self.bugtracker_button.clicked.connect(self.open_bugtracker)
        self.website_button = QPushButton('Wiki Page')
        self.website_button.clicked.connect(self.open_website)
        awidget2 = QWidget()
        buttonLayout = QHBoxLayout(awidget2)        
        buttonLayout.addWidget(self.bugtracker_button)
        buttonLayout.addWidget(self.website_button)
        aboutLayout.addWidget(awidget2)
        
        awidget.setLayout(aboutLayout)
        aboutScrollArea.setWidget(awidget)
        self.setCentralWidget(aboutScrollArea)
        self.show()        
        
    def open_website(self):
        QDesktopServices.openUrl(QUrl('http://wiki.maemo.org/Snuggle'))
    def open_bugtracker(self):
        QDesktopServices.openUrl(QUrl('https://bugs.maemo.org'))
 
class snuggleMainWindow(QtGui.QMainWindow): #FIXME: cleanup of old code.

    def __init__(self, parent=None):
  
       #Build parent user interface
       QtGui.QWidget.__init__(self, parent)
       self.ui = Ui_snuggleUI()
       self.ui.setupUi(self)
       self.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
       self.setAttribute(Qt.WA_Maemo5StackedWindow, True)
      
       #Connect the GUI Buttons with actions
       ##Application buttons
       QtCore.QObject.connect(self.ui.btnGetCellIDon, QtCore.SIGNAL('clicked()'), self.doTrackOn)
       QtCore.QObject.connect(self.ui.btnGetCellIDoff, QtCore.SIGNAL('clicked()'), self.doTrackOff)
       QtCore.QObject.connect(self.ui.btnSeeMap, QtCore.SIGNAL('clicked()'), self.doSeeMap)
       QtCore.QObject.connect(self.ui.btnGoogleMaps, QtCore.SIGNAL('clicked()'), self.doOpenGoogleMaps)
       ##Application button - edit mode 
       # QtCore.QObject.connect(self.ui.btnGetLocation, QtCore.SIGNAL('clicked()'), self.doGetLocation)
       # QtCore.QObject.connect(self.ui.btnGetCellID, QtCore.SIGNAL('clicked()'), self.doGetCellID)
       ##Application buttons - checkbox
       QtCore.QObject.connect(self.ui.checkBoxGetLocation, QtCore.SIGNAL('clicked()'), self.GetLocationToggled)
      
       ##Connect Menu Buttons 
       QtCore.QObject.connect(self.ui.actionQuit, QtCore.SIGNAL('triggered()'), QtGui.qApp, QtCore.SLOT('quit()'))
       QtCore.QObject.connect(self.ui.actionAbout, QtCore.SIGNAL('triggered()'), self.doAbout)
       QtCore.QObject.connect(self.ui.actionEnable_Edit_Mode, QtCore.SIGNAL('triggered()'), self.doEnableEditMode)
       QtCore.QObject.connect(self.ui.actionDisable_Edit_Mode, QtCore.SIGNAL('triggered()'), self.doDisableEditMode)

       ## Disable all menu entries 
       self.ui.lineCellID.setEnabled(False)
       self.ui.lineMCC.setEnabled(False)
       self.ui.lineMNC.setEnabled(False)
       self.ui.lineLAC.setEnabled(False)
       self.ui.lineLON.setEnabled(False)
       self.ui.lineLAT.setEnabled(False)
       ## Disable buttons that cannot be used just yet
       self.ui.btnSeeMap.setEnabled(False)
       self.ui.btnGoogleMaps.setEnabled(False)
       ## Disable action buttons that cannot be used just yet
       self.ui.actionDisable_Edit_Mode.setEnabled(False)
       ## Hide not needed buttons
       #self.ui.btnGetCellIDon.setHidden(False)
       self.ui.btnGetCellIDoff.setHidden(True)
       #self.ui.btnGetLocation.setHidden(True)
       #self.ui.btnGetCellID.setHidden(True)
         
       # Populate UI with values.
       #self.ui.checkBoxGetLocation.setChecked(True)
       self.doGetCellID()

    def closeEvent (self,event):
       '''Close app grasefully'''

       import gobject
    
       self.ReceiverUnSet()
       time.sleep(1)
       gobject.MainLoop().quit()
       sys.exit(1)
    
    def doTrackOn(self):   
       import gobject

       try:            
          DBusGMainLoop(set_as_default = True)

          self.ReceiverSet()
          self.ui.btnGetCellIDon.setHidden(True)
          self.ui.btnGetCellIDoff.setHidden(False)
          gobject.MainLoop().run()

       except Exception, e:
          print 'Snuggle FATAL ERROR:\n%s' % e

    def doTrackOff(self):   
       import gobject

       self.ui.btnGetCellIDon.setHidden(False)
       self.ui.btnGetCellIDoff.setHidden(True)
       
       self.ReceiverUnSet()
       time.sleep(1)
       gobject.MainLoop().quit()
                    
    def ReceiverSet(self):
       '''Setup the change of cell info signal receiver'''
       bus = dbus.SystemBus()
       # bus.add_signal_receiver(self.doGetCellID, 
       bus.add_signal_receiver(self.received_cellid_info, 
                               path           = '/com/nokia/phone/net',
                               dbus_interface = 'Phone.Net',
                               signal_name    = 'registration_status_change')
       print bus  

    def ReceiverUnSet(self):
       '''Unset the change of cell info signal receiver'''
       bus = dbus.SystemBus()
       # bus.remove_signal_receiver(self.doGetCellID, 
       bus.remove_signal_receiver(self.received_cellid_info, 
                               path           = '/com/nokia/phone/net',
                               dbus_interface = 'Phone.Net',
                               signal_name    = 'registration_status_change')
       print bus  
    
    def GetLocationToggled(self):
       
       MCC    = int(self.ui.lineMCC.text())
       MNC    = int(self.ui.lineMNC.text()) 
       LAC    = int(self.ui.lineLAC.text())
       CELLID = int(self.ui.lineCellID.text())

       if self.ui.checkBoxGetLocation.isChecked() == True:
          self.doGetLocation(MCC,MNC,LAC,CELLID)
       else:
          pass
       
    ##Create Methods
    def doAbout(self):
    
       stackwindow = snuggleAbout(self)
       stackwindow.show()

    def doEnableEditMode(self):
    
       self.doTrackOff()
       
       ## Enable all menu entries 
       self.ui.lineCellID.setEnabled(True)
       self.ui.lineMCC.setEnabled(True)
       self.ui.lineMNC.setEnabled(True)
       self.ui.lineLAC.setEnabled(True)
       self.ui.lineLON.setEnabled(True)
       self.ui.lineLAT.setEnabled(True)
       ## Enable all buttons
       self.ui.btnSeeMap.setEnabled(True)
       self.ui.btnGoogleMaps.setEnabled(True)
       ## Enable only the action buttons that cannot be used atm
       self.ui.actionDisable_Edit_Mode.setEnabled(True)
       self.ui.actionEnable_Edit_Mode.setEnabled(False)
    
    def doDisableEditMode(self):

       ## Disable all menu entries 
       self.ui.lineCellID.setEnabled(False)
       self.ui.lineMCC.setEnabled(False)
       self.ui.lineMNC.setEnabled(False)
       self.ui.lineLAC.setEnabled(False)
       self.ui.lineLON.setEnabled(False)
       self.ui.lineLAT.setEnabled(False)
       ## Disable buttons that cannot be used just yet
       self.ui.btnSeeMap.setEnabled(False)
       self.ui.btnGoogleMaps.setEnabled(False)
       ## Enable only the action buttons that cannot be used atm
       self.ui.actionDisable_Edit_Mode.setEnabled(False)
       self.ui.actionEnable_Edit_Mode.setEnabled(True)
     
    def doGetCellID(self):
       ''' Get cellid info from system'''

       MCC,MNC,LAC,CELLID = self.get_cellid_info()
       print 'MCC:', MCC, ', MNC:', MNC, ', LAC: ', LAC, ', CellID:', CELLID

       self.ui.lineCellID.setText(str(CELLID))
       self.ui.lineMCC.setText(str(MCC))
       self.ui.lineMNC.setText(str(MNC))
       self.ui.lineLAC.setText(str(LAC))
      
       if self.ui.checkBoxGetLocation.isChecked() == True:
          self.doGetLocation(MCC,MNC,LAC,CELLID)
       else:
          pass
          
    def doGetLocation(self,MCC,MNC,LAC,CELLID):
       ''' Get coordinates from Google mmap API'''

       #MCC,MNC,LAC,CELLID = self.get_cellid_info()
       #print MCC, MNC, LAC, CELLID
      
       # MCC    = int(self.ui.lineMCC.text())
       # MNC    = int(self.ui.lineMNC.text()) 
       # LAC    = int(self.ui.lineLAC.text())
       # CELLID = int(self.ui.lineCellID.text())

       LAT,LON,validData,message = self.get_location_by_cell(CELLID, LAC, MNC, MCC)
       print 'LAT:', LAT, ', LON:', LON

       if validData == 'True':
          self.ui.lineLON.setText(str(LON))
          self.ui.lineLAT.setText(str(LAT))
     
          self.ui.btnSeeMap.setEnabled(True)
          self.ui.btnGoogleMaps.setEnabled(True)
       else:
          showQuickMessage(message)
               
    def doSeeMap(self):
       ''' Store a png from location''' 

       LAT = float(self.ui.lineLAT.text())
       LON = float(self.ui.lineLON.text())

       isComplete,message = self.storeMap(LAT, LON)
       showQuickMessage(message)
       
       if isComplete == True:
          stackwindow = OpenImage(self)
          stackwindow.show()
       else:
          pass

    def doOpenGoogleMaps(self):
       ''' Open browser @ google maps @ coordinates'''

       LAT = float(self.ui.lineLAT.text())
       LON = float(self.ui.lineLON.text())
       os.system('%s"%s?q=%f,%f"' % (dbus_browser, url_map, LAT, LON))
     
    def someother(self): #FIXME: not used atm

       LAT = float(self.ui.lineLAT.text())
       LON = float(self.ui.lineLON.text())
       self.get_location_by_geo(LAT, LON)

    def fetch_latlong_http(self, query):
       http = HTTP('www.google.com', 80)
       http.putrequest('POST', '/glm/mmap')
       http.putheader('Content-Type', 'application/binary')
       http.putheader('Content-Length', str(len(query)))
       http.endheaders()
       http.send(query)
      
       code, msg, headers = http.getreply()
       result = http.file.read()
      
       return result

    def fetch_latlong_urllib(self, query):
       headers = { 'User-Agent' : user_agent }
       req = urllib2.Request(url_mmap, query, headers)
       resp = urllib2.urlopen(req)
       response = resp.read()
       return response

    fetch_latlong = fetch_latlong_http

    def get_location_by_cell(self, cid, lac, mnc=0, mcc=0, country='en'):
       latitude = 0
       longitude = 0
       validData = 'False'         
       try:
          b_string = pack('>hqh2sh13sh5sh3sBiiihiiiiii',
                         21, 0,
                         len(country), country,
                         len(device), device,
                         len('1.3.1'), "1.3.1",
                         len('Web'), "Web",
                         27, 0, 0,
                         3, 0, cid, lac,
                         0, 0, 0, 0)
       except:
          message = 'WARNING: Could not construct the http call for fetching the location'
          pass
       else:
          try:
              bytes = self.fetch_latlong_http(b_string)
              #bytes = self.fetch_latlong_urllib(b_string)
              (a, b, errorCode, latitude, longitude, c, d, e) = unpack(">hBiiiiih",bytes)
              print 'ErrorCode: ', errorCode
          except:
              message = 'WARNING: Could not get a valid responce from the MMAP API'
              pass
          else:
              latitude = latitude / 1000000.0
              longitude = longitude / 1000000.0
              message = 'INFO: Got the LAT and LON for this cellID.'
              validData = 'True'
              
       print message
      
       os.system( 'echo \"%s,%s,%s\" >> %s/%s'% ( GetTime(), latitude, longitude, LogPath, LogGeoInfo )) 
         
       return latitude, longitude, validData, message

    def get_location_by_geo(self, latitude, longitude):
       url = '%s?q=%s,%s&output=json&oe=utf8' % (url_geo, str(latitude), str(longitude))
       return urllib2.urlopen(url).read()

    def storeMap(self, latitude, longitude):
       '''Create map of current coordinates.'''

       MapZoom     = 16
       MapSize     = (800,390)
       MarkerColor = 'red'
       MarkerLabel = 'N'

       MapUrl = 'http://maps.google.com/maps/api/staticmap?center=%s,%s&zoom=%s&size=%sx%s&format=png&markers=color:%s|label:%s|%s,%s&sensor=true' \
               % (latitude,
                  longitude,
                  MapZoom,
                  MapSize[0],
                  MapSize[1],
                  MarkerColor,
                  MarkerLabel,
                  latitude,
                  longitude)
       try:
          print MapUrl
          urllib.urlretrieve( MapUrl, '%s/%s' % (LogPath, MapName) )
       except:
          print 'WARNING: failed to create coordinate map (retrieve error)'
          message = 'WARNING: failed to create coordinate map (retrieve error)'
          return False, message
       else:
          if os.path.isfile( '%s/%s' % (LogPath, MapName) ) == True:
              print 'INFO: created coordinate map'
              message = 'INFO: created coordinate map'
              os.system( 'cp %s/%s %s/%s' % ( LogPath, MapName, LogPath, 'map_'+GetTime()+'.png' ) )
              
              return True, message
          else:
              print 'WARNING: failed to create coordinate map (file not found)'
              message =  'WARNING: failed to create coordinate map (file not found)'
              return False, message

    def get_cellid_info(self):
       '''Get cellid info from system'''
         
       info = os.popen(dbus_cellid).read().replace('   byte ','').replace('   uint32 ','').replace('   uint16 ','').replace('   int32 ','').split('\n')
       MCC    = int(info[4])
       MNC    = int(info[3])
       LAC    = int(info[1])
       CELLID = int(info[2])

       os.system( 'echo \"%s,%s,%s,%s,%s\" >> %s/%s'% ( GetTime(), MCC, MNC, LAC, CELLID, LogPath, LogCellInfo )) 
       return MCC, MNC, LAC, CELLID

    def received_cellid_info(self, other1, LAC, CELLID, MNC, MCC, other2, other3):
       '''Decode cellid info from signal'''
         
       MCC    = int(MCC)
       MNC    = int(MNC)
       LAC    = int(LAC)
       CELLID = int(CELLID)
       other1 = int(other1)
       other2 = int(other2)
       other3 = int(other3)
       print 'Received cell info:'
       print 'MCC:', MCC, ', MNC:', MNC, ', LAC: ', LAC, ', CellID:', CELLID, ',other: ', other1, other2, other3

       self.ui.lineCellID.setText(str(CELLID))
       self.ui.lineMCC.setText(str(MCC))
       self.ui.lineMNC.setText(str(MNC))
       self.ui.lineLAC.setText(str(LAC))
      
       if self.ui.checkBoxGetLocation.isChecked() == True:
          self.doGetLocation(MCC,MNC,LAC,CELLID)
       else:
          pass

       os.system( 'echo \"%s,%s,%s,%s,%s\" >> %s/%s'% ( GetTime(), MCC, MNC, LAC, CELLID, LogPath, LogCellInfo )) 
      
class OpenImage(QtGui.QMainWindow):
    def __init__(self, parent = None):
    
       imgFile = LogPath + "/" + MapName
       QMainWindow.__init__(self,parent)
       self.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
       self.setAttribute(Qt.WA_Maemo5StackedWindow, True)
       self.setWindowTitle("Map image of location")
       self.image = QtGui.QImage(imgFile)#.scaled(800,450,Qt.KeepAspectRatio)
       #self.resize(self.image.size())
          
    def paintEvent(self, event):
       p = QtGui.QPainter(self)
       p.drawImage(event.rect(), self.image)

       self.show()
         
class snuggleMain(): 
    
    ##Check with what priviledges the GUI has been executed
    if os.geteuid() == 0:
       message = 'ERROR: The application cannot be executed as root. Exiting..'
       showMessage(message)
       sys.exit(1)
    else:
       pass

    ##Check if temp folder is available
    if os.path.exists(LogPath) == False:
       os.system('mkdir %s' % LogPath)
    else:
       pass
       
    ##Check if log files exist, if not create them
    if checkFile(LogPath, LogCellInfo) == False:
       os.system ( 'echo \"Time,MCC,MNC,LAC,CELLID\" > %s/%s' % (LogPath, LogCellInfo) )
    else:
       pass
       
    if checkFile(LogPath, LogGeoInfo) == False:
       os.system ( 'echo \"Time,LAT,LON\" > %s/%s' % (LogPath, LogGeoInfo) )
    else:
       pass
         
    ##Open Dialog Window
    app = QtGui.QApplication(sys.argv)
    myapp = snuggleMainWindow()
    myapp.show()
    sys.exit(app.exec_())