TEMPLATE = app
TARGET = siggy
DEPENDPATH += .
INCLUDEPATH += .
#OBJECTS_DIR = src
#MOC_DIR = src
#DESTDIR = src

# Input
HEADERS += global.h                   \
           account.h                  \
           dbmanager.h                \
           expense.h                  \
           concept.h                  \
           monthdata.h                \
           controller.h               \
           expensesgraph.h            \
           expensesgraphmodel.h       \
           expensedetailsdialog.h     \
           budgetdialog.h             \
           conceptsdialog.h           \
           conceptdetailsdialog.h     \
           expenseslist.h             \
           scheduledlist.h            \
           scheduleddetailsdialog.h   \
           summarywindow.h            \
           summarydata.h              \
           conceptschart.h            \
           accountsdialog.h           \
           accountdetailsdialog.h     \
           mainwindow.h

SOURCES += dbmanager.cpp              \
           account.cpp                \
           expense.cpp                \
           concept.cpp                \
           monthdata.cpp              \
           controller.cpp             \
           mainwindow.cpp             \
           expensesgraph.cpp          \
           expensesgraphmodel.cpp     \
           expensedetailsdialog.cpp   \
           budgetdialog.cpp           \
           conceptsdialog.cpp         \
           conceptdetailsdialog.cpp   \
           expenseslist.cpp           \
           scheduledlist.cpp          \
           scheduleddetailsdialog.cpp \
           summarywindow.cpp          \
           summarydata.cpp            \
           conceptschart.cpp          \
           accountsdialog.cpp         \
           accountdetailsdialog.cpp   \
           main.cpp

QT+= sql

###################################################
#SET DEFAULT PREFIX FOR PLATFORM                  #
###################################################
isEmpty(PREFIX) {
  maemo5 {
    PREFIX = /usr
    message(Using maemo default prefix: $$PREFIX)
  }

  unix:!maemo5 {
    PREFIX = /usr/local
    message(Using unix default prefix: $$PREFIX)
  }
} else {
  message(Using prefix: $$PREFIX)
}
##################################################



###################################################
#ADD FILES DEPENDING ON PLATFORM                  #
###################################################
unix {
  message(Adding Unix environment configuration)

  BINDIR = $$PREFIX/bin
  DATADIR =$$PREFIX/share

  DEFINES += DATADIR=\"$$DATADIR\" PKGDATADIR=\"$$PKGDATADIR\"

  INSTALLS += target i18n iconxpm icon26 icon48 icon64

    target.path =$$BINDIR

    i18n.path = $$DATADIR/$${TARGET}
    i18n.files += ../i18n/*.qm

    iconxpm.path = $$DATADIR/pixmaps
    iconxpm.files += ../data/icons/$${TARGET}.xpm

    icon26.path = $$DATADIR/icons/hicolor/26x26/apps
    icon26.files += ../data/icons/26x26/$${TARGET}.png

    icon48.path = $$DATADIR/icons/hicolor/48x48/apps
    icon48.files += ../data/icons/48x48/$${TARGET}.png

    icon64.path = $$DATADIR/icons/hicolor/64x64/apps
    icon64.files += ../data/icons/64x64/$${TARGET}.png

  !maemo5 {
    message(Adding desktop version files)

    HEADERS += desktop/mainwindowdesktop.h                   \
               desktop/accountsdialogdesktop.h               \
               desktop/budgetdialogdesktop.h                 \
               desktop/conceptdetailsdialogdesktop.h         \
               desktop/conceptsdialogdesktop.h               \
               desktop/confirmationdialogdesktop.h           \
               desktop/expensedetailsdialogdesktop.h         \
               desktop/scheduleddetailsdialogdesktop.h       \
               desktop/scheduledlistdesktop.h                \
               desktop/summarywindowdesktop.h                \
               desktop/expenseslistdesktop.h                 \
               desktop/accountdetailsdialogdesktop.h

    SOURCES += desktop/mainwindowdesktop.cpp                 \
               desktop/accountsdialogdesktop.cpp             \
               desktop/budgetdialogdesktop.cpp               \
               desktop/conceptdetailsdialogdesktop.cpp       \
               desktop/conceptsdialogdesktop.cpp             \
               desktop/confirmationdialogdesktop.cpp         \
               desktop/expensedetailsdialogdesktop.cpp       \
               desktop/scheduleddetailsdialogdesktop.cpp     \
               desktop/scheduledlistdesktop.cpp              \
               desktop/summarywindowdesktop.cpp              \
               desktop/expenseslistdesktop.cpp               \
                desktop/accountdetailsdialogdesktop.cpp
  }

  maemo5 {
    message(Adding Maemo5 environment configuration)

    QT+= maemo5

    BACKUPDIR = /etc/osso-backup/applications

    INSTALLS += desktop backup

      desktop.path = $$DATADIR/applications/hildon
      desktop.files += ../data/desktop/$${TARGET}.desktop

      backup.path = $$BACKUPDIR
      backup.files += ../data/backup/$${TARGET}.conf

    message(Adding maemo version files)
    HEADERS += maemo/accountdetailsdialogmaemo.h         \
               maemo/accountsdialogmaemo.h               \
               maemo/budgetdialogmaemo.h                 \
               maemo/conceptdetailsdialogmaemo.h         \
               maemo/conceptsdialogmaemo.h               \
               maemo/datechooserdialogmaemo.h            \
               maemo/confirmationdialogmaemo.h           \
               maemo/expensedetailsdialogmaemo.h         \
               maemo/scheduleddetailsdialogmaemo.h       \
               maemo/scheduledlistmaemo.h                \
               maemo/summarywindowmaemo.h                \
               maemo/expenseslistmaemo.h                 \
               maemo/mainwindowmaemo.h

    SOURCES += maemo/accountdetailsdialogmaemo.cpp       \
               maemo/accountsdialogmaemo.cpp             \
               maemo/budgetdialogmaemo.cpp               \
               maemo/conceptdetailsdialogmaemo.cpp       \
               maemo/conceptsdialogmaemo.cpp             \
               maemo/datechooserdialogmaemo.cpp          \
               maemo/confirmationdialogmaemo.cpp         \
               maemo/expensedetailsdialogmaemo.cpp       \
               maemo/scheduleddetailsdialogmaemo.cpp     \
               maemo/scheduledlistmaemo.cpp              \
               maemo/summarywindowmaemo.cpp              \
               maemo/expenseslistmaemo.cpp               \
               maemo/mainwindowmaemo.cpp
  }
}
##################################################
