#include <QHBoxLayout>
#include <QDialogButtonBox>
#include <QDebug>
#include <QListView>
#include <QTreeView>
#include <QPushButton>
#include "accountsdialog.h"
#include "accountsdialogmaemo.h"

AccountsDialogMaemo::AccountsDialogMaemo(QStandardItemModel *accounts,
                                         QWidget *parent,
                                         Qt::WindowFlags f)
        : AccountsDialog (parent, f)
{
        setWindowTitle(tr("Accounts"));

        QHBoxLayout *layout = new QHBoxLayout (this);

        QTreeView *tree = new QTreeView();
        tree->setModel(accounts);
        tree->setProperty("FingerScrollable", true);
        tree->setColumnHidden(0, true);
        tree->setColumnWidth(1, 525);
        tree->setColumnHidden(2, true);
        tree->setColumnWidth(3, 50);
        tree->setHeaderHidden(true);
        tree->setIconSize(QSize(48, 48));
        layout->addWidget(tree, 1);

        connect (tree, SIGNAL(activated(const QModelIndex&)),
                 this, SLOT(detailsSelected(const QModelIndex&)));

        QDialogButtonBox *box = new QDialogButtonBox();
        box->addButton(new QPushButton(tr("New")), QDialogButtonBox::AcceptRole);
        box->addButton(QDialogButtonBox::Cancel);
        layout->addWidget (box, 0, Qt::AlignBottom);

        connect(box, SIGNAL(accepted()), this, SLOT(newSelected()));
        connect(box, SIGNAL(rejected()), this, SLOT(reject()));
}

AccountsDialogMaemo::~AccountsDialogMaemo()
{
}

void AccountsDialogMaemo::newSelected()
{
        accept();
        emit newAccountSelected();
}

void AccountsDialogMaemo::detailsSelected(const QModelIndex &index)
{
        accept();
        emit accountDetailsSelected(index);
}
