#ifndef ACCOUNTDETAILSDIALOGMAEMO_H
#define ACCOUNTDETAILSDIALOGMAEMO_H

#include <QStandardItemModel>
#include <QLabel>
#include <QLineEdit>
#include <QDialogButtonBox>
#include "account.h"
#include "accountdetailsdialog.h"

class AccountDetailsDialogMaemo : public AccountDetailsDialog
{
        Q_OBJECT
 public:
        AccountDetailsDialogMaemo(QStandardItemModel *accounts,
                                  int row,
                                  Account *activeAccount,
                                  QWidget *parent = 0,
                                  Qt::WindowFlags f = 0);
        AccountDetailsDialogMaemo(QWidget *parent = 0,
                                  Qt::WindowFlags f = 0);

 private slots:
        void saveClicked();
        void deleteClicked();
        void newClicked();
        void activateClicked();

 private:
        QLineEdit *_name;
        QLineEdit *_budget;
        QDialogButtonBox *box;
        int _row;
        double accountBudget;
        QString accountName;
        int accountId;
};
#endif
