#ifndef EXPENSEDETAILSDIALOGDESKTOP_H
#define EXPENSEDETAILSDIALOGDESKTOP_H

#include <QLineEdit>
#include <QList>
#include <QDate>
#include "expense.h"
#include "concept.h"
#include <QDialogButtonBox>
#include <QStandardItemModel>
#include <QComboBox>
#include "expensedetailsdialog.h"

class ExpenseDetailsDialogDesktop : public ExpenseDetailsDialog
{
        Q_OBJECT
 public:
        ExpenseDetailsDialogDesktop(const QDate &date,
                                    QStandardItemModel *concepts,
                                    QWidget *parent = 0,
                                    Qt::WindowFlags f = 0);

        ExpenseDetailsDialogDesktop(const QDate &date,
                                    QStandardItemModel *concepts,
                                    QStandardItemModel *expenses,
                                    int row,
                                    QWidget *parent = 0,
                                    Qt::WindowFlags f = 0);

        ~ExpenseDetailsDialogDesktop();
        QSize minimumSizeHint() const;
        QSize sizeHint() const;

 private slots:
        void checkValues();
        void deleteClicked();

 private:
        void buildUI (const QDate &date,
                      QStandardItemModel *concepts);
        QString humanizeDay(const QDate &date,
                            const QDate &currentDate,
                            bool isCurrentMonth);

        QComboBox *day;
        QLineEdit *amount;
        QComboBox *concept;
        QLineEdit *description;
        int expenseId;
        QDialogButtonBox *box;
        bool newExpense;
};
#endif
