#include "conceptsdialogdesktop.h"
#include <QVBoxLayout>
#include <QDialogButtonBox>
#include <QDebug>
#include <QTreeView>
#include <QPushButton>

ConceptsDialogDesktop::ConceptsDialogDesktop(QStandardItemModel *concepts,
                                             QWidget *parent,
                                             Qt::WindowFlags f)
        : ConceptsDialog (parent, f)
{
        setWindowTitle(tr("Items"));

        QVBoxLayout *layout = new QVBoxLayout (this);

        QTreeView *tree = new QTreeView();
        tree->setModel(concepts);
        tree->setColumnWidth(0, 200);
        tree->setColumnWidth(1, 100);
        tree->setUniformRowHeights(true);
        layout->addWidget(tree, 1);

        connect (tree, SIGNAL(activated(const QModelIndex&)),
                 this, SLOT(detailsSelected(const QModelIndex&)));

        QDialogButtonBox *box = new QDialogButtonBox();
        box->addButton(new QPushButton(tr("New")), QDialogButtonBox::AcceptRole);
        box->addButton(QDialogButtonBox::Cancel);
        layout->addWidget (box, 0, Qt::AlignBottom);

        connect(box, SIGNAL(accepted()), this, SLOT(newSelected()));
        connect(box, SIGNAL(rejected()), this, SLOT(reject()));
}

ConceptsDialogDesktop::~ConceptsDialogDesktop()
{
}

void ConceptsDialogDesktop::newSelected()
{
        emit newConceptSelected();
}

void ConceptsDialogDesktop::detailsSelected(const QModelIndex &index)
{
        emit conceptDetailsSelected(index);
}

QSize ConceptsDialogDesktop::minimumSizeHint() const
{
        return QSize(400, 200);
}

QSize ConceptsDialogDesktop::sizeHint() const
{
        return QSize(400, 200);
}
