#include "summarywindow.h"
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QGridLayout>
#include <QDebug>
#include <QMenuBar>
#include <QActionGroup>
#include <QMaemo5InformationBox>

SummaryWindow::SummaryWindow(int minYear,
                             int minMonth,
                             int maxYear,
                             int maxMonth,
                             QWidget *parent)
        : PeriodWindow (minYear, minMonth, maxYear, maxMonth, parent)
{
        setWindowTitle(tr("Month Summary"));

        QActionGroup *actionGroup = new QActionGroup(this);
        QAction *statistics = new QAction(tr("Statistics"), actionGroup);
        connect(statistics, SIGNAL(triggered()), this, SLOT(statisticsSelected()));
        QAction *items = new QAction(tr("Items"), actionGroup);
        connect(items, SIGNAL(triggered()), this, SLOT(itemsSelected()));

        QMenuBar *menuBar = new QMenuBar(this);
        menuBar->addAction(statistics);
        menuBar->addAction(items);

        summaryData = NULL;

        statistics->setCheckable(true);
        items->setCheckable(true);

        /* statistics mode stuff */
        statsBox = new QFrame();
        statsBox->setFrameStyle(QFrame::NoFrame);
        vbox->addWidget(statsBox, 1);

        QGridLayout *statsLayout = new QGridLayout();
        statsBox->setLayout(statsLayout);

        statsLayout->addWidget(new QLabel(tr("Period totals")), 0, 0, 1, 1, Qt::AlignCenter);
        statsLayout->addWidget(new QLabel(tr("Budget")), 1, 0, 1, 1, Qt::AlignCenter);
        totalBudget = new QLabel(QString("0"));
        statsLayout->addWidget(totalBudget, 2, 0, 1, 1, Qt::AlignCenter);
        statsLayout->addWidget(new QLabel(tr("Expenses")), 3, 0, 1, 1, Qt::AlignCenter);
        totalExpense = new QLabel(QString("0"));
        statsLayout->addWidget(totalExpense, 4, 0, 1, 1, Qt::AlignCenter);
        statsLayout->addWidget(new QLabel(tr("Saved")), 5, 0, 1, 1, Qt::AlignCenter);
        totalSaved = new QLabel(QString("0"));
        statsLayout->addWidget(totalSaved, 6, 0, 1, 1, Qt::AlignCenter);

        statsLayout->addWidget(new QLabel(tr("Period expenses")), 0, 1, 1, 1, Qt::AlignCenter);
        statsLayout->addWidget(new QLabel(tr("Minimum")), 1, 1, 1, 1, Qt::AlignCenter);
        minExpense = new QLabel(QString("0"));
        statsLayout->addWidget(minExpense, 2, 1, 1, 1, Qt::AlignCenter);
        statsLayout->addWidget(new QLabel(tr("Maximum")), 3, 1, 1, 1, Qt::AlignCenter);
        maxExpense = new QLabel(QString("0"));
        statsLayout->addWidget(maxExpense, 4, 1, 1, 1, Qt::AlignCenter);
        statsLayout->addWidget(new QLabel(tr("Average")), 5, 1, 1, 1, Qt::AlignCenter);
        averageExpense = new QLabel(QString("0"));
        statsLayout->addWidget(averageExpense, 6, 1, 1, 1, Qt::AlignCenter);

        statsLayout->addWidget(new QLabel(tr("Period saves")), 0, 2, 1, 1, Qt::AlignCenter);
        statsLayout->addWidget(new QLabel(tr("Minimum")), 1, 2, 1, 1, Qt::AlignCenter);
        minSaved = new QLabel(QString("0"));
        statsLayout->addWidget(minSaved, 2, 2, 1, 1, Qt::AlignCenter);
        statsLayout->addWidget(new QLabel(tr("Maximum")), 3, 2, 1, 1, Qt::AlignCenter);
        maxSaved = new QLabel(QString("0"));
        statsLayout->addWidget(maxSaved, 4, 2, 1, 1, Qt::AlignCenter);
        statsLayout->addWidget(new QLabel(tr("Average")), 5, 2, 1, 1, Qt::AlignCenter);
        averageSaved = new QLabel(QString("0"));
        statsLayout->addWidget(averageSaved, 6, 2, 1, 1, Qt::AlignCenter);

        chart = new ConceptsChart();
        vbox->addWidget(chart, 1);

        /* set statistics mode by default */
        statistics->setChecked(true);
        chart->hide();
}

SummaryWindow::~SummaryWindow()
{
        if (summaryData != NULL) {
                delete summaryData;
        }
}

void SummaryWindow::statisticsSelected()
{
        statsBox->show();
        chart->hide();
}

void SummaryWindow::itemsSelected()
{
        statsBox->hide();
        chart->show();
}

void SummaryWindow::setSummaryData(SummaryData *data)
{
        if (summaryData != NULL) {
                delete summaryData;
        }

        summaryData = data;

        totalBudget->setText(QString("%1").arg(summaryData->totalBudget()));
        totalExpense->setText(QString("%1").arg(summaryData->totalExpense()));

        if (summaryData->totalSaved() > 0) {
                totalSaved->setText(QString("<font color='green'>%1</font>")
                                    .arg(summaryData->totalSaved()));
        } else {
                totalSaved->setText(QString("<font color='red'>%1</font>")
                                    .arg(summaryData->totalSaved()));
        }

        minExpense->setText(QString("%1").arg(summaryData->minExpense()));
        maxExpense->setText(QString("%1").arg(summaryData->maxExpense()));
        averageExpense->setText(QString("%1").arg(summaryData->averageExpense()));

        minSaved->setText(QString("%1").arg(summaryData->minSaved()));
        maxSaved->setText(QString("%1").arg(summaryData->maxSaved()));

        if (summaryData->averageSaved() > 0) {
                averageSaved->setText(QString("<font color='green'>%1</font>")
                                    .arg(summaryData->averageSaved()));
        } else {
                averageSaved->setText(QString("<font color='red'>%1</font>")
                                    .arg(summaryData->averageSaved()));
        }

        chart->setSummaryData(summaryData);
        if (chart->isVisible()) {
                chart->repaint();
        }

        if (summaryData->totalExpense() == 0) {
                QMaemo5InformationBox::information(this, tr("Warning: there are no expenses stored in the selected period"));
        }
}
