#include "confirmationdialog.h"
#include <QHBoxLayout>
#include <QDialogButtonBox>
#include <QPushButton>
#include <QLabel>

bool ConfirmationDialog::dialogAccepted = false;

ConfirmationDialog::ConfirmationDialog(const QString &message,
                                       QWidget *parent,
                                       Qt::WindowFlags f)
        : QDialog (parent, f)
{
        setWindowTitle(tr("Confirm action"));

        QHBoxLayout *layout = new QHBoxLayout (this);

        QLabel *label = new QLabel(message);
        label->setWordWrap(true);
        layout->addWidget(label, 1);

        QDialogButtonBox *box = new QDialogButtonBox(Qt::Vertical);
        box->addButton(new QPushButton(tr("Yes")), QDialogButtonBox::YesRole);
        box->addButton(new QPushButton(tr("No")), QDialogButtonBox::NoRole);
        layout->addWidget (box, 0, Qt::AlignBottom);

        connect(box, SIGNAL(accepted()), this, SLOT(confirmationAccepted()));
        connect(box, SIGNAL(rejected()), this, SLOT(confirmationRejected()));
}

ConfirmationDialog::~ConfirmationDialog()
{
}

void ConfirmationDialog::confirmationAccepted()
{
        ConfirmationDialog::dialogAccepted = true;
        accept();
}

void ConfirmationDialog::confirmationRejected()
{
        ConfirmationDialog::dialogAccepted = false;
        reject();
}

bool ConfirmationDialog::askConfirmation(const QString &message)
{
        dialogAccepted = false;
        ConfirmationDialog dialog(message);
        dialog.exec();
        return dialogAccepted;
}
