#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui>
#include <QPushButton>
#include <iostream>
#include <videofile.h>

using namespace std;

class Settings;
class QListWidget;

class MainWindow : public QWidget {
    Q_OBJECT;

    public:
        MainWindow();
        ~MainWindow();

        /**
         * Called on key events. Derived from QWidget.
         */
        void keyPressEvent ( QKeyEvent* event );

    public:
        void updateFileList( const QList<VideoFile*>& files );

    private slots:
        void playButtonPressed();
        void resumeButtonPressed();
        void settingsButtonPressed();
        void helpButtonPressed();
        void fileSelected();
        void cellClicked();
        void resort( int column );
        void playerStart();
        void playerStop();

    private:
        QString toHHMMSS( unsigned int tenthOfASec );

    private:
        QTableView* m_fileList;
        QPushButton* m_playbutton;
        QPushButton* m_resumebutton;
        int m_sortByColumn;
        Qt::SortOrder m_sortOrder;
};

#endif // MAINWINDOW_H
