#ifndef DATADOWNLOADER_H
#define DATADOWNLOADER_H

#include <QObject>
#include <QStringList>
#include <QUrl>
#include <QDate>
#include <QMap>
#include <QSet>

class QFile;
class QIODevice;

struct DownloadInput
{
	QString requestChannel;
	bool	downloadIndicator;
	QDate requestDate;
};

class DataDownloader : public QObject
{
    Q_OBJECT

public:
    DataDownloader( QObject *parent );
    DataDownloader( QObject *parent , const char* datapath);
	virtual void initSettings();
    virtual ~DataDownloader();
	virtual QUrl getUrl() = 0;
	virtual void updateSettingsFile(QString maxDate);
	virtual void checkDataStatus();
	virtual QString saveFile(QString channel, QIODevice *source);
	virtual QString saveZipFile(QString channel, QIODevice *source);
	virtual void setInput(DownloadInput d);
	virtual QString finishedDownload(QString channel, QIODevice *source);
	virtual QStringList getChannelList();
	virtual QString getChannelDisplayName(QString);
	virtual QStringList getFilelist();
	virtual void sendRecordMsg(QStringList input) = 0;
	virtual bool isSingleXMLTVFile() { return true; }
	virtual void splitXMLTVFile(QString filename);
	virtual int timeZoneOffset() { return 0; }
	virtual void clearRegionData();
	virtual QDate getDownloadDate();

signals:

public slots:

private slots:

protected:
	QMap<QString, QSet<QString> > _channelDateMap;
	// BE channels names are different from the channel code we need during a network download request url
	// hence we maintain this mapping as the codes dont mean much to the user while displaying the list :)
	QMap<QString , QString> _channelCodeMap;

	QFile *_settingsFile;
	// input to download
	QString _requestChannel;
	// to indicate data available in files is current or not
	bool _useLocal;
	// to indicate if user has selected the requestCHannel for downloading weekly data
	bool _downloadIndicator;
	// to indicate a date for which download was requested
	QDate _requestDate;

	int _downloadStartIndex;
	int _downloadEndIndex;

	// path to the regional settings file, init'ed by child classes
	const char* DATAPATH;
	QString _channelFile; // hold the channel list filename

private:
};

#endif // DATADOWNLOADER_H
