#ifndef GAMEAREA_H
#define GAMEAREA_H

/*
  RulerJinni - A simple virtual ruler
  Copyright (C) 2009  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <Lum/Object.h>

class GameArea : public Lum::Control
{
private:
  Lum::OS::FontRef  font;
  int               rulerOffset;
  int               scaleOffset;
  bool              dragActive;
  int               dragStartX;
  int               dragStartY;
  int               dragStartRulerOffset;
  int               dragStartScaleOffset;
  size_t            rulerHeight;
  Lum::OS::ColorRef backgroundColor;
  Lum::OS::ColorRef primaryColor;
  Lum::OS::ColorRef secondaryColor;

public:
  GameArea();
  ~GameArea();

  void CalcSize();

  //bool SetModel(Lum::Base::Model* model);

  void Layout();
  void Draw(int x, int y, size_t w, size_t h);

  bool HandleMouseEvent(const Lum::OS::MouseEvent& event);
  bool HandleKeyEvent(const Lum::OS::KeyEvent& event);

  void Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg);
};

#endif
