/*
 * vk-plugin: An account plugin for telepathy-vkontakte
 * Copyright (C) 2010 Ivan Daniluk
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef _VK_PLUGIN_H_
#define _VK_PLUGIN_H_

#include <librtcom-accounts-widgets/rtcom-account-plugin.h>

G_BEGIN_DECLS

#define VK_TYPE (vk_plugin_get_type ())
#define VK_PLUGIN(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), VK_TYPE, VkPlugin))
#define VK_PLUGIN_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), VK_TYPE, VkPluginClass))
#define VK_IS_PLUGIN(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VK_TYPE))
#define VK_IS_PLUGIN_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), VK_TYPE))
#define VK_PLUGIN_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), VK_TYPE, VkPluginClass))

typedef struct _VkPluginClass VkPluginClass;
typedef struct _VkPlugin VkPlugin;

struct _VkPluginClass
{
  RtcomAccountPluginClass parent_class;

  GtkWidget * (*get_login_page) (VkPlugin *plugin, RtcomAccountItem *account);

  GtkWidget * (*get_edit_page) (VkPlugin *plugin, RtcomAccountItem *account);
};

struct _VkPlugin
{
  RtcomAccountPlugin parent_instance;
};

GType vk_plugin_get_type (void) G_GNUC_CONST;

G_END_DECLS

#endif /* _VK_PLUGIN_H_ */
