/*
 * This file is a part of Queen Beecon Widget
 * queen-beecon-location: Utility for QBW GPS/Location Management and Operations
 *
 * http://talk.maemo.org/showthread.php?t=45388
 *
 * Copyright (c) 2010 No!No!No!Yes! (Alessandro Peralma)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version. or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef QUEEN_BEECON_LOCATION_H
#define QUEEN_BEECON_LOCATION_H

typedef enum {
	QBW_INIT_LOCATION_MONITOR,
	QBW_ENABLE_LOCATION_MONITOR,
	QBW_READ_LOCATION_FIX,
	QBW_DISABLE_LOCATION_MONITOR,
	QBW_DEINIT_LOCATION_MONITOR
} QbwLocationAction;

// DBUS Management functions
DBusHandlerResult queen_beecon_location_filter_function(DBusConnection *connection, DBusMessage *message, QueenBeecon *self);
gboolean queen_beecon_location_manager(QueenBeecon *self, QbwLocationAction action);
GtkWidget *queen_beecon_location_settings_selector(void);

#endif /* QUEEN_BEECON_LOCATION_H */

