/*

queen-beecon.c - Queen Beecon Widget
http://talk.maemo.org/showthread.php?t=45388

Copyright (c) 2010 No!No!No!Yes! (Alessandro Peralma)

From and idea/application by cpscotti (Clovis Peruchi Scotti)
(Desktop Command Execution Widget http://talk.maemo.org/showthread.php?t=39177)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

[No!No!No!Yes!]

*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "queen-beecon.h"
#include <hildon/hildon.h>
#include <glib.h>
#include <glib/gprintf.h>
#include <gtk/gtk.h>
#include <libintl.h>
#include <stdlib.h>
#include <string.h>

#include <conic.h>

#define HOME_DIR g_get_home_dir()

#define _(String) dgettext("hildon-libs", String)

#define QUEEN_BEECON_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE (obj, QUEEN_BEECON_TYPE, QueenBeeconPrivate))

#define QUEEN_BEECON_SETTINGS_FILE "/.queen_beecon"
#define QUEEN_BEECON_PRIVATE_DIR "/.queen_beecon_dir/"
#define SYSTEM_PUBLIC_ICON_DIR "/usr/share/icons/hicolor/48x48/hildon/"
#define QUEEN_BEECON_MYDOCS_IMAGE_DIR "/MyDocs/.images/queen_beecon_dir/"
#define QUEEN_BEECON_INSTANCE_BASENAME "queen-beecon.desktop-"
#define SYSTEM_INSTANCE_BASE_DIR "/var/lib/gconf/apps/osso/hildon-desktop/applets"
#define QUEEN_BEECON_SETTINGS_VERSION 1.0

//main settings window
#define NON_GTK_RESPONSE_ADD_CMD 10
#define NON_GTK_RESPONSE_EDIT_CMD 20
#define NON_GTK_RESPONSE_DELETE_CMD 30
#define NON_GTK_RESPONSE_SAVE_AND_RUN 40
#define NON_GTK_RESPONSE_ADVANCED 50
//save is GTK_RESPONSE_OK

#define NETWORK__UNRELATED 0
#define NETWORK__ONLY_CONNECTED 1
#define NETWORK__ONLY_DISCONNECTED 2

#define SIZE_WIDTH_ALL 800
#define SIZE_HEIGHT_ALL 420//AP3
#define SIZE_BEECON_RATIO 2 * 1.7//AP3

struct _colorsRGB
{
	gchar *colorName;
	gchar *colorRGB;
} p_colors[] = {//AP3
		{"Black",	"#000000" },
		{"White", 	"#FFFFFF" },
		{"Gray",	"#808080" },
		{"Lime",	"#00FF00" },
		{"Yellow",	"#FFFF00" },
		{"Red",		"#FF0000" },
		{"Magenta",	"#FF00FF" },
		{"Silver",	"#C0C0C0" },
		{"Olive",	"#808000" },
		{"Purple",	"#800080" },
		{"Maroon",	"#800000" },
		{"Aqua",	"#00FFFF" },
		{"Teal",	"#008080" },
		{"Green",	"#008000" },
		{"Blue",	"#0000FF" },
		{"Navy",	"#000080" },
		{NULL,		"#000000" }
};

gchar * p_justification[] = {//AP3
	"Left","Right","Center","Fill", NULL};//AP1

gchar * p_visible_position[] = {//AP3
	"Hidden","Top Left","Top Center","Top Right","Center Left","Center","Center Right","Bottom Left","Bottom Center","Bottom Right",NULL};//AP1

gchar * p_fonts[] = {//AP1
		"Nokia,Sans","NewCourier","NewTimes","Monospace","Nokia,Sans,Cn","Nokia,Sans,Maps","Nokia,Sans,SemiBold","Sans","Serif","SwissA","Tanseek,Pro,Arabic","Univers,OTS,Arabic",NULL};//AP1

gchar * p_fonts_types[] = {//AP1
	 "Regular", "Italic", "Bold","Italic Bold", NULL};//AP1

void queen_beecon_read_settings ( QueenBeecon *self, gboolean needInstanceSettings, gboolean isImportFromADB, gchar *importData);
void queen_beecon_write_settings (QueenBeecon *self, gboolean needInstanceSettings);
void queen_beecon_update_content (QueenBeecon *self);
void queen_beecon_draw_canvas(GtkWidget *widget);
void queen_beecon_update_content_layout (QueenBeecon *self);
static gboolean queen_beecon_expose_event (GtkWidget *widget, GdkEventExpose *event);
gchar *queen_beecon_g_key_file_get_string(GKeyFile *key_file, const gchar *group_name, const gchar *key, gchar *defaultValue);
gboolean queen_beecon_g_key_file_get_boolean(GKeyFile *key_file, const gchar *group_name, const gchar *key, gboolean defaultValue);
gint queen_beecon_g_key_file_get_integer(GKeyFile *key_file, const gchar *group_name, const gchar *key, gint defaultValue);
gdouble queen_beecon_g_key_file_get_double(GKeyFile *key_file, const gchar *group_name, const gchar *key, gdouble defaultValue);

//Dialogs prototypes:
gboolean queen_beecon_advanced_dialog ( QueenBeecon *self, gint cmdSel);
gboolean queen_beecon_edit_add_dialog ( QueenBeecon *self, gboolean new, gint curr);
void queen_beecon_settings (HDHomePluginItem *hitem, QueenBeecon *self);

//Auxiliary functions' prototypes:
GtkWidget *fontPropertiesSelector(guint Name, /*guint Type, guint Justify,*/ guint size);
void AddCommand(QueenBeecon *self, gchar * s_title, gchar * s_command, gboolean doInstantiate);
void EditCommand(QueenBeecon *self, gchar * s_title, gchar * s_command, gboolean doInstantiate, int index);
void DelCommand(QueenBeecon *self, int index);
guint GetSeconds(guint index);
guint checksum(gchar *buffer);
gboolean is_command_in_use_by_other_instances(gchar *s_title);

guint housekeeping = 0;
void beecon_config_file_housekeeping(gpointer data);

struct _QueenBeeconPrivate
{

	GtkWidget 		*homeWidget;
	GtkWidget 		*currentDialog;
	GtkWidget 		*event;
	GtkWidget 		*contents;

	GtkWidget 		*cmdTitle_lb;
	GtkWidget 		*cmdTitle_img;

	GtkWidget 		*cmdResult_lb;
	GtkWidget 		*cmdResult_img;

	gboolean 		isPressed;

	/* widget's instance identification str */
	gchar 			*widgetID;

	//config data

	//global data
		gchar 		**c_titles;
		gchar 		**c_commands;
		guint 		c_size;

	//instance data
		gboolean 		hideCanvas;
		gboolean 		updOnStartup;
		gboolean 		updOnClick;
		gboolean 		updOnDesktop;
		guint 			updNeworkPolicy;

		gint			widXOrigin;
		gint			widYOrigin;
		gdouble 		widWidth;
		gdouble 		widHeight;//AP

		guint 			snippetBgRGB;

		guint 			beecon_lt0_BgRGB;
		gchar			*beecon_lt0_ImgFilename;
		guint 			beecon_lt0_ImgZoom;

		guint 			beecon_eq0_BgRGB;
		gchar			*beecon_eq0_ImgFilename;
		guint 			beecon_eq0_ImgZoom;

		guint 			beecon_eq1_BgRGB;
		gchar			*beecon_eq1_ImgFilename;
		guint 			beecon_eq1_ImgZoom;

		guint 			beecon_ge2_BgRGB;
		gchar			*beecon_ge2_ImgFilename;
		guint 			beecon_ge2_ImgZoom;

		guint 			beecon_idxge2_BgRGB;
		gchar			*beecon_idxge2_ImgFilename;
		guint 			beecon_idxge2_ImgZoom;

		guint 			operationalStatus; // Instance status 0 maximized/enabled, 1 minimized/disabled
		guint	 		widgetType;//AP3
		gint 			cmdExitStatus;//AP3

		GtkWidget 		*tableLayout;

		gchar			*cmdImgFilename;
		guint 			cmdImgZoom;
		guint 			cmdFgRGB;
		guint 			cmdVisibilityPosition;//AP3
		guint 			cmdImgVisibilityPosition;//AP3
		guint 			cmdJustify;//AP3
		guint 			cmdFontName;//AP1
		gdouble 		cmdFontSize;//AP1

		gchar			*resImgFilename;
		guint 			resImgZoom;
		guint 			resFgRGB;
		guint 			resVisibilityPosition;//AP3
		guint 			resImgVisibilityPosition;//AP3
		guint 			resJustify;//AP3
		guint 			resFontName;//AP1
		gdouble 		resFontSize;//AP1

		gchar 			*instanceTitle;
		gchar 			*instanceCmd;

		//Update on timer data
		guint 			delaySeconds;
		guint 			delayIndex;//index of delaySeconds in the array defined inside "queen_beecon_settings"

		//timer process id; used to stop when closing app or changing delay
		guint 			updateTimerID;

		//network connection query ptr
		ConIcConnection	*connection;
		gboolean 		isConnected;

		//Advanced Dialog data
		gboolean 		instanceImportOK;
		GtkTextBuffer 	*importExportBuffer, *cmdTestDriveBuffer, *cmdOutputBuffer; // Buffers for advanced dialog box
		GtkWidget 		*commandPicker;
};

HD_DEFINE_PLUGIN_MODULE (QueenBeecon, queen_beecon, HD_TYPE_HOME_PLUGIN_ITEM);

//Settings file functions

void queen_beecon_read_settings ( QueenBeecon *self, gboolean needInstanceSettings, gboolean isImportFromADB, gchar *importData)
{
g_warning("(%p) queen_beecon_read_settings",self);
	gchar *filename=NULL, *sourceGroup=NULL;
	gboolean fileExists;
	GKeyFile *keyFile=NULL;
	GError *error=NULL;

	if(self->priv->widgetID == NULL) {
		g_warning("(%p) Widget instance not initialized, not reading settings..", self);
		return;
	}

	keyFile = g_key_file_new();
	g_warning("(%p) keyfile %p", self, keyFile);
	if (!isImportFromADB) {
		sourceGroup=self->priv->widgetID;
	} else {
		g_warning("(%p) Import from ADB", self);
		sourceGroup="queen-beecon-exported-instance";
		fileExists = g_key_file_load_from_data (keyFile, importData, strlen(importData), G_KEY_FILE_KEEP_COMMENTS, NULL);
		if (!fileExists) {
			g_warning("(%p) Import from ADB buffer error", self);
			return;
		} else goto needInstanceSettings;
	}
	filename = g_strconcat (HOME_DIR, QUEEN_BEECON_SETTINGS_FILE, NULL);
	g_warning("(%p) filename %s", self, filename);
	fileExists = g_key_file_load_from_file (keyFile, filename, G_KEY_FILE_KEEP_COMMENTS, NULL);
	g_warning("(%p) fileExists %d", self, fileExists);

	gdouble settingsVer = queen_beecon_g_key_file_get_double (keyFile, "config", "version", QUEEN_BEECON_SETTINGS_VERSION);
	g_warning("(%p) settingsVer %f", self, settingsVer);

	guint cmdListInConsistent = 0;
	if (fileExists) {
		//gets "global" data/commands list
		//BEGIN get list
		g_strfreev(self->priv->c_commands);
		self->priv->c_commands = (gchar **) g_key_file_get_string_list (keyFile, "config", "c_commands", &(self->priv->c_size) ,&error);
		g_warning("(%p) c_size=%d", self, self->priv->c_size);
		//gint i;	for (i=0;i<self->priv->c_size;i++) g_ warning("(%p) c_commands[%d]=%s", self, i, self->priv->c_commands[i]);
		if (error) {
			g_warning("(%p) ERROR g_key_file_get_string_list (keyFile, \"config\", \"c_commands\", ...)", self);
			cmdListInConsistent++;
			g_error_free (error);
			error = NULL;
		}

		guint consistencyCheck = -1;

		g_strfreev(self->priv->c_titles);
		self->priv->c_titles = g_key_file_get_string_list (keyFile, "config", "c_titles", &consistencyCheck ,&error);
		gint j;	for (j=0;j<consistencyCheck;j++) {
			;
			g_warning("(%p) c_titles[%d]=%s", self, j, self->priv->c_titles[j]);
		}
		if (error) {
			g_warning("(%p) ERROR g_key_file_get_string_list (keyFile, \"config\", \"c_titles\", ...)", self);
			cmdListInConsistent++;
			g_error_free (error);
			error = NULL;
		}

		if(consistencyCheck != self->priv->c_size) {
			g_warning("(%p) consistencyCheck FAILED=%d", self, consistencyCheck);
			g_warning("(%p) Settings file corrupted!", self);
			cmdListInConsistent++;
		}
		//END
	} else
		cmdListInConsistent++;
	if (cmdListInConsistent) {
		#define QUEEN_BEECON_TOTAL_FIXED_COMMANDS 13
		gchar * p_titles[] = { "appOK", "appWRN", "appERR", "sysERR", "Uptime:", "Battery(%):", "Battery(mAh):", "Boot Reason:", "Boot Count:", "External IP:", "Internal IP:", "Rootfs(%):", "Free Rootfs:", NULL};
		gchar * p_commands[] = {
		"echo test && exit 0",
		"echo test && exit 1",
		"echo test && exit 2",
		"all_work_and_no_play_makes_jack_a_dull_boy",
		"uptime|cut -d\" \" -f4-|sed 's/\\, *load.*//'",
		"hal-device bme | awk -F\"[. ]\" '$5 == \"is_charging\" {chrg = $7}; $5 == \"percentage\" {perc = $7} END if (chrg == \"false\") {print perc \"%\"} else {print \"Chrg\"}'",
		"hal-device bme | grep battery.reporting | awk -F. '{print $3}' | sort | awk '$1 == \"current\" { current = $3}; $1== \"design\" {print current \"/\" $3}'",
		"cat /proc/bootreason",
		"cat /var/lib/dsme/boot_count",
		"wget -q -O - api.myiptest.com | awk -F \"\\\"\" '{print $4}'",
		"/sbin/ifconfig | grep \"inet addr\" | awk -F: '{print $2}' | awk '{print $1}'",
		"df | awk '$1 == \"rootfs\" {print $5}'",
		"df -h | awk ' $1 == \"rootfs\" {print $4\"B\"}'",
		NULL};
		g_warning("(%p) Records empty, filling with pre-loaded vals", self);
		self->priv->c_size = QUEEN_BEECON_TOTAL_FIXED_COMMANDS;
		//clean possible oldies
		g_strfreev(self->priv->c_titles);
		self->priv->c_titles = NULL;
		g_strfreev(self->priv->c_commands);
		self->priv->c_commands = NULL;
		//assign new from stack values
		self->priv->c_titles = g_strdupv(p_titles);
		self->priv->c_commands = g_strdupv(p_commands);
	}

needInstanceSettings:
	if (needInstanceSettings) {
		/*getting instance specific data*/
		g_warning("(%p) Getting instance specific data: %s", self, sourceGroup);
		//BEGIN
		self->priv->widgetType = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "widgetType", 0);//0=Beecon

		self->priv->operationalStatus = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "operationalStatus", 0);//0=Maximized/Enabled

		self->priv->hideCanvas = queen_beecon_g_key_file_get_boolean (keyFile, sourceGroup, "hideCanvas", FALSE);//FALSE=Show Canvas by default

		self->priv->snippetBgRGB = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "snippetBgRGB", 0);//0=Black

		g_warning("(%p) self->priv->beecon_lt0_ImgFilename = %p", self, self->priv->beecon_lt0_ImgFilename);
		g_free(self->priv->beecon_lt0_ImgFilename);self->priv->beecon_lt0_ImgFilename=NULL;
		self->priv->beecon_lt0_ImgFilename = g_strdup(queen_beecon_g_key_file_get_string (keyFile, sourceGroup, "beecon_lt0_ImgFilename", "queen-beecon-syserr.png"));//No Image filename
		g_warning("(%p) self->priv->beecon_lt0_ImgFilename = %p", self, self->priv->beecon_lt0_ImgFilename);

		self->priv->beecon_lt0_ImgZoom = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "beecon_lt0_ImgZoom", 0);//0=100% 1=Fit to Widget

		self->priv->beecon_lt0_BgRGB = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "beecon_lt0_BgRGB", 2);//2=Gray

		g_warning("(%p) self->priv->beecon_eq0_ImgFilename = %p", self, self->priv->beecon_eq0_ImgFilename);
		g_free(self->priv->beecon_eq0_ImgFilename);self->priv->beecon_eq0_ImgFilename=NULL;
		self->priv->beecon_eq0_ImgFilename = g_strdup(queen_beecon_g_key_file_get_string (keyFile, sourceGroup, "beecon_eq0_ImgFilename", "queen-beecon-appok.png"));//No Image filename
		g_warning("(%p) self->priv->beecon_eq0_ImgFilename = %p", self, self->priv->beecon_eq0_ImgFilename);

		self->priv->beecon_eq0_ImgZoom = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "beecon_eq0_ImgZoom", 0);//0=100% 1=Fit to Widget

		self->priv->beecon_eq0_BgRGB = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "beecon_eq0_BgRGB", 3);//3=Green

		g_warning("(%p) self->priv->beecon_eq1_ImgFilename = %p", self, self->priv->beecon_eq1_ImgFilename);
		g_free(self->priv->beecon_eq1_ImgFilename);self->priv->beecon_eq1_ImgFilename=NULL;
		self->priv->beecon_eq1_ImgFilename = g_strdup(queen_beecon_g_key_file_get_string (keyFile, sourceGroup, "beecon_eq1_ImgFilename", "queen-beecon-appwrn.png"));//No Image filename
		g_warning("(%p) self->priv->beecon_eq1_ImgFilename = %p", self, self->priv->beecon_eq1_ImgFilename);

		self->priv->beecon_eq1_ImgZoom = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "beecon_eq1_ImgZoom", 0);//0=100% 1=Fit to Widget

		self->priv->beecon_eq1_BgRGB = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "beecon_eq1_BgRGB", 4);//4=yellow

		g_warning("(%p) self->priv->beecon_ge2_ImgFilename = %p", self, self->priv->beecon_ge2_ImgFilename);
		g_free(self->priv->beecon_ge2_ImgFilename);self->priv->beecon_ge2_ImgFilename=NULL;
		self->priv->beecon_ge2_ImgFilename = g_strdup(queen_beecon_g_key_file_get_string (keyFile, sourceGroup, "beecon_ge2_ImgFilename", "queen-beecon-apperr.png"));//No Image filename
		g_warning("(%p) self->priv->beecon_ge2_ImgFilename = %p", self, self->priv->beecon_ge2_ImgFilename);

		self->priv->beecon_ge2_ImgZoom = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "beecon_ge2_ImgZoom", 0);//0=100% 1=Fit to Widget

		self->priv->beecon_ge2_BgRGB = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "beecon_ge2_BgRGB", 5);//5=red

		g_warning("(%p) self->priv->beecon_idxge2_ImgFilename = %p", self, self->priv->beecon_idxge2_ImgFilename);
		g_free(self->priv->beecon_idxge2_ImgFilename);self->priv->beecon_idxge2_ImgFilename=NULL;
		self->priv->beecon_idxge2_ImgFilename = g_strdup(queen_beecon_g_key_file_get_string (keyFile, sourceGroup, "beecon_idxge2_ImgFilename", "queen-beecon-index.png"));//No Image filename
		g_warning("(%p) self->priv->beecon_idxge2_ImgFilename = %p", self, self->priv->beecon_idxge2_ImgFilename);

		self->priv->beecon_idxge2_ImgZoom = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "beecon_idxge2_ImgZoom", 0);//0=100% 1=Fit to Widget

		self->priv->beecon_idxge2_BgRGB = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "beecon_idxge2_BgRGB", 11);//5=aqua

		self->priv->widWidth = queen_beecon_g_key_file_get_double (keyFile, sourceGroup, "widWidth", 130.0);//130px
		self->priv->widHeight = queen_beecon_g_key_file_get_double (keyFile, sourceGroup, "widHeight", 115.0);//115px

		g_warning("(%p) self->priv->cmdImgFilename = %p", self, self->priv->cmdImgFilename);
		g_free(self->priv->cmdImgFilename);self->priv->cmdImgFilename=NULL;
		self->priv->cmdImgFilename = g_strdup(queen_beecon_g_key_file_get_string (keyFile, sourceGroup, "cmdImgFilename", "queen-beecon.png"));//No Image filename
		g_warning("(%p) self->priv->cmdImgFilename = %p", self, self->priv->cmdImgFilename);

		self->priv->cmdImgZoom = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "cmdImgZoom", 0);//0=100% 1=Fit to Widget
		self->priv->cmdFgRGB = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "cmdFgRGB", 1);//1-White
		self->priv->cmdVisibilityPosition = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "cmdVisibilityPosition", 2);//2=top-center
		self->priv->cmdImgVisibilityPosition = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "cmdImgVisibilityPosition", 5);//1=center
		self->priv->cmdJustify = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "cmdJustify", 0);//0=left
		self->priv->cmdFontName = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "cmdFontName", 3);//3=(Nokia Sans, Italic, Bold)
		self->priv->cmdFontSize = queen_beecon_g_key_file_get_double (keyFile, sourceGroup, "cmdFontSize", 12);//12

		g_warning("(%p) self->priv->resImgFilename = %p", self, self->priv->resImgFilename);
		g_free(self->priv->resImgFilename);self->priv->resImgFilename=NULL;
		self->priv->resImgFilename = g_strdup(queen_beecon_g_key_file_get_string (keyFile, sourceGroup, "resImgFilename", "queen-beecon-resimg.png"));//No Image filename
		g_warning("(%p) self->priv->resImgFilename = %p", self, self->priv->resImgFilename);

		self->priv->resImgZoom = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "resImgZoom", 0);//0=100% 1=Fit to Widget
		self->priv->resFgRGB = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "resFgRGB", 1);//1=White
		self->priv->resVisibilityPosition = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "resVisibilityPosition", 8);//center-center
		self->priv->resImgVisibilityPosition = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "resImgVisibilityPosition", 9);//bottom-center
		self->priv->resJustify = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "resJustify", 0);//0=left
		self->priv->resFontName = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "resFontName", 2);//2=(Nokia Sans, Bold)
		self->priv->resFontSize = queen_beecon_g_key_file_get_double (keyFile, sourceGroup, "resFontSize", 12);//12

		g_warning("(%p) self->priv->instanceTitle = %p [%s]", self, self->priv->instanceTitle, self->priv->instanceTitle);
		if (self->priv->instanceTitle!=NULL) g_free(self->priv->instanceTitle); self->priv->instanceTitle = NULL;
		self->priv->instanceTitle = queen_beecon_g_key_file_get_string (keyFile, sourceGroup, "instanceTitle", NULL); //If value not found assume first command in fixed list
		g_warning("(%p) self->priv->instanceTitle = %p [%s]", self, self->priv->instanceTitle, self->priv->instanceTitle);

		g_warning("(%p) self->priv->instanceCmd = %p [%s]", self, self->priv->instanceCmd, self->priv->instanceCmd);
		if (self->priv->instanceCmd!=NULL) g_free(self->priv->instanceCmd); self->priv->instanceCmd = NULL;
		self->priv->instanceCmd = queen_beecon_g_key_file_get_string (keyFile, sourceGroup, "instanceCmd", NULL); //If value not found assume first command in fixed list
		g_warning("(%p) self->priv->instanceCmd = %p [%s]", self, self->priv->instanceCmd, self->priv->instanceCmd);

		//BEGIN update policy
		self->priv->updOnStartup = queen_beecon_g_key_file_get_boolean (keyFile, sourceGroup, "updOnStartup", TRUE);//TRUE= Update when widget launched
		self->priv->updOnClick = queen_beecon_g_key_file_get_boolean (keyFile, sourceGroup, "updOnClick", TRUE);//TRUE= Update when clicked
		self->priv->updOnDesktop = queen_beecon_g_key_file_get_boolean (keyFile, sourceGroup, "updOnDesktop", TRUE);//TRUE= Update when widget's desktop switched
		self->priv->delayIndex = (guint) g_key_file_get_integer (keyFile, sourceGroup, "delayIndex", 0);//0=Assume no timer event
		if (self->priv->delayIndex) self->priv->delaySeconds = GetSeconds(self->priv->delayIndex);
		self->priv->updNeworkPolicy = (guint) g_key_file_get_integer (keyFile, sourceGroup, "updNeworkPolicy", NETWORK__UNRELATED);
		//END
	}
	g_key_file_free (keyFile);
	if (!isImportFromADB) g_free (filename);

	queen_beecon_write_settings (self, TRUE);
	g_warning("(%p) Settings file loaded successfully", self);
}

void queen_beecon_write_settings (QueenBeecon *self, gboolean needInstanceSettings)
{
g_warning ("(%p) queen_beecon_write_settings",self);
	GKeyFile *keyFile=NULL;
	gboolean fileExists;

	gchar *fileData=NULL;
	FILE *iniFile=NULL;
	gsize size;
	gchar *filename=NULL;

	if(self->priv->widgetID == NULL) {
		g_warning("(%p) Widget instance not initialized, not writing settings..", self);
		return;
	}

	keyFile = g_key_file_new();
	g_warning("(%p) keyfile %p", self, keyFile);

	filename = g_strconcat (HOME_DIR, QUEEN_BEECON_SETTINGS_FILE, NULL);
	g_warning("(%p) filename %s", self, filename);
	fileExists = g_key_file_load_from_file (keyFile, filename, G_KEY_FILE_KEEP_COMMENTS, NULL);
	g_warning("(%p) fileExists %d", self, fileExists);

	g_key_file_set_double (keyFile, "config", "version", QUEEN_BEECON_SETTINGS_VERSION);

	if(self->priv->c_titles != NULL && self->priv->c_commands != NULL)
	{
		g_warning("(%p) self->priv->c_titles=%p self->priv->c_commands=%p", self, self->priv->c_titles, self->priv->c_commands);
		g_key_file_set_string_list(keyFile, "config", "c_titles", (const gchar **)(self->priv->c_titles),self->priv->c_size);
		g_key_file_set_string_list(keyFile, "config", "c_commands", (const gchar **)(self->priv->c_commands),self->priv->c_size);
	}

	if (needInstanceSettings) {
		g_key_file_set_integer (keyFile, self->priv->widgetID, "widgetType", self->priv->widgetType);//AP3

		g_key_file_set_integer (keyFile, self->priv->widgetID, "operationalStatus", self->priv->operationalStatus);//AP3

		g_key_file_set_boolean (keyFile, self->priv->widgetID, "hideCanvas", self->priv->hideCanvas);//FALSE=Show Canvas by default

		g_key_file_set_integer (keyFile, self->priv->widgetID, "snippetBgRGB", self->priv->snippetBgRGB);//AP3

		g_key_file_set_integer (keyFile, self->priv->widgetID, "beecon_lt0_ImgZoom", self->priv->beecon_lt0_ImgZoom);//AP3
		g_key_file_set_integer (keyFile, self->priv->widgetID, "beecon_lt0_BgRGB", self->priv->beecon_lt0_BgRGB);//AP3
		g_key_file_set_string (keyFile, self->priv->widgetID, "beecon_lt0_ImgFilename", self->priv->beecon_lt0_ImgFilename);//AP3

		g_key_file_set_integer (keyFile, self->priv->widgetID, "beecon_eq0_ImgZoom", self->priv->beecon_eq0_ImgZoom);//AP3
		g_key_file_set_integer (keyFile, self->priv->widgetID, "beecon_eq0_BgRGB", self->priv->beecon_eq0_BgRGB);//AP3
		g_key_file_set_string (keyFile, self->priv->widgetID, "beecon_eq0_ImgFilename", self->priv->beecon_eq0_ImgFilename);//AP3

		g_key_file_set_integer (keyFile, self->priv->widgetID, "beecon_eq1_ImgZoom", self->priv->beecon_eq1_ImgZoom);//AP3
		g_key_file_set_integer (keyFile, self->priv->widgetID, "beecon_eq1_BgRGB", self->priv->beecon_eq1_BgRGB);//AP3
		g_key_file_set_string (keyFile, self->priv->widgetID, "beecon_eq1_ImgFilename", self->priv->beecon_eq1_ImgFilename);//AP3

		g_key_file_set_integer (keyFile, self->priv->widgetID, "beecon_ge2_ImgZoom", self->priv->beecon_ge2_ImgZoom);//AP3
		g_key_file_set_integer (keyFile, self->priv->widgetID, "beecon_ge2_BgRGB", self->priv->beecon_ge2_BgRGB);//AP3
		g_key_file_set_string (keyFile, self->priv->widgetID, "beecon_ge2_ImgFilename", self->priv->beecon_ge2_ImgFilename);//AP3

		g_key_file_set_integer (keyFile, self->priv->widgetID, "beecon_idxge2_ImgZoom", self->priv->beecon_idxge2_ImgZoom);//AP3
		g_key_file_set_integer (keyFile, self->priv->widgetID, "beecon_idxge2_BgRGB", self->priv->beecon_idxge2_BgRGB);//AP3
		g_key_file_set_string (keyFile, self->priv->widgetID, "beecon_idxge2_ImgFilename", self->priv->beecon_idxge2_ImgFilename);//AP3

		g_key_file_set_double (keyFile, self->priv->widgetID, "widWidth", self->priv->widWidth);
		g_key_file_set_double (keyFile, self->priv->widgetID, "widHeight", self->priv->widHeight);

		if(self->priv->instanceTitle == NULL || self->priv->instanceCmd == NULL)
		{
			g_warning("(%p) self->priv->instanceTitle = %p [%s]", self, self->priv->instanceTitle, self->priv->instanceTitle);
			if (self->priv->instanceTitle != NULL) {g_free(self->priv->instanceTitle);self->priv->instanceTitle = NULL;}
			self->priv->instanceTitle = g_strdup(self->priv->c_titles[0]);
			g_warning("(%p) self->priv->instanceTitle = %p [%s]", self, self->priv->instanceTitle, self->priv->instanceTitle);

			g_warning("(%p) self->priv->instanceCmd = %p [%s]", self, self->priv->instanceCmd, self->priv->instanceCmd);
			if (self->priv->instanceCmd != NULL) {g_free(self->priv->instanceCmd);self->priv->instanceCmd = NULL;}
			self->priv->instanceCmd = g_strdup(self->priv->c_commands[0]);
			g_warning("(%p) self->priv->instanceCmd = %p [%s]", self, self->priv->instanceCmd, self->priv->instanceCmd);
		}
		g_key_file_set_string (keyFile, self->priv->widgetID, "instanceTitle", self->priv->instanceTitle);
		g_key_file_set_string (keyFile, self->priv->widgetID, "instanceCmd", self->priv->instanceCmd);

		g_key_file_set_string (keyFile, self->priv->widgetID, "cmdImgFilename", self->priv->cmdImgFilename);//AP3
		g_key_file_set_integer (keyFile, self->priv->widgetID, "cmdImgZoom", self->priv->cmdImgZoom);//AP3
		g_key_file_set_integer (keyFile, self->priv->widgetID, "cmdFgRGB", self->priv->cmdFgRGB);//AP3
		g_key_file_set_integer (keyFile, self->priv->widgetID, "cmdVisibilityPosition", self->priv->cmdVisibilityPosition);//AP2
		g_key_file_set_integer (keyFile, self->priv->widgetID, "cmdImgVisibilityPosition", self->priv->cmdImgVisibilityPosition);//AP2
		g_key_file_set_integer (keyFile, self->priv->widgetID, "cmdJustify", self->priv->cmdJustify);//AP2
		g_key_file_set_integer (keyFile, self->priv->widgetID, "cmdFontName", self->priv->cmdFontName);//AP1
		g_key_file_set_double (keyFile, self->priv->widgetID, "cmdFontSize", self->priv->cmdFontSize);//AP1

		g_key_file_set_string (keyFile, self->priv->widgetID, "resImgFilename", self->priv->resImgFilename);//AP3
		g_key_file_set_integer (keyFile, self->priv->widgetID, "resImgZoom", self->priv->resImgZoom);//AP3
		g_key_file_set_integer (keyFile, self->priv->widgetID, "resFgRGB", self->priv->resFgRGB);//AP3
		g_key_file_set_integer (keyFile, self->priv->widgetID, "resVisibilityPosition", self->priv->resVisibilityPosition);//AP2
		g_key_file_set_integer (keyFile, self->priv->widgetID, "resImgVisibilityPosition", self->priv->resImgVisibilityPosition);//AP2
		g_key_file_set_integer (keyFile, self->priv->widgetID, "resJustify", self->priv->resJustify);//AP2
		g_key_file_set_integer (keyFile, self->priv->widgetID, "resFontName", self->priv->resFontName);//AP1
		g_key_file_set_double (keyFile, self->priv->widgetID, "resFontSize", self->priv->resFontSize);//AP1

		g_key_file_set_boolean (keyFile, self->priv->widgetID, "updOnStartup", self->priv->updOnStartup);
		g_key_file_set_boolean (keyFile, self->priv->widgetID, "updOnClick", self->priv->updOnClick);
		g_key_file_set_boolean (keyFile, self->priv->widgetID, "updOnDesktop", self->priv->updOnDesktop);
		g_key_file_set_integer (keyFile, self->priv->widgetID, "delayIndex", self->priv->delayIndex);
		g_key_file_set_integer (keyFile, self->priv->widgetID, "updNeworkPolicy", self->priv->updNeworkPolicy);
	}
	filename = g_strconcat (HOME_DIR, QUEEN_BEECON_SETTINGS_FILE, NULL);
	g_warning("(%p) filename %s", self, filename);

	fileData = g_key_file_to_data (keyFile, &size, NULL);
	g_warning("(%p) fileData %p", self, fileData);

	iniFile = fopen (filename, "w");
	fputs (fileData, iniFile);
	fclose (iniFile);
	g_key_file_free (keyFile);
	g_free (fileData);
	g_free (filename);
}

//widget/touchscreen interaction callbacks
void queen_beecon_button_press (GtkWidget *widget, GdkEventButton *event, QueenBeecon *self)
{
g_warning ("(%p) queen_beecon_button_press",self);
	if (self->priv->operationalStatus==1) { // Keep Sleeping if disabled
		self->priv->isPressed = TRUE;
		gtk_widget_queue_draw (GTK_WIDGET (self));
		return;
	}
	if (self->priv->updOnClick) {
		self->priv->isPressed = TRUE;
		gtk_widget_queue_draw (GTK_WIDGET (self));
	}
}

void queen_beecon_button_release (GtkWidget *widget, GdkEventButton *event, QueenBeecon *self)
{
g_warning ("(%p) queen_beecon_button_release",self);
	if (self->priv->operationalStatus==1) { // Wake up and restore size and operations
		self->priv->isPressed = FALSE;
		self->priv->operationalStatus=0;
		queen_beecon_write_settings (self, TRUE);
		if (self->priv->updOnStartup) { // do we have to update on startup?
			g_warning("(%p) RESIZE HACK queen_beecon_update_content (self)", self);
			queen_beecon_update_content (self);
		} else
			queen_beecon_update_content_layout (self); // No... only update layout
		gtk_widget_queue_draw (GTK_WIDGET (self));
		return;
	}
	if (self->priv->updOnClick) {
		self->priv->isPressed = FALSE;
		queen_beecon_update_content(self);
		gtk_widget_queue_draw (GTK_WIDGET (self));
	}
}

void queen_beecon_leave_event (GtkWidget *widget, GdkEventCrossing *event, QueenBeecon *self)
{
g_warning ("(%p) queen_beecon_leave_event",self);
	if (self->priv->operationalStatus==1) { // Keep Sleeping if disabled
		self->priv->isPressed = FALSE;
		gtk_widget_queue_draw (GTK_WIDGET (self));
		return;
	}
	if (self->priv->updOnClick) {
		self->priv->isPressed = FALSE;
		gtk_widget_queue_draw (GTK_WIDGET (self));
	}
}

static void queen_beecon_check_desktop (GObject *gobject, GParamSpec *pspec, QueenBeecon *self)
{
g_warning ("(%p) queen_beecon_check_desktop",self);
	if (self->priv->operationalStatus==1) { // Keep Sleeping if disabled
		gtk_widget_queue_draw (GTK_WIDGET (self));
		return;
	}
	if (self->priv->updOnDesktop) {
		queen_beecon_update_content (self);
		gtk_widget_queue_draw (GTK_WIDGET (self));
	}
}


gboolean queen_beecon_connection_event (ConIcConnection *connection, ConIcConnectionEvent *event, QueenBeecon *self)
{
g_warning ("(%p) queen_beecon_connection_event",self);
	ConIcConnectionStatus status = con_ic_connection_event_get_status(event);
	if(status == CON_IC_STATUS_CONNECTED) {
		self->priv->isConnected = TRUE;
	} else {
		self->priv->isConnected = FALSE;
	}
	if (self->priv->operationalStatus==1) { // Keep Sleeping if disabled
		gtk_widget_queue_draw (GTK_WIDGET (self));
		return TRUE;
	}
	if(self->priv->updNeworkPolicy != NETWORK__UNRELATED) {
		queen_beecon_update_content(self);
	}
	return TRUE;
}


//Content/widget creation/update
void queen_beecon_content_create (QueenBeecon *self)
{
g_warning ("(%p) queen_beecon_content_create",self);
	self->priv->contents = gtk_event_box_new ();
	g_warning ("(%p) gtk_event_box_new ()= %p",self, self->priv->contents);
	gtk_event_box_set_visible_window (GTK_EVENT_BOX (self->priv->contents), FALSE);
	gtk_container_set_border_width (GTK_CONTAINER (self->priv->contents), 0);

	self->priv->tableLayout = gtk_table_new(1, 1, FALSE);
	g_warning ("(%p) tableLayout gtk_table_new ()= %p",self, self->priv->tableLayout);

	// Create Title/Result Label
	self->priv->cmdTitle_lb = gtk_label_new ("Not Updated");
	g_warning ("(%p) cmdTitle_lb gtk_label_new ()= %p",self, self->priv->cmdTitle_lb);
	g_warning("(%p) gtk_table_attach self->priv->cmdTitle_lb=%p self->priv->tableLayout=%p", self, self->priv->cmdTitle_lb, self->priv->tableLayout);
	gtk_table_attach(GTK_TABLE(self->priv->tableLayout), self->priv->cmdTitle_lb, 0, 1, 0, 1, GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 0, 0);

	self->priv->cmdResult_lb = gtk_label_new ("Not Updated");
	g_warning ("(%p) cmdResult_lb gtk_label_new ()= %p",self, self->priv->cmdResult_lb);
	g_warning("(%p) gtk_table_attach self->priv->cmdResult_lb=%p self->priv->tableLayout=%p", self, self->priv->cmdResult_lb, self->priv->tableLayout);
	gtk_table_attach(GTK_TABLE(self->priv->tableLayout), GTK_WIDGET(self->priv->cmdResult_lb), 0, 1, 0, 1, GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 0, 0);

	GtkWidget *box = gtk_hbox_new (FALSE, 0);
	g_warning ("(%p) box gtk_hbox_new ()= %p",self, box);
	gtk_box_pack_start (GTK_BOX (box), self->priv->tableLayout, FALSE, FALSE, 0);
	gtk_container_add (GTK_CONTAINER (self->priv->contents), box);

	gtk_box_pack_start (GTK_BOX (self->priv->homeWidget), self->priv->contents, FALSE, FALSE, 0);

	//widget drawing signal connections
	g_signal_connect (self->priv->contents, "button-release-event", G_CALLBACK (queen_beecon_button_release), self);
	g_signal_connect (self->priv->contents, "button-press-event", G_CALLBACK (queen_beecon_button_press), self);
	g_signal_connect (self->priv->contents, "leave-notify-event", G_CALLBACK (queen_beecon_leave_event), self);

	gtk_widget_show_all (self->priv->homeWidget);
}

void queen_beecon_update_content_layout (QueenBeecon *self)
{
	g_warning ("(%p) queen_beecon_update_content_layout",self);

	GdkColor color;
	PangoFontDescription *fd = NULL;//AP1
	gboolean isCmdImage = FALSE, isResImage = FALSE;
	gint rsImgZoomW=0, rsImgZoomH=0;
	gint cmImgZoomW=0, cmImgZoomH=0;
	gchar *rsImgFilename = NULL, *auxrsImgFilename = NULL, *sysrsImgFilename = NULL, *cmdImgFilename = NULL, *auxcmdImgFilename = NULL, *syscmdImgFilename = NULL;
	gchar *noImgFilename = g_strdup_printf("%s%s", SYSTEM_PUBLIC_ICON_DIR, "queen-beecon-noimg.png");
	g_warning("(%p) No Image filename=[%s]", self, noImgFilename);

	if(self->priv->instanceCmd == NULL || self->priv->instanceTitle == NULL) {
		g_warning("(%p) self->priv->instanceTitle = %p [%s]", self, self->priv->instanceTitle, self->priv->instanceTitle);
		g_warning("(%p) self->priv->instanceCmd = %p [%s]", self, self->priv->instanceCmd, self->priv->instanceCmd);
		gtk_label_set_markup (GTK_LABEL (self->priv->cmdTitle_lb), "Error:");
		gtk_label_set_markup (GTK_LABEL (self->priv->cmdResult_lb), "No commands");
		return;
	}

	g_warning("(%p) self->priv->instanceTitle = %p [%s]", self, self->priv->instanceTitle, self->priv->instanceTitle);
	gtk_label_set_markup (GTK_LABEL (self->priv->cmdTitle_lb), self->priv->instanceTitle);

	if (self->priv->operationalStatus==1) { // Widget instance is disabled and minimized on screen
		// Let's define widget geometry and size
		g_warning ("(%p) Disabled Updating widget geometry w=%0.0f h=%0.0f",self, (float)60, (float)60);

		GdkGeometry hints;
		hints.min_width = (int)60;//AP3
		hints.min_height = (int)60;//AP3
		hints.max_width = (int)90;//AP3
		hints.max_height = (int)90;//AP3
		gtk_window_set_default_size (GTK_WINDOW (self), 60, 60);
		gtk_window_set_geometry_hints (GTK_WINDOW (self), self->priv->homeWidget, &hints, GDK_HINT_MIN_SIZE | GDK_HINT_MAX_SIZE);
		gtk_widget_set_size_request (GTK_WIDGET (self), (int)60, (int)60);//AP
		gtk_window_resize (GTK_WINDOW (self), (int)60, (int)60);//AP

		g_warning("(%p) Disabled Let's process TITLE Output: Do we need result Image or Text?", self);
		if (self->priv->cmdTitle_img) gtk_widget_destroy(GTK_WIDGET(self->priv->cmdTitle_img));
		syscmdImgFilename = g_strconcat (SYSTEM_PUBLIC_ICON_DIR, "queen-beecon-zzz.png", NULL);
		g_warning ("(%p) Disabled syscmdImgFilename = %s", self, syscmdImgFilename);
		g_warning ("(%p) Disabled noImgFilename = %s", self, noImgFilename);
		GdkPixbuf      *cmdPixBuf = gdk_pixbuf_new_from_file_at_scale (syscmdImgFilename, -1, -1, TRUE, NULL);
		if (!cmdPixBuf) cmdPixBuf = gdk_pixbuf_new_from_file_at_scale (noImgFilename, -1, -1, TRUE, NULL);
		g_warning ("(%p) Disabled cmdPixBuf = %p", self, cmdPixBuf);
		g_warning ("(%p) Disabled self->priv->cmdTitle_img = %p", self, self->priv->cmdTitle_img);
		self->priv->cmdTitle_img = gtk_image_new_from_pixbuf (cmdPixBuf);
		g_warning ("(%p) cmdTitle_img gtk_image_new_from_pixbuf (cmdPixBuf)= %p", self, self->priv->cmdTitle_img);
		g_warning ("(%p) cmdImgVisibilityPosition self->priv->cmdTitle_img Absolute %d Relative rX=%0.1f rY=%0.1f", self, self->priv->cmdImgVisibilityPosition, ((self->priv->cmdImgVisibilityPosition-1)%3)*0.5,((self->priv->cmdImgVisibilityPosition-1)/3)*0.5);
		gtk_widget_set_size_request(GTK_WIDGET(self->priv->cmdTitle_img), 60, 60);
		gtk_misc_set_alignment(GTK_MISC (self->priv->cmdTitle_img),0.5,0.0);
		g_object_unref (cmdPixBuf);
		g_free(syscmdImgFilename);
		g_warning("(%p) gtk_table_attach self->priv->cmdTitle_img=%p self->priv->tableLayout=%p", self, self->priv->cmdTitle_img, self->priv->tableLayout);
		gtk_table_attach(GTK_TABLE(self->priv->tableLayout), self->priv->cmdTitle_img, 0, 1, 0, 1, GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 0, 0);
		gtk_widget_show (GTK_WIDGET(self->priv->cmdTitle_img));
		gtk_widget_hide (GTK_WIDGET(self->priv->cmdResult_img));// Visible

		// Update Results Layout (Label/image Font + Colors + Alignment + Position + ...)
		fd = pango_font_description_from_string("Nokia,Sans 9");//AP1
		gtk_widget_modify_font(GTK_WIDGET(self->priv->cmdTitle_lb), fd);//AP1

		gdk_color_parse("#FFFFFF", &color);
		gtk_widget_modify_fg (GTK_WIDGET(self->priv->cmdTitle_lb), GTK_STATE_NORMAL, &color); // White text
		gtk_widget_set_size_request(GTK_WIDGET(self->priv->cmdTitle_lb), 60, 60);
		gtk_misc_set_alignment(GTK_MISC (self->priv->cmdTitle_lb),0.5,1.0); // Bottom Center aligned
		gtk_misc_set_padding (GTK_MISC (self->priv->cmdTitle_lb), 1, 1);//AP1
		gtk_widget_show (GTK_WIDGET(self->priv->cmdTitle_lb));// Visible
		gtk_widget_hide (GTK_WIDGET(self->priv->cmdResult_lb));// Visible

		g_free(noImgFilename);noImgFilename=NULL;
		return;
	}

	// Let's define widget geometry and size
	g_warning ("(%p) Updating widget geometry w=%0.0f h=%0.0f",self, self->priv->widWidth, self->priv->widHeight);
	GdkGeometry hints;
	hints.min_width = (int)(self->priv->widWidth);//AP3
	hints.min_height = (int)(self->priv->widHeight);//AP3
	hints.max_width = self->priv->widWidth>90?(int)(self->priv->widWidth):90;//AP3
	hints.max_height = self->priv->widHeight>90?(int)(self->priv->widHeight):90;//AP3
	gtk_window_set_default_size (GTK_WINDOW (self), self->priv->widWidth, self->priv->widHeight);
	gtk_window_set_geometry_hints (GTK_WINDOW (self), self->priv->homeWidget, &hints, GDK_HINT_MIN_SIZE | GDK_HINT_MAX_SIZE);
	gtk_widget_set_size_request (GTK_WIDGET (self), (int)(self->priv->widWidth), (int)(self->priv->widHeight));//AP
	gtk_window_resize (GTK_WINDOW (self), (int)(self->priv->widWidth), (int)(self->priv->widHeight));//AP

	gtk_widget_set_size_request(GTK_WIDGET(self->priv->cmdTitle_lb), self->priv->widWidth, self->priv->widHeight);
	gtk_widget_set_size_request(GTK_WIDGET(self->priv->cmdResult_lb), self->priv->widWidth, self->priv->widHeight);

	// Update Results Layout (Label/image Font + Colors + Alignment + Position + ...)
	gchar resFontTtl[256];//AP1
	g_sprintf(resFontTtl,"%s %s %ld", p_fonts[self->priv->resFontName/4], p_fonts_types[self->priv->resFontName%4], (long) self->priv->resFontSize);//AP1
	g_warning("(%p) Result Font: %s",self, resFontTtl);
	fd = pango_font_description_from_string(resFontTtl);//AP1
	gtk_widget_modify_font(GTK_WIDGET(self->priv->cmdResult_lb), fd);//AP1

	gtk_widget_set_size_request(GTK_WIDGET(self->priv->cmdResult_lb), self->priv->widWidth, self->priv->widHeight);
	gdk_color_parse(p_colors[self->priv->resFgRGB].colorRGB,&color);
	gtk_widget_modify_fg (GTK_WIDGET(self->priv->cmdResult_lb), GTK_STATE_NORMAL, &color);
	g_warning ("(%p) resVisibilityPosition self->priv->cmdResult_lb Absolute %d Relative rX=%0.1f rY=%0.1f", self, self->priv->resVisibilityPosition, ((self->priv->resVisibilityPosition-1)%3)*0.5,((self->priv->resVisibilityPosition-1)/3)*0.5);
	gtk_misc_set_alignment(GTK_MISC (self->priv->cmdResult_lb),((self->priv->resVisibilityPosition-1)%3)*0.5,((self->priv->resVisibilityPosition-1)/3)*0.5);
	gtk_misc_set_padding (GTK_MISC (self->priv->cmdResult_lb), 2, 2);//AP1
	gtk_label_set_justify(GTK_LABEL(self->priv->cmdResult_lb), self->priv->resJustify);
	if (self->priv->resVisibilityPosition) {
		g_warning("(%p) showing self->priv->cmdResult_lb=%p", self, self->priv->cmdResult_lb);
		gtk_widget_show (GTK_WIDGET(self->priv->cmdResult_lb));
	} else {
		g_warning("(%p) hiding self->priv->cmdResult_lb=%p", self, self->priv->cmdResult_lb);
		gtk_widget_hide (GTK_WIDGET(self->priv->cmdResult_lb));//AP3
	}
	//v Results Image
	g_warning("(%p) Let's process RESULT Output: Do we need result Image or Text?", self);
	if (self->priv->widgetType!=0) {
		g_warning("(%p) I'm SNIPPET... do I need result Image?", self);
		if (self->priv->resImgFilename[0]!='\0' && self->priv->resImgFilename[0]!=';') {
			if (self->priv->resImgFilename[0]=='/') // if / leading let's assume absolute path for img filename
				rsImgFilename = g_strconcat (self->priv->resImgFilename, NULL);
			else {
				rsImgFilename = g_strconcat (HOME_DIR, QUEEN_BEECON_PRIVATE_DIR, self->priv->resImgFilename, NULL);
				auxrsImgFilename = g_strconcat (HOME_DIR, QUEEN_BEECON_MYDOCS_IMAGE_DIR, self->priv->resImgFilename, NULL);
				sysrsImgFilename = g_strconcat (SYSTEM_PUBLIC_ICON_DIR, self->priv->resImgFilename, NULL);
			}
			gint w=48,h=48;
			GdkPixbufFormat *resPixBufFmt = gdk_pixbuf_get_file_info(auxrsImgFilename,&w,&h);
			if (!resPixBufFmt) resPixBufFmt = gdk_pixbuf_get_file_info(rsImgFilename,&w,&h);
			rsImgZoomW=self->priv->resImgZoom==0?-1:self->priv->resImgZoom==1?self->priv->widWidth:(self->priv->resImgZoom-1)*w*5/100;
			rsImgZoomH=self->priv->resImgZoom==0?-1:self->priv->resImgZoom==1?self->priv->widHeight:(self->priv->resImgZoom-1)*h*5/100;
			isResImage=TRUE;
		}
	} else {//AP3
		switch (self->priv->cmdExitStatus) {
		case -1:
			g_warning("(%p) I'm BEECON (lt0=%s) ... do I need result Image?", self, self->priv->beecon_lt0_ImgFilename);
			if (self->priv->beecon_lt0_ImgFilename[0]!='\0' && self->priv->beecon_lt0_ImgFilename[0]!=';') {
				if (self->priv->beecon_lt0_ImgFilename[0]=='/') // if / leading let's assume absolute path for img filename
					rsImgFilename = g_strconcat (self->priv->beecon_lt0_ImgFilename, NULL);
				else {
					rsImgFilename = g_strconcat (HOME_DIR, QUEEN_BEECON_PRIVATE_DIR, self->priv->beecon_lt0_ImgFilename, NULL);
					auxrsImgFilename = g_strconcat (HOME_DIR, QUEEN_BEECON_MYDOCS_IMAGE_DIR, self->priv->beecon_lt0_ImgFilename, NULL);
					sysrsImgFilename = g_strconcat (SYSTEM_PUBLIC_ICON_DIR, self->priv->beecon_lt0_ImgFilename, NULL);
				}
				gint w=48,h=48;
				GdkPixbufFormat *resPixBufFmt = gdk_pixbuf_get_file_info(auxrsImgFilename,&w,&h);
				if (!resPixBufFmt) resPixBufFmt = gdk_pixbuf_get_file_info(rsImgFilename,&w,&h);
				rsImgZoomW=self->priv->beecon_lt0_ImgZoom==0?-1:self->priv->beecon_lt0_ImgZoom==1?self->priv->widWidth:(self->priv->beecon_lt0_ImgZoom-1)*w*5/100;
				rsImgZoomH=self->priv->beecon_lt0_ImgZoom==0?-1:self->priv->beecon_lt0_ImgZoom==1?self->priv->widHeight:(self->priv->beecon_lt0_ImgZoom-1)*h*5/100;
				isResImage=TRUE;
			}
			break;
		case 0:
			g_warning("(%p) I'm BEECON (eq0=%s) ... do I need result Image?", self, self->priv->beecon_eq0_ImgFilename);
			if (self->priv->beecon_eq0_ImgFilename[0]!='\0' && self->priv->beecon_eq0_ImgFilename[0]!=';') {
				if (self->priv->beecon_eq0_ImgFilename[0]=='/') // if / leading let's assume absolute path for img filename
					rsImgFilename = g_strconcat (self->priv->beecon_eq0_ImgFilename, NULL);
				else {
					rsImgFilename = g_strconcat (HOME_DIR, QUEEN_BEECON_PRIVATE_DIR, self->priv->beecon_eq0_ImgFilename, NULL);
					auxrsImgFilename = g_strconcat (HOME_DIR, QUEEN_BEECON_MYDOCS_IMAGE_DIR, self->priv->beecon_eq0_ImgFilename, NULL);
					sysrsImgFilename = g_strconcat (SYSTEM_PUBLIC_ICON_DIR, self->priv->beecon_eq0_ImgFilename, NULL);
				}
				gint w=48,h=48;
				GdkPixbufFormat *resPixBufFmt = gdk_pixbuf_get_file_info(auxrsImgFilename,&w,&h);
				if (!resPixBufFmt) resPixBufFmt = gdk_pixbuf_get_file_info(rsImgFilename,&w,&h);
				rsImgZoomW=self->priv->beecon_eq0_ImgZoom==0?-1:self->priv->beecon_eq0_ImgZoom==1?self->priv->widWidth:(self->priv->beecon_eq0_ImgZoom-1)*w*5/100;
				rsImgZoomH=self->priv->beecon_eq0_ImgZoom==0?-1:self->priv->beecon_eq0_ImgZoom==1?self->priv->widHeight:(self->priv->beecon_eq0_ImgZoom-1)*h*5/100;
				isResImage=TRUE;
			}
			break;
		case 1:
			g_warning("(%p) I'm BEECON (eq1=%s) ... do I need result Image?", self, self->priv->beecon_eq1_ImgFilename);
			if (self->priv->beecon_eq1_ImgFilename[0]!='\0' && self->priv->beecon_eq1_ImgFilename[0]!=';') {
				if (self->priv->beecon_eq1_ImgFilename[0]=='/') // if / leading let's assume absolute path for img filename
					rsImgFilename = g_strconcat (self->priv->beecon_eq1_ImgFilename, NULL);
				else {
					rsImgFilename = g_strconcat (HOME_DIR, QUEEN_BEECON_PRIVATE_DIR, self->priv->beecon_eq1_ImgFilename, NULL);
					auxrsImgFilename = g_strconcat (HOME_DIR, QUEEN_BEECON_MYDOCS_IMAGE_DIR, self->priv->beecon_eq1_ImgFilename, NULL);
					sysrsImgFilename = g_strconcat (SYSTEM_PUBLIC_ICON_DIR, self->priv->beecon_eq1_ImgFilename, NULL);
				}
				gint w=48,h=48;
				GdkPixbufFormat *resPixBufFmt = gdk_pixbuf_get_file_info(auxrsImgFilename,&w,&h);
				if (!resPixBufFmt) resPixBufFmt = gdk_pixbuf_get_file_info(rsImgFilename,&w,&h);
				rsImgZoomW=self->priv->beecon_eq1_ImgZoom==0?-1:self->priv->beecon_eq1_ImgZoom==1?self->priv->widWidth:(self->priv->beecon_eq1_ImgZoom-1)*w*5/100;
				rsImgZoomH=self->priv->beecon_eq1_ImgZoom==0?-1:self->priv->beecon_eq1_ImgZoom==1?self->priv->widHeight:(self->priv->beecon_eq1_ImgZoom-1)*h*5/100;
				isResImage=TRUE;
			}
			break;
		case 2:
			g_warning("(%p) I'm BEECON (ge2=%s) ... do I need result Image?", self, self->priv->beecon_ge2_ImgFilename);
			if (self->priv->beecon_ge2_ImgFilename[0]!='\0' && self->priv->beecon_ge2_ImgFilename[0]!=';') {
				if (self->priv->beecon_ge2_ImgFilename[0]=='/') // if / leading let's assume absolute path for img filename
					rsImgFilename = g_strconcat (self->priv->beecon_ge2_ImgFilename, NULL);
				else {
					rsImgFilename = g_strconcat (HOME_DIR, QUEEN_BEECON_PRIVATE_DIR, self->priv->beecon_ge2_ImgFilename, NULL);
					auxrsImgFilename = g_strconcat (HOME_DIR, QUEEN_BEECON_MYDOCS_IMAGE_DIR, self->priv->beecon_ge2_ImgFilename, NULL);
					sysrsImgFilename = g_strconcat (SYSTEM_PUBLIC_ICON_DIR, self->priv->beecon_ge2_ImgFilename, NULL);
				}
				gint w=48,h=48;
				GdkPixbufFormat *resPixBufFmt = gdk_pixbuf_get_file_info(auxrsImgFilename,&w,&h);
				if (!resPixBufFmt) resPixBufFmt = gdk_pixbuf_get_file_info(rsImgFilename,&w,&h);
				rsImgZoomW=self->priv->beecon_ge2_ImgZoom==0?-1:self->priv->beecon_ge2_ImgZoom==1?self->priv->widWidth:(self->priv->beecon_ge2_ImgZoom-1)*w*5/100;
				rsImgZoomH=self->priv->beecon_ge2_ImgZoom==0?-1:self->priv->beecon_ge2_ImgZoom==1?self->priv->widHeight:(self->priv->beecon_ge2_ImgZoom-1)*h*5/100;
				isResImage=TRUE;
			}
			break;
		default:
			g_warning("(%p) I'm BEECON (idxge2=%s) ... do I need result Image?", self, self->priv->beecon_idxge2_ImgFilename);
			if (self->priv->beecon_idxge2_ImgFilename[0]!='\0' && self->priv->beecon_idxge2_ImgFilename[0]!=';') {
				if (self->priv->beecon_idxge2_ImgFilename[0]=='/') // if / leading let's assume absolute path for img filename
					rsImgFilename = g_strdup_printf("%s.%d", self->priv->beecon_idxge2_ImgFilename, self->priv->cmdExitStatus);
				else {
					rsImgFilename = g_strdup_printf("%s%s%s.%d", HOME_DIR, QUEEN_BEECON_PRIVATE_DIR, self->priv->beecon_idxge2_ImgFilename, self->priv->cmdExitStatus);
					auxrsImgFilename = g_strdup_printf("%s%s%s.%d", HOME_DIR, QUEEN_BEECON_MYDOCS_IMAGE_DIR, self->priv->beecon_idxge2_ImgFilename, self->priv->cmdExitStatus);
					sysrsImgFilename = g_strdup_printf("%s%s.%d", SYSTEM_PUBLIC_ICON_DIR, self->priv->beecon_idxge2_ImgFilename, self->priv->cmdExitStatus);
				}
				gint w=48,h=48;
				GdkPixbufFormat *resPixBufFmt = gdk_pixbuf_get_file_info(auxrsImgFilename,&w,&h);
				if (!resPixBufFmt) resPixBufFmt = gdk_pixbuf_get_file_info(rsImgFilename,&w,&h);
				rsImgZoomW=self->priv->beecon_idxge2_ImgZoom==0?-1:self->priv->beecon_idxge2_ImgZoom==1?self->priv->widWidth:(self->priv->beecon_idxge2_ImgZoom-1)*w*5/100;
				rsImgZoomH=self->priv->beecon_idxge2_ImgZoom==0?-1:self->priv->beecon_idxge2_ImgZoom==1?self->priv->widHeight:(self->priv->beecon_idxge2_ImgZoom-1)*h*5/100;
				isResImage=TRUE;
			}
			break;
		}
	}//AP3
	if (self->priv->cmdResult_img) gtk_widget_destroy(GTK_WIDGET(self->priv->cmdResult_img));
	if (isResImage) {
		g_warning ("(%p) Yes!!! auxrsImgFilename = %s", self, auxrsImgFilename);
		g_warning ("(%p) Yes!!! rsImgFilename = %s", self, rsImgFilename);
		g_warning ("(%p) Yes!!! sysrsImgFilename = %s", self, sysrsImgFilename);
		g_warning ("(%p) Yes!!! noImgFilename = %s", self, noImgFilename);
//gdk_pixbuf_animation_new_from_file ()
//gtk_image_new_from_animation ()
		g_warning ("(%p) rsImgZoomW=%d rsImgZoomH=%d", self, rsImgZoomW, rsImgZoomH);
		GdkPixbuf     *rsPixBuf = gdk_pixbuf_new_from_file_at_scale (auxrsImgFilename, rsImgZoomW, rsImgZoomH, TRUE, NULL);
		if (!rsPixBuf) rsPixBuf = gdk_pixbuf_new_from_file_at_scale (rsImgFilename, rsImgZoomW, rsImgZoomH, TRUE, NULL);
		if (!rsPixBuf) rsPixBuf = gdk_pixbuf_new_from_file_at_scale (sysrsImgFilename, rsImgZoomW, rsImgZoomH, TRUE, NULL);
		if (!rsPixBuf) rsPixBuf = gdk_pixbuf_new_from_file_at_scale (noImgFilename, rsImgZoomW, rsImgZoomH, TRUE, NULL);
		g_warning ("(%p) rsPixBuf = %p", self, rsPixBuf);
		g_warning ("(%p) self->priv->cmdResult_img = %p", self, self->priv->cmdResult_img);
		self->priv->cmdResult_img = gtk_image_new_from_pixbuf (rsPixBuf);
		g_warning ("(%p) cmdResult_img gtk_image_new_from_pixbuf (rsPixBuf)= %p", self, self->priv->cmdResult_img);
		gtk_widget_set_size_request(GTK_WIDGET(self->priv->cmdResult_img), self->priv->widWidth, self->priv->widHeight);
		g_warning ("(%p) resImgVisibilityPosition self->priv->cmdResult_img Absolute %d Relative rX=%0.1f rY=%0.1f", self, self->priv->resImgVisibilityPosition, ((self->priv->resImgVisibilityPosition-1)%3)*0.5,((self->priv->resImgVisibilityPosition-1)/3)*0.5);
		gtk_misc_set_alignment(GTK_MISC (self->priv->cmdResult_img),((self->priv->resImgVisibilityPosition-1)%3)*0.5,((self->priv->resImgVisibilityPosition-1)/3)*0.5);
		g_warning ("(%p) cmdResult_img = %p", self, self->priv->cmdResult_img);
		g_object_unref (rsPixBuf);
		g_free(rsImgFilename);
		g_free(auxrsImgFilename);
		g_free(sysrsImgFilename);
		g_warning("(%p) gtk_table_attach self->priv->cmdResult_img=%p self->priv->tableLayout=%p", self, self->priv->cmdResult_img, self->priv->tableLayout);
		gtk_table_attach(GTK_TABLE(self->priv->tableLayout), GTK_WIDGET(self->priv->cmdResult_img), 0, 1, 0, 1, GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 0, 0);
		if (self->priv->resImgVisibilityPosition) {
			g_warning("(%p) showing self->priv->cmdResult_img=%p", self, self->priv->cmdResult_img);
			gtk_widget_show (GTK_WIDGET(self->priv->cmdResult_img));
		} else {
			g_warning("(%p) hiding self->priv->cmdResult_img=%p", self, self->priv->cmdResult_img);
			gtk_widget_hide (GTK_WIDGET(self->priv->cmdResult_img));//AP3
		}
	}
	//^ Results Image

	// Update Command Layout (Label/image Font + Colors + Alignment + Position + ...)
	gchar cmdFontTtl[256];//AP1
	g_sprintf(cmdFontTtl,"%s %s %ld", p_fonts[self->priv->cmdFontName/4], p_fonts_types[self->priv->cmdFontName%4], (long) self->priv->cmdFontSize);//AP1
	g_warning("(%p) Title Font: %s",self, cmdFontTtl);
	fd = pango_font_description_from_string(cmdFontTtl);//AP1
	gtk_widget_modify_font(GTK_WIDGET(self->priv->cmdTitle_lb), fd);//AP1

	gtk_widget_set_size_request(GTK_WIDGET(self->priv->cmdTitle_lb), self->priv->widWidth, self->priv->widHeight);
	gdk_color_parse(p_colors[self->priv->cmdFgRGB].colorRGB,&color);
	gtk_widget_modify_fg (GTK_WIDGET(self->priv->cmdTitle_lb), GTK_STATE_NORMAL, &color);
	g_warning ("(%p) cmdVisibilityPosition self->priv->cmdTitle_lb Absolute %d Relative rX=%0.1f rY=%0.1f", self, self->priv->cmdVisibilityPosition, ((self->priv->cmdVisibilityPosition-1)%3)*0.5,((self->priv->cmdVisibilityPosition-1)/3)*0.5);
	gtk_misc_set_alignment(GTK_MISC (self->priv->cmdTitle_lb),((self->priv->cmdVisibilityPosition-1)%3)*0.5,((self->priv->cmdVisibilityPosition-1)/3)*0.5);
	gtk_misc_set_padding (GTK_MISC (self->priv->cmdTitle_lb), 2, 2);//AP1
	gtk_label_set_justify(GTK_LABEL(self->priv->cmdTitle_lb), self->priv->cmdJustify);
	if (self->priv->cmdVisibilityPosition) //AP2
		gtk_widget_show (GTK_WIDGET(self->priv->cmdTitle_lb));
	else
		gtk_widget_hide (GTK_WIDGET(self->priv->cmdTitle_lb));//AP3

	//v Command Image
	g_warning("(%p) Let's process TITLE Output: Do we need result Image or Text?", self);
	if (self->priv->cmdTitle_img) gtk_widget_destroy(GTK_WIDGET(self->priv->cmdTitle_img));
	if (self->priv->cmdImgFilename[0]!='\0' && self->priv->cmdImgFilename[0]!=';') {
		if (self->priv->cmdImgFilename[0]=='/') // if / leading let's assume absolute path for img filename
			cmdImgFilename = g_strconcat (self->priv->cmdImgFilename, NULL);
		else {
			cmdImgFilename = g_strconcat (HOME_DIR, QUEEN_BEECON_PRIVATE_DIR, self->priv->cmdImgFilename, NULL);
			auxcmdImgFilename = g_strconcat (HOME_DIR, QUEEN_BEECON_MYDOCS_IMAGE_DIR, self->priv->cmdImgFilename, NULL);
			syscmdImgFilename = g_strconcat (SYSTEM_PUBLIC_ICON_DIR, self->priv->cmdImgFilename, NULL);
		}
		isCmdImage=TRUE;
		g_warning ("(%p) cmImgZoomW=%d cmImgZoomH=%d", self, cmImgZoomW, cmImgZoomH);
		g_warning ("(%p) Yes!!! auxcmdImgFilename = %s", self, auxcmdImgFilename);
		g_warning ("(%p) Yes!!! cmdImgFilename = %s", self, cmdImgFilename);
		g_warning ("(%p) Yes!!! syscmdImgFilename = %s", self, syscmdImgFilename);
		g_warning ("(%p) Yes!!! noImgFilename = %s", self, noImgFilename);

		gint w=48,h=48;
		GdkPixbufFormat *cmdPixBufFmt = gdk_pixbuf_get_file_info(auxcmdImgFilename,&w,&h);
		if (!cmdPixBufFmt) cmdPixBufFmt = gdk_pixbuf_get_file_info(cmdImgFilename,&w,&h);
		cmImgZoomW=self->priv->cmdImgZoom==0?-1:self->priv->cmdImgZoom==1?self->priv->widWidth:(self->priv->cmdImgZoom-1)*w*5/100;
		cmImgZoomH=self->priv->cmdImgZoom==0?-1:self->priv->cmdImgZoom==1?self->priv->widHeight:(self->priv->cmdImgZoom-1)*h*5/100;
		g_warning ("(%p) cmImgZoomW=%d cmImgZoomH=%d", self, cmImgZoomW, cmImgZoomH);
		GdkPixbuf      *cmdPixBuf = gdk_pixbuf_new_from_file_at_scale (auxcmdImgFilename, cmImgZoomW, cmImgZoomH, TRUE, NULL);
		if (!cmdPixBuf) cmdPixBuf = gdk_pixbuf_new_from_file_at_scale (cmdImgFilename, cmImgZoomW, cmImgZoomH, TRUE, NULL);
		if (!cmdPixBuf) cmdPixBuf = gdk_pixbuf_new_from_file_at_scale (syscmdImgFilename, cmImgZoomW, cmImgZoomH, TRUE, NULL);
		if (!cmdPixBuf) cmdPixBuf = gdk_pixbuf_new_from_file_at_scale (noImgFilename, cmImgZoomW, cmImgZoomH, TRUE, NULL);
		g_warning ("(%p) cmdPixBuf = %p", self, cmdPixBuf);
		g_warning ("(%p) self->priv->cmdTitle_img = %p", self, self->priv->cmdTitle_img);
		self->priv->cmdTitle_img = gtk_image_new_from_pixbuf (cmdPixBuf);
		g_warning ("(%p) cmdTitle_img gtk_image_new_from_pixbuf (cmdPixBuf)= %p", self, self->priv->cmdTitle_img);
		gtk_widget_set_size_request(GTK_WIDGET(self->priv->cmdTitle_img), self->priv->widWidth, self->priv->widHeight);
		g_warning ("(%p) cmdImgVisibilityPosition self->priv->cmdTitle_img Absolute %d Relative rX=%0.1f rY=%0.1f", self, self->priv->cmdImgVisibilityPosition, ((self->priv->cmdImgVisibilityPosition-1)%3)*0.5,((self->priv->cmdImgVisibilityPosition-1)/3)*0.5);
		gtk_misc_set_alignment(GTK_MISC (self->priv->cmdTitle_img),((self->priv->cmdImgVisibilityPosition-1)%3)*0.5,((self->priv->cmdImgVisibilityPosition-1)/3)*0.5);
		g_object_unref (cmdPixBuf);
		g_free(cmdImgFilename);
		g_free(auxcmdImgFilename);
		g_free(syscmdImgFilename);
		g_warning("(%p) gtk_table_attach self->priv->cmdTitle_img=%p self->priv->tableLayout=%p", self, self->priv->cmdTitle_img, self->priv->tableLayout);
		gtk_table_attach(GTK_TABLE(self->priv->tableLayout), self->priv->cmdTitle_img, 0, 1, 0, 1, GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 0, 0);
		if (self->priv->cmdImgVisibilityPosition!=0) //AP2
			gtk_widget_show (GTK_WIDGET(self->priv->cmdTitle_img));
		else
			gtk_widget_hide (GTK_WIDGET(self->priv->cmdTitle_img));//AP3
	}
	//^ Command Image
	g_free(noImgFilename);noImgFilename=NULL;
}

void queen_beecon_blend_gradient(cairo_t *cr, cairo_pattern_t *pat, guint colIdx, double alphaUp, double alphaDown, gboolean isPressed)
{
	GdkColor color,color1;
	gdk_color_parse("#FFFFFF", &color1);
	g_warning ("queen_beecon_blend_gradient cr=%p pat=%p colIdx=%d alphaUp=%0.2f alphaDown=%0.2f isPressed=%d", cr, pat, colIdx, alphaUp, alphaDown, isPressed);
	if (!gdk_color_parse(p_colors[colIdx].colorRGB, &color)) {
		g_warning ("gdk_color_parse color (%s)", p_colors[colIdx].colorRGB);
	}
	g_warning ("queen_beecon_blend_gradient color (%s) rgb(%d,%d,%d)", p_colors[colIdx].colorRGB, color.red, color.green, color.blue);
	if (!isPressed) {
		cairo_pattern_add_color_stop_rgba(pat, 0.0, color1.red, color1.green, color1.blue, alphaUp);
		cairo_pattern_add_color_stop_rgba(pat, 0.05, color.red, color.green, color.blue, alphaUp);
		cairo_pattern_add_color_stop_rgba(pat, 0.95, color.red, color.green, color.blue, alphaUp);
		cairo_pattern_add_color_stop_rgba(pat, 1.0, 0, 0, 0, alphaUp);
	} else {
		cairo_pattern_add_color_stop_rgba(pat, 0.0, 0, 0, 0, alphaDown);
		cairo_pattern_add_color_stop_rgba(pat, 0.05, color.red, color.green, color.blue, alphaDown);
		cairo_pattern_add_color_stop_rgba(pat, 0.95, color.red, color.green, color.blue, alphaDown);
		cairo_pattern_add_color_stop_rgba(pat, 1.0, color1.red, color1.green, color1.blue, alphaDown);
	}
}

void queen_beecon_draw_canvas(GtkWidget *widget)
{
	QueenBeecon *self = QUEEN_BEECON (widget);
	g_warning ("(%p) queen_beecon_draw_canvas", self);
	cairo_t *cr=NULL;
	gint width, height, x, y;
	gint radius = 5;

	width = widget->allocation.width;
	height = widget->allocation.height;
	x = widget->allocation.x;
	y = widget->allocation.y;

	if (self->priv->operationalStatus==1) { // Widget instance is disabled and minimized on screen... don't draw canvas
		g_warning ("(%p) Disabled drawing small canvas (snippet like) canvas...", self);
		cr = gdk_cairo_create(GDK_DRAWABLE (widget->window));
		cairo_move_to(cr, x + radius, y);
		cairo_line_to(cr, x + width - radius, y);
		cairo_curve_to(cr, x + width - radius, y, x + width, y, x + width,y + radius);
		cairo_line_to(cr, x + width, y + height - radius);
		cairo_curve_to(cr, x + width, y + height - radius, x + width,y + height, x + width - radius, y + height);
		cairo_line_to(cr, x + radius, y + height);
		cairo_curve_to(cr, x + radius, y + height, x, y + height, x,y + height - radius);
		cairo_line_to(cr, x, y + radius);
		cairo_curve_to(cr, x, y + radius, x, y, x + radius, y);
		cairo_set_operator (cr, CAIRO_OPERATOR_SOURCE);

		cairo_set_source_rgba (cr, 0, 0, 0, .7);
		cairo_fill_preserve(cr);

		cairo_set_source_rgba (cr, 1, 1, 1, 1);
		cairo_set_line_width (cr, 1);
		cairo_stroke (cr);

		cairo_destroy(cr);
		return;
	}

	if (self->priv->hideCanvas && !self->priv->isPressed) return; // Don't draw canvas if not needed

	cairo_pattern_t *pat = cairo_pattern_create_linear(width/2, 0, width/2, height-1);

	cr = gdk_cairo_create(GDK_DRAWABLE (widget->window));
	g_warning ("(%p) Populating canvas...", self);

	if (self->priv->widgetType!=0) {
		queen_beecon_blend_gradient (cr, pat, self->priv->snippetBgRGB, 0.75, 0.6, self->priv->isPressed);
	} else {//AP3
		switch (self->priv->cmdExitStatus) {
		case -1:
			queen_beecon_blend_gradient (cr, pat, self->priv->beecon_lt0_BgRGB, 0.85, 0.65, self->priv->isPressed);
			break;
		case 0:
			queen_beecon_blend_gradient (cr, pat, self->priv->beecon_eq0_BgRGB, 0.85, 0.65, self->priv->isPressed);
			break;
		case 1:
			queen_beecon_blend_gradient (cr, pat, self->priv->beecon_eq1_BgRGB, 0.85, 0.65, self->priv->isPressed);
			break;
		case 2:
			queen_beecon_blend_gradient (cr, pat, self->priv->beecon_ge2_BgRGB, 0.85, 0.65, self->priv->isPressed);
			break;
		default:
			queen_beecon_blend_gradient (cr, pat, self->priv->beecon_idxge2_BgRGB, 0.85, 0.65, self->priv->isPressed);
			break;
		}
	}//AP3

	if (self->priv->widgetType!=0) {// Is snippet ... draw rectangle
		cairo_move_to(cr, x + radius, y);
		cairo_line_to(cr, x + width - radius, y);
		cairo_curve_to(cr, x + width - radius, y, x + width, y, x + width,y + radius);
		cairo_line_to(cr, x + width, y + height - radius);
		cairo_curve_to(cr, x + width, y + height - radius, x + width,y + height, x + width - radius, y + height);
		cairo_line_to(cr, x + radius, y + height);
		cairo_curve_to(cr, x + radius, y + height, x, y + height, x,y + height - radius);
		cairo_line_to(cr, x, y + radius);
		cairo_curve_to(cr, x, y + radius, x, y, x + radius, y);
	} else {//AP3
		cairo_set_line_join(cr, CAIRO_LINE_JOIN_ROUND);//AP3
		gint l= width / 4;//AP3
		gint h= height / 2;//AP3

		cairo_move_to(cr, x, y + h - 1);
		cairo_line_to(cr, x + l - 1, y + h * 2 - 1);
		cairo_line_to(cr, x + l * 3 - 1, y + h * 2 - 1);
		cairo_line_to(cr, x + l * 4 - 1, y + h - 1);
		cairo_line_to(cr, x + l * 3 - 1 , y);
		cairo_line_to(cr, x + l - 1 , y);
		cairo_line_to(cr, x, y + h - 1);
	}//AP3

	cairo_set_operator (cr, CAIRO_OPERATOR_SOURCE);

	cairo_set_source(cr, pat);
	cairo_fill_preserve(cr);

	cairo_set_source_rgba (cr, 1, 1, 1, 1);
	cairo_set_line_width (cr, 2);
	cairo_stroke (cr);

	cairo_pattern_destroy(pat);
	cairo_destroy(cr);
}

gboolean queen_beecon_resize_hack(QueenBeecon *self)
{
g_warning("(%p) queen_beecon_resize_hack",self);
	if(self->priv->widgetID != NULL) {
		g_warning("(%p) REALIZE HACK calling queen_beecon_read_settings (self)", self);
		queen_beecon_read_settings (self, TRUE, FALSE, NULL);

		if (self->priv->updOnStartup && self->priv->operationalStatus==0) { // do we have to update on startup?
			g_warning("(%p) RESIZE HACK queen_beecon_update_content (self)", self);
			queen_beecon_update_content (self);
		} else
			queen_beecon_update_content_layout (self); // No... only update layout
	} else {
		g_warning("HACK unsuccessful");
 	}
	return FALSE;
}

void queen_beecon_update_content (QueenBeecon *self)
{
g_warning ("(%p) queen_beecon_update_content",self);

	if(self->priv->widgetID == NULL) {
		g_warning("(%p) Widget instance unknown... aborting",self);
		return;
	}

	if (self->priv->operationalStatus==1) { // Keep Sleeping if disabled
		return;
	}

	if(self->priv->updNeworkPolicy == NETWORK__ONLY_CONNECTED && self->priv->isConnected == FALSE)
		return;

	if(self->priv->updNeworkPolicy == NETWORK__ONLY_DISCONNECTED && self->priv->isConnected == TRUE)
		return;

	FILE *fp=NULL;

	g_warning("(%p) self->priv->instanceCmd = %p [%s]", self, self->priv->instanceCmd, self->priv->instanceCmd);
	fp = popen (self->priv->instanceCmd, "r");
	g_warning("(%p) ========> popen(%s) returned %p", self, self->priv->instanceCmd, fp);//AP >> 8 & 0xFF);//AP

	gchar line[4096];//AP Big Big command output buffer//AP
	size_t l;//AP
	l=fread (line, 1, sizeof line, fp);
	if (l>0) {//to this "buffer-based" for multiline handling in widget //AP
		line[l-1]='\000';//AP
		g_warning("(%p) ========> fread() read returned %d [%s]", self, l, line);
	}
	gint exitCode=pclose(fp);
	g_warning("(%p) ppclose(fp) returned 0x%08X", self, exitCode);

	gtk_label_set_markup (GTK_LABEL (self->priv->cmdResult_lb), "No Output");//AP

	if ((self->priv->cmdExitStatus=(exitCode >> 8 & 0xff)) > 0x70) {
		gchar buff[4096]="";//AP output buffer//AP
		self->priv->cmdExitStatus=-1;
		if (l>0) {
			g_sprintf(buff,"[!?%04x]\n%s", exitCode, line);//If command has output we issue a newline after Exit Code
		} else {
			g_sprintf(buff,"[!?%04x]", exitCode);
		}
		gtk_label_set_markup (GTK_LABEL (self->priv->cmdResult_lb), buff);//AP
	} else {
		if (l>0) gtk_label_set_markup (GTK_LABEL (self->priv->cmdResult_lb), line);//AP
	}

	if( (self->priv->updateTimerID == 0) && (self->priv->delaySeconds > 0))
	{
		g_warning("(%p) re-arming timer, delaySeconds=%d", self, self->priv->delaySeconds);
		self->priv->updateTimerID = g_timeout_add_seconds (self->priv->delaySeconds, (GSourceFunc)queen_beecon_update_content, self);
	}

	// Assume something changed ... let's update content layout!!!
	g_warning("(%p) Command executed, let's assume something changed = UPDATE CONTENT LAYOUT", self);
	queen_beecon_update_content_layout (self);
}

static void queen_beecon_dispose (GObject *object)
{
g_warning ("(%p) queen_beecon_dispose",object);
//	QueenBeecon *self = QUEEN_BEECON (object);

	G_OBJECT_CLASS (queen_beecon_parent_class)->dispose (object);
}

static void queen_beecon_finalize (GObject *object)
{
g_warning ("(%p) queen_beecon_finalize",object);
	QueenBeecon *self = QUEEN_BEECON (object);

	if (self->priv->updateTimerID) {
		g_warning("(%p) self->priv->updateTimerID=%d", self, self->priv->updateTimerID);
		g_source_remove (self->priv->updateTimerID);
	}

	g_warning("(%p) self->priv->connection=%p", self, self->priv->connection);
	g_object_unref (self->priv->connection);

	g_warning("(%p) self->priv->c_titles=%p", self, self->priv->c_titles);
	g_strfreev(self->priv->c_titles);
	self->priv->c_titles = NULL;

	g_warning("(%p) self->priv->c_commands=%p", self, self->priv->c_commands);
	g_strfreev(self->priv->c_commands);
	self->priv->c_commands = NULL;

	g_warning("(%p) self->priv->beecon_lt0_ImgFilename = %p", self, self->priv->beecon_lt0_ImgFilename);
	if (self->priv->beecon_lt0_ImgFilename != NULL){g_free(self->priv->beecon_lt0_ImgFilename);self->priv->beecon_lt0_ImgFilename = NULL;}

	g_warning("(%p) self->priv->beecon_eq0_ImgFilename = %p", self, self->priv->beecon_eq0_ImgFilename);
	if (self->priv->beecon_eq0_ImgFilename != NULL){g_free(self->priv->beecon_eq0_ImgFilename);self->priv->beecon_eq0_ImgFilename = NULL;}

	g_warning("(%p) self->priv->beecon_eq1_ImgFilename = %p", self, self->priv->beecon_eq1_ImgFilename);
	if (self->priv->beecon_eq1_ImgFilename != NULL){g_free(self->priv->beecon_eq1_ImgFilename);self->priv->beecon_eq1_ImgFilename = NULL;}

	g_warning("(%p) self->priv->beecon_ge2_ImgFilename = %p", self, self->priv->beecon_ge2_ImgFilename);
	if (self->priv->beecon_ge2_ImgFilename != NULL){g_free(self->priv->beecon_ge2_ImgFilename);self->priv->beecon_ge2_ImgFilename = NULL;}

	g_warning("(%p) self->priv->beecon_idxge2_ImgFilename = %p", self, self->priv->beecon_idxge2_ImgFilename);
	if (self->priv->beecon_ge2_ImgFilename != NULL){g_free(self->priv->beecon_idxge2_ImgFilename);self->priv->beecon_idxge2_ImgFilename = NULL;}

	g_warning("(%p) self->priv->cmdImgFilename = %p", self, self->priv->cmdImgFilename);
	if (self->priv->cmdImgFilename != NULL){g_free(self->priv->cmdImgFilename);self->priv->cmdImgFilename = NULL;}

	g_warning("(%p) self->priv->resImgFilename = %p", self, self->priv->resImgFilename);
	if (self->priv->resImgFilename != NULL){g_free(self->priv->resImgFilename);self->priv->resImgFilename = NULL;}

	g_warning("(%p) self->priv->instanceTitle = %p", self, self->priv->instanceTitle);
	if (self->priv->instanceTitle != NULL){g_free(self->priv->instanceTitle);self->priv->instanceTitle = NULL;}

	g_warning("(%p) self->priv->instanceCmd = %p", self, self->priv->instanceCmd);
	if (self->priv->instanceCmd != NULL){g_free(self->priv->instanceCmd);self->priv->instanceCmd = NULL;}

	g_warning ("(%p) END OF queen_beecon_finalize",object);
	G_OBJECT_CLASS (queen_beecon_parent_class)->finalize (object);
}

static void queen_beecon_realize (GtkWidget *widget)
{
g_warning ("(%p) queen_beecon_realize",widget);
	QueenBeecon *self = QUEEN_BEECON (widget);
	GdkScreen *screen = NULL;

	screen = gtk_widget_get_screen (widget);
	gtk_widget_set_colormap (widget, gdk_screen_get_rgba_colormap (screen));

	gtk_widget_set_app_paintable (widget, TRUE);

	GTK_WIDGET_CLASS (queen_beecon_parent_class)->realize (widget);
	self->priv->widgetID = hd_home_plugin_item_get_applet_id (HD_HOME_PLUGIN_ITEM (widget));

}

static gboolean queen_beecon_expose_event (GtkWidget *widget, GdkEventExpose *event)
{
g_warning ("(%p) queen_beecon_expose_event event=%p", widget, event);

	// Let's draw the canvas with basic background shapes Beecon, Snippet...
	queen_beecon_draw_canvas (GTK_WIDGET (widget));

	return GTK_WIDGET_CLASS (queen_beecon_parent_class)->expose_event (widget, event);
}

static void queen_beecon_class_init (QueenBeeconClass *klass)
{
g_warning ("(%p) queen_beecon_class_init",klass);
	GObjectClass *object_class = G_OBJECT_CLASS (klass);
	GtkWidgetClass *widget_class = GTK_WIDGET_CLASS (klass);

	object_class->dispose = queen_beecon_dispose;
	object_class->finalize = queen_beecon_finalize;

	widget_class->realize = queen_beecon_realize;
	widget_class->expose_event = queen_beecon_expose_event;

	g_type_class_add_private (klass, sizeof (QueenBeeconPrivate));
}

static void queen_beecon_class_finalize (QueenBeeconClass *klass G_GNUC_UNUSED)
{
g_warning ("(%p) queen_beecon_class_finalize",klass);
	beecon_config_file_housekeeping(NULL); // Last housekeeping!!! How HARD!!!! :)
}

static void queen_beecon_init (QueenBeecon *self)
{
g_warning ("(%p) queen_beecon_init",self);
	self->priv = QUEEN_BEECON_GET_PRIVATE (self);

	beecon_config_file_housekeeping(NULL);// Let's do some preventive housekeeping before each instance creation

	GtkClipboard *clipboard = NULL;
	/* Allow clipboard data to be stored even when the application is closed: */
	clipboard = gtk_clipboard_get (GDK_SELECTION_CLIPBOARD);
	gtk_clipboard_set_can_store (clipboard, NULL, 0);

	self->priv->widgetID = NULL;

	self->priv->cmdExitStatus = -1;
	self->priv->updateTimerID = 0;
	self->priv->isPressed = FALSE;
	self->priv->widXOrigin=-1;
	self->priv->widYOrigin=-1;

	self->priv->connection = con_ic_connection_new ();
	g_signal_connect (self->priv->connection, "connection-event", G_CALLBACK (queen_beecon_connection_event), self);
	g_object_set (self->priv->connection, "automatic-connection-events", TRUE, NULL);
	self->priv->isConnected = FALSE;

	self->priv->cmdTitle_lb = NULL;
	self->priv->cmdTitle_img = NULL;
	self->priv->cmdResult_lb = NULL;
	self->priv->cmdResult_img = NULL;

	self->priv->beecon_lt0_ImgFilename = NULL;
	self->priv->beecon_eq0_ImgFilename = NULL;
	self->priv->beecon_eq1_ImgFilename = NULL;
	self->priv->beecon_ge2_ImgFilename = NULL;
	self->priv->beecon_idxge2_ImgFilename = NULL;
	self->priv->cmdImgFilename = NULL;
	self->priv->resImgFilename = NULL;
	self->priv->instanceTitle = NULL;
	self->priv->instanceCmd = NULL;

	// Create/Prepare primary and secondary image directories
	gchar *auxdirname = g_strconcat (HOME_DIR, QUEEN_BEECON_MYDOCS_IMAGE_DIR, NULL);
	g_warning("(%p) opening/creating private auxdirname %s", self, auxdirname);
	if(!g_mkdir_with_parents (auxdirname, 0755)) { // Let's create our directory if not already existing
		g_warning("(%p) problems creating/opening private auxdirname %s", self, auxdirname);
	} else
		g_free(auxdirname);

	gchar *dirname = g_strconcat (HOME_DIR, QUEEN_BEECON_PRIVATE_DIR, NULL);
	g_warning("(%p) opening/creating private dirname %s", self, dirname);
	if(!g_mkdir_with_parents (dirname, 0755)) {// Let's create our directory if not already existing
		g_warning("(%p) problems creating/opening private dirname %s", self, dirname);
	} else
		g_free(dirname);
	//EO Create/Prepare primary and secondary image directories

	// Initialize settings button
	hd_home_plugin_item_set_settings (&self->parent, TRUE);
	g_signal_connect (&self->parent, "show-settings", G_CALLBACK (queen_beecon_settings), self);

	GdkGeometry hints;
	hints.min_width = (int)(60);//AP3
	hints.min_height = (int)(60);//AP3
	hints.max_width = (int)(90);//AP3
	hints.max_height = (int)(90);//AP3
	gtk_window_set_default_size (GTK_WINDOW (self), 130, 115);
	gtk_window_set_geometry_hints (GTK_WINDOW (self), self->priv->homeWidget, &hints, GDK_HINT_MIN_SIZE | GDK_HINT_MAX_SIZE);
	gtk_widget_set_size_request (GTK_WIDGET (self), (int)(130), (int)(115));//AP3
	gtk_window_resize (GTK_WINDOW (self), (int)(130), (int)(115));//AP3

	self->priv->homeWidget = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (self), self->priv->homeWidget);
	gtk_widget_show (self->priv->homeWidget);

	g_warning("(%p) INIT calling queen_beecon_content_create (self)", self);
	queen_beecon_content_create (self);

	g_timeout_add (500, (GSourceFunc)queen_beecon_resize_hack, self);

	g_warning("(%p) INIT Let's arm notify::is-on-current-desktop", self);
	g_signal_connect (self, "notify::is-on-current-desktop", G_CALLBACK (queen_beecon_check_desktop), self);
}

QueenBeecon* queen_beecon_new (void)
{
g_warning ("queen_beecon_new");
	return g_object_new (QUEEN_BEECON_TYPE, NULL);
}


//Separate window dialogs
void queen_beecon_settings (HDHomePluginItem *hitem, QueenBeecon *self)
{
g_warning ("queen_beecon_settings(%p)",self);

	gboolean settingsRunning = TRUE, reloadInstanceSettings = TRUE;
	int i;
	GtkWidget *selector = NULL, *cmdSelector = NULL; //for command list

	beecon_config_file_housekeeping(NULL); // Housekeeping!!! How HARD!!!! :)

	g_warning("(%p) Ingresso in Settings reloadInstanceSettings=%d", self, reloadInstanceSettings);
	while(reloadInstanceSettings) { // First time we go free and easy
		reloadInstanceSettings = FALSE; // Door wide shut!
		settingsRunning = TRUE;
		g_warning ("(%p) settingsRunning in outer settings diaolg loop= %d",self, settingsRunning);
		GtkWidget *dialog = gtk_dialog_new_with_buttons ("Queen BeeCon Widget Settings", NULL, 0,
																										 _("wdgt_bd_save"), GTK_RESPONSE_ACCEPT,
																										 "Save & Run", NON_GTK_RESPONSE_SAVE_AND_RUN,
																										 "Add Cmd", NON_GTK_RESPONSE_ADD_CMD,
																										 "Edit Cmd", NON_GTK_RESPONSE_EDIT_CMD,
																										 "Advanced", NON_GTK_RESPONSE_ADVANCED,
																										 NULL);

		g_warning("(%p) Building settings dialog %p", self, dialog);
		GtkWidget *settingsArea = gtk_dialog_get_content_area (GTK_DIALOG (dialog));
		GtkWidget *scroll = hildon_pannable_area_new ();
		g_object_set (scroll, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);

		GtkWidget *content_area = gtk_vbox_new (FALSE, 0);
		hildon_pannable_area_add_with_viewport (HILDON_PANNABLE_AREA (scroll), content_area);
		gtk_container_add (GTK_CONTAINER (settingsArea), scroll);
		gtk_window_set_default_size (GTK_WINDOW (dialog), -1, 400);

		queen_beecon_read_settings(self, FALSE, FALSE, NULL);

		GtkWidget *widCmdTypeBox = gtk_hbox_new (FALSE, 0);
		//BEGIN Command Selector
		GtkWidget * widgetType = hildon_touch_selector_new_text ();//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (widgetType), "Beecon");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (widgetType), "Snippet");//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (widgetType), 0, self->priv->widgetType);//AP1

		GtkWidget * widgetTypeSelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (widgetTypeSelector), "Widget Type:");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (widgetTypeSelector), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (widgetTypeSelector), HILDON_TOUCH_SELECTOR (widgetType));//AP1
		gtk_box_pack_start (GTK_BOX (widCmdTypeBox), widgetTypeSelector, FALSE, FALSE, 0);//AP

		GtkWidget * widgetOperationalStatus = hildon_touch_selector_new_text ();//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (widgetOperationalStatus), "Enabled");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (widgetOperationalStatus), "Disabled");//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (widgetOperationalStatus), 0, self->priv->operationalStatus);//AP1

		GtkWidget * widgetOperationalStatusSelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (widgetOperationalStatusSelector), "Status:");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (widgetOperationalStatusSelector), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (widgetOperationalStatusSelector), HILDON_TOUCH_SELECTOR (widgetOperationalStatus));//AP1
		gtk_box_pack_start (GTK_BOX (widCmdTypeBox), widgetOperationalStatusSelector, FALSE, FALSE, 0);//AP

		selector = hildon_touch_selector_new_text ();
		g_warning("(%p) Created command selector %p self->priv->c_size = %d", self, selector, self->priv->c_size);
		for(i=0;i<self->priv->c_size;i++)
		{
			hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (selector), self->priv->c_titles[i]);
			g_warning("(%p) Append Titles [%s]-[%s]", self, self->priv->c_titles[i], self->priv->instanceTitle);
			if(g_strcmp0(self->priv->c_titles[i],self->priv->instanceTitle) == 0) {
				g_warning("(%p) Commands [%s]-[%s]", self, self->priv->c_commands[i], self->priv->instanceCmd);
				if(g_strcmp0(self->priv->c_commands[i],self->priv->instanceCmd) == 0) {
					g_warning("(%p) Active [%s]-[%s]", self, self->priv->c_commands[i], self->priv->instanceCmd);
					hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (selector), 0, i);
				}
			}
		}
		cmdSelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
		hildon_button_set_title (HILDON_BUTTON (cmdSelector), "Command Selection:");
		hildon_button_set_alignment (HILDON_BUTTON (cmdSelector), 0, 0.5, 0, 0);
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (cmdSelector), HILDON_TOUCH_SELECTOR (selector));
		gtk_box_pack_start (GTK_BOX (widCmdTypeBox), cmdSelector, TRUE, TRUE, 0);//AP
		//END

		gtk_container_add (GTK_CONTAINER (content_area), widCmdTypeBox);//AP1

		gchar helpWarnMsg[512]="";
		GtkWidget *widHelpLabel = gtk_label_new ("");
		g_sprintf(helpWarnMsg,
				"<span font_desc=\"Nokia Sans 13\"><b><u><span foreground=\"red\">BEECONS</span></u></b> are small hexagonal cells whose background color or images change dynamically according to command exit status.\n<b><u><span foreground=\"red\">SNIPPETS</span></u></b> are normal text boxes with fixed background color or images which are not influenced by the command exit status.\n<b><span foreground=\"red\">WARNING!!!</span></b> For IMAGE filenames, leave blank or prepend \";\" for text only results. Default storage location for images, if no path specified:\n1<sup>st</sup> <span foreground=\"red\">%s%s</span>\n2<sup>nd</sup> <span foreground=\"red\">%s%s</span></span>",
				HOME_DIR,
				QUEEN_BEECON_MYDOCS_IMAGE_DIR,
				HOME_DIR,
				QUEEN_BEECON_PRIVATE_DIR);
		gtk_label_set_markup (GTK_LABEL (widHelpLabel), helpWarnMsg);
		gtk_misc_set_alignment (GTK_MISC (widHelpLabel), 0, 0);
		gtk_label_set_line_wrap (GTK_LABEL (widHelpLabel), TRUE);
		gtk_container_add (GTK_CONTAINER (content_area), widHelpLabel);

		GtkWidget *widgetSizeLabel = gtk_label_new ("");//AP1
		gtk_label_set_markup (GTK_LABEL (widgetSizeLabel), "Widget Size &amp; Position Tuning:");//AP1
		gtk_container_add (GTK_CONTAINER (content_area), widgetSizeLabel);//AP1

		GtkWidget *widthBox = gtk_hbox_new (FALSE, 0);

		GtkWidget *widthLabel = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (widthLabel), "Width:\n<small>Pixels [10-800]</small>");
		gtk_misc_set_alignment (GTK_MISC (widthLabel), 0, 0.5);
		gtk_misc_set_padding (GTK_MISC (widthLabel), HILDON_MARGIN_DOUBLE, 0);

		GtkWidget * widthSelect = gtk_hscale_new_with_range ((gdouble)10.0, (gdouble)SIZE_WIDTH_ALL, (gdouble)5.0);
		gtk_range_set_value(GTK_RANGE(widthSelect), self->priv->widWidth);

		gtk_box_pack_start (GTK_BOX (widthBox), widthLabel, FALSE, FALSE, 0);
		gtk_box_pack_start (GTK_BOX (widthBox), widthSelect, TRUE, TRUE, 0);

		gtk_container_add (GTK_CONTAINER (content_area), widthBox);

		//layout opts heightBox //AP
		GtkWidget *heightBox = gtk_hbox_new (FALSE, 0);//AP

		GtkWidget *heightLabel = gtk_label_new ("");//AP

		gtk_label_set_markup (GTK_LABEL (heightLabel), "Height:\n<small>Pixels [10-400]</small>");

		gtk_misc_set_alignment (GTK_MISC (heightLabel), 0, 0.5);//AP
		gtk_misc_set_padding (GTK_MISC (heightLabel), HILDON_MARGIN_DOUBLE, 0);//AP
//		gtk_size_group_add_widget (group, heightLabel);//AP

		GtkWidget * heightSelect = gtk_hscale_new_with_range ((gdouble)10.0, (gdouble)SIZE_HEIGHT_ALL, (gdouble)5.0);//AP
		gtk_range_set_value(GTK_RANGE(heightSelect), self->priv->widHeight);//AP
		gtk_box_pack_start (GTK_BOX (heightBox), heightLabel, FALSE, FALSE, 0);//AP
		gtk_box_pack_start (GTK_BOX (heightBox), heightSelect, TRUE, TRUE, 0);//AP

		gtk_container_add (GTK_CONTAINER (content_area), heightBox);//AP

		GtkWidget *widPositionBox = gtk_hbox_new (FALSE, 0);//AP1

		GtkWidget *widPositionLabel = gtk_label_new ("");//AP1
		gtk_label_set_markup (GTK_LABEL (widPositionLabel), "Fine Tune (X,Y):\n<small>(x=0,y=0 is Top-Left)</small>");
		gtk_misc_set_alignment (GTK_MISC (widPositionLabel), 0, 0.5);//AP1
		gtk_misc_set_padding (GTK_MISC (widPositionLabel), HILDON_MARGIN_DOUBLE, 0);//AP1
//		gtk_size_group_add_widget (group, widPositionLabel);//AP1

		// Check if we have moved our widget window through settings for fine tuning
		gint widXOrigin, widYOrigin;
		gtk_window_get_position (GTK_WINDOW (self), &widXOrigin, &widYOrigin); // Remember our position ... maybe we need to move a little bit

		GtkWidget *widPositionX = gtk_hscale_new_with_range ((gdouble)widXOrigin-5, (gdouble)widXOrigin+5, (gdouble)1);//AP1
		gtk_range_set_value(GTK_RANGE(widPositionX), widXOrigin);//AP1

		GtkWidget *widPositionY = gtk_hscale_new_with_range ((gdouble)widYOrigin-5, (gdouble)widYOrigin+5, (gdouble)1);//AP1
		gtk_range_set_value(GTK_RANGE(widPositionY), widYOrigin);//AP1

		gtk_box_pack_start (GTK_BOX (widPositionBox), widPositionLabel, FALSE, FALSE, 0);//AP1
		gtk_box_pack_start (GTK_BOX (widPositionBox), widPositionX, TRUE, TRUE, 0);//AP1
		gtk_box_pack_start (GTK_BOX (widPositionBox), widPositionY, TRUE, TRUE, 0);//AP1

		gtk_container_add (GTK_CONTAINER (content_area), widPositionBox);//AP1

		GtkWidget *widgetBgLabel = gtk_label_new ("Status Background Colors & Images:");//AP1
		gtk_container_add (GTK_CONTAINER (content_area), widgetBgLabel);//AP1

		GtkWidget *hidCanvSnipBgBox = gtk_hbox_new (TRUE, 0);//AP1

		GtkWidget *checkBtHideCanvas = hildon_check_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		gtk_button_set_label (GTK_BUTTON (checkBtHideCanvas), "Hide Background");
		hildon_check_button_set_active (HILDON_CHECK_BUTTON (checkBtHideCanvas), self->priv->hideCanvas);
		gtk_box_pack_start (GTK_BOX (hidCanvSnipBgBox), checkBtHideCanvas, TRUE, TRUE, 0);//AP

		GtkWidget *snippetBgRGB = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_colors[i].colorName!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (snippetBgRGB), p_colors[i].colorName);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (snippetBgRGB), 0, self->priv->snippetBgRGB);//AP1

		GtkWidget * snippetBgRGBSelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (snippetBgRGBSelector), "Snippets Bg Color:");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (snippetBgRGBSelector), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (snippetBgRGBSelector), HILDON_TOUCH_SELECTOR (snippetBgRGB));//AP1
		gtk_box_pack_start (GTK_BOX (hidCanvSnipBgBox), snippetBgRGBSelector, TRUE, TRUE, 0);//AP

		gtk_container_add (GTK_CONTAINER (content_area), hidCanvSnipBgBox);//AP1

		GtkWidget *snipHelpLabel = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (snipHelpLabel), "<span font_desc=\"Nokia Sans 12\">><b><u>Not affected</u></b> by Command Exit Status</span>\n");
		gtk_misc_set_alignment (GTK_MISC (snipHelpLabel), 1, 0);
		gtk_label_set_line_wrap (GTK_LABEL (snipHelpLabel), TRUE);
		gtk_container_add (GTK_CONTAINER (content_area), snipHelpLabel);

		GtkWidget *beelt0Box = gtk_hbox_new (FALSE, 0);//AP1
		//BEGIN beecon images image
		GtkWidget *beecon_lt0_ImgLabel = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (beecon_lt0_ImgLabel), "<small>Beecon Command Exit Status <b><u>&lt;0</u></b></small>\n<span font_desc=\"Nokia Sans 12\">Image Filename:</span>");//AP1
		gtk_misc_set_alignment (GTK_MISC (beecon_lt0_ImgLabel), 0, 0.5);
		gtk_container_add (GTK_CONTAINER (content_area), beecon_lt0_ImgLabel);//AP1

		GtkWidget *beecon_lt0_ImgEntry = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		hildon_entry_set_text(HILDON_ENTRY (beecon_lt0_ImgEntry), self->priv->beecon_lt0_ImgFilename);
		gtk_box_pack_start (GTK_BOX (beelt0Box), beecon_lt0_ImgEntry, TRUE, TRUE, 0);//AP

		GtkWidget *beecon_lt0_ImgZoom = hildon_touch_selector_new_text ();//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (beecon_lt0_ImgZoom), "1:1");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (beecon_lt0_ImgZoom), "Fit");//AP1
		for(i=5;i<=200;i+=5) {//AP1
				char b[10]; g_sprintf(b,"%d %%",i);
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (beecon_lt0_ImgZoom), b);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (beecon_lt0_ImgZoom), 0, self->priv->beecon_lt0_ImgZoom);//AP1
		GtkWidget * beecon_lt0_ImgZoomSelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (beecon_lt0_ImgZoomSelector), "Scale:");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (beecon_lt0_ImgZoomSelector), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (beecon_lt0_ImgZoomSelector), HILDON_TOUCH_SELECTOR (beecon_lt0_ImgZoom));//AP1
		gtk_box_pack_start (GTK_BOX (beelt0Box), beecon_lt0_ImgZoomSelector, FALSE, FALSE, 0);//AP

		GtkWidget *beecon_lt0_BgRGB = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_colors[i].colorName!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (beecon_lt0_BgRGB), p_colors[i].colorName);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (beecon_lt0_BgRGB), 0, self->priv->beecon_lt0_BgRGB);//AP1

		GtkWidget * beecon_lt0_BgRGBSelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (beecon_lt0_BgRGBSelector), "Bg Color:");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (beecon_lt0_BgRGBSelector), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (beecon_lt0_BgRGBSelector), HILDON_TOUCH_SELECTOR (beecon_lt0_BgRGB));//AP1
		gtk_box_pack_start (GTK_BOX (beelt0Box), beecon_lt0_BgRGBSelector, FALSE, FALSE, 0);//AP

		//END title image

		gtk_container_add (GTK_CONTAINER (content_area), beelt0Box);//AP1

		GtkWidget *beeeq0Box = gtk_hbox_new (FALSE, 0);//AP1
		//BEGIN beecon images image
		GtkWidget *beecon_eq0_ImgLabel = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (beecon_eq0_ImgLabel), "<small>\nBeecon Command Exit Status <b><u>=0</u></b></small>\n<span font_desc=\"Nokia Sans 12\">Image Filename:</span>");//AP1
		gtk_misc_set_alignment (GTK_MISC (beecon_eq0_ImgLabel), 0, 0.5);
		gtk_container_add (GTK_CONTAINER (content_area), beecon_eq0_ImgLabel);//AP1

		GtkWidget *beecon_eq0_ImgEntry = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		hildon_entry_set_text(HILDON_ENTRY (beecon_eq0_ImgEntry), self->priv->beecon_eq0_ImgFilename);
		gtk_box_pack_start (GTK_BOX (beeeq0Box), beecon_eq0_ImgEntry, TRUE, TRUE, 0);//AP
		//END title image

		GtkWidget *beecon_eq0_ImgZoom = hildon_touch_selector_new_text ();//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (beecon_eq0_ImgZoom), "1:1");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (beecon_eq0_ImgZoom), "Fit");//AP1
		for(i=5;i<=200;i+=5) {//AP1
				char b[10]; g_sprintf(b,"%d %%",i);
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (beecon_eq0_ImgZoom), b);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (beecon_eq0_ImgZoom), 0, self->priv->beecon_eq0_ImgZoom);//AP1
		GtkWidget * beecon_eq0_ImgZoomSelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (beecon_eq0_ImgZoomSelector), "Scale:");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (beecon_eq0_ImgZoomSelector), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (beecon_eq0_ImgZoomSelector), HILDON_TOUCH_SELECTOR (beecon_eq0_ImgZoom));//AP1
		gtk_box_pack_start (GTK_BOX (beeeq0Box), beecon_eq0_ImgZoomSelector, FALSE, FALSE, 0);//AP

		GtkWidget *beecon_eq0_BgRGB = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_colors[i].colorName!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (beecon_eq0_BgRGB), p_colors[i].colorName);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (beecon_eq0_BgRGB), 0, self->priv->beecon_eq0_BgRGB);//AP1

		GtkWidget * beecon_eq0_BgRGBSelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (beecon_eq0_BgRGBSelector), "Bg Color:");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (beecon_eq0_BgRGBSelector), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (beecon_eq0_BgRGBSelector), HILDON_TOUCH_SELECTOR (beecon_eq0_BgRGB));//AP1
		gtk_box_pack_start (GTK_BOX (beeeq0Box), beecon_eq0_BgRGBSelector, FALSE, FALSE, 0);//AP

		gtk_container_add (GTK_CONTAINER (content_area), beeeq0Box);//AP1

		GtkWidget *beeeq1Box = gtk_hbox_new (FALSE, 0);//AP1
		//BEGIN beecon images image
		GtkWidget *beecon_eq1_ImgLabel = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (beecon_eq1_ImgLabel), "<small>\nBeecon Command Exit Status <b><u>=1</u></b></small>\n<span font_desc=\"Nokia Sans 12\">Image Filename:</span>");//AP1
		gtk_misc_set_alignment (GTK_MISC (beecon_eq1_ImgLabel), 0, 0.5);
		gtk_container_add (GTK_CONTAINER (content_area), beecon_eq1_ImgLabel);//AP1

		GtkWidget *beecon_eq1_ImgEntry = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		hildon_entry_set_text(HILDON_ENTRY (beecon_eq1_ImgEntry), self->priv->beecon_eq1_ImgFilename);
		gtk_box_pack_start (GTK_BOX (beeeq1Box), beecon_eq1_ImgEntry, TRUE, TRUE, 0);//AP
		//END title image

		GtkWidget *beecon_eq1_ImgZoom = hildon_touch_selector_new_text ();//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (beecon_eq1_ImgZoom), "1:1");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (beecon_eq1_ImgZoom), "Fit");//AP1
		for(i=5;i<=200;i+=5) {//AP1
				char b[10]; g_sprintf(b,"%d %%",i);
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (beecon_eq1_ImgZoom), b);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (beecon_eq1_ImgZoom), 0, self->priv->beecon_eq1_ImgZoom);//AP1
		GtkWidget * beecon_eq1_ImgZoomSelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (beecon_eq1_ImgZoomSelector), "Scale:");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (beecon_eq1_ImgZoomSelector), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (beecon_eq1_ImgZoomSelector), HILDON_TOUCH_SELECTOR (beecon_eq1_ImgZoom));//AP1
		gtk_box_pack_start (GTK_BOX (beeeq1Box), beecon_eq1_ImgZoomSelector, FALSE, FALSE, 0);//AP

		GtkWidget *beecon_eq1_BgRGB = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_colors[i].colorName!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (beecon_eq1_BgRGB), p_colors[i].colorName);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (beecon_eq1_BgRGB), 0, self->priv->beecon_eq1_BgRGB);//AP1

		GtkWidget * beecon_eq1_BgRGBSelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (beecon_eq1_BgRGBSelector), "Bg Color:");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (beecon_eq1_BgRGBSelector), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (beecon_eq1_BgRGBSelector), HILDON_TOUCH_SELECTOR (beecon_eq1_BgRGB));//AP1
		gtk_box_pack_start (GTK_BOX (beeeq1Box), beecon_eq1_BgRGBSelector, FALSE, FALSE, 0);//AP

		gtk_container_add (GTK_CONTAINER (content_area), beeeq1Box);//AP1

		GtkWidget *beege2Box = gtk_hbox_new (FALSE, 0);//AP1
		//BEGIN beecon images image
		GtkWidget *beecon_ge2_ImgLabel = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (beecon_ge2_ImgLabel), "<small>\nBeecon Command Exit Status <b><u>=2</u></b></small>\n<span font_desc=\"Nokia Sans 12\">Image Filename:</span>");//AP1
		gtk_misc_set_alignment (GTK_MISC (beecon_ge2_ImgLabel), 0, 0.5);
		gtk_container_add (GTK_CONTAINER (content_area), beecon_ge2_ImgLabel);//AP1

		GtkWidget *beecon_ge2_ImgEntry = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		hildon_entry_set_text(HILDON_ENTRY (beecon_ge2_ImgEntry), self->priv->beecon_ge2_ImgFilename);
		gtk_box_pack_start (GTK_BOX (beege2Box), beecon_ge2_ImgEntry, TRUE, TRUE, 0);//AP
		//END title image

		GtkWidget *beecon_ge2_ImgZoom = hildon_touch_selector_new_text ();//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (beecon_ge2_ImgZoom), "1:1");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (beecon_ge2_ImgZoom), "Fit");//AP1
		for(i=5;i<=200;i+=5) {//AP1
				char b[10]; g_sprintf(b,"%d %%",i);
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (beecon_ge2_ImgZoom), b);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (beecon_ge2_ImgZoom), 0, self->priv->beecon_ge2_ImgZoom);//AP1
		GtkWidget * beecon_ge2_ImgZoomSelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (beecon_ge2_ImgZoomSelector), "Scale:");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (beecon_ge2_ImgZoomSelector), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (beecon_ge2_ImgZoomSelector), HILDON_TOUCH_SELECTOR (beecon_ge2_ImgZoom));//AP1
		gtk_box_pack_start (GTK_BOX (beege2Box), beecon_ge2_ImgZoomSelector, FALSE, FALSE, 0);//AP

		GtkWidget *beecon_ge2_BgRGB = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_colors[i].colorName!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (beecon_ge2_BgRGB), p_colors[i].colorName);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (beecon_ge2_BgRGB), 0, self->priv->beecon_ge2_BgRGB);//AP1

		GtkWidget * beecon_ge2_BgRGBSelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (beecon_ge2_BgRGBSelector), "Bg Color:");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (beecon_ge2_BgRGBSelector), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (beecon_ge2_BgRGBSelector), HILDON_TOUCH_SELECTOR (beecon_ge2_BgRGB));//AP1
		gtk_box_pack_start (GTK_BOX (beege2Box), beecon_ge2_BgRGBSelector, FALSE, FALSE, 0);//AP

		gtk_container_add (GTK_CONTAINER (content_area), beege2Box);//AP1

		GtkWidget *beeidxge2Box = gtk_hbox_new (FALSE, 0);//AP1
		//BEGIN beecon images image
		GtkWidget *beecon_idxge2_ImgLabel = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (beecon_idxge2_ImgLabel), "<small>\nBeecon Command Exit Status <b><u>&gt;=3</u></b></small>\n<span font_desc=\"Nokia Sans 12\">Image Filename Base ( \".\" + Exit Status will be appended and image loaded)</span>");//AP1
		gtk_misc_set_alignment (GTK_MISC (beecon_idxge2_ImgLabel), 0, 0.5);
		gtk_container_add (GTK_CONTAINER (content_area), beecon_idxge2_ImgLabel);//AP1

		GtkWidget *beecon_idxge2_ImgEntry = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		hildon_entry_set_text(HILDON_ENTRY (beecon_idxge2_ImgEntry), self->priv->beecon_idxge2_ImgFilename);
		gtk_box_pack_start (GTK_BOX (beeidxge2Box), beecon_idxge2_ImgEntry, TRUE, TRUE, 0);//AP
		//END title image

		GtkWidget *beecon_idxge2_ImgZoom = hildon_touch_selector_new_text ();//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (beecon_idxge2_ImgZoom), "1:1");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (beecon_idxge2_ImgZoom), "Fit");//AP1
		for(i=5;i<=200;i+=5) {//AP1
				char b[10]; g_sprintf(b,"%d %%",i);
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (beecon_idxge2_ImgZoom), b);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (beecon_idxge2_ImgZoom), 0, self->priv->beecon_idxge2_ImgZoom);//AP1
		GtkWidget * beecon_idxge2_ImgZoomSelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (beecon_idxge2_ImgZoomSelector), "Scale:");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (beecon_idxge2_ImgZoomSelector), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (beecon_idxge2_ImgZoomSelector), HILDON_TOUCH_SELECTOR (beecon_idxge2_ImgZoom));//AP1
		gtk_box_pack_start (GTK_BOX (beeidxge2Box), beecon_idxge2_ImgZoomSelector, FALSE, FALSE, 0);//AP

		GtkWidget *beecon_idxge2_BgRGB = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_colors[i].colorName!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (beecon_idxge2_BgRGB), p_colors[i].colorName);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (beecon_idxge2_BgRGB), 0, self->priv->beecon_idxge2_BgRGB);//AP1

		GtkWidget * beecon_idxge2_BgRGBSelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (beecon_idxge2_BgRGBSelector), "Bg Color:");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (beecon_idxge2_BgRGBSelector), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (beecon_idxge2_BgRGBSelector), HILDON_TOUCH_SELECTOR (beecon_idxge2_BgRGB));//AP1
		gtk_box_pack_start (GTK_BOX (beeidxge2Box), beecon_idxge2_BgRGBSelector, FALSE, FALSE, 0);//AP

		gtk_container_add (GTK_CONTAINER (content_area), beeidxge2Box);//AP1

		//BEGIN
		//layout opts

		GtkWidget *LayoutCmdLabel = gtk_label_new ("Command Title Settings:");//AP1
		gtk_container_add (GTK_CONTAINER (content_area), LayoutCmdLabel);//AP1

		//BEGIN title image
		GtkWidget *titleImgLabel = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (titleImgLabel), "<span font_desc=\"Nokia Sans 12\">Image Filename:</span>");//AP1
		gtk_misc_set_alignment (GTK_MISC (titleImgLabel), 0, 0.5);
		gtk_container_add (GTK_CONTAINER (content_area), titleImgLabel);//AP1

		GtkWidget *cmdImgVisPosBox = gtk_hbox_new (FALSE, 0);//AP1

		GtkWidget *titleImgEntry = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		hildon_entry_set_text(HILDON_ENTRY (titleImgEntry), self->priv->cmdImgFilename);
		gtk_box_pack_start (GTK_BOX (cmdImgVisPosBox), titleImgEntry, TRUE, TRUE, 0);//AP1
		//END title image

		GtkWidget *beecon_cmdImgZoom = hildon_touch_selector_new_text ();//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (beecon_cmdImgZoom), "1:1");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (beecon_cmdImgZoom), "Fit");//AP1
		for(i=5;i<=200;i+=5) {//AP1
				char b[10]; g_sprintf(b,"%d %%",i);
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (beecon_cmdImgZoom), b);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (beecon_cmdImgZoom), 0, self->priv->cmdImgZoom);//AP1
		GtkWidget * beecon_cmdImgZoomSelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (beecon_cmdImgZoomSelector), "Scale:");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (beecon_cmdImgZoomSelector), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (beecon_cmdImgZoomSelector), HILDON_TOUCH_SELECTOR (beecon_cmdImgZoom));//AP1
		gtk_box_pack_start (GTK_BOX (cmdImgVisPosBox), beecon_cmdImgZoomSelector, FALSE, FALSE, 0);//AP

		GtkWidget *cmdImgVisibilityPosition = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_visible_position[i]!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (cmdImgVisibilityPosition), p_visible_position[i]);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (cmdImgVisibilityPosition), 0, self->priv->cmdImgVisibilityPosition);//AP1

		GtkWidget * cmdImgVisibilityPositionSelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (cmdImgVisibilityPositionSelector), "Position");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (cmdImgVisibilityPositionSelector), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (cmdImgVisibilityPositionSelector), HILDON_TOUCH_SELECTOR (cmdImgVisibilityPosition));//AP1
		gtk_box_pack_start (GTK_BOX (cmdImgVisPosBox), cmdImgVisibilityPositionSelector, FALSE, FALSE, 0);//AP1

		gtk_container_add (GTK_CONTAINER (content_area), cmdImgVisPosBox);//AP1

		GtkWidget *cmdFontBox = gtk_hbox_new (TRUE, 0);//AP1

		GtkWidget *cmdFontFam = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_fonts[i]!=NULL;i++) {//AP1
			int j;
			for (j=0;j<4;j++) {//AP1
				gchar fs[256];//AP1
				g_sprintf(fs, "%s %s",p_fonts[i], p_fonts_types[j]);//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (cmdFontFam), fs);//AP1
			}//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (cmdFontFam), 0, self->priv->cmdFontName);//AP1

		GtkWidget * cmdFontSelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_THUMB_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (cmdFontSelector), "Font Face: ");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (cmdFontSelector), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (cmdFontSelector), HILDON_TOUCH_SELECTOR (cmdFontFam));//AP1
		gtk_box_pack_start (GTK_BOX (cmdFontBox), cmdFontSelector, TRUE, TRUE, 0);//AP1

		GtkWidget *cmdFontSz = gtk_hscale_new_with_range ((gdouble)8, (gdouble)72, (gdouble)1);//AP1
		gtk_range_set_value(GTK_RANGE(cmdFontSz), self->priv->cmdFontSize);//AP1
		gtk_box_pack_start (GTK_BOX (cmdFontBox), cmdFontSz, TRUE, TRUE, 0);//AP1

		gtk_container_add (GTK_CONTAINER (content_area), cmdFontBox);//AP1

		GtkWidget *cmdPosColJusBox = gtk_hbox_new (TRUE, 0);//AP1

		GtkWidget *cmdVisibilityPosition = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_visible_position[i]!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (cmdVisibilityPosition), p_visible_position[i]);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (cmdVisibilityPosition), 0, self->priv->cmdVisibilityPosition);//AP1

		GtkWidget * cmdVisibilityPositionSelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (cmdVisibilityPositionSelector), "Position");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (cmdVisibilityPositionSelector), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (cmdVisibilityPositionSelector), HILDON_TOUCH_SELECTOR (cmdVisibilityPosition));//AP1
		gtk_box_pack_start (GTK_BOX (cmdPosColJusBox), cmdVisibilityPositionSelector, TRUE, TRUE, 0);//AP1

		GtkWidget *cmdFgRGB = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_colors[i].colorName!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (cmdFgRGB), p_colors[i].colorName);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (cmdFgRGB), 0, self->priv->cmdFgRGB);//AP1

		GtkWidget * cmdFgRGBSelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (cmdFgRGBSelector), "Color: ");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (cmdFgRGBSelector), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (cmdFgRGBSelector), HILDON_TOUCH_SELECTOR (cmdFgRGB));//AP1
		gtk_box_pack_start (GTK_BOX (cmdPosColJusBox), cmdFgRGBSelector, TRUE, TRUE, 0);//AP1

		GtkWidget *cmdJustify = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_justification[i]!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (cmdJustify), p_justification[i]);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (cmdJustify), 0, self->priv->cmdJustify);//AP1

		GtkWidget * cmdJustifySelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (cmdJustifySelector), "Justification: ");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (cmdJustifySelector), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (cmdJustifySelector), HILDON_TOUCH_SELECTOR (cmdJustify));//AP1
		gtk_box_pack_start (GTK_BOX (cmdPosColJusBox), cmdJustifySelector, TRUE, TRUE, 0);//AP1

		gtk_container_add (GTK_CONTAINER (content_area), cmdPosColJusBox);//AP1
//----------------------------
		GtkWidget *LayoutResLabel = gtk_label_new ("Command Results Settings:");//AP1
		gtk_container_add (GTK_CONTAINER (content_area), LayoutResLabel);//AP1

		//BEGIN results image
		GtkWidget *resultImgLabel = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (resultImgLabel), "<span font_desc=\"Nokia Sans 12\">Image Filename:</span>");//AP1
		gtk_misc_set_alignment (GTK_MISC (resultImgLabel), 0, 0.5);
		gtk_container_add (GTK_CONTAINER (content_area), resultImgLabel);

		GtkWidget *resImgVisPosBox = gtk_hbox_new (FALSE, 0);//AP1

		GtkWidget *resultsImgEntry = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		hildon_entry_set_text(HILDON_ENTRY (resultsImgEntry), self->priv->resImgFilename);
		gtk_box_pack_start (GTK_BOX (resImgVisPosBox), resultsImgEntry, TRUE, TRUE, 0);//AP1
		//END results image

		GtkWidget *beecon_resImgZoom = hildon_touch_selector_new_text ();//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (beecon_resImgZoom), "1:1");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (beecon_resImgZoom), "Fit");//AP1
		for(i=5;i<=200;i+=5) {//AP1
				char b[10]; g_sprintf(b,"%d %%",i);
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (beecon_resImgZoom), b);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (beecon_resImgZoom), 0, self->priv->resImgZoom);//AP1
		GtkWidget * beecon_resImgZoomSelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (beecon_resImgZoomSelector), "Scale:");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (beecon_resImgZoomSelector), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (beecon_resImgZoomSelector), HILDON_TOUCH_SELECTOR (beecon_resImgZoom));//AP1
		gtk_box_pack_start (GTK_BOX (resImgVisPosBox), beecon_resImgZoomSelector, FALSE, FALSE, 0);//AP

		GtkWidget *resImgVisibilityPosition = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_visible_position[i]!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (resImgVisibilityPosition), p_visible_position[i]);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (resImgVisibilityPosition), 0, self->priv->resImgVisibilityPosition);//AP1

		GtkWidget * resImgVisibilityPositionSelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (resImgVisibilityPositionSelector), "Position");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (resImgVisibilityPositionSelector), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (resImgVisibilityPositionSelector), HILDON_TOUCH_SELECTOR (resImgVisibilityPosition));//AP1
		gtk_box_pack_start (GTK_BOX (resImgVisPosBox), resImgVisibilityPositionSelector, FALSE, FALSE, 0);//AP1

		gtk_container_add (GTK_CONTAINER (content_area), resImgVisPosBox);//AP1

		GtkWidget *resFontBox = gtk_hbox_new (TRUE, 0);//AP1

		GtkWidget *resFontFam = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_fonts[i]!=NULL;i++) {//AP1
			int j;
			for (j=0;j<4;j++) {//AP1
				gchar fs[256];//AP1
				g_sprintf(fs, "%s %s",p_fonts[i], p_fonts_types[j]);//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (resFontFam), fs);//AP1
			}//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (resFontFam), 0, self->priv->resFontName);//AP1

		GtkWidget * resFontSelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_THUMB_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
		hildon_button_set_title (HILDON_BUTTON (resFontSelector), "Font Face: ");
		hildon_button_set_alignment (HILDON_BUTTON (resFontSelector), 0, 0.5, 0, 0);
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (resFontSelector), HILDON_TOUCH_SELECTOR (resFontFam));
		gtk_box_pack_start (GTK_BOX (resFontBox), resFontSelector, TRUE, TRUE, 0);//AP1

		GtkWidget *resFontSz = gtk_hscale_new_with_range ((gdouble)8, (gdouble)72, (gdouble)1);//AP1
		gtk_range_set_value(GTK_RANGE(resFontSz), self->priv->resFontSize);//AP1
		gtk_box_pack_start (GTK_BOX (resFontBox), resFontSz, TRUE, TRUE, 0);//AP1
		gtk_container_add (GTK_CONTAINER (content_area), resFontBox);//AP1
		//END

		GtkWidget *resVisColJusBox = gtk_hbox_new (TRUE, 0);//AP1

		GtkWidget *resVisibilityPosition = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_visible_position[i]!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (resVisibilityPosition), p_visible_position[i]);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (resVisibilityPosition), 0, self->priv->resVisibilityPosition);//AP1

		GtkWidget * resVisibilityPositionSelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (resVisibilityPositionSelector), "Position");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (resVisibilityPositionSelector), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (resVisibilityPositionSelector), HILDON_TOUCH_SELECTOR (resVisibilityPosition));//AP1
		gtk_box_pack_start (GTK_BOX (resVisColJusBox), resVisibilityPositionSelector, TRUE, TRUE, 0);//AP1

		GtkWidget *resFgRGB = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_colors[i].colorName!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (resFgRGB), p_colors[i].colorName);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (resFgRGB), 0, self->priv->resFgRGB);//AP1

		GtkWidget * resFgRGBSelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (resFgRGBSelector), "Color: ");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (resFgRGBSelector), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (resFgRGBSelector), HILDON_TOUCH_SELECTOR (resFgRGB));//AP1
		gtk_box_pack_start (GTK_BOX (resVisColJusBox), resFgRGBSelector, TRUE, TRUE, 0);//AP1

		GtkWidget *resJustify = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_justification[i]!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (resJustify), p_justification[i]);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (resJustify), 0, self->priv->resJustify);//AP1

		GtkWidget * resJustifySelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (resJustifySelector), "Justification: ");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (resJustifySelector), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (resJustifySelector), HILDON_TOUCH_SELECTOR (resJustify));//AP1
		gtk_box_pack_start (GTK_BOX (resVisColJusBox), resJustifySelector, TRUE, TRUE, 0);//AP1

		gtk_container_add (GTK_CONTAINER (content_area), resVisColJusBox);//AP1

		//BEGIN Update Policy
		GtkWidget *updPolicyLabel = gtk_label_new ("Update Policy:");
		gtk_container_add (GTK_CONTAINER (content_area), updPolicyLabel);

		GtkWidget *checkBtStartup = hildon_check_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		gtk_button_set_label (GTK_BUTTON (checkBtStartup), "Update on Widget/System Startup");
		gtk_container_add (GTK_CONTAINER (content_area), checkBtStartup);
		hildon_check_button_set_active (HILDON_CHECK_BUTTON (checkBtStartup), self->priv->updOnStartup);

		GtkWidget *checkBtClick = hildon_check_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		gtk_button_set_label (GTK_BUTTON (checkBtClick), "Update when clicked");
		gtk_container_add (GTK_CONTAINER (content_area), checkBtClick);
		hildon_check_button_set_active (HILDON_CHECK_BUTTON (checkBtClick), self->priv->updOnClick);

		GtkWidget *checkBtDesktop = hildon_check_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		gtk_button_set_label (GTK_BUTTON (checkBtDesktop), "Update when switched to the desktop");
		gtk_container_add (GTK_CONTAINER (content_area), checkBtDesktop);
		hildon_check_button_set_active (HILDON_CHECK_BUTTON (checkBtDesktop), self->priv->updOnDesktop);

		GtkWidget *intervalSelector = hildon_touch_selector_new_text ();
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (intervalSelector), "0");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (intervalSelector), "30 Seconds");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (intervalSelector), "1 Minute");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (intervalSelector), "5 Minutes");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (intervalSelector), "30 Minutes");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (intervalSelector), "1 Hour");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (intervalSelector), "6 Hours");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (intervalSelector), "12 Hours");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (intervalSelector), "Daily");

		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (intervalSelector), 0, self->priv->delayIndex);

		GtkWidget * intervalSelBt = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);
		hildon_button_set_title (HILDON_BUTTON (intervalSelBt), "Update Interval: ");
//		hildon_button_add_title_size_group (HILDON_BUTTON (intervalSelBt), group);
		hildon_button_set_alignment (HILDON_BUTTON (intervalSelBt), 0, 0.5, 0, 0);
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (intervalSelBt), HILDON_TOUCH_SELECTOR (intervalSelector));
		gtk_container_add (GTK_CONTAINER (content_area), intervalSelBt);

		GtkWidget *updIntervalLabel = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (updIntervalLabel), "<small>'0' disables periodic updating.</small>");
		gtk_misc_set_alignment (GTK_MISC (updIntervalLabel), 0, 0);
		gtk_container_add (GTK_CONTAINER (content_area), updIntervalLabel);

		GtkWidget *networkPolicySel = hildon_touch_selector_new_text ();
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (networkPolicySel), "Disabled (Doesn't Matter)");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (networkPolicySel), "When connected");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (networkPolicySel), "When disconnected");
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (networkPolicySel), 0, self->priv->updNeworkPolicy);

		GtkWidget * networkPolBt = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);
		hildon_button_set_title (HILDON_BUTTON (networkPolBt), "Network Presence: ");
//		hildon_button_add_title_size_group (HILDON_BUTTON (networkPolBt), group);
		hildon_button_set_alignment (HILDON_BUTTON (networkPolBt), 0, 0.5, 0, 0);
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (networkPolBt), HILDON_TOUCH_SELECTOR (networkPolicySel));
		gtk_container_add (GTK_CONTAINER (content_area), networkPolBt);

		GtkWidget *networkPolBtHelp = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (networkPolBtHelp), "<small>If enabled, the selected network event will trigger the command.</small>");
		gtk_misc_set_alignment (GTK_MISC (networkPolBtHelp), 0, 0);
		gtk_label_set_line_wrap (GTK_LABEL (networkPolBtHelp), TRUE);
		gtk_container_add (GTK_CONTAINER (content_area), networkPolBtHelp);

		gtk_widget_show_all (dialog);
		//END

		//BEGIN settings processing
		g_warning ("(%p) settingsRunning out= %d",self, settingsRunning);
		while ( settingsRunning ) {
			int setDialogReturn = 0;
			self->priv->currentDialog=dialog;
			setDialogReturn = gtk_dialog_run (GTK_DIALOG (dialog));
			g_warning ("(%p) setDialogReturn() = %d",self, setDialogReturn);
			if ( setDialogReturn == GTK_RESPONSE_ACCEPT || setDialogReturn == NON_GTK_RESPONSE_SAVE_AND_RUN || setDialogReturn == NON_GTK_RESPONSE_ADVANCED ) {
				g_warning ("(%p) setDialogReturn = %d", self, setDialogReturn);
				if (setDialogReturn == NON_GTK_RESPONSE_ADVANCED) {
					g_warning ("(%p) NON_GTK_RESPONSE_ADVANCED call PRO dialog",self);
					GtkWidget *goPro = hildon_note_new_confirmation (GTK_WINDOW(dialog), "WARNING! Settings need to be saved before proceeding with Advanced Functions.\n\nAre you really sure you want to go \"PRO\"?");
					gint retcode = gtk_dialog_run (GTK_DIALOG (goPro));
					gtk_widget_destroy (goPro);
					if (retcode != GTK_RESPONSE_OK) {
						g_warning ("(%p) NON_GTK_RESPONSE_ADVANCED got scared!!! Beat it! :)",self);
						continue;
					}
				}
				int cmdSel = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (selector), 0);
				g_warning ("(%p) GTK_RESPONSE_ACCEPT cmdSel = %d c_size = %d",self, cmdSel, self->priv->c_size);
				if(cmdSel < self->priv->c_size && cmdSel >= 0) {
					g_warning ("(%p) Fetching cmdSel in internal command list", self);
					g_free(self->priv->instanceTitle);self->priv->instanceTitle=NULL;
					self->priv->instanceTitle = strdup(self->priv->c_titles[cmdSel]);
					g_warning("(%p) self->priv->instanceTitle = %p [%s]", self, self->priv->instanceTitle, self->priv->instanceTitle);
					g_free(self->priv->instanceCmd);self->priv->instanceCmd=NULL;
					self->priv->instanceCmd = strdup(self->priv->c_commands[cmdSel]);
					g_warning("(%p) self->priv->instanceCmd = %p [%s]", self, self->priv->instanceCmd, self->priv->instanceCmd);
				}

				self->priv->widgetType = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (widgetType), 0);//AP2

				self->priv->operationalStatus = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (widgetOperationalStatus), 0);//AP2

				self->priv->hideCanvas = hildon_check_button_get_active (HILDON_CHECK_BUTTON (checkBtHideCanvas));
				self->priv->snippetBgRGB = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (snippetBgRGB), 0);//AP2

				g_warning("(%p) self->priv->beecon_lt0_ImgFilename = %p", self, self->priv->beecon_lt0_ImgFilename);
				//g_free(self->priv->beecon_lt0_ImgFilename);self->priv->beecon_lt0_ImgFilename = NULL;
				self->priv->beecon_lt0_ImgZoom = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (beecon_lt0_ImgZoom), 0);//AP2
				self->priv->beecon_lt0_ImgFilename = g_strdup(hildon_entry_get_text (HILDON_ENTRY (beecon_lt0_ImgEntry)));
				self->priv->beecon_lt0_BgRGB = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (beecon_lt0_BgRGB), 0);//AP2

				g_warning("(%p) self->priv->beecon_eq0_ImgFilename = %p", self, self->priv->beecon_eq0_ImgFilename);
				//g_free(self->priv->beecon_eq0_ImgFilename);self->priv->beecon_eq0_ImgFilename = NULL;
				self->priv->beecon_eq0_ImgZoom = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (beecon_eq0_ImgZoom), 0);//AP2
				self->priv->beecon_eq0_ImgFilename = g_strdup(hildon_entry_get_text (HILDON_ENTRY (beecon_eq0_ImgEntry)));
				self->priv->beecon_eq0_BgRGB = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (beecon_eq0_BgRGB), 0);//AP2

				g_warning("(%p) self->priv->beecon_eq1_ImgFilename = %p", self, self->priv->beecon_eq1_ImgFilename);
				//g_free(self->priv->beecon_eq1_ImgFilename);self->priv->beecon_eq1_ImgFilename = NULL;
				self->priv->beecon_eq1_ImgZoom = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (beecon_eq1_ImgZoom), 0);//AP2
				self->priv->beecon_eq1_ImgFilename = g_strdup(hildon_entry_get_text (HILDON_ENTRY (beecon_eq1_ImgEntry)));
				self->priv->beecon_eq1_BgRGB = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (beecon_eq1_BgRGB), 0);//AP2

				g_warning("(%p) self->priv->beecon_ge2_ImgFilename = %p", self, self->priv->beecon_ge2_ImgFilename);
				//g_free(self->priv->beecon_ge2_ImgFilename);self->priv->beecon_ge2_ImgFilename = NULL;
				self->priv->beecon_ge2_ImgZoom = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (beecon_ge2_ImgZoom), 0);//AP2
				self->priv->beecon_ge2_ImgFilename = g_strdup(hildon_entry_get_text (HILDON_ENTRY (beecon_ge2_ImgEntry)));
				self->priv->beecon_ge2_BgRGB = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (beecon_ge2_BgRGB), 0);//AP2

				g_warning("(%p) self->priv->beecon_idxge2_ImgFilename = %p", self, self->priv->beecon_idxge2_ImgFilename);
				//g_free(self->priv->beecon_idxge2_ImgFilename);self->priv->beecon_idxge2_ImgFilename = NULL;
				self->priv->beecon_idxge2_ImgZoom = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (beecon_idxge2_ImgZoom), 0);//AP2
				self->priv->beecon_idxge2_ImgFilename = g_strdup(hildon_entry_get_text (HILDON_ENTRY (beecon_idxge2_ImgEntry)));
				self->priv->beecon_idxge2_BgRGB = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (beecon_idxge2_BgRGB), 0);//AP2

				self->priv->widXOrigin = gtk_range_get_value(GTK_RANGE(widPositionX));
				self->priv->widYOrigin = gtk_range_get_value(GTK_RANGE(widPositionY));

				g_warning ("(%p) Window Position Previous x=%d y=%d Current x=%d y=%d ", self, widXOrigin, widYOrigin, self->priv->widXOrigin, self->priv->widYOrigin);
				if (self->priv->widXOrigin != widXOrigin || self->priv->widYOrigin != widYOrigin) {
					g_warning ("(%p) Fine Tuning Window Position x=%d y=%d", self, self->priv->widXOrigin, self->priv->widYOrigin);
					gtk_window_move (GTK_WINDOW (self), (int)(self->priv->widXOrigin), (int)(self->priv->widYOrigin));//AP
				}

				self->priv->widWidth = gtk_range_get_value(GTK_RANGE(widthSelect));
				self->priv->widHeight = gtk_range_get_value(GTK_RANGE(heightSelect));

				g_warning("(%p) self->priv->cmdImgFilename = %p", self, self->priv->cmdImgFilename);
				//g_free(self->priv->cmdImgFilename);self->priv->cmdImgFilename = NULL;
				self->priv->cmdImgFilename = g_strdup(hildon_entry_get_text (HILDON_ENTRY (titleImgEntry)));
				self->priv->cmdImgZoom = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (beecon_cmdImgZoom), 0);//AP2
				self->priv->cmdFgRGB = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (cmdFgRGB), 0);//AP2
				self->priv->cmdVisibilityPosition = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (cmdVisibilityPosition), 0);//AP2
				self->priv->cmdImgVisibilityPosition = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (cmdImgVisibilityPosition), 0);//AP2
				self->priv->cmdJustify = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (cmdJustify), 0);//AP2

				self->priv->cmdFontName = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (cmdFontFam), 0);//AP1
				self->priv->cmdFontSize = gtk_range_get_value(GTK_RANGE(cmdFontSz));//AP1

				g_warning("(%p) self->priv->resImgFilename = %p", self, self->priv->resImgFilename);
				self->priv->resImgFilename = g_strdup(hildon_entry_get_text (HILDON_ENTRY (resultsImgEntry)));
				self->priv->resImgZoom = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (beecon_resImgZoom), 0);//AP2
				self->priv->resFgRGB = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (resFgRGB), 0);//AP2
				self->priv->resVisibilityPosition = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (resVisibilityPosition), 0);//AP2
				self->priv->resImgVisibilityPosition = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (resImgVisibilityPosition), 0);//AP2
				self->priv->resJustify = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (resJustify), 0);//AP2

				self->priv->resFontName = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (resFontFam), 0);//AP1
				self->priv->resFontSize = gtk_range_get_value(GTK_RANGE(resFontSz));//AP1

				self->priv->updOnStartup = hildon_check_button_get_active (HILDON_CHECK_BUTTON (checkBtStartup));
				self->priv->updOnClick = hildon_check_button_get_active (HILDON_CHECK_BUTTON (checkBtClick));
				self->priv->updOnDesktop = hildon_check_button_get_active (HILDON_CHECK_BUTTON (checkBtDesktop));

				self->priv->delayIndex = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (intervalSelector), 0);
				self->priv->delaySeconds = GetSeconds(self->priv->delayIndex);

				self->priv->updNeworkPolicy = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (networkPolicySel), 0);

				if (self->priv->updateTimerID != 0) {
					g_source_remove (self->priv->updateTimerID);
					self->priv->updateTimerID = 0;
				}

				g_warning ("(%p) GTK_RESPONSE_ACCEPT write settings()",self);
				queen_beecon_write_settings (self, TRUE);

				if (setDialogReturn == NON_GTK_RESPONSE_ADVANCED) {
					g_warning ("(%p) NON_GTK_RESPONSE_ADVANCED gone PRO call PRO dialog",self);
					if (!queen_beecon_advanced_dialog(self, hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (selector), 0))) {
						g_warning ("(%p) NON_GTK_RESPONSE_ADVANCED nothing relevant happened ... just refresh command selector and nothing else to do",self);

						gint cmdSel = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (selector), 0);
						g_warning ("(%p) NON_GTK_RESPONSE_ADVANCED cmdSel = %d c_size = %d",self, cmdSel, self->priv->c_size);
						selector = hildon_touch_selector_new_text ();
						g_warning ("(%p) NON_GTK_RESPONSE_ADVANCED new selector %p", self, selector);
						for(i=0;i<self->priv->c_size;i++) {
							g_warning ("(%p) NON_GTK_RESPONSE_ADVANCED rebuilding selector c_titles[%d] = %s", self, i, self->priv->c_titles[i]);
							hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (selector), self->priv->c_titles[i]);
						}
						g_warning ("(%p) NON_GTK_RESPONSE_ADVANCED cmdSelector %p selector %p", self, cmdSelector, selector);
						hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (cmdSelector), HILDON_TOUCH_SELECTOR (selector));
						hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (selector), 0, cmdSel);
						hildon_picker_button_set_active (HILDON_PICKER_BUTTON (cmdSelector), cmdSel);
						continue;
					}
					g_warning ("(%p) NON_GTK_RESPONSE_ADVANCED something happened... let's queen_beecon_update_content_layout",self);
					queen_beecon_update_content_layout (self);
					g_warning ("(%p) NON_GTK_RESPONSE_ADVANCED reloadInstanceSettings=TRUE",self);
					reloadInstanceSettings=TRUE;
				}
				if (setDialogReturn == NON_GTK_RESPONSE_SAVE_AND_RUN) {
					g_warning ("(%p) NON_GTK_RESPONSE_SAVE_AND_RUN update content requested!",self);
					g_warning ("(%p) NON_GTK_RESPONSE_SAVE_AND_RUN self->priv->operationalStatus=%d",self, self->priv->operationalStatus);
					if (self->priv->operationalStatus==0) // Wake up and restore size and operations
						queen_beecon_update_content (self);
					else
						queen_beecon_update_content_layout (self);
				} else {
					g_warning ("(%p) GTK_RESPONSE_ACCEPT update content layout",self);
					g_warning ("(%p) GTK_RESPONSE_ACCEPT self->priv->operationalStatus=%d",self, self->priv->operationalStatus);
					queen_beecon_update_content_layout (self);
				}
				g_warning ("(%p) settingsRunning = 0",self);
				settingsRunning = FALSE;
			} else if(setDialogReturn == NON_GTK_RESPONSE_ADD_CMD || setDialogReturn == NON_GTK_RESPONSE_EDIT_CMD ) { // ADD/EDIT COMMAND
				gint cmdSel = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (selector), 0);
				g_warning ("(%p) NON_GTK_RESPONSE_xxxx_CMD cmdSel = %d c_size = %d",self, cmdSel, self->priv->c_size);

				gint prevRollCall = self->priv->c_size; // Let's count how many command we have before operation
				if( setDialogReturn == NON_GTK_RESPONSE_ADD_CMD ) { // New command input
					g_warning ("(%p) NON_GTK_RESPONSE_ADD_CMD call edit/add dialog",self);
					if (!queen_beecon_edit_add_dialog(self, TRUE, 0)) continue; // ADD/EDIT Dialog Cancelled ... just yield and loop again
				} else { // If current active selection then edit command
					g_warning ("(%p) NON_GTK_RESPONSE_EDIT_CMD call edit/add dialog command [%d]",self, cmdSel);
					if (!queen_beecon_edit_add_dialog(self, FALSE, cmdSel)) continue; // ADD/EDIT Dialog Cancelled ... just yield and loop again
				}
				g_warning ("(%p) NON_GTK_RESPONSE_xxxx_CMD write settings()",self);
				queen_beecon_write_settings (self, FALSE); // We write commands to config file

				selector = hildon_touch_selector_new_text ();
				g_warning ("(%p) NON_GTK_RESPONSE_xxxx_CMD new selector %p", self, selector);
				for(i=0;i<self->priv->c_size;i++) {
					g_warning ("(%p) NON_GTK_RESPONSE_xxxx_CMD rebuilding selector c_titles[%d] = %s", self, i, self->priv->c_titles[i]);
					hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (selector), self->priv->c_titles[i]);
				}
				if (self->priv->c_size < prevRollCall) {// TRUE if command has been deleted
					cmdSel = 0;
				} else if (self->priv->c_size > prevRollCall) {// TRUE if command has been added
					cmdSel = self->priv->c_size - 1;
				}
				g_warning ("(%p) NON_GTK_RESPONSE_xxxx_CMD cmdSelector %p selector %p", self, cmdSelector, selector);
				hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (cmdSelector), HILDON_TOUCH_SELECTOR (selector));
				hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (selector), 0, cmdSel);
			    hildon_picker_button_set_active (HILDON_PICKER_BUTTON (cmdSelector), cmdSel);
				//END ADD/EDIT COMMAND
			} else
				settingsRunning = FALSE;
		}
		gtk_widget_destroy (dialog);
	}
	//END
	gtk_widget_queue_draw (GTK_WIDGET (self));//AP3
}

gboolean queen_beecon_edit_add_dialog ( QueenBeecon *self, gboolean new, gint curr)
{
g_warning ("(%p) queen_beecon_edit_add_dialog new=%d curr=%d", self, new, curr);
	GtkWidget *dialog = NULL;
	gchar *title = NULL;
	gboolean needWrite = TRUE;

	if ( new ) // ADD Title
		title = g_strconcat ("Add new command", NULL);
	else // EDIT Title
		if (curr>=0) {
			title = g_strconcat ("Edit ", self->priv->c_titles[curr] ," command", NULL);
		} else {
			title = g_strconcat ("Edit ", self->priv->instanceTitle ," instance command", NULL);
		}
	if ( new ) // ADD
		dialog = gtk_dialog_new_with_buttons (title, NULL, 0, _("wdgt_bd_save"), GTK_RESPONSE_ACCEPT, NULL);
	else // EDIT
		dialog = gtk_dialog_new_with_buttons (title, NULL, 0, _("wdgt_bd_save"), GTK_RESPONSE_ACCEPT, _("wdgt_bd_delete"), NON_GTK_RESPONSE_DELETE_CMD, NULL);

	GtkWidget *content_area = gtk_dialog_get_content_area (GTK_DIALOG (dialog));
	GtkSizeGroup *group = GTK_SIZE_GROUP (gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL));

	//BEGIN title
	GtkWidget *titleBox = gtk_hbox_new (FALSE, 0);

	GtkWidget *titleLabel = gtk_label_new ("Title:");
	gtk_misc_set_alignment (GTK_MISC (titleLabel), 0, 0.5);
	gtk_misc_set_padding (GTK_MISC (titleLabel), HILDON_MARGIN_DOUBLE, 0);
	gtk_size_group_add_widget (group, titleLabel);

	GtkWidget *titleEntry = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
	gtk_box_pack_start (GTK_BOX (titleBox), titleLabel, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (titleBox), titleEntry, TRUE, TRUE, 0);

	gtk_container_add (GTK_CONTAINER (content_area), titleBox);

	//BEGIN command
	GtkWidget *commandBox = gtk_hbox_new (FALSE, 0);

	GtkWidget *commandLabel = gtk_label_new ("Command:");
	gtk_misc_set_alignment (GTK_MISC (commandLabel), 0, 0.5);
	gtk_misc_set_padding (GTK_MISC (commandLabel), HILDON_MARGIN_DOUBLE, 0);
	gtk_size_group_add_widget (group, commandLabel);

	GtkWidget *commandEntry = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
	gtk_box_pack_start (GTK_BOX (commandBox), commandLabel, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (commandBox), commandEntry, TRUE, TRUE, 0);

	gtk_container_add (GTK_CONTAINER (content_area), commandBox);
	//END BUILD DIALOG

	if(!new) {// EDIT
		if (curr>=0) { // Edit List command
			hildon_entry_set_text(HILDON_ENTRY (titleEntry), self->priv->c_titles[curr]);
			hildon_entry_set_text(HILDON_ENTRY (commandEntry), self->priv->c_commands[curr]);
		} else { // Edit Instance command
			hildon_entry_set_text(HILDON_ENTRY (titleEntry), self->priv->instanceTitle);
			hildon_entry_set_text(HILDON_ENTRY (commandEntry), self->priv->instanceCmd);
		}
	}

	//END

	gtk_widget_show_all (dialog);
	int dialogRunResponse = gtk_dialog_run (GTK_DIALOG (dialog));

	switch(dialogRunResponse) {
		case GTK_RESPONSE_ACCEPT:
			if(g_strcmp0((gchar *)"",hildon_entry_get_text (HILDON_ENTRY (titleEntry))) == 0)
				hildon_entry_set_text(HILDON_ENTRY (titleEntry), "[No Title]");
			if ( new ) // ADD
				AddCommand(self, g_strdup(hildon_entry_get_text (HILDON_ENTRY (titleEntry))), g_strdup(hildon_entry_get_text (HILDON_ENTRY (commandEntry))), TRUE);
			else // EDIT
				EditCommand(self, g_strdup(hildon_entry_get_text (HILDON_ENTRY (titleEntry))), g_strdup(hildon_entry_get_text (HILDON_ENTRY (commandEntry))), TRUE, curr);
			break;
		case NON_GTK_RESPONSE_DELETE_CMD:
			if (curr>=0)
				DelCommand(self, curr); // DELETE command in list
			else // Unable to delete instance only command (not in command list)
				{GtkWidget *info = hildon_note_new_information (NULL, "Warning! Unable to delete Instance-Only commands.");gtk_dialog_run (GTK_DIALOG (info));gtk_object_destroy (GTK_OBJECT (info));}
			break;
		default:
			needWrite = FALSE;
	}
	gtk_widget_destroy (dialog);
	g_free(title);
	return ( needWrite );
}

void on_command_picker_value_changed(HildonPickerButton * button, QueenBeecon *self)
{
	int cmdSel = hildon_picker_button_get_active (HILDON_PICKER_BUTTON (button));
	gchar *c = g_strdup(self->priv->c_commands[cmdSel]);
	gtk_text_buffer_set_text(self->priv->cmdTestDriveBuffer,c,-1);
	g_free(c);

}

void testDriveBt_clicked_cb(HildonButton * button, QueenBeecon *self)
{
	int cmdSel;
	FILE *fp = NULL;
	gchar line[4096]="";//AP Big Big command output buffer//AP
	size_t l;//AP
	GtkTextIter start, end;
	gtk_text_buffer_get_bounds (self->priv->cmdTestDriveBuffer, &start, &end);
	gchar *c = g_strdup(gtk_text_buffer_get_text (self->priv->cmdTestDriveBuffer,&start, &end, FALSE));
	if (c[0] == '\0') {
		cmdSel = hildon_picker_button_get_active (HILDON_PICKER_BUTTON (self->priv->commandPicker));
		g_free(c);
		c = g_strdup(self->priv->c_commands[cmdSel]);
		gtk_text_buffer_set_text(self->priv->cmdTestDriveBuffer,c,-1);
	}
	g_warning("(%p) TEST DRIVE CMD %s", self, c);
	fp = popen (c, "r");
	g_warning("(%p) ========> popen(%s) returned %p", self, c, fp);

	if ((l=fread (line, 1, sizeof line, fp))!=0) //to this "buffer-based" for multiline handling in widget //AP
		line[l-1]='\000';//AP
	gint exitCode=pclose(fp);
	g_warning("(%p) ppclose(fp) returned 0x%08X", self, exitCode);

	exitCode = (exitCode >> 8) & 0xff;
	gchar buff[4096]="";//AP output buffer//AP
	g_sprintf(buff,"[Exit Code = %d]\n%s", (char)exitCode, line);//If command has output we issue a newline after Exit Code
	gtk_text_buffer_set_text(self->priv->cmdOutputBuffer,buff,-1);
	g_free(c);
}

void copyCommandBt_clicked_cb ( HildonButton * button, QueenBeecon *self )
{
	g_warning("(%p) copyCommandBt_clicked_cb", self);

	GtkClipboard *clipboard = NULL;
	GtkTextIter start, end;
	gtk_text_buffer_get_bounds (self->priv->cmdTestDriveBuffer, &start, &end);
	gtk_text_buffer_select_range (self->priv->cmdTestDriveBuffer, &start, &end);
	/* do copy */
	clipboard = gtk_clipboard_get (GDK_SELECTION_CLIPBOARD);
	gtk_text_buffer_copy_clipboard (GTK_TEXT_BUFFER(self->priv->cmdTestDriveBuffer), clipboard);
}

void pasteCommandBt_clicked_cb ( HildonButton * button, QueenBeecon *self )
{
	g_warning("(%p) pasteCommandBt_clicked_cb", self);

	GtkClipboard *clipboard = NULL;
	GtkTextIter start, end;
	gtk_text_buffer_get_bounds (self->priv->cmdTestDriveBuffer, &start, &end);
	gtk_text_buffer_select_range (self->priv->cmdTestDriveBuffer, &start, &end);
	  /* do paste */
	clipboard = gtk_clipboard_get (GDK_SELECTION_CLIPBOARD);
	gtk_text_buffer_paste_clipboard (GTK_TEXT_BUFFER (self->priv->cmdTestDriveBuffer), clipboard, NULL, TRUE);
}

void updateCommandBt_clicked_cb ( HildonButton * button, QueenBeecon *self )
{
	g_warning("(%p) updateCommandBt_clicked_cb", self);

	int cmdSel;
	GtkWidget *confirmDlg;
	gchar *confirmMsg;
	gint retcode;
	GtkTextIter start, end;

	gtk_text_buffer_get_bounds (self->priv->cmdTestDriveBuffer, &start, &end);
	gchar *c = g_strdup(gtk_text_buffer_get_text (self->priv->cmdTestDriveBuffer,&start, &end, FALSE));
	g_warning("(%p) Current Test Drive Command Buffer [%s]", self, c);
	if ( !c || c[0]=='\0' ) {
		GtkWidget *info = hildon_note_new_information (NULL, "WARNING! Test Drive Buffer empty or not valid.\nUnable to update selected command.");
		gtk_dialog_run (GTK_DIALOG (info));gtk_object_destroy (GTK_OBJECT (info));
		g_warning("(%p) Warning! Test Drive buffer empty or not valid. Unable to update selected command.", self);
		g_free(c);
		return;
	}

	cmdSel = hildon_picker_button_get_active (HILDON_PICKER_BUTTON (self->priv->commandPicker));
	if (cmdSel>=0) { //Update command in list
		confirmMsg = g_strdup_printf("Warning! You are about to update currently selected command with Test Drive buffer.\n\ntitle=[%s]\ncommand=[%s]\n\n\nAre you Sure?", self->priv->c_titles[cmdSel], self->priv->c_commands[cmdSel]);
		confirmDlg = hildon_note_new_confirmation (GTK_WINDOW(NULL), confirmMsg);
		retcode = gtk_dialog_run (GTK_DIALOG (confirmDlg));
		gtk_widget_destroy (confirmDlg);
		g_free(confirmMsg);
	} else { //Update command in instance
		confirmMsg = g_strdup_printf("WARNING! You are about to Update current Instance Command with Test Drive buffer.\n\nAre you Sure?");
		confirmDlg = hildon_note_new_confirmation (GTK_WINDOW(NULL), confirmMsg);
		retcode = gtk_dialog_run (GTK_DIALOG (confirmDlg));
		gtk_widget_destroy (confirmDlg);
		g_free(confirmMsg);
	}
	if (retcode != GTK_RESPONSE_OK) {
		g_warning ("(%p) Didn't like to confirm ... got scared!!! Beat it! :)",self);
		return;
	}

	if (cmdSel>=0) { //Update command in list
		g_warning("(%p) Current Title Command to update [%s]", self, self->priv->c_titles[cmdSel]);
		EditCommand(self, g_strdup(self->priv->c_titles[cmdSel]), g_strdup(c), FALSE, cmdSel);
	} else { //Update command in instance
		g_warning("(%p) Current Title Instance Command to update [%s]", self, self->priv->instanceTitle);
		EditCommand(self, g_strdup(self->priv->instanceTitle), g_strdup(c), TRUE, cmdSel);
	}
	GtkWidget *info = hildon_note_new_information (NULL, "Command successfully updated.");gtk_dialog_run (GTK_DIALOG (info));gtk_object_destroy (GTK_OBJECT (info));
	g_free(c);
}

void importCommandBt_clicked_cb ( HildonButton * button, QueenBeecon *self )
{
	g_warning("(%p) importCommandBt_clicked_cb", self);

	GtkTextIter start, end;
	gboolean fileExists = FALSE;
	GKeyFile *keyFile = NULL;
	GtkWidget *confirmDlg;
	gint retcode;

	gtk_text_buffer_get_iter_at_line(self->priv->importExportBuffer, &start, 4);
	gtk_text_buffer_get_end_iter(self->priv->importExportBuffer, &end);
	gchar *c = g_strdup(gtk_text_buffer_get_text (self->priv->importExportBuffer,&start, &end, FALSE));
	if (!c || c[0]=='\0') {
		g_warning("(%p) error with c=%p", self, c);
		GtkWidget *info = hildon_note_new_information (NULL, "WARNING! Import Buffer is empty!\nPlease paste relevant Command Export Data first.");gtk_dialog_run (GTK_DIALOG (info));gtk_object_destroy (GTK_OBJECT (info));
		g_free(c);
		return;
	}
	gchar *confirmMsg = g_strdup_printf("WARNING! You are about to import the Command Data currently in Import Buffer.\n\nAre you Sure?");
	confirmDlg = hildon_note_new_confirmation (GTK_WINDOW(NULL), confirmMsg);
	retcode = gtk_dialog_run (GTK_DIALOG (confirmDlg));
	gtk_widget_destroy (confirmDlg);
	g_free(confirmMsg);
	if (retcode != GTK_RESPONSE_OK) {
		g_warning ("(%p) Didn't like to confirm ... got scared!!! Beat it! :)",self);
		g_free(c);
		return;
	}
	g_warning("(%p) c=%s", self, c);

	guint calcChksum = checksum(c);//very trivial :)
	g_warning("(%p) import command data checksum=%d", self, calcChksum);
	g_free(c);
	keyFile = g_key_file_new();
	g_warning("(%p) keyfile %p", self, keyFile);

	gtk_text_buffer_get_iter_at_line(self->priv->importExportBuffer, &start, 0);
	c = g_strdup(gtk_text_buffer_get_text (self->priv->importExportBuffer,&start, &end, FALSE));

	fileExists = g_key_file_load_from_data (keyFile, c, strlen(c), G_KEY_FILE_KEEP_COMMENTS, NULL);
	if (!fileExists) {
		g_warning("(%p) Import from ADB command buffer error g_key_file_load_from_data()", self);
		g_key_file_free (keyFile);
		g_free(c);
		return;
	}

	g_warning("(%p) Export/Import buffer ready for KeyFile operations", self);
	// Get all the elements
	gdouble exportVersion = g_key_file_get_double (keyFile, "queen-beecon-header", "version", NULL);
	g_warning("(%p) exportVersion=%f", self, exportVersion);
	if (exportVersion!=QUEEN_BEECON_SETTINGS_VERSION) {
		GtkWidget *info = hildon_note_new_information (NULL, "WARNING! WRONG Version for Import Data!");gtk_dialog_run (GTK_DIALOG (info));gtk_object_destroy (GTK_OBJECT (info));
		g_warning("(%p) WRONG Version!!! Handle new version in next release possibly", self);
		g_key_file_free (keyFile);
		g_free(c);
		return;
	}

	guint stampChksum = g_key_file_get_integer (keyFile, "queen-beecon-header", "checksum", NULL);
	g_warning("(%p) stampChksum=%d", self, stampChksum);
	g_free(c);

	if (stampChksum==calcChksum||stampChksum==911) {
		g_warning("(%p) CHECKSUM is GOOD!!! ready to read and import command data!", self);
		gchar *title = g_key_file_get_string (keyFile, "queen-beecon-exported-command", "title", NULL);
		gchar *command = g_key_file_get_string (keyFile, "queen-beecon-exported-command", "command", NULL);
		g_key_file_free (keyFile);

		g_warning("(%p) About to call AddCommand title=[%s] command=[%s]", self, title, command);
		AddCommand(self, g_strdup(title), g_strdup(command), FALSE);

		queen_beecon_write_settings (self, FALSE); // We write commands to config file

		g_warning("(%p) Rebuilding command selector adding new command", self);
		GtkWidget *commandPickerSelector = hildon_touch_selector_new_text ();
		gint i;
		for(i=0;i<self->priv->c_size;i++)
		{
			g_warning("(%p) Append Command [%d] [%s]", self, i, self->priv->c_titles[i]);
			hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (commandPickerSelector), self->priv->c_titles[i]);
		}
		g_warning("(%p) Rebuilding command to selector [%p] set active %d", self, commandPickerSelector, self->priv->c_size-1);
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (commandPickerSelector), 0, self->priv->c_size-1);
	    g_warning("(%p) Rebuilding command selector set selector [%p] to picker [%p]", self, commandPickerSelector, self->priv->commandPicker);
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->commandPicker), HILDON_TOUCH_SELECTOR (commandPickerSelector));
		g_warning("(%p) Rebuilding command to picker [%p] set active %d", self, self->priv->commandPicker, self->priv->c_size-1);
		hildon_picker_button_set_active (HILDON_PICKER_BUTTON (self->priv->commandPicker), self->priv->c_size-1);

		c = g_strdup(self->priv->c_commands[self->priv->c_size-1]);
		g_warning("(%p) Filling command Test Drive Buffer [%p] with new command [%s]", self, self->priv->cmdTestDriveBuffer, c);
		gtk_text_buffer_set_text(self->priv->cmdTestDriveBuffer,c,-1);
		g_free(c);
		g_warning("(%p) Command successfully added to Command List and to Test Drive command input.", self);
		GtkWidget *info = hildon_note_new_information (NULL, "SUCCESS! Command added to Command List and to Test Drive command input.");gtk_dialog_run (GTK_DIALOG (info));gtk_object_destroy (GTK_OBJECT (info));
	} else {
		GtkWidget *info = hildon_note_new_information (NULL, "WARNING! Bad Checksum!\nPossibly corrupt Import Command Data!");gtk_dialog_run (GTK_DIALOG (info));gtk_object_destroy (GTK_OBJECT (info));
		g_warning("(%p) Bad Checksum, possibly corrupt import command data!", self);
	}
}

void exportCommandBt_clicked_cb ( HildonButton * button, QueenBeecon *self )
{
	g_warning("(%p) exportCommandBt_clicked_cb", self);
	int cmdSel;
	GtkTextIter start, end;

	gtk_text_buffer_get_bounds (self->priv->cmdTestDriveBuffer, &start, &end);
	gchar *c = g_strdup(gtk_text_buffer_get_text (self->priv->cmdTestDriveBuffer,&start, &end, FALSE));
	g_warning("(%p) cmdTestDriveBuffer %s", self, c);
	if (!c || c[0]=='\0') {
		g_warning("(%p) error with c=%p", self, c);
		GtkWidget *info = hildon_note_new_information (NULL, "WARNING! Command Buffer is empty!\nPlease select from List or type New Command first.");gtk_dialog_run (GTK_DIALOG (info));gtk_object_destroy (GTK_OBJECT (info));
		g_free(c);
		return;
	}
	cmdSel = hildon_picker_button_get_active (HILDON_PICKER_BUTTON (self->priv->commandPicker));
	g_warning("(%p) cmdSel %d", self, cmdSel);
	gchar *exportData = g_strdup_printf("title=%s\ncommand=%s", self->priv->c_titles[cmdSel], c);
	g_warning("(%p) exportData (checksum here applies = %d", self, checksum(exportData));
	gchar* headerVersion = g_strdup_printf("[queen-beecon-header]\nversion=%f\nchecksum=%d\n[queen-beecon-exported-command]\n%s", QUEEN_BEECON_SETTINGS_VERSION, checksum(exportData),exportData);//very trivial :)
	g_warning("(%p) headerVersion %s", self, headerVersion);
	gtk_text_buffer_set_text (self->priv->importExportBuffer, headerVersion, -1);
	g_free(c);
	g_free(exportData);
	g_free(headerVersion);

}

void pasteFromClipboardADBExportImportBt_clicked_cb ( HildonButton * button, QueenBeecon *self )
{
	g_warning("(%p) pasteFromClipboardADBExportImportBt_clicked_cb", self);

	GtkClipboard *clipboard = NULL;
	GtkTextIter start, end;
	gtk_text_buffer_get_bounds (self->priv->importExportBuffer, &start, &end);
	gtk_text_buffer_select_range (self->priv->importExportBuffer, &start, &end);
	/* do paste */
	clipboard = gtk_clipboard_get (GDK_SELECTION_CLIPBOARD);
	gtk_text_buffer_paste_clipboard (GTK_TEXT_BUFFER (self->priv->importExportBuffer), clipboard, NULL, TRUE);
}

void copyToClipboardADBExportImportBt_clicked_cb ( HildonButton * button, QueenBeecon *self )
{
	g_warning("(%p) copyToClipboardADBExportImportBt_clicked_cb", self);

	GtkClipboard *clipboard = NULL;
	GtkTextIter start, end;
	gtk_text_buffer_get_bounds (self->priv->importExportBuffer, &start, &end);
	gtk_text_buffer_select_range (self->priv->importExportBuffer, &start, &end);
	/* do copy */
	clipboard = gtk_clipboard_get (GDK_SELECTION_CLIPBOARD);
	gtk_text_buffer_copy_clipboard (GTK_TEXT_BUFFER(self->priv->importExportBuffer), clipboard);
}

void importInstanceBt_clicked_cb ( HildonButton * button, QueenBeecon *self )
{
	g_warning("(%p) importInstanceBt_clicked_cb", self);
	GtkTextIter start, end;
	gchar *confirmMsg;
	GtkWidget *confirmDlg;
	gint retcode;
	gboolean fileExists;
	GKeyFile *keyFile = NULL;

	gtk_text_buffer_get_iter_at_line(self->priv->importExportBuffer, &start, 4);
	gtk_text_buffer_get_end_iter(self->priv->importExportBuffer, &end);
	gchar *c = g_strdup(gtk_text_buffer_get_text (self->priv->importExportBuffer,&start, &end, FALSE));
	if (!c || c[0]=='\0') {
		g_warning("(%p) error with c=%p", self, c);
		GtkWidget *info = hildon_note_new_information (NULL, "WARNING! Import Buffer is empty!\nPlease paste relevant Instance Export Data first.");gtk_dialog_run (GTK_DIALOG (info));gtk_object_destroy (GTK_OBJECT (info));
		g_free(c);
		return;
	}
	confirmMsg = g_strdup_printf("WARNING! You are about to Import the Instance Data currently in Import Buffer.\n\nAre you Sure?");
	confirmDlg = hildon_note_new_confirmation (GTK_WINDOW(NULL), confirmMsg);
	retcode = gtk_dialog_run (GTK_DIALOG (confirmDlg));
	gtk_widget_destroy (confirmDlg);
	g_free(confirmMsg);
	if (retcode != GTK_RESPONSE_OK) {
		g_warning ("(%p) Didn't like to confirm ... got scared!!! Beat it! :)",self);
		g_free(c);
		return;
	}

	g_warning("(%p) c=%s", self, c);

	guint calcChksum = checksum(c);//very trivial :)
	g_warning("(%p) import instance data checksum=%d", self, calcChksum);
	g_free(c);

	keyFile = g_key_file_new();
	g_warning("(%p) keyfile %p", self, keyFile);

	gtk_text_buffer_get_iter_at_line(self->priv->importExportBuffer, &start, 0);
	c = g_strdup(gtk_text_buffer_get_text (self->priv->importExportBuffer,&start, &end, FALSE));

	fileExists = g_key_file_load_from_data (keyFile, c, strlen(c), G_KEY_FILE_KEEP_COMMENTS, NULL);
	if (!fileExists) {
		g_warning("(%p) Import from ADB instance buffer error g_key_file_load_from_data()", self);
		g_key_file_free (keyFile);
		g_free(c);
		return;
	}

	g_warning("(%p) Export/Import buffer ready for KeyFile operations", self);
	// Get all the elements
	gdouble exportVersion = g_key_file_get_double (keyFile, "queen-beecon-header", "version", NULL);
	g_warning("(%p) exportVersion=%f", self, exportVersion);
	if (exportVersion!=QUEEN_BEECON_SETTINGS_VERSION) {
		g_warning("(%p) WRONG Version!!!", self);
		g_key_file_free (keyFile);
		g_free(c);
		return;
	}

	guint stampChksum = g_key_file_get_integer (keyFile, "queen-beecon-header", "checksum", NULL);
	g_warning("(%p) stampChksum=%d", self, stampChksum);

	if (stampChksum==calcChksum||stampChksum==911) {
		g_warning("(%p) CHECKSUM is GOOD!!! ready to read and import instance data!", self);
		queen_beecon_read_settings ( self, TRUE, TRUE, c);

		g_warning("(%p) AddCommand title=[%s] command=[%s]", self, self->priv->instanceTitle, self->priv->instanceCmd);
		AddCommand(self, g_strdup(self->priv->instanceTitle), g_strdup(self->priv->instanceCmd), TRUE);

		queen_beecon_write_settings (self, FALSE); // We write current added command to config file

		g_warning("(%p) Rebuilding command selector adding new command", self);
		GtkWidget *commandPickerSelector = hildon_touch_selector_new_text ();
		gint i;
		for(i=0;i<self->priv->c_size;i++)
		{
			g_warning("(%p) Append Command [%d] [%s]", self, i, self->priv->c_titles[i]);
			hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (commandPickerSelector), self->priv->c_titles[i]);
		}
		g_warning("(%p) Rebuilding command to selector [%p] set active %d", self, commandPickerSelector, self->priv->c_size-1);
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (commandPickerSelector), 0, self->priv->c_size-1);

	    g_warning("(%p) Rebuilding command selector set selector [%p] to picker [%p]", self, commandPickerSelector, self->priv->commandPicker);
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->commandPicker), HILDON_TOUCH_SELECTOR (commandPickerSelector));

		g_warning("(%p) Rebuilding command to picker [%p] set active %d", self, self->priv->commandPicker, self->priv->c_size-1);
		hildon_picker_button_set_active (HILDON_PICKER_BUTTON (self->priv->commandPicker), self->priv->c_size-1);
		GtkWidget *info = hildon_note_new_information (NULL, "SUCCESS! Instance imported into current Beecon/Snippet!\nCommand added to command list.");gtk_dialog_run (GTK_DIALOG (info));gtk_object_destroy (GTK_OBJECT (info));
		self->priv->instanceImportOK=TRUE;
		g_warning("(%p) Instance Settings loaded successfully", self);
	} else {
		GtkWidget *info = hildon_note_new_information (NULL, "WARNING! Bad Checksum!\nPossibly corrupt Import Instance Data!");gtk_dialog_run (GTK_DIALOG (info));gtk_object_destroy (GTK_OBJECT (info));
		g_warning("(%p) Bad Checksum, possibly corrupt import data!", self);
	}

	g_free(c);
	g_key_file_free (keyFile);

}

void exportInstanceBt_clicked_cb ( HildonButton * button, QueenBeecon *self )
{
	g_warning("(%p) exportInstanceBt_clicked_cb", self);
	gchar *filename = NULL;
	gboolean fileExists;
	GKeyFile *keyFile = NULL;
	GError *error=NULL;
	gchar **instance_keys = NULL;
	gsize element_count;
	GtkTextIter start,end;
	int i;

	if(self->priv->widgetID == NULL) {
		g_warning("(%p) Widget instance not initialized, not reading settings..", self);
		return;
	}

	keyFile = g_key_file_new();
	g_warning("(%p) keyfile %p", self, keyFile);
	filename = g_strconcat (HOME_DIR, QUEEN_BEECON_SETTINGS_FILE, NULL);
	g_warning("(%p) filename %s", self, filename);
	fileExists = g_key_file_load_from_file (keyFile, filename, G_KEY_FILE_KEEP_COMMENTS, NULL);
	g_warning("(%p) fileExists %d", self, fileExists);

	gdouble settingsVer = g_key_file_get_double (keyFile, "config", "version", NULL);
	g_warning("(%p) settingsVer %f", self, settingsVer);

	/* Get all the elements */
	instance_keys = g_key_file_get_keys (keyFile, self->priv->widgetID, &element_count, NULL);
	g_warning("(%p) instance_keys %p", self, instance_keys);
	if (instance_keys != NULL && element_count != 0) {
		gtk_text_buffer_set_text (self->priv->importExportBuffer, "", -1);
		gtk_text_buffer_get_iter_at_line(self->priv->importExportBuffer, &end, 0);
		for (i = 0; i < element_count; i++) {
			gchar *keyVal = g_strdup_printf("%s=%s\n", instance_keys [i], g_key_file_get_value(keyFile, self->priv->widgetID, instance_keys [i], &error));
			g_warning("(%p) keyVal %s", self, keyVal);
			gtk_text_buffer_insert (self->priv->importExportBuffer, &end, keyVal, -1);
			g_free(keyVal);
		}
		//Let's eval buffer checksum
		gtk_text_buffer_get_bounds (self->priv->importExportBuffer, &start, &end);
		gchar *c = g_strdup(gtk_text_buffer_get_text (self->priv->importExportBuffer,&start, &end, FALSE));
		gchar *headerVersion = g_strdup_printf("[queen-beecon-header]\nversion=%f\nchecksum=%d\n[queen-beecon-exported-instance]\n", settingsVer, checksum(c));//very trivial :)
		g_free(c);
		g_warning("(%p) headerVersion %s", self, headerVersion);
		gtk_text_buffer_get_iter_at_line(self->priv->importExportBuffer, &end, 0);
		gtk_text_buffer_insert (self->priv->importExportBuffer, &end, headerVersion, -1);
		g_free(headerVersion);
	}
	g_key_file_free (keyFile);
	g_free (filename);

	g_warning("(%p) Instance Settings exported", self);
}

gboolean queen_beecon_advanced_dialog ( QueenBeecon *self, gint cmdSel )
{
g_warning ("(%p) queen_beecon_advanced_dialog", self);
	gboolean reReadSettings = FALSE;
	gboolean timeToGoBack = FALSE;
	gchar *title = NULL;

	title = g_strconcat ("Advanced Settings and Tools (... Hic Sunt Leones!)", NULL);
	GtkWidget *dialog = gtk_dialog_new_with_buttons (title, NULL, 0, NULL);

	g_warning("(%p) Building advanced settings dialog %p", self, dialog);
	GtkWidget *settingsArea = gtk_dialog_get_content_area (GTK_DIALOG (dialog));
	GtkWidget *scroll = hildon_pannable_area_new ();
	g_object_set (scroll, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	gtk_container_add (GTK_CONTAINER (settingsArea), scroll);
	gtk_window_set_default_size (GTK_WINDOW (dialog), -1, 380);

	GtkWidget *content_area = gtk_vbox_new (FALSE, 0);
	hildon_pannable_area_add_with_viewport (HILDON_PANNABLE_AREA (scroll), content_area);

	GtkWidget *cmdSelectionLabel = gtk_label_new ("Command Test Drive:");
	gtk_box_pack_start (GTK_BOX (content_area), cmdSelectionLabel, FALSE, FALSE, 0);

    GtkWidget *cmdTestDriveLabelHelp = gtk_label_new ("");
	gtk_label_set_markup (GTK_LABEL (cmdTestDriveLabelHelp), "<span font_desc=\"Nokia Sans 13\">Type command you would like to execute and press <u>TestDrive</u> to see RAW Output in box below.</span>");//AP1
	gtk_box_pack_start (GTK_BOX (content_area), cmdTestDriveLabelHelp, TRUE, TRUE, 0);

	//BEGIN Command Selector

	GtkWidget *testDriveBox = gtk_hbox_new (FALSE, 0);

	GtkWidget *commandPickerSelector = hildon_touch_selector_new_text ();
	gint i;
	for(i=0;i<self->priv->c_size;i++)
	{
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (commandPickerSelector), self->priv->c_titles[i]);
	}
	self->priv->commandPicker = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
	hildon_button_set_title (HILDON_BUTTON (self->priv->commandPicker), "Commands: ");
	hildon_button_set_alignment (HILDON_BUTTON (self->priv->commandPicker), 0, 0.5, 0, 0);
	hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->commandPicker), HILDON_TOUCH_SELECTOR (commandPickerSelector));
	hildon_picker_button_set_active (HILDON_PICKER_BUTTON (self->priv->commandPicker), cmdSel);
	gtk_box_pack_start (GTK_BOX (testDriveBox), self->priv->commandPicker, TRUE, TRUE, 0);

	GtkWidget *testDriveBt = hildon_button_new_with_text (HILDON_SIZE_FINGER_HEIGHT |
                                          HILDON_SIZE_AUTO_WIDTH, HILDON_BUTTON_ARRANGEMENT_VERTICAL,
										  "TestDrive",
                                          NULL);
	hildon_button_set_value (HILDON_BUTTON (testDriveBt), "Command");
	hildon_button_set_alignment (HILDON_BUTTON (testDriveBt), 0, 0.5, 0, 0);//AP1
	g_signal_connect (testDriveBt, "clicked", G_CALLBACK (testDriveBt_clicked_cb), self);
    gtk_box_pack_start (GTK_BOX (testDriveBox), testDriveBt, FALSE, FALSE, 0);


	GtkWidget *updateCmdBt = hildon_button_new_with_text (HILDON_SIZE_FINGER_HEIGHT |
                                          HILDON_SIZE_AUTO_WIDTH, HILDON_BUTTON_ARRANGEMENT_VERTICAL,
										  "Update",
                                          NULL);
	hildon_button_set_alignment (HILDON_BUTTON (updateCmdBt), 0, 0.5, 0, 0);//AP1
	hildon_button_set_value (HILDON_BUTTON (updateCmdBt), "Command");
	g_signal_connect (updateCmdBt, "clicked", G_CALLBACK (updateCommandBt_clicked_cb), self);
    gtk_box_pack_start (GTK_BOX (testDriveBox), updateCmdBt, FALSE, FALSE, 0);

	GtkWidget *copyCmdBt = hildon_button_new_with_text (HILDON_SIZE_FINGER_HEIGHT |
                                          HILDON_SIZE_AUTO_WIDTH, HILDON_BUTTON_ARRANGEMENT_VERTICAL,
										  "Copy",
                                          NULL);
	hildon_button_set_alignment (HILDON_BUTTON (copyCmdBt), 0, 0.5, 0, 0);//AP1
	hildon_button_set_value (HILDON_BUTTON (copyCmdBt), "Command");
	g_signal_connect (copyCmdBt, "clicked", G_CALLBACK (copyCommandBt_clicked_cb), self);
    gtk_box_pack_start (GTK_BOX (testDriveBox), copyCmdBt, FALSE, FALSE, 0);

    GtkWidget *pasteCmdBt = hildon_button_new_with_text (HILDON_SIZE_FINGER_HEIGHT |
                                          HILDON_SIZE_AUTO_WIDTH, HILDON_BUTTON_ARRANGEMENT_VERTICAL,
										  "Paste",
                                          NULL);
	hildon_button_set_alignment (HILDON_BUTTON (pasteCmdBt), 0, 0.5, 0, 0);//AP1
	hildon_button_set_value (HILDON_BUTTON (pasteCmdBt), "Command");
	g_signal_connect (pasteCmdBt, "clicked", G_CALLBACK (pasteCommandBt_clicked_cb), self);
    gtk_box_pack_start (GTK_BOX (testDriveBox), pasteCmdBt, FALSE, FALSE, 0);

    gtk_box_pack_start (GTK_BOX (content_area), testDriveBox, TRUE, TRUE, 0);

	GtkWidget *cmdTestDrive = hildon_text_view_new ();
	gtk_widget_set_size_request (GTK_WIDGET (cmdTestDrive), -1, 150);//AP
	gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (cmdTestDrive), GTK_WRAP_WORD_CHAR);
	gtk_box_pack_start (GTK_BOX (content_area), cmdTestDrive, TRUE, TRUE, 0);

	GtkWidget *cmdOutput = hildon_text_view_new ();
	gtk_widget_set_size_request (GTK_WIDGET (cmdOutput), -1, 150);//AP
	hildon_text_view_set_placeholder(HILDON_TEXT_VIEW (cmdOutput), "Exit Status & Command RAW Output will be displayed HERE");
	gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (cmdOutput), GTK_WRAP_WORD_CHAR);
	gtk_text_view_set_editable(GTK_TEXT_VIEW(cmdOutput), FALSE);
	gtk_box_pack_start (GTK_BOX (content_area), cmdOutput, FALSE, FALSE, 0);

	GtkWidget *IEBufferLabel = gtk_label_new ("Import/Export Operations:");
	gtk_box_pack_start (GTK_BOX (content_area), IEBufferLabel, FALSE, FALSE, 0);

	GtkWidget *cmdImportBox = gtk_hbox_new (TRUE, 0);

	GtkWidget *importCommandBt = hildon_button_new_with_text (HILDON_SIZE_FINGER_HEIGHT |
                                          HILDON_SIZE_AUTO_WIDTH, HILDON_BUTTON_ARRANGEMENT_VERTICAL,
										  "Import",
                                          NULL);
	hildon_button_set_alignment (HILDON_BUTTON (importCommandBt), 0, 0.5, 0, 0);//AP1
	hildon_button_set_value (HILDON_BUTTON (importCommandBt), "Command from Buffer");
	g_signal_connect (importCommandBt, "clicked", G_CALLBACK (importCommandBt_clicked_cb), self);
    gtk_box_pack_start (GTK_BOX (cmdImportBox), importCommandBt, TRUE, TRUE, 0);

	GtkWidget *pasteFromClipboardBt = hildon_button_new_with_text (HILDON_SIZE_FINGER_HEIGHT |
                                          HILDON_SIZE_AUTO_WIDTH, HILDON_BUTTON_ARRANGEMENT_VERTICAL,
										  "Paste",
                                          NULL);
	hildon_button_set_alignment (HILDON_BUTTON (pasteFromClipboardBt), 0, 0.5, 0, 0);//AP1
	hildon_button_set_value (HILDON_BUTTON (pasteFromClipboardBt), "from Clipboard to Buffer");
	g_signal_connect (pasteFromClipboardBt, "clicked", G_CALLBACK (pasteFromClipboardADBExportImportBt_clicked_cb), self);
    gtk_box_pack_start (GTK_BOX (cmdImportBox), pasteFromClipboardBt, TRUE, TRUE, 0);

	GtkWidget *importInstanceBt = hildon_button_new_with_text (HILDON_SIZE_FINGER_HEIGHT |
                                          HILDON_SIZE_AUTO_WIDTH, HILDON_BUTTON_ARRANGEMENT_VERTICAL,
										  "Import",
                                          NULL);
	hildon_button_set_alignment (HILDON_BUTTON (importInstanceBt), 0, 0.5, 0, 0);//AP1
	hildon_button_set_value (HILDON_BUTTON (importInstanceBt), "Beecon/Snippet from Buffer");
	g_signal_connect (importInstanceBt, "clicked", G_CALLBACK (importInstanceBt_clicked_cb), self);
    gtk_box_pack_start (GTK_BOX (cmdImportBox), importInstanceBt, TRUE, TRUE, 0);

	gtk_box_pack_start (GTK_BOX (content_area), cmdImportBox, TRUE, TRUE, 0);

	GtkWidget *cmdExportBox = gtk_hbox_new (TRUE, 0);

	GtkWidget *exportCommandBt = hildon_button_new_with_text (HILDON_SIZE_FINGER_HEIGHT |
                                          HILDON_SIZE_AUTO_WIDTH, HILDON_BUTTON_ARRANGEMENT_VERTICAL,
										  "Export",
                                          NULL);
	hildon_button_set_alignment (HILDON_BUTTON (exportCommandBt), 0, 0.5, 0, 0);//AP1
	hildon_button_set_value (HILDON_BUTTON (exportCommandBt), "Command to Buffer");
	g_signal_connect (exportCommandBt, "clicked", G_CALLBACK (exportCommandBt_clicked_cb), self);
    gtk_box_pack_start (GTK_BOX (cmdExportBox), exportCommandBt, TRUE, TRUE, 0);

	GtkWidget *copyToClipboardBt = hildon_button_new_with_text (HILDON_SIZE_FINGER_HEIGHT |
                                          HILDON_SIZE_AUTO_WIDTH, HILDON_BUTTON_ARRANGEMENT_VERTICAL,
										  "Copy",
                                          NULL);
	hildon_button_set_alignment (HILDON_BUTTON (copyToClipboardBt), 0, 0.5, 0, 0);//AP1
	hildon_button_set_value (HILDON_BUTTON (copyToClipboardBt), "to Clipboard from Buffer");
	g_signal_connect (copyToClipboardBt, "clicked", G_CALLBACK (copyToClipboardADBExportImportBt_clicked_cb), self);
    gtk_box_pack_start (GTK_BOX (cmdExportBox), copyToClipboardBt, TRUE, TRUE, 0);

    GtkWidget *exportInstanceBt = hildon_button_new_with_text (HILDON_SIZE_FINGER_HEIGHT |
                                          HILDON_SIZE_AUTO_WIDTH, HILDON_BUTTON_ARRANGEMENT_VERTICAL,
										  "Export",
                                          NULL);
	hildon_button_set_alignment (HILDON_BUTTON (exportInstanceBt), 0, 0.5, 0, 0);//AP1
	hildon_button_set_value (HILDON_BUTTON (exportInstanceBt), "Beecon/Snippet to Buffer");
	g_signal_connect (exportInstanceBt, "clicked", G_CALLBACK (exportInstanceBt_clicked_cb), self);
    gtk_box_pack_start (GTK_BOX (cmdExportBox), exportInstanceBt, TRUE, TRUE, 0);

	gtk_box_pack_start (GTK_BOX (content_area), cmdExportBox, TRUE, TRUE, 0);

	GtkWidget *IEBufferLabelHelp = gtk_label_new ("");
	gtk_label_set_markup (GTK_LABEL (IEBufferLabelHelp), "<span font_desc=\"Nokia Sans 13\">Buffer for Command or Instance Export/Import ... handle with care!</span>");//AP1
	gtk_label_set_line_wrap (GTK_LABEL (IEBufferLabelHelp), TRUE);
	gtk_misc_set_alignment (GTK_MISC (IEBufferLabelHelp), 0.5, 0.5);
	gtk_box_pack_start (GTK_BOX (content_area), IEBufferLabelHelp, FALSE, FALSE, 0);

	GtkWidget *cmdInstanceText = hildon_text_view_new ();
	gtk_widget_set_size_request (GTK_WIDGET (cmdInstanceText), -1, 200);//AP
	gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (cmdInstanceText), GTK_WRAP_WORD_CHAR);
	gtk_box_pack_start (GTK_BOX (content_area), cmdInstanceText, FALSE, FALSE, 0);

	//END

	gtk_widget_show_all (dialog);

	PangoFontDescription *fd = pango_font_description_from_string("Monospace Bold 13");//AP1
	gtk_widget_modify_font(GTK_WIDGET (cmdInstanceText), fd);//AP1
	gtk_widget_modify_font(GTK_WIDGET (cmdTestDrive), fd);//AP1
	gtk_widget_modify_font(GTK_WIDGET (cmdOutput), fd);//AP1

	self->priv->importExportBuffer = hildon_text_view_get_buffer (HILDON_TEXT_VIEW (cmdInstanceText));
	self->priv->cmdTestDriveBuffer = hildon_text_view_get_buffer (HILDON_TEXT_VIEW (cmdTestDrive));
	self->priv->cmdOutputBuffer = hildon_text_view_get_buffer (HILDON_TEXT_VIEW (cmdOutput));

	g_signal_connect (G_OBJECT (self->priv->commandPicker), "value-changed",G_CALLBACK (on_command_picker_value_changed), self);

	cmdSel = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (commandPickerSelector), 0);
	if (cmdSel>=0) {
		g_warning ("(%p) Working on global selector title=[%s] command=[%s]", self, self->priv->c_titles[cmdSel], self->priv->c_commands[cmdSel]);
		gchar *c = g_strdup(self->priv->c_commands[cmdSel]);
		gtk_text_buffer_set_text(self->priv->cmdTestDriveBuffer,c,-1);
		g_free(c);
	} else {
		g_warning ("(%p) Working on instance title=[%s] command=[%s]", self, self->priv->instanceTitle, self->priv->instanceCmd);
		gchar *c = g_strdup(self->priv->instanceCmd);
		gtk_text_buffer_set_text(self->priv->cmdTestDriveBuffer,c,-1);
		g_free(c);
	}
	self->priv->instanceImportOK=FALSE;

	while (!timeToGoBack) {
		self->priv->currentDialog=dialog;
		int dialogRunResponse = gtk_dialog_run (GTK_DIALOG (dialog));
		g_warning ("(%p) Advanced Dialogue response =[%d]", self, dialogRunResponse);

		switch(dialogRunResponse) {
			case GTK_RESPONSE_ACCEPT:
				g_warning ("(%p) GTK_RESPONSE_ACCEPT...", self);
				break;
			default:
				g_warning ("(%p) Time to go back... response %d", self, dialogRunResponse);
				timeToGoBack = TRUE;
				if (self->priv->instanceImportOK) reReadSettings=TRUE;
				break;
		}
	}
	gtk_widget_destroy (dialog);
	g_free(title);
	return(reReadSettings);
}

//Auxiliary functions
void AddCommand(QueenBeecon *self, gchar * s_title, gchar * s_command, gboolean doInstantiate)
{
g_warning ("(%p) AddCommand title=[%s] command=[%s] doInstantiate=%d", self, s_title, s_command, doInstantiate);
	int i;

	gchar **newTitles = malloc( sizeof(gchar*)*(self->priv->c_size+2) );
	gchar **newCommands = malloc( sizeof(gchar*)*(self->priv->c_size+2) );

	for(i=0;i<self->priv->c_size;i++) {
		newTitles[i] = g_strdup(self->priv->c_titles[i]);
		newCommands[i] = g_strdup(self->priv->c_commands[i]);
	}

	g_strfreev(self->priv->c_titles);
	self->priv->c_titles = NULL;
	g_strfreev(self->priv->c_commands);
	self->priv->c_commands = NULL;

	newTitles[self->priv->c_size] = s_title;
	newCommands[self->priv->c_size] = s_command;

	newTitles[self->priv->c_size+1] = NULL;
	newCommands[self->priv->c_size+1] = NULL;

	if (doInstantiate) {
		if (self->priv->instanceTitle!=NULL) g_free(self->priv->instanceTitle);	self->priv->instanceTitle = NULL;
		self->priv->instanceTitle = strdup(newTitles[self->priv->c_size]);
		g_warning("(%p) self->priv->instanceTitle = %p [%s]", self, self->priv->instanceTitle, self->priv->instanceTitle);

		if (self->priv->instanceCmd!=NULL) g_free(self->priv->instanceCmd);	self->priv->instanceCmd = NULL;
		self->priv->instanceCmd = strdup(newCommands[self->priv->c_size]);
		g_warning("(%p) self->priv->instanceCmd = %p [%s]", self, self->priv->instanceCmd, self->priv->instanceCmd);
	}

	self->priv->c_size += 1;

	self->priv->c_titles = newTitles;
	self->priv->c_commands = newCommands;
}

void EditCommand(QueenBeecon *self, gchar * s_title, gchar * s_command, gboolean doInstantiate, int index)
{
g_warning ("(%p) EditCommand title=[%s] command=[%s] index=[%d]", self, s_title, s_command, index);
	//Clean old
	if (index>=0) { // Command is one of the listed commands
		g_free(self->priv->c_titles[index]);
		self->priv->c_titles[index] = s_title;

		g_free(self->priv->c_commands[index]);
		self->priv->c_commands[index] = s_command;
	}

	if (doInstantiate) {
		if (self->priv->instanceTitle!=NULL) g_free(self->priv->instanceTitle);
		self->priv->instanceTitle = g_strdup(s_title);

		if (self->priv->instanceCmd!=NULL) g_free(self->priv->instanceCmd);
		self->priv->instanceCmd = g_strdup(s_command);
	}
}

void DelCommand(QueenBeecon *self, int index)
{
g_warning ("(%p) DelCommand index=%d", self, index);
	int i;

	gchar **newTitles = malloc( sizeof(gchar*)*(self->priv->c_size) );
	gchar **newCommands = malloc( sizeof(gchar*)*(self->priv->c_size) );

	for(i=0;i<self->priv->c_size;i++) {
		//index is the delete target
		if(i < index) {
			newTitles[i] = g_strdup(self->priv->c_titles[i]);
			newCommands[i] = g_strdup(self->priv->c_commands[i]);
		} else if(i > index) {
			newTitles[i-1] = g_strdup(self->priv->c_titles[i]);
			newCommands[i-1] = g_strdup(self->priv->c_commands[i]);
		}
	}
	newTitles[self->priv->c_size-1] = NULL;
	newCommands[self->priv->c_size-1] = NULL;

	//clear old
	g_strfreev(self->priv->c_titles);
	self->priv->c_titles = NULL;

	g_strfreev(self->priv->c_commands);
	self->priv->c_commands = NULL;

	//assign new
	self->priv->c_titles = newTitles;
	self->priv->c_commands = newCommands;

	if (self->priv->instanceTitle!=NULL) g_free(self->priv->instanceTitle);
	self->priv->instanceTitle = NULL;

	if (self->priv->instanceCmd!=NULL) g_free(self->priv->instanceCmd);
	self->priv->instanceCmd = NULL;

	if(self->priv->c_size > 1) {
		self->priv->instanceTitle = g_strdup(newTitles[0]);
		g_warning("(%p) self->priv->instanceTitle = %p [%s]", self, self->priv->instanceTitle, self->priv->instanceTitle);
		self->priv->instanceCmd = g_strdup(newCommands[0]);
		g_warning("(%p) self->priv->instanceCmd = %p [%s]", self, self->priv->instanceCmd, self->priv->instanceCmd);
	}

	self->priv->c_size -= 1;//decrement size
}

guint GetSeconds(guint index)
{
g_warning ("GetSeconds index=%d", index);
	if(index > 0 && index < 9)
	{
		guint intervalTimes[] = {0, 30, 60, 300, 1800, 3600, 21600, 43200, 86400};
		return intervalTimes[index];
	}
	return 0;
}

guint checksum(gchar *buffer)
{
	int i;
	guint chksm=0;

	for (i=0;buffer[i]!='\0';i++) if ((guint)buffer[i]>32 && (guint)buffer[i]<127) chksm+=(guint)(buffer[i]^i)<<1;
	return(chksm);
}

#ifdef GLOBAL_WIDGET_HEARTBEAT_TIMER
//Housekeeping timer
//static gboolean home_applet_timer (gpointer data)
//{
//	g_warning ("home_applet_timer (gpointer data)called");
//
//	beecon_config_file_housekeeping(data);
//
//	/* repeat this timer */
//return TRUE;
//}
#endif

void beecon_config_file_housekeeping(gpointer data)
{
	g_warning ("beecon_config_file_housekeeping(void) called");
	GKeyFile *keyFile = NULL;
	gchar *filename = NULL;
	gchar *fileData = NULL;
	FILE *iniFile = NULL;
	gsize size;
	gboolean fileExists;
	GError *error = NULL;
    gchar **groups = NULL;
	gint i;
	gsize groupLength;

	// :) Do not mess up with the housekeeper!!!
	if (housekeeping) return;

	housekeeping=1;
	keyFile = g_key_file_new();
	g_warning("(%p) keyfile%p", data, keyFile);
	filename = g_strconcat (HOME_DIR, QUEEN_BEECON_SETTINGS_FILE, NULL);
	g_warning("(%p) filename %s",data, filename);
	fileExists = g_key_file_load_from_file (keyFile, filename, G_KEY_FILE_KEEP_COMMENTS, NULL);
	g_warning("(%p) fileExists %d", data, fileExists);

	if (fileExists) {
	    groups = g_key_file_get_groups (keyFile, &groupLength);
    	g_warning("(%p) Found Groups=%d", data, groupLength);
	    for(i=0; i<groupLength; i++) {
	    	g_warning("(%p) Group=%s", data, groups[i]);
	    	if ( !strncmp(QUEEN_BEECON_INSTANCE_BASENAME, groups[i], strlen(QUEEN_BEECON_INSTANCE_BASENAME)) ) {
		    	g_warning("(%p) Instance groups here = [%s] = [%s]", data, QUEEN_BEECON_INSTANCE_BASENAME, groups[i]);
		    	gchar *instanceDir = g_strdup_printf("%s/%s", SYSTEM_INSTANCE_BASE_DIR, groups[i]);
		    	g_warning("(%p) Instance dir = [%s]", data, instanceDir);
	    		GDir *dir = g_dir_open (instanceDir, 0, NULL);
	    		g_free(instanceDir);
	    		if (!dir) {
					g_warning("(%p) No Instance Directory... Time to delete group from Config File [%s]", data, groups[i]);
					if (!g_key_file_remove_group (keyFile, groups[i], &error)) {
						g_warning("(%p) Delete group error [%s]", data, error->message);
					}
				} else {
					g_warning("(%p) Instance Directory successfully open ... Instance is alive and kicking [%s]", data, groups[i]);
					g_dir_close (dir);
       		    }
	    	}
	    }
		g_strfreev(groups);

		fileData = g_key_file_to_data (keyFile, &size, NULL);
		g_warning("(%p) fileData %p", data, fileData);
		iniFile = fopen (filename, "w");
		fputs (fileData, iniFile);
		fclose (iniFile);
		g_free (fileData);
	}
	g_free (filename);
	g_key_file_free (keyFile);
	housekeeping=0; // Everything is clean and easy!!!
}

gchar *queen_beecon_g_key_file_get_string(GKeyFile *key_file, const gchar *group_name, const gchar *key, gchar *defaultValue)
{
	GError *error=NULL;
	gchar *setting = g_key_file_get_string(key_file, group_name, key,&error);
	if (error) {
		g_warning("No setting [%s] on key file, assuming %s", key, defaultValue);
		g_error_free (error);//AP3
		return(defaultValue);
	} else
		return(setting);
}

gboolean queen_beecon_g_key_file_get_boolean(GKeyFile *key_file, const gchar *group_name, const gchar *key, gboolean defaultValue)
{
	GError *error=NULL;
	gboolean setting = g_key_file_get_boolean(key_file, group_name, key,&error);
	if (error) {
		g_warning("No setting [%s] on key file, assuming %d", key, defaultValue);
		g_error_free (error);//AP3
		return(defaultValue);
	} else
		return(setting);
}

gint queen_beecon_g_key_file_get_integer(GKeyFile *key_file, const gchar *group_name, const gchar *key, gint defaultValue)
{
	GError *error=NULL;
	gint setting = g_key_file_get_integer(key_file, group_name, key,&error);
	if (error) {
		g_warning("No setting [%s] on key file, assuming %d", key, defaultValue);
		g_error_free (error);//AP3
		return(defaultValue);
	}else
		return(setting);
}

gdouble queen_beecon_g_key_file_get_double(GKeyFile *key_file, const gchar *group_name, const gchar *key, gdouble defaultValue)
{
	GError *error=NULL;
	gdouble setting = g_key_file_get_double(key_file, group_name, key, &error);
	if (error) {
		g_warning("No setting [%s] on key file, assuming %f", key, defaultValue);
		g_error_free (error);//AP3
		return(defaultValue);
	} else
		return(setting);
}
