#ifndef STACKEDWINDOW_H
#define STACKEDWINDOW_H

#include <QMainWindow>
#include <QResizeEvent>
#include <QNetworkAccessManager>
#include <QUrl>
#include <QNetworkReply>
#include <QSignalMapper>
#include <QPropertyAnimation>
#include <QLabel>
#include "graphframe.h"

namespace Ui {
    class StackedWindow;
}

class StackedWindow : public QMainWindow
{
    Q_OBJECT

public:
	explicit StackedWindow(QString& latlong, QString& wso, QString& zcode,
						   QString& offset, QPixmap& dayIcon, QString& dayURL,
						   QPixmap& nightIcon, QString& nightURL, QWidget *parent = 0);
    ~StackedWindow();
    void setInfo(QString &day, QString &hi, QString &lo, QString &precip, QString &dayFor, QString &nightFor);


protected:
    virtual void resizeEvent(QResizeEvent * event);

private slots:
    void setIcons(int mapping);
	void addSnowGraph();
	void addRainGraph();

private:
    Ui::StackedWindow *ui;
    QSignalMapper* mapper;
    QNetworkAccessManager *manager;
	QString* wfo;
	QString* latlong;
	QString* offset;
	QString* zcode;
	GraphFrame* tempFrame;
	GraphFrame* precipFrame;
	GraphFrame* snowFrame;
	GraphFrame* rainFrame;
};

#endif // STACKEDWINDOW_H
