/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 *
 // TODO several files? or several wallets in database?
 // TODO import picture from camera
 // TODO modify picture (zoom, ...)
 * TODO after change type it is not refreshed on list
 * TODO implements copy of information field (and images?)
 * TODO check types on import
 * TODO pc version?
 * TODO fix problems with key
 * TODO after import groups are not refresh
 * TODO get language from system not from regional settings
 * TODO what happens with small pictures
 * TODO add contacts
 * TODO plugin to allow link some OS info inside Wallet
 * TODO widget to link some info on desktop
 * TODO addon for firefox to get info from wallet
 * TODO anti robo (avisos por email - sms
 * TODO be able to copy sms and others messages (and contacts?) into wallet.
 * TODO add configuration file to backup
 * TODO get card properties from scanner
 * TODO show target summary translate
 */

#include "utils.h"

#ifdef Q_WS_MAEMO_5
#include <QDBusInterface>
#include <QDBusConnection>
#endif

#include "eWallet.h"
#include "Constants.h"
#include "DatabaseManager.h"
#include "AntiTheftManager.h"
#include <Qt>
#include <QtGui>
#include <QFile>
#include <QDesktopServices>
#include <QListView>

//#include "tpsession/tpsession.h"

//#include "qmessageservice.h"
//#include "qmessage.h"

#define SIM_DBUS_SERVICE  "com.nokia.phone.SIM"
#define SIM_DBUS_PATH     "/com/nokia/phone/SIM/security"
#define SIM_DBUS_IFACE    "Phone.Sim.Security"
#define SIM_IMEI_REQ      "get_imei"

DatabaseManager * dbManager;


eWallet::eWallet(QString * group, eWallet * _parent, QWidget *parent) :
	QMainWindow(parent) {
	setWindowTitle("Wallet");

	centerlayout = new QVBoxLayout;
	centerwidget = new QWidget;
	centerwidget->setLayout(centerlayout);
	setCentralWidget(centerwidget);

	centerlayout->setContentsMargins(0, 0, 0, 0);

	isFirst = false;
	types = _parent->types;
	//fieldsByType = _parent->fieldsByType;

	centralWidget = NULL;
	currentGroup = group;

//	this->originalDelegate = _parent->originalDelegate;
//	this->newDelegate = _parent->newDelegate;

#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5AutoOrientation, true);
	//connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged(int)));

	this->setAttribute(Qt::WA_Maemo5StackedWindow);
#else
	this->setMinimumSize(WINDOW_WIDTH, WINDOW_HEIGHT);
#endif

	isShowGroups = 2;

	showList(true);
}


eWallet::eWallet(QWidget *parent) :
	QMainWindow(parent) {
	setWindowTitle("Wallet");

	centerlayout = new QVBoxLayout;
	centerwidget = new QWidget;
	centerwidget->setLayout(centerlayout);
	setCentralWidget(centerwidget);
	centerlayout->setContentsMargins(0, 0, 0, 0);

	isShowGroups = 0;
	isFirst = true;
	centralWidget = NULL;
	currentGroup = NULL;

#ifdef Q_WS_MAEMO_5

	this->setAttribute(Qt::WA_Maemo5AutoOrientation, true);
	connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged(int)));

	this->setAttribute(Qt::WA_Maemo5StackedWindow);
#else
	this->setMinimumSize(WINDOW_WIDTH, WINDOW_HEIGHT);
#endif

	types = NULL;

	::dbManager = new DatabaseManager(this);

	QObject::connect(::dbManager, SIGNAL(createDatabase()), this,
			SLOT(createDatabase()));
	QObject::connect(::dbManager, SIGNAL(migrateDatabase(int,int)), this,
			SLOT(migrateDatabase(int,int)));

#ifdef Q_WS_MAEMO_5
        QDBusInterface interface(SIM_DBUS_SERVICE, SIM_DBUS_PATH, SIM_DBUS_IFACE,
			QDBusConnection::systemBus());
	QDBusMessage reply = interface.call(SIM_IMEI_REQ);
	if (reply.type() == QDBusMessage::ErrorMessage) {
		qDebug() << reply.errorMessage();
	} else {
		QList<QVariant> args = reply.arguments();
		qDebug() << args;
		//label.setText(QString("Phone's IMEI: %1").arg(args.at(0).toString()));
		QString imei = args.at(0).toString();

		//        if ("356938030072939" != imei) {
		//        	qDebug () << "found stolen mobile " << imei;
		//
	}
#endif
	askPassword();
}

void eWallet::initTemplates() {
#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif
	//qDebug () << "initTemplates";

	QList<Target*> * types = new QList<Target*> ;

	_loadTypesAndFields(types); //, fieldsByType);

	static const char *types_string[] = { QT_TR_NOOP("Membership Info"),
			QT_TR_NOOP("Password"), QT_TR_NOOP("Credit Card"),
			QT_TR_NOOP("Bank Account"), QT_TR_NOOP("Health Numbers"),
			QT_TR_NOOP("Passport Info"), QT_TR_NOOP("Note Card"),
			QT_TR_NOOP("Car Info"), QT_TR_NOOP("Cellular Phone"),
			QT_TR_NOOP("Serial Number Software"),
			QT_TR_NOOP("Serial Number Hardware"), QT_TR_NOOP("Web site"),
			QT_TR_NOOP("ID Card"), QT_TR_NOOP("Social Security Number"),
			QT_TR_NOOP("Email Account"), QT_TR_NOOP("Driver's License"),
			QT_TR_NOOP("Others") };

	for (int i = 0; i < types->size(); i++) {
		Target * t = types->at(i);

		t->id = i + 1;
		t->name = DetailWindow::tr(types_string[i]);

		//qDebug () << "initTemplates" << t->name << " " << t->id;

		::dbManager->insertTemplate(t);
		::dbManager->updateTemplateFields(t);
	}
	// TODO delete all objects??
	delete types;

#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
}

void eWallet::createDatabase() {
	qDebug() << "createDatabase";

	initTemplates();
}

void eWallet::migrateDatabase(int from, int to) {
	qDebug() << "migrateDatabase " << from << " -> " << to;
	if (to == 4) {
		initTemplates();
	}
}

void eWallet::orientationChanged(int o) {
	if (isAskPassword) {
		loginDialogDlg->orientationChanged(o);
	}
}

void eWallet::showList(bool interactive) {
	qDebug () << "going to showList " << interactive;

	isAskPassword = false;
	isChangingPassword = false;

	if (interactive) {
		setContextMenuPolicy(Qt::DefaultContextMenu);
	} else {
		setContextMenuPolicy(Qt::NoContextMenu);
	}

	if (interactive) {
		createMenu();
	}

	if (centralWidget.isNull()) {
		if (isShowGroups == 2) {
			centralWidget = new ListOfCards (isFirst, currentGroup, this);
		}
		else {
			centralWidget = new ListOfCards (isFirst, this);
		}

		if (interactive) {
			QObject::connect(centralWidget, SIGNAL(selectTarget(Target *)), this, SLOT(viewTarget(Target *)));
			QObject::connect(centralWidget, SIGNAL(selectGroup(QString *)), this, SLOT(viewGroup(QString *)));
			QObject::connect(centralWidget, SIGNAL(renameGroup(QString)), this, SLOT(renameGroup(QString)));
			QObject::connect(centralWidget, SIGNAL(deleteGroup(QString)), this, SLOT(deleteGroup(QString)));
			QObject::connect(centralWidget, SIGNAL(viewTarget(Target *)), this, SLOT(viewTarget(Target *)));
			QObject::connect(centralWidget, SIGNAL(editTarget(Target *)), this, SLOT(editTarget(Target *)));
			QObject::connect(centralWidget, SIGNAL(newLikeTarget(Target *)), this, SLOT(newLikeTarget(Target *)));
			QObject::connect(centralWidget, SIGNAL(duplicateTarget(Target *)), this, SLOT(duplicateTarget(Target *)));
			QObject::connect(centralWidget, SIGNAL(deleteTarget(Target *)), this, SLOT(deleteTarget(Target *)));
		}

		//setCentralWidget(centralWidget);
		centerlayout->addWidget(centralWidget);
	}
	if (!loginDialogDlg.isNull()) loginDialogDlg->hide();
	centralWidget->show ();
	centralWidget->setFocus();
}

void eWallet::viewGroup(QString * _target) {
#ifndef Q_WS_MAEMO_5
	if (!(extraWindow.isNull() && detailWindow.isNull()
			&& detailWindowEdit.isNull())) {
		if (!extraWindow.isNull())
			extraWindow->raise();
		else if (!detailWindow.isNull())
			detailWindow->raise();
		else if (!detailWindowEdit.isNull())
			detailWindowEdit->raise();
		return;
	}
#endif
	if (extraWindow.isNull()) {
		extraWindow = new eWallet(_target, this, this);
		extraWindow->setAttribute(Qt::WA_DeleteOnClose);
		connect(extraWindow, SIGNAL(destroyed(QObject*)), this,
				SLOT(windowDestroyedExtra(QObject*)));
		extraWindow->show();
	}
}

void eWallet::listenInactivity(QString s) {
	qDebug() << "listenInactivity " << s;
	if (s == QString("off") && ::dbManager->isReady()) {
		hideN();
	} else {
		if (s == QString("on") && ::dbManager->isReady()) {
			askAgainPassword();
		}
	}
}

void eWallet::lockWallet() {
	::dbManager->lock();
	askPassword();
}

void eWallet::deleteDB() {
	if (messageBox.isNull()) {
		messageBox = new QMessageBox(this);
		int	b = messageBox->information(this,"Wallet",tr("Are you sure you want to remove all your data? You will lost all your data"),
								QMessageBox::Yes, QMessageBox::No);
		if (b == QMessageBox::Yes) {
			::dbManager->reset();

			if (!loginDialogDlg.isNull()) {
				loginDialogDlg->resetF();
			}
		}
	}
	delete messageBox;
	messageBox = 0;
}


void eWallet::finalUnlock(const QString pass) {
	bool res = ::dbManager->validatePassword(pass);
	if (res) {
		QObject::disconnect(loginDialogDlg, SIGNAL(finalWithPassword(QString)), this,
			SLOT(finalUnlock(QString)));

		qDebug() << "valid password " << res;

		showN();

		showList(true);
		//showInfo(false);
	} else {
		if (++times > 3) {
			exit(3);
		}
		else {
#ifdef Q_WS_MAEMO_5
			show_banner (this, tr("Wrong password"));
#endif
#ifndef Q_WS_MAEMO_5
			if (messageBox.isNull()) {
				messageBox = new QMessageBox(this);
				messageBox->information(this, "Wallet",
						tr("Wrong password"), QMessageBox::Ok);
			}
			delete messageBox;
			messageBox = 0;
#endif

			if (times == 2) {
#ifndef OPEN_SOURCE_VERSION
				AntiTheftManager * manager = new AntiTheftManager (this);
				manager->notifyFailure ();
#endif
			}
			loginDialogDlg->clearS();
		}
	}
}

bool eWallet::openDataBase(const QString & pas) {
	tempPass = pas;

	bool res = ::dbManager->openDB(pas);

	if (!res) {
		if (++times > 3) {
			exit(3);
		}
		else {
			if (!::dbManager->isReady()) {
#ifdef Q_WS_MAEMO_5
				show_banner (this, tr("Wrong password"));
#endif
#ifndef Q_WS_MAEMO_5
				if (messageBox.isNull()) {
					messageBox = new QMessageBox(this);
					messageBox->information(this, "Wallet",
							tr("Wrong password"), QMessageBox::Ok);
				}
				delete messageBox;
				messageBox = 0;
#endif

				if (times == 2) {
#ifndef OPEN_SOURCE_VERSION
					AntiTheftManager * manager = new AntiTheftManager (this);
					manager->notifyFailure ();
#endif
				}

			}

			loginDialogDlg->clearS();
		}
	}
	else {
		if (isShowGroups == 0) {
			qDebug () << "detecting if groups";
			QList<QString> grouplist;

			//grouplist.clear();
			grouplist = ::dbManager->getGroups();

			if (grouplist.size() > 1) {
				isShowGroups = 1;
			} else if (grouplist.size() == 1) {
				if (grouplist.at(0).length() == 0) {
					isShowGroups = 2;
				} else {
					isShowGroups = 1;
				}
			} else {
				isShowGroups = 2;
			}

			grouplist.clear();
		}

		showList(true);
		showInfo(true);
	}
	return res;
}

eWallet::~eWallet() {
//	qDebug () << "deleting group";
//	if (currentGroup != NULL)
//		delete currentGroup;

	qDebug () << "end ~eWallet";
}

/*
 * TYPES
 * 	S -> String
 * 	T -> Text
 * 	D -> Date
 *  U -> URL
 *  P -> Password
 *  N -> Number
 *  H -> Phone number
 */
void eWallet::_loadTypesAndFields(QList<Target*> * types) {//, QList<QList<TargetField*>*> * fieldsByType) {
	types->append(new Target("Membership Info"));
	types->at(types->length() - 1)->listLoaded = true;
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Organization"), TYPE_STRING, true, 2, "Organization"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Phone Number"), TYPE_PHONE_NUMBER, true, 3, "Phone Number"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Other Information"), TYPE_STRING, true, 4, "Other Information"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"User Name"), TYPE_STRING, true, 5, "User Name"));
	types->at(types->length() - 1)->fields.append(new TargetField(
			tr("Password"), TYPE_PASSWORD, true, 6, "Password"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Organization club"), TYPE_STRING, true, 7, "Organization club"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"ID Number"), TYPE_INTEGER, true, 8, "ID Number"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr("URL"),
			TYPE_URL, true, 9, "URL"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Card Notes"), TYPE_TEXT, true, 10, "Card Notes"));

	types->append(new Target("Password"));
	types->at(types->length() - 1)->listLoaded = true;
	types->at(types->length() - 1)->fields.append(new TargetField(tr("System"),
			TYPE_STRING, true, 2, "System"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"User Name"), TYPE_STRING, true, 3, "User Name"));
	types->at(types->length() - 1)->fields.append(new TargetField(
			tr("Password"), TYPE_PASSWORD, true, 4, "Password"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr("URL"),
			TYPE_URL, true, 5, "URL"));

	types->append(new Target("Credit Card"));
	types->at(types->length() - 1)->listLoaded = true;
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Credit Card Type"), TYPE_STRING, true, 2, "Credit Card Type"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Card Provider"), TYPE_STRING, true, 3, "Card Provider"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Card Number"), TYPE_INTEGER, true, 4, "Card Number"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Expiration Date"), TYPE_DATE, true, 5, "Expiration Date"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Name on Card"), TYPE_STRING, true, 6, "Name on Card"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Phone Number"), TYPE_PHONE_NUMBER, true, 7, "Phone Number"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr("PIN"),
			TYPE_PASSWORD, true, 8, "PIN"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Start Date"), TYPE_DATE, true, 9, "Start Date"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Expiration Date"), TYPE_DATE, true, 10, "Expiration Date"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr("Detail"),
			TYPE_STRING, true, 11, "Detail"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"3-digit CVC#"), TYPE_STRING, true, 12, "3-digit CVC#"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Card Notes"), TYPE_TEXT, true, 13, "Card Notes"));

	types->append(new Target("Bank Account"));
	types->at(types->length() - 1)->listLoaded = true;
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Bank Name"), TYPE_STRING, true, 2, "Bank Name"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Account Number"), TYPE_INTEGER, true, 3, "Account Number"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Telephone"), TYPE_PHONE_NUMBER, true, 4, "Telephone"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr("PIN"),
			TYPE_PASSWORD, true, 5, "PIN"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"SWIFT Code"), TYPE_STRING, true, 6, "SWIFT Code"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Other Information"), TYPE_STRING, true, 7, "Other Information"));

	types->append(new Target("Health Numbers"));
	types->at(types->length() - 1)->listLoaded = true;
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"ID Number"), TYPE_INTEGER, true, 2, "ID Number"));
	types->at(types->length() - 1)->fields.append(new TargetField(
			tr("Password"), TYPE_PASSWORD, true, 3, "Password"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Card Title"), TYPE_STRING, true, 4, "Card Title"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Card Notes"), TYPE_TEXT, true, 5, "Card Notes"));

	types->append(new Target("Passport Info"));
	types->at(types->length() - 1)->listLoaded = true;
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Passport No"), TYPE_STRING, true, 2, "Passport No"));
	types->at(types->length() - 1)->fields.append(new TargetField(
			tr("Surname"), TYPE_STRING, true, 3, "Surname"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Given names"), TYPE_STRING, true, 4, "Given names"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Date of birth"), TYPE_DATE, true, 5, "Date of birth"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Date of issue"), TYPE_DATE, true, 6, "Date of issue"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Date of expiration"), TYPE_DATE, true, 7, "Date of expiration"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Authority"), TYPE_STRING, true, 8, "Authority"));

	types->append(new Target("Note Card"));
	types->at(types->length() - 1)->listLoaded = true;
	types->at(types->length() - 1)->fields.append(new TargetField(tr("Text"),
			TYPE_TEXT, true, 2, "Text"));

	types->append(new Target("Car Info"));
	types->at(types->length() - 1)->listLoaded = true;
	types->at(types->length() - 1)->fields.append(new TargetField(tr("Model"),
			TYPE_STRING, true, 2, "Model"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Vehicle Number"), TYPE_INTEGER, true, 3, "Vehicle Number"));

	types->append(new Target("Cellular Phone"));
	types->at(types->length() - 1)->listLoaded = true;
	types->at(types->length() - 1)->fields.append(new TargetField(tr("Model"),
			TYPE_STRING, true, 2, "Model"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr("Brand"),
			TYPE_STRING, true, 3, "Brand"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr("IMEI#"),
			TYPE_STRING, true, 4, "IMEI#"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Firmware code"), TYPE_STRING, true, 5, "Firmware code"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Purchased"), TYPE_DATE, true, 6, "Purchased"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr("Pin1"),
			TYPE_STRING, true, 7, "Pin1"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr("Pin2"),
			TYPE_STRING, true, 8, "Pin2"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr("Puk1"),
			TYPE_STRING, true, 9, "Puk1"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr("Puk2"),
			TYPE_STRING, true, 10, "Puk2"));
	types->at(types->length() - 1)->fields.append(new TargetField(
			tr("Num SIM"), TYPE_STRING, true, 11, "Num SIM"));
	types->at(types->length() - 1)->fields.append(new TargetField(
			tr("Password"), TYPE_PASSWORD, true, 12, "Password"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Phone Number"), TYPE_PHONE_NUMBER, true, 13, "Phone Number"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Manufacturer"), TYPE_STRING, true, 14, "Manufacturer"));

	types->append(new Target("Serial Number Software"));
	types->at(types->length() - 1)->listLoaded = true;
	types->at(types->length() - 1)->fields.append(new TargetField(
			tr("Product"), TYPE_STRING, true, 2, "Product"));
	types->at(types->length() - 1)->fields.append(new TargetField(
			tr("Version"), TYPE_STRING, true, 3, "Version"));
	types->at(types->length() - 1)->fields.append(new TargetField(
			tr("Serial #"), TYPE_STRING, true, 4, "Serial #"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr("URL"),
			TYPE_URL, true, 5, "URL"));
	types->at(types->length() - 1)->fields.append(new TargetField(
			tr("Company"), TYPE_STRING, true, 6, "Company"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Date bought"), TYPE_DATE, true, 7, "Date bought"));
	types->at(types->length() - 1)->fields.append(new TargetField(
			tr("Username"), TYPE_STRING, true, 8, "Username"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr("Login"),
			TYPE_STRING, true, 9, "Login"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Authorization key"), TYPE_STRING, true, 10, "Authorization key"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Price paid"), TYPE_STRING, true, 11, "Price paid"));
	types->at(types->length() - 1)->fields.append(new TargetField(
			tr("Support"), TYPE_STRING, true, 12, "Support"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr("Notes"),
			TYPE_TEXT, true, 13, "Notes"));

	types->append(new Target("Serial Number Hardware"));
	types->at(types->length() - 1)->listLoaded = true;
	types->at(types->length() - 1)->fields.append(new TargetField(
			tr("Product"), TYPE_STRING, true, 2, "Product"));
	types->at(types->length() - 1)->fields.append(new TargetField(
			tr("Serial #"), TYPE_STRING, true, 3, "Serial #"));
	types->at(types->length() - 1)->fields.append(new TargetField(
			tr("Model #"), TYPE_STRING, true, 4, "Model #"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Bought from"), TYPE_STRING, true, 5, "Bought from"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Price paid"), TYPE_STRING, true, 6, "Price paid"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Guarantee period"), TYPE_DATE, true, 7, "Guarantee period"));

	types->append(new Target("Web site"));
	types->at(types->length() - 1)->listLoaded = true;
	types->at(types->length() - 1)->fields.append(new TargetField(tr("URL"),
			TYPE_URL, true, 2, "URL"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr("Login"),
			TYPE_STRING, true, 3, "Login"));
	types->at(types->length() - 1)->fields.append(new TargetField(
			tr("Password"), TYPE_PASSWORD, true, 4, "Password"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"E mail used"), TYPE_STRING, true, 5, "E mail used"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr("Notes"),
			TYPE_TEXT, true, 6, "Notes"));

	types->append(new Target("ID Card"));
	types->at(types->length() - 1)->listLoaded = true;
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"ID Number"), TYPE_INTEGER, true, 2, "ID Number"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Card Title"), TYPE_STRING, true, 3, "Card Title"));

	types->append(new Target("Social Security Number"));
	types->at(types->length() - 1)->listLoaded = true;
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Social Security Number"), TYPE_INTEGER, true, 2,
			"Social Security Number"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr("Name"),
			TYPE_STRING, true, 3, "Name"));
	types->at(types->length() - 1)->fields.append(new TargetField(
			tr("Password"), TYPE_PASSWORD, true, 4, "Password"));

	types->append(new Target("Email Account"));
	types->at(types->length() - 1)->listLoaded = true;
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"User Name"), TYPE_STRING, true, 2, "User Name"));
	types->at(types->length() - 1)->fields.append(new TargetField(
			tr("Password"), TYPE_PASSWORD, true, 3, "Password"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr("System"),
			TYPE_STRING, true, 4, "System"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Card Notes"), TYPE_TEXT, true, 5, "Card Notes"));

	types->append(new Target("Driver's License"));
	types->at(types->length() - 1)->listLoaded = true;
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Driver's License Number"), TYPE_INTEGER, true, 2,
			"Driver's License Number"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Date Issued"), TYPE_DATE, true, 3, "Date Issued"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Expiration Date"), TYPE_DATE, true, 4, "Expiration Date"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr("URL"),
			TYPE_URL, true, 5, "URL"));
	types->at(types->length() - 1)->fields.append(new TargetField(
			tr("Password"), TYPE_PASSWORD, true, 6, "Password"));

	types->append(new Target("Others"));
	types->at(types->length() - 1)->listLoaded = true;
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Card Notes"), TYPE_TEXT, true, 2, "Card Notes"));
}

void eWallet::loadTypesAndFields() {
	if (types == NULL) {
		types = new QList<Target*> ;
	}

	Target * target;
	foreach(target, *types)
		{
			delete target;
		}
	types->clear();

	QList<Target *> typesTmp = dbManager->getTemplates();

	for (int i = 0; i < typesTmp.size(); i++) {
		Target * t = typesTmp.at(i);
		types->append(t);

		qDebug() << "detecting type " << t->name;

		dbManager->getTemplateFields(t);
	}
}

void eWallet::keyPressEvent(QKeyEvent* event) {
	qDebug()<<"eWallet key pressed " << event->key();
	QWidget::keyPressEvent(event);//event->accept();
}

void eWallet::showInfo(bool reset) {
	qDebug () << "show Info " << isShowGroups << " " << reset;
	centralWidget->showInfo(isShowGroups, reset);
}

void eWallet::createMenu() {
	//qDebug () << "create Menu " << isAskPassword;
#ifdef Q_WS_MAEMO_5
	menuBar()->clear();
	if (isAskPassword) {
		menuBar()->addAction(tr("About"), this, SLOT(about()));
#ifdef OPEN_SOURCE_VERSION
		if (!isChangingPassword) {
			menuBar()->addAction(tr("Delete DB"), this, SLOT(deleteDB()));
		}
#endif
		menuBar()->addAction(tr("Options"), this, SLOT(options()));
#ifndef OPEN_SOURCE_VERSION
//		menuBar()->addAction(tr("Anti-Theft options"), this, SLOT(optionsAntiTheft()));
#endif
		menuBar()->addAction(tr("Exit"), QApplication::instance(), SLOT(quit()));
	}
	else {
		menuBar()->addAction(tr("New"), this, SLOT(newTarget()));
		if (isShowGroups == 2) {
			menuBar()->addAction(tr("Edit"), this, SLOT(_editTarget()));
		}
		menuBar()->addAction(tr("Invert Sort"), this, SLOT(_sort()));
		menuBar()->addAction(tr("Import"), this, SLOT(import()));
		menuBar()->addAction(tr("Export"), this, SLOT(exportData()));
#ifndef OPEN_SOURCE_VERSION
		menuBar()->addAction(tr("Export Xml"), this, SLOT(exportXml()));
		menuBar()->addAction(tr("Import Xml"), this, SLOT(importXml()));
		menuBar()->addAction(tr("Merge DB"), this, SLOT(mergeDB()));
#endif
		//menuBar()->addAction(tr("Change View"), this, SLOT(changeMode()));
		menuBar()->addAction(tr("Change Password"), this, SLOT(changePassword()));
#ifndef OPEN_SOURCE_VERSION
		menuBar()->addAction(tr("Templates"), this, SLOT(editTemplates()));
#endif
		menuBar()->addAction(tr("Options"), this, SLOT(options()));
#ifndef OPEN_SOURCE_VERSION
//		menuBar()->addAction(tr("Anti-Theft options"), this, SLOT(optionsAntiTheft()));
#endif
		menuBar()->addAction(tr("About"), this, SLOT(about()));
		menuBar()->addAction(tr("Exit"), QApplication::instance(), SLOT(quit()));
	}
#else
	menuBar()->clear();
	if (isAskPassword) {
		menuBar()->addAction(tr("Exit"), QApplication::instance(), SLOT(quit()));
		menuBar()->addAction(tr("About"), this, SLOT(about()));
		//		if (!isChangingPassword) {
		//			menuBar()->addAction(tr("Delete DB"), this, SLOT(deleteDB()));
		//		}
	} else {
		QMenu * m = menuBar()->addMenu(tr("Card"));
		m->addAction(tr("New"), this, SLOT(newTarget()));
		if (isShowGroups == 2)
			m->addAction(tr("Edit"), this, SLOT(_editTarget()));
		m->addSeparator();
		m->addAction(tr("Invert Sort"), this, SLOT(sort()));
		m->addSeparator();
		m->addAction(tr("Change Password"), this, SLOT(changePassword()));
		m->addSeparator();
		m->addAction(tr("Import"), this, SLOT(import()));
		m->addAction(tr("Export"), this, SLOT(exportData()));
#ifndef OPEN_SOURCE_VERSION
		m->addAction(tr("Export Xml"), this, SLOT(exportXml()));
		m->addSeparator();
		m->addAction(tr("Merge DB"), this, SLOT(mergeDB()));
		m->addSeparator();
#endif
		m->addAction(tr("Options"), this, SLOT(options()));
#ifndef OPEN_SOURCE_VERSION
//		m->addAction(tr("Anti-Theft options"), this, SLOT(optionsAntiTheft()));
		m->addAction(tr("Templates"), this, SLOT(editTemplates()));
#endif
		m->addSeparator();
		menuBar()->addAction(tr("Exit"), QApplication::instance(), SLOT(quit()));
		menuBar()->addAction(tr("About"), this, SLOT(about()));
		//menuBar()->addAction(tr("Change View"), this, SLOT(changeMode()));
	}
#endif
}

void eWallet::_editTarget() {
	centralWidget->_editTarget();
}

void eWallet::_sort() {
	centralWidget->sort ();
}

bool eWallet::__insertTarget(Target* target) {
	preProcessImage(target->picture);
	preProcessImage(target->pictureBack);

	if (::dbManager->insertTarget(target)) {
		////qDebug () << "Adding new item";
		::dbManager->updateFields(target);

		target->freeFieldList();
		return true;
	}
	return false;
}

bool eWallet::_insertTarget(Target* target) {
	if (__insertTarget(target)) {
		centralWidget->_insertTarget(target);
		return true;
	}
	return false;
}

bool eWallet::deleteTarget(Target* target) {
	if (messageBox.isNull()) {
		messageBox = new QMessageBox(this);
		int b = messageBox->information(this, "Wallet", tr(
				"Are you sure you want to remove it?"), QMessageBox::Yes,
				QMessageBox::No);
		if (b != QMessageBox::Yes) {
			delete messageBox;
			messageBox = 0;

			return false;
		}
	}
	delete messageBox;
	messageBox = 0;

	if (::dbManager->deleteTarget(target)) {
		centralWidget->_deleteTarget(target);
		delete target;
		return true;
	}
	return false;
}

bool eWallet::_updateTarget(Target* target) {
//	////qDebug () << "UPDATE ON " << i;
//
	if (::dbManager->updateTarget(target)) {
		::dbManager->updateFields(target);

		target->freeFieldList();

		centralWidget->_updateTarget(target);
		return true;
	}
	return false;
}
//
bool eWallet::_updateTargetPicture(Target* target) {
//	////qDebug () << "UPDATE ON " << i;
	preProcessImage(target->picture);

	if (::dbManager->updateTargetPicture(target)) {
		centralWidget->_updateTargetPicture(target);
		return true;
	}
	return false;
}

bool eWallet::_updateTargetPictureBack(Target* target) {
	preProcessImage(target->pictureBack);

	if (::dbManager->updateTargetPictureBack(target)) {
		return true;
	}
	return false;
}

void eWallet::windowDestroyedExtra(QObject* obj) {
	disconnect(obj, SIGNAL(destroyed(QObject*)), this,
			SLOT(windowDestroyedExtra(QObject*)));

	delete extraWindow;
	extraWindow = 0;

	//qDebug () << "WINDOW DESTROYED YES";

	centralWidget->showInfo(1, true);
}
//
void eWallet::windowDestroyedTemplates(QObject* obj) {
	disconnect(obj, SIGNAL(destroyed(QObject*)), this,
			SLOT(windowDestroyedTemplates(QObject*)));

	loadTypesAndFields();

	delete templatesWindow;
	templatesWindow = 0;
}
//
void eWallet::windowDestroyed(QObject* obj) {
	disconnect(obj, SIGNAL(destroyed(QObject*)), this,
			SLOT(windowDestroyed(QObject*)));

	delete detailWindow;
	detailWindow = 0;
}

void eWallet::walletDestroyed(QObject* obj) {
	disconnect(obj, SIGNAL(destroyed(QObject*)), this,
			SLOT(walletDestroyed(QObject*)));

	qDebug () << "destroy wallet ";
}
//
void eWallet::windowDestroyedEdit(QObject* obj) {
	disconnect(obj, SIGNAL(destroyed(QObject*)), this,
			SLOT(windowDestroyedEdit(QObject*)));

	delete detailWindowEdit;
	detailWindowEdit = 0;

	centralWidget->reloadInfo ();
}
//
void eWallet::viewTarget(Target * rent) {
#ifndef Q_WS_MAEMO_5
	if (!(detailWindow.isNull() && detailWindowEdit.isNull())) {
		if (!detailWindow.isNull())
			detailWindow->raise();
		else if (!detailWindowEdit.isNull())
			detailWindowEdit->raise();
		return;
	}
#endif
	dbManager->getFields(rent);

	if (detailWindow.isNull()) {
		detailWindow = new DetailWindow(rent, "", 0, false, this, this);

		connect(detailWindow, SIGNAL(editTarget(Target*)), this,
				SLOT(editTarget(Target*)));
		connect(detailWindow, SIGNAL(newLikeTarget(Target*)), this,
				SLOT(newLikeTarget(Target*)));
		connect(detailWindow, SIGNAL(duplicateTarget(Target*)), this,
				SLOT(duplicateTarget(Target*)));
		connect(detailWindow, SIGNAL(newTarget()), this, SLOT(newTarget()));

		detailWindow->setAttribute(Qt::WA_DeleteOnClose);
		connect(detailWindow, SIGNAL(destroyed(QObject*)), this,
				SLOT(windowDestroyed(QObject*)));
		//detailWindow->setAttribute(Qt::WA_Maemo5StackedWindow);
		detailWindow->show(); //owMaximized();
	}
}

void eWallet::import() {
	QString path(QDesktopServices::storageLocation(
			QDesktopServices::HomeLocation));
	QString s = QFileDialog::getOpenFileName(this, tr("Choose import file"),
			path, tr("Text files (*.txt);;"));

#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif

	if (!s.isNull() && !s.isEmpty()) {
		QFile file(s);
		QString line;

		Target * target = NULL;
		if (file.open(QIODevice::Text | QIODevice::ReadOnly)) {
			// file opened successfully
			QTextStream t(&file); // use a text stream
			// until end of file...
			int i = 0;
			while (!t.atEnd()) {
				// read and parse the command line
				QString line = t.readLine(); // line of text excluding '\n'
				// do something with the line

				if (line.length() > 0) {
					if (target == NULL) {
						target = new Target();
					}

					int j = line.indexOf(QChar(':'));
					if (j > 0) {
						switch (i++) {
						case 0:
							target->name = line.mid(j + 1).trimmed();
							break;
						case 1:
							target->groupName = line.mid(j + 1).trimmed();
							break;
						case 2:
							// TODO check type with existing one!
							target->type = line.mid(j + 1).trimmed();
							break;
						default:
							TargetField * field = new TargetField();

							int jj = line.mid(0, j).indexOf(QChar(';'));
							if (jj >= 0) {
								field->name = line.mid(0, jj).trimmed();

								int type = TYPE_STRING;
								switch (line.at(jj + 1).toAscii()) {
								case 'T':
									type = TYPE_TEXT;
									break;
								case 'D':
									type = TYPE_DATE;
									break;
								case 'U':
									type = TYPE_URL;
									break;
								case 'P':
									type = TYPE_PASSWORD;
									break;
								case 'N':
									type = TYPE_INTEGER;
									break;
								case 'H':
									type = TYPE_PHONE_NUMBER;
									break;
								case 'I':
									type = TYPE_IMAGE;
									break;
								case 'S':
								default:
									type = TYPE_STRING;
								}
								field->type = type;
							} else {
								field->name = line.mid(0, j).trimmed();

								//							  if (field->name.contains("url", Qt::CaseInsensitive)) {
								//								  field->type = TYPE_URL;
								//							  }
								//							  else
								//							  if (field->name.contains("password", Qt::CaseInsensitive)) {
								//								  field->type = TYPE_PASSWORD;
								//							  }
								//							  else
								//							  if (field->name.contains("pin", Qt::CaseInsensitive)) {
								//								  field->type = TYPE_PASSWORD;
								//							  }
								//							  else
								//							  if (field->name.contains("phone", Qt::CaseInsensitive)) {
								//								  field->type = TYPE_PHONE_NUMBER;
								//							  }
								//							  else
								//							  if (field->name.contains("number", Qt::CaseInsensitive)) {
								//								  field->type = TYPE_INTEGER;
								//							  }
								//							  else
								//							  if (field->name.contains("date", Qt::CaseInsensitive)) {
								//								  field->type = TYPE_DATE;
								//							  }
								//							  else
								//							  if (field->name.contains("note", Qt::CaseInsensitive)) {
								//								  field->type = TYPE_TEXT;
								//							  }
								//							  else
								field->type = TYPE_STRING;
							}
							// TODO TYPE_IMAGE
							field->value = line.mid(j + 1).trimmed();
							field->order = 10 * (i - 3);
							field->encrypted = true;

							target->fields.append(field);
						}

						////qDebug () << line << " | " << line.mid(j + 1) << " IS " << line.mid (0, j);
					} else {
						if (target != NULL && target->fields.size() > 0) {
							target->fields.last()->value.append("\n").append(
									line);
							target->fields.last()->type = TYPE_TEXT;
						}
					}
				} else {
					if (target != NULL) {
						{
							QString imgPath = QFileInfo(s).absolutePath();
							imgPath += "/";
							imgPath += target->name.simplified().replace(' ',
									'_');
							imgPath += ".png";

							//qDebug () << "checking image " << imgPath;

							QFile imgFile(imgPath);
							if (imgFile.exists()) {
								QImage * currentImageN = new QImage();
								DetailWindow::loadImage(settings, imgPath,
										*currentImageN); //;
								target->setPicture(currentImageN);

								//::dbManager->updateTargetPicture (target);
							}
						}
						{
							QString imgPath = QFileInfo(s).absolutePath();
							imgPath += "/";
							imgPath += target->name.simplified().replace(' ',
									'_');
							imgPath += "_BACK.png";

							//qDebug () << "checking image " << imgPath;

							QFile imgFile(imgPath);
							if (imgFile.exists()) {
								QImage * currentImageN = new QImage();
								DetailWindow::loadImage(settings, imgPath,
										*currentImageN); //;
								target->setPictureBack(currentImageN);

								//::dbManager->updateTargetPictureBack (target);
							}
						}
						this->__insertTarget(target);
					}
					target = NULL;
					i = 0;
				}

				QApplication::instance()->processEvents();

				////qDebug () << line;
			}

			if (target != NULL) {
				{
					QString imgPath = QFileInfo(s).absolutePath();
					imgPath += "/";
					imgPath += target->name.simplified().replace(' ', '_');
					imgPath += ".png";

					//qDebug () << "checking image " << imgPath;

					QFile imgFile(imgPath);
					if (imgFile.exists()) {
						QImage * currentImageN = new QImage();
						DetailWindow::loadImage(settings, imgPath,
								*currentImageN); //;
						target->setPicture(currentImageN);

						//::dbManager->updateTargetPicture (target);
					}
				}
				{
					QString imgPath = QFileInfo(s).absolutePath();
					imgPath += "/";
					imgPath += target->name.simplified().replace(' ', '_');
					imgPath += "_BACK.png";

					//qDebug () << "checking image " << imgPath;

					QFile imgFile(imgPath);
					if (imgFile.exists()) {
						QImage * currentImageN = new QImage();
						DetailWindow::loadImage(settings, imgPath,
								*currentImageN); //;
						target->setPictureBack(currentImageN);

						//::dbManager->updateTargetPictureBack (target);
					}
				}
				this->__insertTarget(target);
			}
			// Close the file
			file.close();

			showInfo(true);
		}
	}
#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
}

void eWallet::renameGroup(QString target) {
	RenameGroupDialog * dialog = new RenameGroupDialog(this);
	dialog->setName(target);
	if (dialog->exec() == QDialog::Accepted) {
		QString newName = dialog->getName();

		//qDebug () << "NEW GROUP NAME " << target << " TO " << newName;

		if (::dbManager->renameGroup(target, newName)) {
			centralWidget->reloadGroups();
		}
	}
	delete dialog;
}

bool eWallet::deleteGroup(QString target) {
	if (messageBox.isNull()) {
		messageBox = new QMessageBox(this);
		int b = messageBox->information(this, "Wallet", tr(
				"Are you sure you want to remove it?"), QMessageBox::Yes,
				QMessageBox::No);
		if (b != QMessageBox::Yes) {
			delete messageBox;
			messageBox = 0;

			return false;
		}
	}
	delete messageBox;
	messageBox = 0;

	if (::dbManager->deleteGroup(target)) {
		centralWidget->reloadGroups();

		return true;
	}
	return false;
}

void eWallet::exportData() {
	QString path(QDesktopServices::storageLocation(
			QDesktopServices::HomeLocation));

	path.append("/wallet_export.txt");

	QString s = QFileDialog::getSaveFileName(this, tr("Choose export file"),
			path, tr("Text files (*.txt);;"));

#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif
	if (!s.isNull() && !s.isEmpty()) {
		if (!s.endsWith(".txt"))
			s.append(".txt");

		QFile file(s);

		if (file.open(QIODevice::Text | QIODevice::WriteOnly)) {
			// file opened successfully
			QTextStream t(&file); // use a text stream

			QList<Target *> list = ::dbManager->getTargets(NULL);

			for (int i = 0; i < list.size(); i++) {
				Target * target = list[i];

				QImage * img = target->getPicture();

				if (img != NULL) {
					QString imgPath = QFileInfo(s).absolutePath();
					imgPath += "/";
					imgPath += target->name.simplified().replace(' ', '_');
					imgPath += ".png";

					//qDebug () << "exporting image " << imgPath;

					img->save(imgPath, "PNG"); // writes image into ba in PNG format
				}

				img = target->getPictureBack();

				if (img != NULL) {
					QString imgPath = QFileInfo(s).absolutePath();
					imgPath += "/";
					imgPath += target->name.simplified().replace(' ', '_');
					imgPath += "_BACK.png";

					//qDebug () << "exporting back image " << imgPath;

					img->save(imgPath, "PNG"); // writes image into ba in PNG format
				}

				t << "Name: " << target->name << "\n";
				t << "Group Name: " << target->groupName << "\n";
				t << "Type: " << target->type << "\n";

				dbManager->getFields(target);

				TargetField * field;
				foreach(field, target->fields)
					{
						switch (field->type) {
						case TYPE_TEXT:
							t << field->name << ";T: " << field->value << "\n";
							break;
						case TYPE_DATE:
							t << field->name << ";D: " << field->value << "\n";
							break;
						case TYPE_URL:
							t << field->name << ";U: " << field->value << "\n";
							break;
						case TYPE_PASSWORD:
							t << field->name << ";P: " << field->value << "\n";
							break;
						case TYPE_INTEGER:
							t << field->name << ";N: " << field->value << "\n";
							break;
						case TYPE_PHONE_NUMBER:
							t << field->name << ";H: " << field->value << "\n";
							break;
						case TYPE_IMAGE:
							t << field->name << ";I: " << field->value << "\n"; // TODO
							break;
						case 'S':
						default:
							t << field->name << ": " << field->value << "\n";
						}
					}

				t << "\n\n";

				target->freeFieldList();
				target->freeResources();

				QApplication::instance()->processEvents();

				delete target;
			}

			//                        Target * target;
			//                        foreach(target, list) {
			//                                delete target;
			//                        }

			list.clear();

			// Close the file
			file.close();
		}
	}
#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
}

//QByteArray FIX_VALUE (QString a) {
//	// TODO escape characters
//	return Qt::escape(a).toUtf8();
//}

void eWallet::mergeDB() {
	QString path(QDesktopServices::storageLocation(
			QDesktopServices::HomeLocation));
	QString s = QFileDialog::getOpenFileName(this, tr("Choose DB file"), path,
			tr("DB files (*.sqlite);;"));

#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif

	if (!s.isNull() && !s.isEmpty()) {
		QFile file(s);

		QString res = ::dbManager->mergeDB(s, tempPass);

		qDebug() << "finish merge " << res;

		showInfo(true);
	}

#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
}

void eWallet::importXml() {
	QString path(QDesktopServices::storageLocation(
			QDesktopServices::HomeLocation));

	path.append("/wallet_export.xml");

	QString s = QFileDialog::getOpenFileName(this, tr("Choose import file"),
			path, tr("Text files (*.xml);;"));

	bool update = false;

#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif

	if (!s.isNull() && !s.isEmpty()) {
		if (!s.endsWith(".xml"))
			s.append(".xml");

		QFile file(s);

		if (file.open(QIODevice::Text | QIODevice::ReadOnly)) {
			QXmlStreamReader xml;
			xml.setDevice(&file);
			if (!xml.atEnd()) {
				xml.readNext();
				if (xml.isStartDocument()) {
					qDebug() << "START " << xml.name().toString();
					xml.readNext();
					if (xml.isStartElement()) {
						QString sec(xml.name().toString());
						if (QString("targets").compare(sec,
								Qt::CaseInsensitive) == 0) {
							qDebug() << "START ff " << xml.name().toString();
							Target * t = NULL;
							while (xml.readNextStartElement()) {
								QString sec(xml.name().toString());
								if (QString("target").compare(sec,
										Qt::CaseInsensitive) == 0) {
									qDebug() << "START fff "
											<< xml.name().toString();
									t = new Target;
									int order = 0;
									while (xml.readNextStartElement()) {
										//xml.readNext();
										QString sec(xml.name().toString());
										QXmlStreamAttributes attrs = xml.attributes();
										QString content = xml.readElementText().trimmed();
										qDebug() << "START " << sec;
										if (QString("id").compare(sec,
												Qt::CaseInsensitive) == 0) {
											if (update)
												t->id = content.toInt();
											else
												t->id = -1;
										} else if (QString("name").compare(sec,
												Qt::CaseInsensitive) == 0) {
											t->name = content;
										} else if (QString("groupName").compare(
												sec, Qt::CaseInsensitive) == 0) {
											t->groupName = content;
										} else if (QString("type").compare(sec,
												Qt::CaseInsensitive) == 0) {
											t->type = content;
										} else if (QString("image").compare(
												sec, Qt::CaseInsensitive) == 0) {
											QImage * image = new QImage;
											if (!image->loadFromData(
													QByteArray::fromBase64(
															content.toAscii()))) {
											}
											t->setPicture(image);
										} else if (QString("backImage").compare(
												sec, Qt::CaseInsensitive) == 0) {
											QImage * image = new QImage;
											if (!image->loadFromData(
													QByteArray::fromBase64(
															content.toAscii()))) {
											}
											t->setPictureBack(image);
										} else if (QString("creationTime").compare(sec, Qt::CaseInsensitive) == 0) {
											t->creationdate = content;
										} else if (QString("modificationTime").compare(sec, Qt::CaseInsensitive) == 0) {
											t->modificationdate = content;
										} else if (QString("field").compare(sec, Qt::CaseInsensitive) == 0) {
											QString name;
											QString _type;
											for (int i = 0; i < attrs.size(); i++) {
												if (QString("name").compare(attrs.at(i).name().toString(), Qt::CaseInsensitive) == 0) {
													name = attrs.at(i).value().toString();
												}
												else
												if (QString("type").compare(attrs.at(i).name().toString(), Qt::CaseInsensitive) == 0) {
													_type = attrs.at(i).value().toString();
												}
											}
//											QString name = attrs.value("name").toString();
//											QString _type = attrs.value("type").toString();

											qDebug () << " FIeLD " << name << " " << _type;

											int type = TYPE_STRING;
											switch (_type.at(0).toAscii()) {
											case 'T':
												type = TYPE_TEXT;
												break;
											case 'D':
												type = TYPE_DATE;
												break;
											case 'U':
												type = TYPE_URL;
												break;
											case 'P':
												type = TYPE_PASSWORD;
												break;
											case 'N':
												type = TYPE_INTEGER;
												break;
											case 'H':
												type = TYPE_PHONE_NUMBER;
												break;
											case 'I':
												type = TYPE_IMAGE;
												break;
											case 'S':
											default:
												type = TYPE_STRING;
											}

											TargetField * tf = new TargetField(name, type, true, ++order);
											tf->value = content;
											t->fields.append(tf);
										} else {
											qDebug() << "invalid node " << sec;
										}
									}

									if (update)
										__insertTarget(t);
									else
										__insertTarget(t);

									t->freeFieldList();
									t->freeResources();
									delete t;
									t = NULL;

									QApplication::instance()->processEvents();

									if (!xml.isEndElement()) {

										break;
									}
								} else {
									qDebug() << "invalid! "
											<< xml.name().toString();
								}

							}
						}
					}
				}
			}
		}
		file.close();
	}
	showInfo(true);
#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
}

void eWallet::exportXml() {
	QString path(QDesktopServices::storageLocation(
			QDesktopServices::HomeLocation));

	path.append("/wallet_export.xml");

	QString s = QFileDialog::getSaveFileName(this, tr("Choose export file"),
			path, tr("Text files (*.xml);;"));

#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif
	if (!s.isNull() && !s.isEmpty()) {
		if (!s.endsWith(".xml"))
			s.append(".xml");

		QFile file(s);

		if (file.open(QIODevice::Text | QIODevice::WriteOnly)) {
			// file opened successfully
			//QTextStream t(&file);        // use a text stream

			QList<Target *> list = ::dbManager->getTargets(NULL);

			QXmlStreamWriter stream(&file);

			stream.setAutoFormatting(true);
			stream.writeStartDocument();

			//		    t << "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
			//			t << "<targets>\n";
			stream.writeStartElement("targets");
			for (int i = 0; i < list.size(); i++) {
				Target * target = list[i];

				stream.writeStartElement("target");

				stream.writeStartElement("id");
				stream.writeCharacters(QString::number(target->id));
				stream.writeEndElement();

				stream.writeStartElement("name");
				stream.writeCharacters(target->name);
				stream.writeEndElement();

				stream.writeStartElement("groupName");
				stream.writeCharacters(target->groupName);
				stream.writeEndElement();

				stream.writeStartElement("type");
				stream.writeCharacters(target->type);
				stream.writeEndElement();

				//				t << "<target>\n";
				//				t << "<id>" << target->id << "</id>\n";
				//				t << "<name>" << FIX_VALUE(target->name) << "</name>\n";
				//				t << "<group>" << FIX_VALUE(target->groupName) << "</group>\n";
				//				t << "<type>" << FIX_VALUE(target->type) << "</type>\n";

				QImage * img = target->getPicture();

				if (img != NULL) {
					QByteArray im1;
					QBuffer buffer1(&im1);
					buffer1.open(QIODevice::WriteOnly);
					img->save(&buffer1, "PNG"); // writes image into ba in PNG format

					stream.writeStartElement("image");
					stream.writeCharacters(im1.toBase64());
					stream.writeEndElement();

					//					t << "<image>" << im1.toBase64() << "</image>\n";
				}

				img = target->getPictureBack();

				if (img != NULL) {
					QByteArray im1;
					QBuffer buffer1(&im1);
					buffer1.open(QIODevice::WriteOnly);
					img->save(&buffer1, "PNG"); // writes image into ba in PNG format

					stream.writeStartElement("backimage");
					stream.writeCharacters(im1.toBase64());
					stream.writeEndElement();
					//					t << "<backimage>" << im1.toBase64() << "</backimage>\n";
				}

				dbManager->getFields(target);

				TargetField * field;
				foreach(field, target->fields)
					{
						switch (field->type) {
						case TYPE_TEXT:
							stream.writeStartElement("field");
							//stream.writeAttribute("id", QString::number(field->id));
							stream.writeAttribute("name", field->name);
							stream.writeAttribute("type", "T");
							stream.writeCharacters(field->value);
							stream.writeEndElement();
							//							t << "<field id=\"" << field->id << "\" name=\"" << FIX_VALUE(field->name) << "\" type=\"T\">" << FIX_VALUE(field->value) << "</field>\n";
							break;
						case TYPE_DATE:
							stream.writeStartElement("field");
							//stream.writeAttribute("id", QString::number(field->id));
							stream.writeAttribute("name", field->name);
							stream.writeAttribute("type", "D");
							stream.writeCharacters(field->value);
							stream.writeEndElement();
							//								t << "<field id=\"" << field->id << "\" name=\"" << FIX_VALUE(field->name) << "\" type=\"D\">" << FIX_VALUE(field->value) << "</field>\n";
							break;
						case TYPE_URL:
							stream.writeStartElement("field");
							//stream.writeAttribute("id", QString::number(field->id));
							stream.writeAttribute("name", field->name);
							stream.writeAttribute("type", "U");
							stream.writeCharacters(field->value);
							stream.writeEndElement();
							//t << "<field id=\"" << field->id << "\" name=\"" << FIX_VALUE(field->name) << "\" type=\"U\">" << FIX_VALUE(field->value) << "</field>\n";
							break;
						case TYPE_PASSWORD:
							stream.writeStartElement("field");
							//stream.writeAttribute("id", QString::number(field->id));
							stream.writeAttribute("name", field->name);
							stream.writeAttribute("type", "P");
							stream.writeCharacters(field->value);
							stream.writeEndElement();
							//t << "<field id=\"" << field->id << "\" name=\"" << FIX_VALUE(field->name) << "\" type=\"P\">" << FIX_VALUE(field->value) << "</field>\n";
							break;
						case TYPE_INTEGER:
							stream.writeStartElement("field");
							//stream.writeAttribute("id", QString::number(field->id));
							stream.writeAttribute("name", field->name);
							stream.writeAttribute("type", "N");
							stream.writeCharacters(field->value);
							stream.writeEndElement();
							//t << "<field id=\"" << field->id << "\" name=\"" << FIX_VALUE(field->name) << "\" type=\"N\">" << FIX_VALUE(field->value) << "</field>\n";
							break;
						case TYPE_PHONE_NUMBER:
							stream.writeStartElement("field");
							//stream.writeAttribute("id", QString::number(field->id));
							stream.writeAttribute("name", field->name);
							stream.writeAttribute("type", "H");
							stream.writeCharacters(field->value);
							stream.writeEndElement();
							//t << "<field id=\"" << field->id << "\" name=\"" << FIX_VALUE(field->name) << "\" type=\"H\">" << FIX_VALUE(field->value) << "</field>\n";
							break;
						case TYPE_IMAGE:
							stream.writeStartElement("field");
							//stream.writeAttribute("id", QString::number(field->id));
							stream.writeAttribute("name", field->name);
							stream.writeAttribute("type", "I");
							stream.writeCharacters(field->value);
							stream.writeEndElement();
							//t << "<field id=\"" << field->id << "\" name=\"" << FIX_VALUE(field->name) << "\" type=\"I\">" << FIX_VALUE(field->value) << "</field>\n";
							break;
						case 'S':
						default:
							stream.writeStartElement("field");
							//stream.writeAttribute("id", QString::number(field->id));
							stream.writeAttribute("name", field->name);
							stream.writeCharacters(field->value);
							stream.writeEndElement();
							//								t << "<field id=\"" << field->id << "\" name=\"" << FIX_VALUE(field->name) << "\">" << FIX_VALUE(field->value) << "</field>\n";
						}
					}
				stream.writeStartElement("creationTime");
				stream.writeCharacters(target->creationdate);
				stream.writeEndElement();

				stream.writeStartElement("modificationTime");
				stream.writeCharacters(target->modificationdate);
				stream.writeEndElement();

				//				t << "<creationTime>" << target->creationdate << "</creationTime>\n";
				//				t << "<modificationTime>" << target->modificationdate << "</modificationTime>\n";
				//				t << "</target>\n";
				stream.writeEndElement();

				target->freeFieldList();
				target->freeResources();

				QApplication::instance()->processEvents();

				delete target;
			}
			stream.writeEndElement();
			stream.writeEndDocument();
			//			t << "</targets>\n";

			//                        Target * target;
			//                        foreach(target, list) {
			//                                delete target;
			//                        }
			list.clear();

			// Close the file
			file.close();
		}
	}
#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
}

void eWallet::editTarget(Target * target) {
#ifndef Q_WS_MAEMO_5
	if (!(detailWindow.isNull() && detailWindowEdit.isNull())) {
		if (!detailWindow.isNull())
			detailWindow->raise();
		else if (!detailWindowEdit.isNull())
			detailWindowEdit->raise();
		return;
	}
#endif

	dbManager->getFields(target);

	if (detailWindowEdit.isNull()) {
		detailWindowEdit = new DetailWindow(target, "", 0, true, this, this);
		//detailWindowEdit->setAttribute(Qt::WA_Maemo5StackedWindow);
		detailWindowEdit->setAttribute(Qt::WA_DeleteOnClose);
		connect(detailWindowEdit, SIGNAL(destroyed(QObject*)), this,
				SLOT(windowDestroyedEdit(QObject*)));
		detailWindowEdit->show();
	}
}
//
void eWallet::duplicateTarget(Target * target) {
#ifndef Q_WS_MAEMO_5
	if (!(detailWindow.isNull() && detailWindowEdit.isNull())) {
		if (!detailWindow.isNull())
			detailWindow->raise();
		else if (!detailWindowEdit.isNull())
			detailWindowEdit->raise();
		return;
	}
#endif

	dbManager->getFields(target);

	if (detailWindowEdit.isNull()) {
		detailWindowEdit = new DetailWindow(target,
				currentGroup != NULL ? *currentGroup : "", 2, true, this, this);
		//detailWindowEdit->setAttribute(Qt::WA_Maemo5StackedWindow);
		detailWindowEdit->setAttribute(Qt::WA_DeleteOnClose);
		connect(detailWindowEdit, SIGNAL(destroyed(QObject*)), this,
				SLOT(windowDestroyedEdit(QObject*)));
		detailWindowEdit->show();
	}
}
//
void eWallet::newLikeTarget(Target * target) {
#ifndef Q_WS_MAEMO_5
	if (!(detailWindow.isNull() && detailWindowEdit.isNull())) {
		if (!detailWindow.isNull())
			detailWindow->raise();
		else if (!detailWindowEdit.isNull())
			detailWindowEdit->raise();
		return;
	}
#endif
	dbManager->getFields(target);

	if (detailWindowEdit.isNull()) {
		detailWindowEdit = new DetailWindow(target,
				currentGroup != NULL ? *currentGroup : "", 1, true, this, this);
		//detailWindowEdit->setAttribute(Qt::WA_Maemo5StackedWindow);
		detailWindowEdit->setAttribute(Qt::WA_DeleteOnClose);
		connect(detailWindowEdit, SIGNAL(destroyed(QObject*)), this,
				SLOT(windowDestroyedEdit(QObject*)));
		detailWindowEdit->show();
	}
}
//
void eWallet::editTemplates() {
#ifndef Q_WS_MAEMO_5
	if (!(detailWindow.isNull() && detailWindowEdit.isNull())) {
		if (!detailWindow.isNull())
			detailWindow->raise();
		else if (!detailWindowEdit.isNull())
			detailWindowEdit->raise();
		return;
	}
#endif
	if (templatesWindow.isNull()) {
		templatesWindow = new EditTemplates(this);
		templatesWindow->setAttribute(Qt::WA_DeleteOnClose);
		connect(templatesWindow, SIGNAL(destroyed(QObject*)), this,
				SLOT(windowDestroyedTemplates(QObject*)));
		templatesWindow->show();
	}
}

void eWallet::newTarget() {
#ifndef Q_WS_MAEMO_5
	if (!(detailWindow.isNull() && detailWindowEdit.isNull())) {
		if (!detailWindow.isNull())
			detailWindow->raise();
		else if (!detailWindowEdit.isNull())
			detailWindowEdit->raise();
		return;
	}
#endif
	if (detailWindowEdit.isNull()) {
		detailWindowEdit = new DetailWindow(NULL,
				currentGroup != NULL ? *currentGroup : "", 0, true, this, this);
		//detailWindowEdit->setAttribute(Qt::WA_Maemo5StackedWindow);
		detailWindowEdit->setAttribute(Qt::WA_DeleteOnClose);
		connect(detailWindowEdit, SIGNAL(destroyed(QObject*)), this,
				SLOT(windowDestroyedEdit(QObject*)));
		detailWindowEdit->show();
	}
}

void eWallet::closeEvent(QCloseEvent *event) {
	event->accept();
}

void eWallet::askPassword() {
	setContextMenuPolicy(Qt::NoContextMenu);

	times = 0;

	isAskPassword = true;
	isChangingPassword = false;
	isUnLockMode = false;
	createMenu();

	bool firstTime = !::dbManager->hasPassword();
#ifdef Q_WS_MAEMO_5
	if (firstTime) {
		show_information_note (this, tr("Please, enter a password for your wallet"));
	}
	else {
		show_banner (this, tr("Please, enter the password to unlock your wallet"));
	}
#endif

	if (loginDialogDlg.isNull()) {
		loginDialogDlg = new LoginDialog(firstTime, this);

		centerlayout->addWidget(loginDialogDlg);
	}

	QObject::connect(loginDialogDlg, SIGNAL(finalWithPassword(QString)),
			this, SLOT(finalPassword(QString)));

	if (!centralWidget.isNull()) centralWidget->hide();
	loginDialogDlg->show ();
	loginDialogDlg->focus();
}

void eWallet::hideN() {
	if (!detailWindowEdit.isNull()) {
		qDebug() << "hide edit";
		detailWindowEdit->hideN();
		detailWindowEdit->hide();
	}
	if (!detailWindow.isNull()) {
		qDebug() << "hide detail";
		detailWindow->hideN();
		detailWindow->hide();
	}
	if (!extraWindow.isNull()) {
		qDebug() << "hide extra";
		extraWindow->hideN();
		extraWindow->hide();
	}
	//if (!isFirst) hide();
}
void eWallet::showN() {
	if (!extraWindow.isNull()) {
		qDebug() << "show extra";
		extraWindow->show();
		extraWindow->showN();
	}
	if (!detailWindow.isNull()) {
		qDebug() << "show detail";
		detailWindow->show();
		detailWindow->showN();
	}
	if (!detailWindowEdit.isNull()) {
		qDebug() << "show edit";
		detailWindowEdit->show();
		detailWindowEdit->showN();
	}
	//if (!isFirst) show();
}

void eWallet::askAgainPassword() {
	setContextMenuPolicy(Qt::NoContextMenu);

	times = 0;

	isAskPassword = true;
	isChangingPassword = false;
	isUnLockMode = true;
	createMenu();

	qDebug() << "askAgainPassword";

#ifdef Q_WS_MAEMO_5
	show_banner (this, tr("Please, enter the password to unlock your wallet"));
#endif

	if (loginDialogDlg.isNull()) {
		loginDialogDlg = new LoginDialog(false, this);

		centerlayout->addWidget(loginDialogDlg);
	}

	QObject::connect(loginDialogDlg, SIGNAL(finalWithPassword(QString)), this,
		SLOT(finalUnlock(QString)));

	if (!centralWidget.isNull()) centralWidget->hide();
	loginDialogDlg->clearS();
	loginDialogDlg->show ();
	loginDialogDlg->focus();
}

void eWallet::options() {
	if (optionsDlg.isNull()) {
		optionsDlg = new OptionsDialog(this);
		optionsDlg->setMinimumSize(size().width(), size().height() - 100);
		optionsDlg->exec();
	}
}

void eWallet::optionsAntiTheft() {
	if (optionsAntiThefDlg.isNull()) {
		optionsAntiThefDlg = new AntiTheftOptionsDialog(this);
		optionsAntiThefDlg->setMinimumSize(size().width(), size().height() - 100);
		optionsAntiThefDlg->exec();
	}
}

void eWallet::about() {
	this->setStyleSheet("QMessageBox QLabel :link { color: #FF0000; }");
#ifdef OPEN_SOURCE_VERSION
	QMessageBox::about(this, tr("About Wallet"), tr("<qt><br><br><p><i><b>qtWallet</b></i>, v.1.0</p>"
					"<p>Developed by <b>nowheremanmail@gmail.com</b></p>"
					"<p>Icons by http://pixelmixer.ru/</p>"
					"<p>if you think that qtWallet is useful for you, please</p>"
					"<a href=\"https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=nowheremanmail@gmail.com&lc=US&item_name=qtWallet&currency_code=EUR&bn=PP%2dDonationsBF%3abtn_donate_SM%2egif%3aNonHosted\">DONATE</a></qt>").arg(VERSION));
#else
	QMessageBox::about(this, tr("About Wallet"), tr(
			"<qt><br><br><p><i><b>Wallet</b></i>, v.%1</p>"
				"<p>Developed by <b>nowheremanmail@gmail.com</b></p>"
				"<p>Icons by http://pixelmixer.ru/</p>"
				"</qt>").arg(VERSION));
#endif

}

void eWallet::finalPassword(const QString pass) {
	bool res = openDataBase(pass);
	if (res) {
		QObject::disconnect(loginDialogDlg, SIGNAL(finalWithPassword(QString)),
				this, SLOT(finalPassword(QString)));

		loadTypesAndFields();
#ifdef Q_WS_MAEMO_5
		QDBusConnection conn = QDBusConnection::systemBus(); //QString(MCE_SERVICE), QString(MCE_SIGNAL_PATH)
		conn.connect("","", QString("com.nokia.mce.signal"/*MCE_SIGNAL_IF*/), QString("display_status_ind"/*MCE_DISPLAY_SIG*/) , this, SLOT(listenInactivity(QString)));
		//bool success = conn.connect("","", QString(MCE_SIGNAL_IF), QString(MCE_DISPLAY_SIG) , this, SLOT(listenInactivity(QString)));
#endif
//		loginDialogDlg = 0;
		showInfo (false);
	}
}

void eWallet::finalChangePassword(const QString pass) {
	QObject::disconnect(loginDialogDlg, SIGNAL(finalWithPassword(QString)),
			this, SLOT(finalChangePassword(QString)));

	reallyChangePassword(pass);
}

void eWallet::preProcessImage(QImage * image) {
	if (image == NULL)
		return;

	QSettings settings;

	int h = settings.value("internalImage/HEIGH", _INTERNAL_HEIGH).toInt();
	int w = settings.value("internalImage/WIDTH", _INTERNAL_WIDTH).toInt();

	//QImage res QImage::scaled (const QSize & size, Qt::AspectRatioMode aspectRatioMode = Qt::IgnoreAspectRatio, Qt::TransformationMode transformMode = Qt::FastTransformation ) const
	//QSize imageSize = reader.size();
	qDebug() << "IMAGE SIZE " << image->width() << " " << image->height();

	if (image->height() > h || image->width() > w) {
		if (settings.value("internalImage/scale", true).toBool()) {
			QImage res;
			switch (settings.value("internalImage/aspect", 1).toInt()) {
			case 1:
				qDebug() << "scaling with keep aspect image";
				res = image->scaled(w, h, Qt::KeepAspectRatio,
						Qt::SmoothTransformation);
				break;
			case 2:
				qDebug() << "scaling with expanding aspect image";
				res = image->scaled(w, h, Qt::KeepAspectRatioByExpanding,
						Qt::SmoothTransformation);
				break;
			default:
				res = image->scaled(w, h, Qt::IgnoreAspectRatio,
						Qt::SmoothTransformation);
			}

			*image = res;
		}
	} else {
		// TODO
	}
}

void eWallet::changePassword() {
	times = 0;
	isChangingPassword = true;
	isAskPassword = true;

	createMenu();

	if (loginDialogDlg.isNull()) {
		loginDialogDlg = new LoginDialog(true, this);

		centerlayout->addWidget(loginDialogDlg);
	}

	QObject::connect(loginDialogDlg, SIGNAL(finalWithPassword(QString)),
			this, SLOT(finalChangePassword(QString)));

	if (!centralWidget.isNull()) centralWidget->hide ();
	loginDialogDlg->show();
	setFocus();
	loginDialogDlg->setFocus();
	focusNextChild();
}

class MyThread: public QThread {
public:
	QString p;
	QString newPassword;

	void run() {
		//sleep(2000);

		p = ::dbManager->changePassword(newPassword);
	}

};

void eWallet::reallyChangePassword(const QString & newPassword) {
//	loginDialogDlg = 0;

	//	QMessageBox * messageBox = new QMessageBox (this);
	//	messageBox->information(this, "Wallet", tr("Changing password, please wait until application quits"), QMessageBox::Ok);

	//show_information_note (NULL, tr("Changing password, please wait until application quits"));

#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif

	MyThread t;
	t.newPassword = newPassword;
	t.start();
	//	t.wait ();

	while (t.isRunning()) {
#ifdef Q_WS_MAEMO_5
		show_banner (this, tr("Changing password, please wait until application quits"));
#endif
		QApplication::instance()->processEvents();
		t.wait(2000);
	}

	QString p = t.p; // ::dbManager->changePassword(newPassword);

#ifndef Q_WS_MAEMO_5
	QMessageBox * messageBox = new QMessageBox(this);
#endif
	if (p.length() == 0)
#ifndef Q_WS_MAEMO_5
		messageBox->information(this, "Wallet", tr(
				"Password changed successfully, application will exit"),
				QMessageBox::Ok);
#endif
#ifdef Q_WS_MAEMO_5
	show_information_note (this, tr("Password changed successfully, application will exit"));
#endif
	else {
#ifndef Q_WS_MAEMO_5
		messageBox->information(
				this,
				"Wallet",
				tr(
						"Password CANNOT BE changed, because %1, and application will exit").arg(
						p), QMessageBox::Ok);
#endif
#ifdef Q_WS_MAEMO_5
		show_information_note (this, tr("Password CANNOT BE changed, because %1, and application will exit").arg(p));
#endif
	}

	delete messageBox;

	//delete ::dbManager;
	//exit (3);
#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif

	::dbManager->close();
	openDataBase(newPassword);

	showList(false);

	//	::dbManager->lock ();
	//	askPassword ();
}

