/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 */

#ifndef CREATEFIELD_H
#define CREATEFIELD_H

#include <QtGui>
#include <QDebug>
#include "DatabaseManager.h"

class FieldsHelper {
public:
	bool fieldsChanged;
};

class CreateFieldDialog: public QDialog
{
	Q_OBJECT

public:
	CreateFieldDialog(Target * target, FieldsHelper *paTarget, QWidget * parent );
	~CreateFieldDialog();

public slots:
	void previous();
	void next();
	void addNew();
	void save();
	void deleteCurrent();
	//void orientationChanged(int o);

private:
	void showField();
	void update();

	int pos;
	Target * target;
	FieldsHelper * parent;
	QLineEdit * nameLineEdit;
	QLineEdit * orderEdit;
	QComboBox * typeLineEdit;
	QPushButton * previousButton;
	QPushButton * nextButton;
	QPushButton * deleteButton;
	QList<TargetField*> fields;
	bool _fieldsChanged;
};


#endif // CREATEFIELD_H
