/*!
  @file
  QxtXmlRpc, a Qt4 library for XML-RPC network communication

  (C) 2006 Music Pictures, Ltd. (www.musicpictures.com)
  @author Tobias G. Pfeiffer (tgpfeiffer@web.de)
  @date 2007/02/05
  @version 0.3

  See http://qtnode.net/wiki/QxtXmlRpc or the README file for license terms.
*/

#ifndef QXTXMLRPCCLIENT_H
#define QXTXMLRPCCLIENT_H

#include <QtCore>
#include <QtNetwork>


//! main class; use this for composing your calls
/*! This class is the one to be used for doing XML-RPC calls. Call the
    constructor with the URL of an XML-RPC server. Then, for each
    individual call, create a QList<QVariant> that contains your function
    parameters for the remote procedure and execute the call() method.
    This will return an integer uniquely identifying this call; this will be
    the first parameter of all of the signals that will be emitted when the
    server's response arrives. Important: One (and only one) of the four
    signals *will* be emitted for each call. */
class QxtXmlRpcClient : public QObject {
  Q_OBJECT
  private:
      QUrl url;
      QHttp* http;
      QMap<int, QIODevice*> requests;
  public:
    //! constructor taking the server url (keep the trailing slash!!!)
    explicit QxtXmlRpcClient(QWidget *parent, QUrl serverUrl);
    //! destructor
    ~QxtXmlRpcClient();
  private slots:
    void handleResponse(int req, bool error);
  public slots:
    //! calls the given RPC procedure
    int call(QString procName, QList<QVariant> params);
  signals:
    //! is emitted when RPC call has finished successfully
    void finish(int callId, QVariant retValue);
    //! is emitted on error during call
    void networkError(int callId, QString errorMsg);
    //! is emitted on XML-RPC fault
    void fault(int callId, int faultCode, QString faultString);
    //! is emitted on XML parsing error
    void parseError(int callId, QString errorMsg);

};
#endif
